/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.Serializable;
import soot.ArrayType;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.IntType;
import soot.Scene;
import soot.ShortType;
import soot.util.Numberable;
import soot.util.Switch;
import soot.util.Switchable;

public abstract class Type
implements Switchable,
Serializable,
Numberable {
    protected ArrayType arrayType;
    private int number = 0;

    public Type() {
        Scene.v().getTypeNumberer().add(this);
    }

    public abstract String toString();

    public static Type toMachineType(Type t) {
        if (t.equals(ShortType.v()) || t.equals(ByteType.v()) || t.equals(BooleanType.v()) || t.equals(CharType.v())) {
            return IntType.v();
        }
        return t;
    }

    public Type merge(Type other, Scene cm) {
        throw new RuntimeException("illegal type merge: " + this + " and " + other);
    }

    public abstract boolean isPrimitive();

    public void apply(Switch sw) {
    }

    public void setArrayType(ArrayType at) {
        this.arrayType = at;
    }

    public ArrayType getArrayType() {
        return this.arrayType;
    }

    public ArrayType makeArrayType() {
        return ArrayType.v(this, 1);
    }

    public final int getNumber() {
        return this.number;
    }

    public final void setNumber(int number) {
        this.number = number;
    }
}

