/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.dava.toolkits.base.AST.traversals.ClosestAbruptTargetFinder;
import soot.toolkits.scalar.AbstractFlowSet;
import soot.toolkits.scalar.FlowSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DavaFlowSet
extends AbstractFlowSet {
    static final int DEFAULT_SIZE = 8;
    int numElements;
    int maxElements;
    public Object[] elements;
    HashMap<Serializable, List<DavaFlowSet>> breakList;
    HashMap<Serializable, List<DavaFlowSet>> continueList;
    HashMap<Serializable, List<DavaFlowSet>> implicitBreaks;
    HashMap<Serializable, List<DavaFlowSet>> implicitContinues;

    public DavaFlowSet() {
        this.maxElements = 8;
        this.elements = new Object[8];
        this.numElements = 0;
        this.breakList = new HashMap();
        this.continueList = new HashMap();
        this.implicitBreaks = new HashMap();
        this.implicitContinues = new HashMap();
    }

    public DavaFlowSet(DavaFlowSet other) {
        this.numElements = other.numElements;
        this.maxElements = other.maxElements;
        this.elements = (Object[])other.elements.clone();
        this.breakList = (HashMap)other.breakList.clone();
        this.continueList = (HashMap)other.continueList.clone();
        this.implicitBreaks = (HashMap)other.implicitBreaks.clone();
        this.implicitContinues = (HashMap)other.implicitContinues.clone();
    }

    private boolean sameType(Object flowSet) {
        return flowSet instanceof DavaFlowSet;
    }

    @Override
    public DavaFlowSet clone() {
        return new DavaFlowSet(this);
    }

    @Override
    public Object emptySet() {
        return new DavaFlowSet();
    }

    @Override
    public void clear() {
        this.numElements = 0;
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public boolean isEmpty() {
        return this.numElements == 0;
    }

    @Override
    public List toList() {
        Object[] copiedElements = new Object[this.numElements];
        System.arraycopy(this.elements, 0, copiedElements, 0, this.numElements);
        return Arrays.asList(copiedElements);
    }

    @Override
    public void add(Object e) {
        if (!this.contains(e)) {
            if (this.numElements == this.maxElements) {
                this.doubleCapacity();
            }
            this.elements[this.numElements++] = e;
        }
    }

    private void doubleCapacity() {
        int newSize = this.maxElements * 2;
        Object[] newElements = new Object[newSize];
        System.arraycopy(this.elements, 0, newElements, 0, this.numElements);
        this.elements = newElements;
        this.maxElements = newSize;
    }

    @Override
    public void remove(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            this.elements[i] = this.elements[--this.numElements];
            return;
        }
    }

    @Override
    public void union(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other) {
                for (int i = 0; i < this.numElements; ++i) {
                    dest.add(this.elements[i]);
                }
            } else {
                if (this != dest) {
                    this.copy(dest);
                }
                for (int i = 0; i < other.numElements; ++i) {
                    dest.add(other.elements[i]);
                }
            }
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet workingSet;
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new DavaFlowSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (!other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet otherFlow, FlowSet destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            DavaFlowSet workingSet;
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (dest == other || dest == this) {
                workingSet = new DavaFlowSet();
            } else {
                workingSet = dest;
                workingSet.clear();
            }
            for (int i = 0; i < this.numElements; ++i) {
                if (other.contains(this.elements[i])) continue;
                workingSet.add(this.elements[i]);
            }
            if (workingSet != dest) {
                workingSet.copy(dest);
            }
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(Object obj) {
        for (int i = 0; i < this.numElements; ++i) {
            if (!this.elements[i].equals(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            DavaFlowSet other = (DavaFlowSet)otherFlow;
            if (other.numElements != this.numElements) {
                return false;
            }
            int size = this.numElements;
            for (int i = 0; i < size; ++i) {
                if (other.contains(this.elements[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet destFlow) {
        if (this.sameType(destFlow)) {
            DavaFlowSet dest = (DavaFlowSet)destFlow;
            while (dest.maxElements < this.maxElements) {
                dest.doubleCapacity();
            }
            dest.numElements = this.numElements;
            System.arraycopy(this.elements, 0, dest.elements, 0, this.numElements);
        } else {
            super.copy(destFlow);
        }
    }

    private List<DavaFlowSet> addIfNotDuplicate(List<DavaFlowSet> into, DavaFlowSet addThis) {
        Iterator<DavaFlowSet> it = into.iterator();
        boolean found = false;
        while (it.hasNext()) {
            DavaFlowSet temp = it.next();
            if (!temp.equals(addThis) || !temp.internalDataMatchesTo(addThis)) continue;
            found = true;
            break;
        }
        if (!found) {
            into.add(addThis);
        }
        return into;
    }

    public void addToBreakList(String labelBroken, DavaFlowSet set) {
        List<DavaFlowSet> obj = this.breakList.get(labelBroken);
        if (obj == null) {
            ArrayList<DavaFlowSet> labelsBreakList = new ArrayList<DavaFlowSet>();
            labelsBreakList.add(set);
            this.breakList.put((Serializable)((Object)labelBroken), labelsBreakList);
        } else {
            List<DavaFlowSet> labelsBreakList = obj;
            this.breakList.put((Serializable)((Object)labelBroken), this.addIfNotDuplicate(labelsBreakList, set));
        }
    }

    public void addToContinueList(String labelContinued, DavaFlowSet set) {
        List<DavaFlowSet> obj = this.continueList.get(labelContinued);
        if (obj == null) {
            ArrayList<DavaFlowSet> labelsContinueList = new ArrayList<DavaFlowSet>();
            labelsContinueList.add(set);
            this.continueList.put((Serializable)((Object)labelContinued), labelsContinueList);
        } else {
            List<DavaFlowSet> labelsContinueList = obj;
            this.continueList.put((Serializable)((Object)labelContinued), this.addIfNotDuplicate(labelsContinueList, set));
        }
    }

    private boolean checkImplicit(DAbruptStmt ab) {
        SETNodeLabel label = ab.getLabel();
        if (label == null) {
            return true;
        }
        return label.toString() == null;
    }

    public void addToImplicitBreaks(DAbruptStmt ab, DavaFlowSet set) {
        if (!this.checkImplicit(ab)) {
            throw new RuntimeException("Tried to add explicit break statement in the implicit list in");
        }
        if (!ab.is_Break()) {
            throw new RuntimeException("Tried to add continue statement in the break list in DavaFlowSet.addToImplicitBreaks");
        }
        ASTNode node = ClosestAbruptTargetFinder.v().getTarget(ab);
        List<DavaFlowSet> list = this.implicitBreaks.get(node);
        ArrayList<DavaFlowSet> listSets = null;
        listSets = list == null ? new ArrayList<DavaFlowSet>() : (ArrayList<DavaFlowSet>)list;
        this.implicitBreaks.put(node, this.addIfNotDuplicate(listSets, set));
    }

    public void addToImplicitContinues(DAbruptStmt ab, DavaFlowSet set) {
        if (!this.checkImplicit(ab)) {
            throw new RuntimeException("Tried to add explicit continue statement in the implicit list ");
        }
        if (!ab.is_Continue()) {
            throw new RuntimeException("Tried to add break statement in the continue list");
        }
        ASTNode node = ClosestAbruptTargetFinder.v().getTarget(ab);
        List<DavaFlowSet> list = this.implicitContinues.get(node);
        ArrayList<DavaFlowSet> listSets = null;
        listSets = list == null ? new ArrayList<DavaFlowSet>() : (ArrayList<DavaFlowSet>)list;
        this.implicitContinues.put(node, this.addIfNotDuplicate(listSets, set));
    }

    private HashMap<Serializable, List<DavaFlowSet>> getBreakList() {
        return this.breakList;
    }

    private HashMap<Serializable, List<DavaFlowSet>> getContinueList() {
        return this.continueList;
    }

    public HashMap<Serializable, List<DavaFlowSet>> getImplicitBreaks() {
        return this.implicitBreaks;
    }

    public HashMap<Serializable, List<DavaFlowSet>> getImplicitContinues() {
        return this.implicitContinues;
    }

    public List getImplicitlyBrokenSets(ASTNode node) {
        List<DavaFlowSet> toReturn = this.implicitBreaks.get(node);
        if (toReturn != null) {
            return toReturn;
        }
        return null;
    }

    public List getImplicitlyContinuedSets(ASTNode node) {
        List<DavaFlowSet> toReturn = this.implicitContinues.get(node);
        if (toReturn != null) {
            return toReturn;
        }
        return null;
    }

    private List<DavaFlowSet> copyDavaFlowSetList(List<DavaFlowSet> currentList, List<DavaFlowSet> temp) {
        for (DavaFlowSet check : temp) {
            Iterator<DavaFlowSet> currentListIt = currentList.iterator();
            boolean found = false;
            while (currentListIt.hasNext()) {
                DavaFlowSet currentSet = currentListIt.next();
                if (!check.equals(currentSet) || !check.internalDataMatchesTo(currentSet)) continue;
                found = true;
                break;
            }
            if (found) continue;
            currentList.add(check);
        }
        return currentList;
    }

    public void copyInternalDataFrom(Object fromThis) {
        ArrayList toDavaFlowSets;
        ArrayList fromDavaFlowSets;
        List<DavaFlowSet> complete;
        List<DavaFlowSet> currentList;
        List<DavaFlowSet> list;
        List<DavaFlowSet> temp;
        if (!this.sameType(fromThis)) {
            return;
        }
        HashMap<Serializable, List<DavaFlowSet>> fromThisBreakList = ((DavaFlowSet)fromThis).getBreakList();
        for (String string : fromThisBreakList.keySet()) {
            temp = fromThisBreakList.get(string);
            list = this.breakList.get(string);
            if (list == null) {
                this.breakList.put((Serializable)((Object)string), temp);
                continue;
            }
            currentList = list;
            complete = this.copyDavaFlowSetList(currentList, temp);
            this.breakList.put((Serializable)((Object)string), complete);
        }
        HashMap<Serializable, List<DavaFlowSet>> fromThisContinueList = ((DavaFlowSet)fromThis).getContinueList();
        for (String string : fromThisContinueList.keySet()) {
            temp = fromThisContinueList.get(string);
            list = this.continueList.get(string);
            if (list == null) {
                this.continueList.put((Serializable)((Object)string), temp);
                continue;
            }
            currentList = list;
            complete = this.copyDavaFlowSetList(currentList, temp);
            this.continueList.put((Serializable)((Object)string), currentList);
        }
        HashMap<Serializable, List<DavaFlowSet>> copyThis = ((DavaFlowSet)fromThis).getImplicitBreaks();
        for (ASTNode aSTNode : copyThis.keySet()) {
            fromDavaFlowSets = (ArrayList)copyThis.get(aSTNode);
            list = this.implicitBreaks.get(aSTNode);
            if (list == null) {
                this.implicitBreaks.put(aSTNode, fromDavaFlowSets);
                continue;
            }
            toDavaFlowSets = (ArrayList)list;
            complete = this.copyDavaFlowSetList(toDavaFlowSets, fromDavaFlowSets);
            this.implicitBreaks.put(aSTNode, complete);
        }
        copyThis = ((DavaFlowSet)fromThis).getImplicitContinues();
        for (ASTNode aSTNode : copyThis.keySet()) {
            fromDavaFlowSets = (ArrayList)copyThis.get(aSTNode);
            list = this.implicitContinues.get(aSTNode);
            if (list == null) {
                this.implicitContinues.put(aSTNode, fromDavaFlowSets);
                continue;
            }
            toDavaFlowSets = (ArrayList)list;
            complete = this.copyDavaFlowSetList(toDavaFlowSets, fromDavaFlowSets);
            this.implicitContinues.put(aSTNode, complete);
        }
    }

    private boolean compareLists(Object One, Object Two) {
        if (One == null && Two == null) {
            return true;
        }
        if (One == null || Two == null) {
            return false;
        }
        List listOne = (List)One;
        List listTwo = (List)Two;
        if (listOne.size() != listTwo.size()) {
            return false;
        }
        Iterator listOneIt = listOne.iterator();
        boolean found = false;
        while (listOneIt.hasNext()) {
            Object listOneObj = listOneIt.next();
            for (Object listTwoObj : listTwo) {
                if (!listOneObj.equals(listTwoObj)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
            found = false;
        }
        return true;
    }

    public boolean internalDataMatchesTo(Object otherObj) {
        if (!(otherObj instanceof DavaFlowSet)) {
            return false;
        }
        DavaFlowSet other = (DavaFlowSet)otherObj;
        HashMap<Serializable, List<DavaFlowSet>> otherMap = other.getBreakList();
        if (!this.compareHashMaps(this.breakList, otherMap)) {
            return false;
        }
        otherMap = other.getContinueList();
        if (!this.compareHashMaps(this.continueList, otherMap)) {
            return false;
        }
        otherMap = other.getImplicitBreaks();
        if (!this.compareHashMaps(this.implicitBreaks, otherMap)) {
            return false;
        }
        otherMap = other.getImplicitContinues();
        return this.compareHashMaps(this.implicitContinues, otherMap);
    }

    private boolean compareHashMaps(HashMap<Serializable, List<DavaFlowSet>> thisMap, HashMap<Serializable, List<DavaFlowSet>> otherMap) {
        ArrayList<String> otherKeyList = new ArrayList<String>();
        for (String string : otherMap.keySet()) {
            List<DavaFlowSet> listThis;
            otherKeyList.add(string);
            List<DavaFlowSet> listOther = otherMap.get(string);
            if (this.compareLists(listOther, listThis = thisMap.get(string))) continue;
            return false;
        }
        for (String string : thisMap.keySet()) {
            Iterator keyListIt = otherKeyList.iterator();
            boolean alreadyDone = false;
            while (keyListIt.hasNext()) {
                String doneKey = (String)keyListIt.next();
                if (!string.equals(doneKey)) continue;
                alreadyDone = true;
                break;
            }
            if (alreadyDone) continue;
            return false;
        }
        return true;
    }

    public List getContinueSet(String label) {
        return this.continueList.remove(label);
    }

    public List getBreakSet(String label) {
        return this.breakList.remove(label);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(" SET={");
        for (int i = 0; i < this.numElements; ++i) {
            if (i != 0) {
                b.append(" , ");
            }
            b.append(this.elements[i].toString());
        }
        b.append(" }");
        return b.toString();
    }
}

