/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.structuredAnalysis;

import java.util.List;
import soot.Local;
import soot.Value;
import soot.dava.internal.AST.ASTUnaryBinaryCondition;
import soot.dava.toolkits.base.AST.structuredAnalysis.DavaFlowSet;
import soot.dava.toolkits.base.AST.structuredAnalysis.StructuredAnalysis;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;

public class ReachingCopies
extends StructuredAnalysis {
    public ReachingCopies(Object analyze) {
        DavaFlowSet temp = (DavaFlowSet)this.process(analyze, new DavaFlowSet());
    }

    public DavaFlowSet emptyFlowSet() {
        return new DavaFlowSet();
    }

    public void setMergeType() {
        this.MERGETYPE = 2;
    }

    public Object newInitialFlow() {
        return new DavaFlowSet();
    }

    public Object cloneFlowSet(Object flowSet) {
        if (flowSet instanceof DavaFlowSet) {
            return ((DavaFlowSet)flowSet).clone();
        }
        throw new RuntimeException("cloneFlowSet not implemented for other flowSet types");
    }

    public Object processUnaryBinaryCondition(ASTUnaryBinaryCondition cond, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    public Object processSynchronizedLocal(Local local, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    public Object processSwitchKey(Value key, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processCondition is not implemented for other flowSet types");
        }
        return input;
    }

    public Object processStatement(Stmt s, Object input) {
        if (!(input instanceof DavaFlowSet)) {
            throw new RuntimeException("processStatement is not implemented for other flowSet types");
        }
        DavaFlowSet inSet = (DavaFlowSet)input;
        if (inSet == this.NOPATH) {
            return inSet;
        }
        if (s instanceof DefinitionStmt) {
            DavaFlowSet toReturn = (DavaFlowSet)this.cloneFlowSet(inSet);
            Value leftOp = ((DefinitionStmt)s).getLeftOp();
            Value rightOp = ((DefinitionStmt)s).getRightOp();
            if (leftOp instanceof Local) {
                this.kill(toReturn, (Local)leftOp);
            }
            if (leftOp instanceof Local && rightOp instanceof Local) {
                this.gen(toReturn, (Local)leftOp, (Local)rightOp);
            }
            return toReturn;
        }
        return input;
    }

    public void gen(DavaFlowSet in, Local left, Local right) {
        LocalPair localp = new LocalPair(left, right);
        in.add(localp);
    }

    public void kill(DavaFlowSet in, Local redefined) {
        List list = in.toList();
        for (LocalPair tempPair : list) {
            if (!tempPair.contains(redefined)) continue;
            in.remove(tempPair);
        }
    }

    public DavaFlowSet getReachingCopies(Object node) {
        Object beforeSet = this.getBeforeSet(node);
        if (beforeSet == null) {
            throw new RuntimeException("Could not get reaching copies of node/stmt");
        }
        if (!(beforeSet instanceof DavaFlowSet)) {
            throw new RuntimeException("Reaching def set is not a Dava FlowSet");
        }
        DavaFlowSet beforeSetReaching = (DavaFlowSet)beforeSet;
        return beforeSetReaching;
    }

    public class LocalPair {
        private final Local leftLocal;
        private final Local rightLocal;

        public LocalPair(Local left, Local right) {
            this.leftLocal = left;
            this.rightLocal = right;
        }

        public Local getLeftLocal() {
            return this.leftLocal;
        }

        public Local getRightLocal() {
            return this.rightLocal;
        }

        public boolean equals(Object other) {
            return other instanceof LocalPair && this.leftLocal.toString().equals(((LocalPair)other).getLeftLocal().toString()) && this.rightLocal.toString().equals(((LocalPair)other).getRightLocal().toString());
        }

        public boolean contains(Local local) {
            return this.leftLocal.toString().equals(local.toString()) || this.rightLocal.toString().equals(local.toString());
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append("<" + this.leftLocal.toString() + "," + this.rightLocal.toString() + ">");
            return b.toString();
        }
    }
}

