/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.Local;
import soot.Value;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.traversals.ASTParentNodeFinder;
import soot.dava.toolkits.base.AST.traversals.ASTUsesAndDefs;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.Stmt;
import soot.util.Chain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalVariableCleaner
extends DepthFirstAdapter {
    public final boolean DEBUG = false;
    ASTNode AST;
    ASTUsesAndDefs useDefs;
    ASTParentNodeFinder parentOf;

    public LocalVariableCleaner(ASTNode AST) {
        this.AST = AST;
        this.parentOf = new ASTParentNodeFinder();
        AST.apply(this.parentOf);
    }

    public LocalVariableCleaner(boolean verbose, ASTNode AST) {
        super(verbose);
        this.AST = AST;
        this.parentOf = new ASTParentNodeFinder();
        AST.apply(this.parentOf);
    }

    @Override
    public void outASTMethodNode(ASTMethodNode node) {
        boolean redo = false;
        this.useDefs = new ASTUsesAndDefs(this.AST);
        this.AST.apply(this.useDefs);
        Iterator decIt = node.getDeclaredLocals().iterator();
        ArrayList<Local> removeList = new ArrayList<Local>();
        while (decIt.hasNext()) {
            Local var = (Local)decIt.next();
            List<DefinitionStmt> defs = this.getDefs(var);
            if (defs.size() == 0) {
                removeList.add(var);
                continue;
            }
            for (DefinitionStmt ds : defs) {
                if (!this.canRemoveDef(ds)) continue;
                redo = this.removeStmt(ds);
            }
        }
        for (Local removeLocal : removeList) {
            node.removeDeclaredLocal(removeLocal);
            if (this.AST instanceof ASTMethodNode) {
                DavaBody body = ((ASTMethodNode)this.AST).getDavaBody();
                Chain<Local> localChain = body.getLocals();
                if (removeLocal != null && localChain != null) {
                    localChain.remove(removeLocal);
                }
            } else {
                throw new DecompilationException("found AST which is not a methodNode");
            }
            redo = true;
        }
        if (redo) {
            this.outASTMethodNode(node);
        }
    }

    public boolean canRemoveDef(DefinitionStmt ds) {
        List uses = this.useDefs.getDUChain(ds);
        if (uses.size() != 0) {
            return false;
        }
        return ds.getRightOp() instanceof Local || ds.getRightOp() instanceof Constant;
    }

    public List<DefinitionStmt> getDefs(Local var) {
        ArrayList<DefinitionStmt> toReturn = new ArrayList<DefinitionStmt>();
        HashMap<Object, List> dU = this.useDefs.getDUHashMap();
        for (DefinitionStmt definitionStmt : dU.keySet()) {
            Value left = definitionStmt.getLeftOp();
            if (!(left instanceof Local) || ((Local)left).getName().compareTo(var.getName()) != 0) continue;
            toReturn.add(definitionStmt);
        }
        return toReturn;
    }

    public boolean removeStmt(Stmt stmt) {
        Object tempParent = this.parentOf.getParentOf(stmt);
        if (tempParent == null) {
            return false;
        }
        ASTNode parent = (ASTNode)tempParent;
        if (!(parent instanceof ASTStatementSequenceNode)) {
            return false;
        }
        ASTStatementSequenceNode parentNode = (ASTStatementSequenceNode)parent;
        ArrayList<Object> newSequence = new ArrayList<Object>();
        List<Object> stmts = parentNode.getStatements();
        int size = stmts.size();
        for (AugmentedStmt augmentedStmt : stmts) {
            Stmt s = augmentedStmt.get_Stmt();
            if (s.toString().compareTo(stmt.toString()) == 0) continue;
            newSequence.add(augmentedStmt);
        }
        parentNode.setStatements(newSequence);
        return newSequence.size() < size;
    }
}

