/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.dava.internal.AST.ASTAndCondition;
import soot.dava.internal.AST.ASTCondition;
import soot.dava.internal.AST.ASTDoWhileNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTUnconditionalLoopNode;
import soot.dava.internal.AST.ASTWhileNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DAbruptStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrengthenByIf {
    public static List<ASTNode> getNewNode(ASTNode loopNode, ASTIfNode ifNode) {
        ASTNode tempNode;
        List<Object> ifBody = ifNode.getIfBody();
        String label = StrengthenByIf.isItOnlyBreak(ifBody);
        if (label != null) {
            if (((ASTLabeledNode)loopNode).get_Label().toString() != null && ((ASTLabeledNode)loopNode).get_Label().toString().compareTo(label) == 0) {
                if (loopNode instanceof ASTWhileNode) {
                    ASTCondition outerCond = ((ASTWhileNode)loopNode).get_Condition();
                    ASTCondition innerCond = ifNode.get_Condition();
                    innerCond.flip();
                    ASTAndCondition newCond = new ASTAndCondition(outerCond, innerCond);
                    ArrayList<Object> newWhileBody = new ArrayList<Object>();
                    SETNodeLabel newLabel = new SETNodeLabel();
                    ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
                    toReturn.add(new ASTWhileNode(newLabel, newCond, newWhileBody));
                    return toReturn;
                }
                if (loopNode instanceof ASTDoWhileNode) {
                    return null;
                }
                if (loopNode instanceof ASTUnconditionalLoopNode) {
                    ASTCondition innerCond = ifNode.get_Condition();
                    innerCond.flip();
                    ArrayList<Object> newWhileBody = new ArrayList<Object>();
                    SETNodeLabel newLabel = new SETNodeLabel();
                    ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
                    toReturn.add(new ASTWhileNode(newLabel, innerCond, newWhileBody));
                    return toReturn;
                }
            }
        } else if (loopNode instanceof ASTUnconditionalLoopNode && ifBody.size() == 1 && (tempNode = (ASTNode)ifBody.get(0)) instanceof ASTStatementSequenceNode) {
            List<Object> statements = ((ASTStatementSequenceNode)tempNode).getStatements();
            Iterator<Object> stIt = statements.iterator();
            while (stIt.hasNext()) {
                AugmentedStmt as = (AugmentedStmt)stIt.next();
                Stmt stmt = as.get_Stmt();
                if (stmt instanceof DAbruptStmt && !stIt.hasNext()) {
                    DAbruptStmt abStmt = (DAbruptStmt)stmt;
                    if (!abStmt.is_Break()) continue;
                    String loopLabel = ((ASTLabeledNode)loopNode).get_Label().toString();
                    String breakLabel = abStmt.getLabel().toString();
                    if (loopLabel == null || breakLabel == null || loopLabel.compareTo(breakLabel) != 0) continue;
                    ASTCondition innerCond = ifNode.get_Condition();
                    innerCond.flip();
                    ArrayList<Object> newWhileBody = new ArrayList<Object>();
                    SETNodeLabel newLabel = ((ASTUnconditionalLoopNode)loopNode).get_Label();
                    ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
                    toReturn.add(new ASTWhileNode(newLabel, innerCond, newWhileBody));
                    Iterator<Object> tempIt = statements.iterator();
                    ArrayList<Object> newStmts = new ArrayList<Object>();
                    while (tempIt.hasNext()) {
                        Object tempStmt = tempIt.next();
                        if (!tempIt.hasNext()) continue;
                        newStmts.add(tempStmt);
                    }
                    toReturn.add(new ASTStatementSequenceNode(newStmts));
                    return toReturn;
                }
                if (!(stmt instanceof ReturnStmt) && !(stmt instanceof ReturnVoidStmt) || stIt.hasNext()) continue;
                ASTCondition innerCond = ifNode.get_Condition();
                innerCond.flip();
                ArrayList<Object> newWhileBody = new ArrayList<Object>();
                SETNodeLabel newLabel = new SETNodeLabel();
                ArrayList<ASTNode> toReturn = new ArrayList<ASTNode>();
                toReturn.add(new ASTWhileNode(newLabel, innerCond, newWhileBody));
                Iterator<Object> tempIt = statements.iterator();
                ArrayList<Object> newStmts = new ArrayList<Object>();
                while (tempIt.hasNext()) {
                    newStmts.add(tempIt.next());
                }
                toReturn.add(new ASTStatementSequenceNode(newStmts));
                return toReturn;
            }
        }
        return null;
    }

    private static String isItOnlyBreak(List<Object> body) {
        if (body.size() != 1) {
            return null;
        }
        ASTNode tempNode = (ASTNode)body.get(0);
        if (!(tempNode instanceof ASTStatementSequenceNode)) {
            return null;
        }
        List<Object> statements = ((ASTStatementSequenceNode)tempNode).getStatements();
        if (statements.size() != 1) {
            return null;
        }
        AugmentedStmt as = (AugmentedStmt)statements.get(0);
        Stmt stmt = as.get_Stmt();
        if (!(stmt instanceof DAbruptStmt)) {
            return null;
        }
        DAbruptStmt abStmt = (DAbruptStmt)stmt;
        if (!abStmt.is_Break()) {
            return null;
        }
        return abStmt.getLabel().toString();
    }
}

