/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PrimType;
import soot.RefType;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.VoidType;
import soot.dava.CorruptASTException;
import soot.dava.Dava;
import soot.dava.DavaBody;
import soot.dava.DecompilationException;
import soot.dava.internal.AST.ASTMethodNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.asg.AugmentedStmt;
import soot.dava.internal.javaRep.DIntConstant;
import soot.dava.internal.javaRep.DNewInvokeExpr;
import soot.dava.internal.javaRep.DSpecialInvokeExpr;
import soot.dava.internal.javaRep.DStaticInvokeExpr;
import soot.dava.internal.javaRep.DVariableDeclarationStmt;
import soot.dava.internal.javaRep.DVirtualInvokeExpr;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.traversals.ASTParentNodeFinder;
import soot.dava.toolkits.base.AST.traversals.ASTUsesAndDefs;
import soot.dava.toolkits.base.AST.traversals.AllDefinitionsFinder;
import soot.grimp.internal.GAssignStmt;
import soot.grimp.internal.GCastExpr;
import soot.grimp.internal.GInvokeStmt;
import soot.grimp.internal.GReturnStmt;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.internal.JimpleLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperFirstStmtHandler
extends DepthFirstAdapter {
    public final boolean DEBUG = false;
    ASTMethodNode originalASTMethod;
    DavaBody originalDavaBody;
    Unit originalConstructorUnit;
    InstanceInvokeExpr originalConstructorExpr;
    SootMethod originalSootMethod;
    SootClass originalSootClass;
    Map originalPMap;
    List argsOneTypes = null;
    List argsOneValues = null;
    List argsTwoValues = null;
    List argsTwoTypes = null;
    SootMethod newSootPreInitMethod = null;
    DavaBody newPreInitDavaBody = null;
    ASTMethodNode newASTPreInitMethod = null;
    SootMethod newConstructor = null;
    DavaBody newConstructorDavaBody = null;
    ASTMethodNode newASTConstructorMethod = null;
    List<Local> mustInitialize;
    int mustInitializeIndex = 0;

    public SuperFirstStmtHandler(ASTMethodNode AST) {
        this.originalASTMethod = AST;
        this.initialize();
    }

    public SuperFirstStmtHandler(boolean verbose, ASTMethodNode AST) {
        super(verbose);
        this.originalASTMethod = AST;
        this.initialize();
    }

    public void initialize() {
        this.originalDavaBody = this.originalASTMethod.getDavaBody();
        this.originalConstructorUnit = this.originalDavaBody.get_ConstructorUnit();
        this.originalConstructorExpr = this.originalDavaBody.get_ConstructorExpr();
        if (this.originalConstructorExpr != null) {
            this.argsTwoValues = this.originalConstructorExpr.getArgs();
            this.argsTwoTypes = new ArrayList();
            for (Value val : this.argsTwoValues) {
                Type type = val.getType();
                this.argsTwoTypes.add(type);
            }
        }
        this.originalSootMethod = this.originalDavaBody.getMethod();
        this.originalSootClass = this.originalSootMethod.getDeclaringClass();
        this.originalPMap = this.originalDavaBody.get_ParamMap();
        this.argsOneTypes = this.originalSootMethod.getParameterTypes();
        this.argsOneValues = new ArrayList();
        Iterator typeIt = this.argsOneTypes.iterator();
        int count = 0;
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            this.argsOneValues.add(this.originalPMap.get(new Integer(count)));
            ++count;
        }
    }

    @Override
    public void inASTStatementSequenceNode(ASTStatementSequenceNode node) {
        List<Object> stmts = node.getStatements();
        for (AugmentedStmt augmentedStmt : stmts) {
            Stmt u = augmentedStmt.get_Stmt();
            if (u != this.originalConstructorUnit) continue;
            ASTParentNodeFinder parentFinder = new ASTParentNodeFinder();
            this.originalASTMethod.apply(parentFinder);
            Object tempParent = parentFinder.getParentOf(node);
            if (tempParent != this.originalASTMethod) {
                this.removeInit();
                return;
            }
            this.createSootPreInitMethod();
            this.createNewASTPreInitMethod(node);
            if (this.newASTPreInitMethod == null) {
                this.removeInit();
                return;
            }
            if (!this.finalizePreInitMethod()) {
                this.removeInit();
                return;
            }
            this.createNewConstructor();
            this.createNewASTConstructor(node);
            if (!this.createCallToSuper()) {
                this.removeInit();
                return;
            }
            this.finalizeConstructor();
            if (!this.changeOriginalAST()) continue;
            this.debug("SuperFirstStmtHandler....inASTStatementSeuqneNode", "Added PreInit");
            G.v().SootMethodAddedByDava = true;
            G.v().SootMethodsAdded.add(this.newSootPreInitMethod);
            G.v().SootMethodsAdded.add(this.newConstructor);
            G.v().SootClassNeedsDavaSuperHandlerClass.add(this.originalSootClass);
        }
    }

    public void removeInit() {
        ArrayList<Object> newBody = new ArrayList<Object>();
        List<Object> subBody = this.originalASTMethod.get_SubBodies();
        if (subBody.size() != 1) {
            return;
        }
        List oldBody = (List)subBody.get(0);
        for (ASTNode node : oldBody) {
            if (!(node instanceof ASTStatementSequenceNode)) {
                newBody.add(node);
                continue;
            }
            ASTStatementSequenceNode seqNode = (ASTStatementSequenceNode)node;
            ArrayList<Object> newStmtList = new ArrayList<Object>();
            List<Object> stmts = seqNode.getStatements();
            for (AugmentedStmt augmentedStmt : stmts) {
                Stmt stmtTemp = augmentedStmt.get_Stmt();
                if (stmtTemp == this.originalConstructorUnit) continue;
                newStmtList.add(augmentedStmt);
            }
            if (newStmtList.size() == 0) continue;
            newBody.add(new ASTStatementSequenceNode(newStmtList));
        }
        this.originalASTMethod.replaceBody(newBody);
    }

    public boolean changeOriginalAST() {
        if (this.originalConstructorExpr == null) {
            return false;
        }
        ArrayList<DStaticInvokeExpr> thisArgList = new ArrayList<DStaticInvokeExpr>();
        thisArgList.addAll(this.argsOneValues);
        DStaticInvokeExpr newInvokeExpr = new DStaticInvokeExpr(this.newSootPreInitMethod.makeRef(), this.argsOneValues);
        thisArgList.add(newInvokeExpr);
        DSpecialInvokeExpr tempExpr = new DSpecialInvokeExpr(this.originalConstructorExpr.getBase(), this.newConstructor.makeRef(), thisArgList);
        this.originalDavaBody.set_ConstructorExpr(tempExpr);
        GInvokeStmt s = new GInvokeStmt(tempExpr);
        this.originalDavaBody.set_ConstructorUnit(s);
        this.originalASTMethod.setDeclarations(new ASTStatementSequenceNode(new ArrayList<Object>()));
        this.originalASTMethod.replaceBody(new ArrayList<Object>());
        return true;
    }

    private SootMethodRef makeMethodRef(String methodName, ArrayList args) {
        SootMethod method = new SootMethod(methodName, args, RefType.v("java.lang.Object"));
        method.setDeclaringClass(new SootClass("DavaSuperHandler"));
        return method.makeRef();
    }

    private boolean createCallToSuper() {
        if (this.originalConstructorExpr == null) {
            return false;
        }
        SootClass parentClass = this.originalSootClass.getSuperclass();
        if (!parentClass.declaresMethod("<init>", this.argsTwoTypes)) {
            return false;
        }
        SootMethod superConstructor = parentClass.getMethod("<init>", this.argsTwoTypes);
        ArrayList<Value> argsForConstructor = new ArrayList<Value>();
        int count = 0;
        RefType type = new SootClass("DavaSuperHandler").getType();
        JimpleLocal jimpleLocal = new JimpleLocal("handler", type);
        ArrayList<IntType> tempList = new ArrayList<IntType>();
        tempList.add(IntType.v());
        SootMethodRef getMethodRef = this.makeMethodRef("get", tempList);
        ArrayList<DIntConstant> tempArgList = null;
        for (Type tempType : this.argsTwoTypes) {
            DIntConstant arg = DIntConstant.v(count, IntType.v());
            ++count;
            tempArgList = new ArrayList<DIntConstant>();
            tempArgList.add(arg);
            DVirtualInvokeExpr tempInvokeExpr = new DVirtualInvokeExpr(jimpleLocal, getMethodRef, tempArgList, new HashSet<Object>());
            Value toAddExpr = this.getProperCasting(tempType, tempInvokeExpr);
            if (toAddExpr == null) {
                throw new DecompilationException("UNABLE TO CREATE TOADDEXPR:" + tempType);
            }
            argsForConstructor.add(toAddExpr);
        }
        this.mustInitializeIndex = count;
        DVirtualInvokeExpr virtualInvoke = new DVirtualInvokeExpr(this.originalConstructorExpr.getBase(), superConstructor.makeRef(), argsForConstructor, new HashSet<Object>());
        this.newConstructorDavaBody.set_ConstructorExpr(virtualInvoke);
        GInvokeStmt s = new GInvokeStmt(virtualInvoke);
        this.newConstructorDavaBody.set_ConstructorUnit(s);
        return true;
    }

    public Value getProperCasting(Type tempType, DVirtualInvokeExpr tempInvokeExpr) {
        if (tempType instanceof RefType) {
            return new GCastExpr(tempInvokeExpr, tempType);
        }
        if (tempType instanceof PrimType) {
            PrimType t = (PrimType)tempType;
            if (t == BooleanType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Boolean"));
                SootMethod tempMethod = new SootMethod("booleanValue", new ArrayList(), BooleanType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Boolean"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == ByteType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Byte"));
                SootMethod tempMethod = new SootMethod("byteValue", new ArrayList(), ByteType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Byte"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == CharType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Character"));
                SootMethod tempMethod = new SootMethod("charValue", new ArrayList(), CharType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Character"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == DoubleType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Double"));
                SootMethod tempMethod = new SootMethod("doubleValue", new ArrayList(), DoubleType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Double"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == FloatType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Float"));
                SootMethod tempMethod = new SootMethod("floatValue", new ArrayList(), FloatType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Float"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == IntType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Integer"));
                SootMethod tempMethod = new SootMethod("intValue", new ArrayList(), IntType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Integer"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == LongType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Long"));
                SootMethod tempMethod = new SootMethod("longValue", new ArrayList(), LongType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Long"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            if (t == ShortType.v()) {
                GCastExpr tempExpr = new GCastExpr(tempInvokeExpr, (Type)RefType.v("java.lang.Short"));
                SootMethod tempMethod = new SootMethod("shortValue", new ArrayList(), ShortType.v());
                tempMethod.setDeclaringClass(new SootClass("java.lang.Short"));
                SootMethodRef tempMethodRef = tempMethod.makeRef();
                return new DVirtualInvokeExpr(tempExpr, tempMethodRef, new ArrayList(), new HashSet<Object>());
            }
            throw new DecompilationException("Unhandle primType:" + tempType);
        }
        throw new DecompilationException("The type:" + tempType + " was not a reftye or primtype. PLEASE REPORT.");
    }

    private void finalizeConstructor() {
        this.newASTConstructorMethod.setDavaBody(this.newConstructorDavaBody);
        this.newConstructorDavaBody.getUnits().clear();
        this.newConstructorDavaBody.getUnits().addLast(this.newASTConstructorMethod);
        System.out.println("Setting declaring class of method" + this.newConstructor.getSubSignature());
        this.newConstructor.setDeclaringClass(this.originalSootClass);
    }

    private boolean finalizePreInitMethod() {
        this.newASTPreInitMethod.setDavaBody(this.newPreInitDavaBody);
        this.newPreInitDavaBody.getUnits().clear();
        this.newPreInitDavaBody.getUnits().addLast(this.newASTPreInitMethod);
        List<Object> subBodies = this.newASTPreInitMethod.get_SubBodies();
        if (subBodies.size() != 1) {
            return false;
        }
        List body = (List)subBodies.get(0);
        Iterator it = body.iterator();
        boolean empty = true;
        while (it.hasNext()) {
            ASTNode tempNode = (ASTNode)it.next();
            if (!(tempNode instanceof ASTStatementSequenceNode)) {
                empty = false;
                break;
            }
            List<Object> stmts = ((ASTStatementSequenceNode)tempNode).getStatements();
            for (AugmentedStmt augmentedStmt : stmts) {
                Stmt s = augmentedStmt.get_Stmt();
                if (s instanceof DVariableDeclarationStmt) continue;
                empty = false;
                break;
            }
            if (empty) continue;
            break;
        }
        if (empty) {
            return false;
        }
        this.createDavaStoreStmts();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void createNewASTConstructor(ASTStatementSequenceNode initNode) {
        void var14_20;
        List<Object> originalASTMethodSubBodies;
        AugmentedStmt augStmt;
        Stmt stmtTemp;
        ArrayList<Object> newConstructorBody = new ArrayList<Object>();
        ArrayList<Object> newStmts = new ArrayList<Object>();
        RefType type = new SootClass("DavaSuperHandler").getType();
        JimpleLocal jimpleLocal = new JimpleLocal("handler", type);
        ArrayList<IntType> tempList = new ArrayList<IntType>();
        tempList.add(IntType.v());
        SootMethodRef getMethodRef = this.makeMethodRef("get", tempList);
        if (this.mustInitialize != null) {
            for (Local initLocal : this.mustInitialize) {
                Type tempType = initLocal.getType();
                DIntConstant arg = DIntConstant.v(this.mustInitializeIndex, IntType.v());
                ++this.mustInitializeIndex;
                ArrayList<DIntConstant> tempArgList = new ArrayList<DIntConstant>();
                tempArgList.add(arg);
                DVirtualInvokeExpr tempInvokeExpr = new DVirtualInvokeExpr(jimpleLocal, getMethodRef, tempArgList, new HashSet<Object>());
                Value value = this.getProperCasting(tempType, tempInvokeExpr);
                if (value == null) {
                    throw new DecompilationException("UNABLE TO CREATE TOADDEXPR:" + tempType);
                }
                GAssignStmt assign = new GAssignStmt(initLocal, value);
                newStmts.add(new AugmentedStmt(assign));
            }
        }
        Iterator<Object> it = initNode.getStatements().iterator();
        while (it.hasNext() && (stmtTemp = (augStmt = (AugmentedStmt)it.next()).get_Stmt()) != this.originalConstructorUnit) {
        }
        while (it.hasNext()) {
            newStmts.add(it.next());
        }
        if (newStmts.size() > 0) {
            newConstructorBody.add(new ASTStatementSequenceNode(newStmts));
        }
        if ((originalASTMethodSubBodies = this.originalASTMethod.get_SubBodies()).size() != 1) {
            throw new CorruptASTException("size of ASTMethodNode subBody not 1");
        }
        List oldASTBody = (List)originalASTMethodSubBodies.get(0);
        it = oldASTBody.iterator();
        boolean sanity = false;
        while (it.hasNext()) {
            ASTNode tempNode = (ASTNode)it.next();
            if (!(tempNode instanceof ASTStatementSequenceNode) || !((Object)((ASTStatementSequenceNode)tempNode).getStatements()).equals(initNode.getStatements())) continue;
            sanity = true;
            break;
        }
        if (!sanity) {
            throw new DecompilationException("never found the init node");
        }
        while (it.hasNext()) {
            newConstructorBody.add(it.next());
        }
        ArrayList<Object> newConstructorDeclarations = new ArrayList<Object>();
        for (AugmentedStmt augmentedStmt : this.originalASTMethod.getDeclarations().getStatements()) {
            DVariableDeclarationStmt varDecStmt = (DVariableDeclarationStmt)augmentedStmt.get_Stmt();
            newConstructorDeclarations.add(new AugmentedStmt((DVariableDeclarationStmt)varDecStmt.clone()));
        }
        ASTStatementSequenceNode aSTStatementSequenceNode = new ASTStatementSequenceNode(new ArrayList<Object>());
        if (newConstructorDeclarations.size() > 0) {
            ASTStatementSequenceNode aSTStatementSequenceNode2 = new ASTStatementSequenceNode(newConstructorDeclarations);
            newConstructorBody.add(0, aSTStatementSequenceNode2);
        }
        this.newASTConstructorMethod = new ASTMethodNode(newConstructorBody);
        this.newASTConstructorMethod.setDeclarations((ASTStatementSequenceNode)var14_20);
    }

    private void createNewConstructor() {
        String uniqueName = "<init>";
        ArrayList<RefType> args = new ArrayList<RefType>();
        args.addAll(this.argsOneTypes);
        RefType type = new SootClass("DavaSuperHandler").getType();
        args.add(type);
        this.newConstructor = new SootMethod(uniqueName, args, IntType.v());
        this.newConstructor.setDeclaringClass(this.originalSootClass);
        this.newConstructor.setModifiers(1);
        this.newConstructorDavaBody = Dava.v().newBody(this.newConstructor);
        HashMap tempMap = new HashMap();
        Iterator typeIt = this.argsOneTypes.iterator();
        int count = 0;
        while (typeIt.hasNext()) {
            Type t = (Type)typeIt.next();
            tempMap.put(new Integer(count), this.originalPMap.get(new Integer(count)));
            ++count;
        }
        tempMap.put(new Integer(this.argsOneTypes.size()), "handler");
        this.newConstructorDavaBody.set_ParamMap(tempMap);
        this.newConstructor.setActiveBody(this.newConstructorDavaBody);
    }

    /*
     * WARNING - void declaration
     */
    private void createNewASTPreInitMethod(ASTStatementSequenceNode initNode) {
        void var10_13;
        AugmentedStmt augStmt;
        Stmt stmtTemp;
        ArrayList<Object> newPreinitBody = new ArrayList<Object>();
        List<Object> originalASTMethodSubBodies = this.originalASTMethod.get_SubBodies();
        if (originalASTMethodSubBodies.size() != 1) {
            throw new CorruptASTException("size of ASTMethodNode subBody not 1");
        }
        List oldASTBody = (List)originalASTMethodSubBodies.get(0);
        Iterator<Object> it = oldASTBody.iterator();
        boolean sanity = false;
        while (it.hasNext()) {
            ASTNode tempNode = (ASTNode)it.next();
            if (tempNode instanceof ASTStatementSequenceNode) {
                if (((Object)((ASTStatementSequenceNode)tempNode).getStatements()).equals(initNode.getStatements())) {
                    sanity = true;
                    break;
                }
                newPreinitBody.add(tempNode);
                continue;
            }
            newPreinitBody.add(tempNode);
        }
        if (!sanity) {
            throw new DecompilationException("never found the init node");
        }
        ArrayList<Object> newStmts = new ArrayList<Object>();
        it = initNode.getStatements().iterator();
        while (it.hasNext() && (stmtTemp = (augStmt = (AugmentedStmt)it.next()).get_Stmt()) != this.originalConstructorUnit) {
            newStmts.add(augStmt);
        }
        if (newStmts.size() > 0) {
            newPreinitBody.add(new ASTStatementSequenceNode(newStmts));
        }
        ArrayList<Object> newPreinitDeclarations = new ArrayList<Object>();
        for (AugmentedStmt augmentedStmt : this.originalASTMethod.getDeclarations().getStatements()) {
            DVariableDeclarationStmt varDecStmt = (DVariableDeclarationStmt)augmentedStmt.get_Stmt();
            newPreinitDeclarations.add(new AugmentedStmt((DVariableDeclarationStmt)varDecStmt.clone()));
        }
        ASTStatementSequenceNode aSTStatementSequenceNode = new ASTStatementSequenceNode(new ArrayList<Object>());
        if (newPreinitDeclarations.size() > 0) {
            ASTStatementSequenceNode aSTStatementSequenceNode2 = new ASTStatementSequenceNode(newPreinitDeclarations);
            newPreinitBody.remove(0);
            newPreinitBody.add(0, aSTStatementSequenceNode2);
        }
        if (newPreinitBody.size() < 1) {
            this.newASTPreInitMethod = null;
            return;
        }
        this.newASTPreInitMethod = new ASTMethodNode(newPreinitBody);
        this.newASTPreInitMethod.setDeclarations((ASTStatementSequenceNode)var10_13);
    }

    private void createSootPreInitMethod() {
        String uniqueName = this.getUniqueName();
        this.newSootPreInitMethod = new SootMethod(uniqueName, this.argsOneTypes, new SootClass("DavaSuperHandler").getType());
        this.newSootPreInitMethod.setDeclaringClass(this.originalSootClass);
        this.newSootPreInitMethod.setModifiers(10);
        this.newPreInitDavaBody = Dava.v().newBody(this.newSootPreInitMethod);
        this.newPreInitDavaBody.set_ParamMap(this.originalPMap);
        this.newSootPreInitMethod.setActiveBody(this.newPreInitDavaBody);
    }

    private String getUniqueName() {
        String toReturn = "preInit";
        int counter = 0;
        List<SootMethod> methodList = this.originalSootClass.getMethods();
        boolean done = false;
        block0: while (!done) {
            done = true;
            for (SootMethod temp : methodList) {
                if (temp instanceof SootMethod) {
                    SootMethod method = temp;
                    String name = method.getName();
                    if (toReturn.compareTo(name) != 0) continue;
                    toReturn = "preInit" + ++counter;
                    done = false;
                    break;
                }
                throw new DecompilationException("SootClass returned a non SootMethod method");
            }
            for (SootMethod method : G.v().SootMethodsAdded) {
                String name = method.getName();
                if (toReturn.compareTo(name) != 0) continue;
                toReturn = "preInit" + ++counter;
                done = false;
                continue block0;
            }
        }
        return toReturn;
    }

    private void createDavaStoreStmts() {
        ArrayList<Object> davaHandlerStmts = new ArrayList<Object>();
        SootClass sootClass = new SootClass("DavaSuperHandler");
        RefType localType = sootClass.getType();
        JimpleLocal newLocal = new JimpleLocal("handler", localType);
        DVariableDeclarationStmt varStmt = null;
        varStmt = new DVariableDeclarationStmt(localType, this.newPreInitDavaBody);
        varStmt.addLocal(newLocal);
        AugmentedStmt as = new AugmentedStmt(varStmt);
        davaHandlerStmts.add(as);
        DNewInvokeExpr invokeExpr = new DNewInvokeExpr(RefType.v(sootClass), this.makeMethodRef("DavaSuperHandler", new ArrayList()), new ArrayList());
        GAssignStmt initialization = new GAssignStmt(newLocal, invokeExpr);
        davaHandlerStmts.add(new AugmentedStmt(initialization));
        Iterator typeIt = this.argsTwoTypes.iterator();
        Iterator valIt = this.argsTwoValues.iterator();
        ArrayList<RefType> tempList = new ArrayList<RefType>();
        tempList.add(RefType.v("java.lang.Object"));
        SootMethod method = new SootMethod("store", tempList, VoidType.v());
        method.setDeclaringClass(sootClass);
        SootMethodRef getMethodRef = method.makeRef();
        while (typeIt.hasNext() && valIt.hasNext()) {
            Type tempType = (Type)typeIt.next();
            Value tempVal = (Value)valIt.next();
            AugmentedStmt toAdd = this.createStmtAccordingToType(tempType, tempVal, newLocal, getMethodRef);
            davaHandlerStmts.add(toAdd);
        }
        if (typeIt.hasNext() || valIt.hasNext()) {
            throw new DecompilationException("Error creating DavaHandler stmts");
        }
        List<Local> uniqueLocals = this.addDefsToLiveVariables();
        for (Local local : uniqueLocals) {
            AugmentedStmt toAdd = this.createStmtAccordingToType(local.getType(), local, newLocal, getMethodRef);
            davaHandlerStmts.add(toAdd);
        }
        this.mustInitialize = uniqueLocals;
        GReturnStmt returnStmt = new GReturnStmt(newLocal);
        davaHandlerStmts.add(new AugmentedStmt(returnStmt));
        ASTStatementSequenceNode addedNode = new ASTStatementSequenceNode(davaHandlerStmts);
        List<Object> subBodies = this.newASTPreInitMethod.get_SubBodies();
        if (subBodies.size() != 1) {
            throw new CorruptASTException("ASTMethodNode does not have one subBody");
        }
        List body = (List)subBodies.get(0);
        body.add(addedNode);
        this.newASTPreInitMethod.replaceBody(body);
    }

    public AugmentedStmt createStmtAccordingToType(Type tempType, Value tempVal, Local newLocal, SootMethodRef getMethodRef) {
        if (tempType instanceof RefType) {
            return this.createAugmentedStmtToAdd(newLocal, getMethodRef, tempVal);
        }
        if (tempType instanceof PrimType) {
            PrimType t = (PrimType)tempType;
            ArrayList<Value> argList = new ArrayList<Value>();
            argList.add(tempVal);
            if (t == BooleanType.v()) {
                ArrayList<IntType> typeList = new ArrayList<IntType>();
                typeList.add(IntType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Boolean"), this.makeMethodRef("Boolean", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == ByteType.v()) {
                ArrayList<ByteType> typeList = new ArrayList<ByteType>();
                typeList.add(ByteType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Byte"), this.makeMethodRef("Byte", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == CharType.v()) {
                ArrayList<CharType> typeList = new ArrayList<CharType>();
                typeList.add(CharType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Character"), this.makeMethodRef("Character", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == DoubleType.v()) {
                ArrayList<DoubleType> typeList = new ArrayList<DoubleType>();
                typeList.add(DoubleType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Double"), this.makeMethodRef("Double", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == FloatType.v()) {
                ArrayList<FloatType> typeList = new ArrayList<FloatType>();
                typeList.add(FloatType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Float"), this.makeMethodRef("Float", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == IntType.v()) {
                ArrayList<IntType> typeList = new ArrayList<IntType>();
                typeList.add(IntType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Integer"), this.makeMethodRef("Integer", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == LongType.v()) {
                ArrayList<LongType> typeList = new ArrayList<LongType>();
                typeList.add(LongType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Long"), this.makeMethodRef("Long", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            if (t == ShortType.v()) {
                ArrayList<ShortType> typeList = new ArrayList<ShortType>();
                typeList.add(ShortType.v());
                DNewInvokeExpr argForStore = new DNewInvokeExpr(RefType.v("java.lang.Short"), this.makeMethodRef("Short", typeList), argList);
                return this.createAugmentedStmtToAdd(newLocal, getMethodRef, argForStore);
            }
            throw new DecompilationException("UNHANDLED PRIMTYPE:" + tempType);
        }
        throw new DecompilationException("The type:" + tempType + " is neither a reftype or a primtype");
    }

    private List<Local> addDefsToLiveVariables() {
        AllDefinitionsFinder finder = new AllDefinitionsFinder();
        this.newASTPreInitMethod.apply(finder);
        List<DefinitionStmt> allDefs = finder.getAllDefs();
        ArrayList<Local> uniqueLocals = new ArrayList<Local>();
        ArrayList<DefinitionStmt> uniqueLocalDefs = new ArrayList<DefinitionStmt>();
        for (DefinitionStmt s : allDefs) {
            Value left = s.getLeftOp();
            if (!(left instanceof Local)) continue;
            if (uniqueLocals.contains(left)) {
                uniqueLocals.remove(left);
                uniqueLocalDefs.remove(s);
                continue;
            }
            uniqueLocals.add((Local)left);
            uniqueLocalDefs.add(s);
        }
        ASTParentNodeFinder parentFinder = new ASTParentNodeFinder();
        this.newASTPreInitMethod.apply(parentFinder);
        ArrayList<DefinitionStmt> toRemoveDefs = new ArrayList<DefinitionStmt>();
        for (DefinitionStmt s : uniqueLocalDefs) {
            Object grandParent;
            Object parent = parentFinder.getParentOf(s);
            if (parent == null || !(parent instanceof ASTStatementSequenceNode)) {
                toRemoveDefs.add(s);
            }
            if ((grandParent = parentFinder.getParentOf(parent)) != null && grandParent instanceof ASTMethodNode) continue;
            toRemoveDefs.add(s);
        }
        for (DefinitionStmt s : toRemoveDefs) {
            int index = uniqueLocalDefs.indexOf(s);
            uniqueLocals.remove(index);
            uniqueLocalDefs.remove(index);
        }
        toRemoveDefs = new ArrayList();
        ASTUsesAndDefs uDdU = new ASTUsesAndDefs(this.originalASTMethod);
        this.originalASTMethod.apply(uDdU);
        for (DefinitionStmt s : uniqueLocalDefs) {
            ArrayList uses;
            List temp = uDdU.getDUChain(s);
            if (temp == null) {
                toRemoveDefs.add(s);
            }
            if ((uses = (ArrayList)temp).size() == 0) {
                toRemoveDefs.add(s);
            }
            Iterator useIt = uses.iterator();
            boolean onlyInConstructorUnit = true;
            while (useIt.hasNext()) {
                Object tempUse = useIt.next();
                if (tempUse == this.originalConstructorUnit) continue;
                onlyInConstructorUnit = false;
            }
            if (!onlyInConstructorUnit) continue;
            toRemoveDefs.add(s);
        }
        for (DefinitionStmt s : toRemoveDefs) {
            int index = uniqueLocalDefs.indexOf(s);
            uniqueLocals.remove(index);
            uniqueLocalDefs.remove(index);
        }
        return uniqueLocals;
    }

    private AugmentedStmt createAugmentedStmtToAdd(Local newLocal, SootMethodRef getMethodRef, Value tempVal) {
        ArrayList<Value> tempArgList = new ArrayList<Value>();
        tempArgList.add(tempVal);
        DVirtualInvokeExpr tempInvokeExpr = new DVirtualInvokeExpr(newLocal, getMethodRef, tempArgList, new HashSet<Object>());
        GInvokeStmt s = new GInvokeStmt(tempInvokeExpr);
        return new AugmentedStmt(s);
    }

    public void debug(String methodName, String debug) {
    }
}

