/*
 * Decompiled with CFR 0.152.
 */
package soot.grimp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import soot.Body;
import soot.G;
import soot.Local;
import soot.PackManager;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.grimp.Grimp;
import soot.jimple.AbstractStmtSwitch;
import soot.jimple.AssignStmt;
import soot.jimple.BreakpointStmt;
import soot.jimple.EnterMonitorStmt;
import soot.jimple.ExitMonitorStmt;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.IfStmt;
import soot.jimple.InvokeStmt;
import soot.jimple.JimpleBody;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.NopStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThrowStmt;
import soot.jimple.internal.StmtBox;
import soot.options.Options;

public class GrimpBody
extends StmtBody {
    GrimpBody(SootMethod m) {
        super(m);
    }

    public Object clone() {
        GrimpBody b = Grimp.v().newBody(this.getMethod());
        b.importBodyContentsFrom(this);
        return b;
    }

    GrimpBody(Body body) {
        super(body.getMethod());
        if (Options.v().verbose()) {
            G.v().out.println("[" + this.getMethod().getName() + "] Constructing GrimpBody...");
        }
        JimpleBody jBody = null;
        if (!(body instanceof JimpleBody)) {
            throw new RuntimeException("Can only construct GrimpBody's from JimpleBody's (for now)");
        }
        jBody = (JimpleBody)body;
        Iterator<Local> localIt = jBody.getLocals().iterator();
        while (localIt.hasNext()) {
            this.getLocals().add(localIt.next());
        }
        Iterator<Unit> it = jBody.getUnits().iterator();
        final HashMap<Stmt, Stmt> oldToNew = new HashMap<Stmt, Stmt>(this.getUnits().size() * 2 + 1, 0.7f);
        LinkedList<Unit> updates = new LinkedList<Unit>();
        while (it.hasNext()) {
            Stmt stmt = (Stmt)it.next();
            final StmtBox newStmtBox = (StmtBox)Grimp.v().newStmtBox(null);
            final StmtBox updateStmtBox = (StmtBox)Grimp.v().newStmtBox(null);
            stmt.apply(new AbstractStmtSwitch(){

                public void caseAssignStmt(AssignStmt s) {
                    newStmtBox.setUnit(Grimp.v().newAssignStmt(s));
                }

                public void caseIdentityStmt(IdentityStmt s) {
                    newStmtBox.setUnit(Grimp.v().newIdentityStmt(s));
                }

                public void caseBreakpointStmt(BreakpointStmt s) {
                    newStmtBox.setUnit(Grimp.v().newBreakpointStmt(s));
                }

                public void caseInvokeStmt(InvokeStmt s) {
                    newStmtBox.setUnit(Grimp.v().newInvokeStmt(s));
                }

                public void caseEnterMonitorStmt(EnterMonitorStmt s) {
                    newStmtBox.setUnit(Grimp.v().newEnterMonitorStmt(s));
                }

                public void caseExitMonitorStmt(ExitMonitorStmt s) {
                    newStmtBox.setUnit(Grimp.v().newExitMonitorStmt(s));
                }

                public void caseGotoStmt(GotoStmt s) {
                    newStmtBox.setUnit(Grimp.v().newGotoStmt(s));
                    updateStmtBox.setUnit(s);
                }

                public void caseIfStmt(IfStmt s) {
                    newStmtBox.setUnit(Grimp.v().newIfStmt(s));
                    updateStmtBox.setUnit(s);
                }

                public void caseLookupSwitchStmt(LookupSwitchStmt s) {
                    newStmtBox.setUnit(Grimp.v().newLookupSwitchStmt(s));
                    updateStmtBox.setUnit(s);
                }

                public void caseNopStmt(NopStmt s) {
                    newStmtBox.setUnit(Grimp.v().newNopStmt(s));
                }

                public void caseReturnStmt(ReturnStmt s) {
                    newStmtBox.setUnit(Grimp.v().newReturnStmt(s));
                }

                public void caseReturnVoidStmt(ReturnVoidStmt s) {
                    newStmtBox.setUnit(Grimp.v().newReturnVoidStmt(s));
                }

                public void caseTableSwitchStmt(TableSwitchStmt s) {
                    newStmtBox.setUnit(Grimp.v().newTableSwitchStmt(s));
                    updateStmtBox.setUnit(s);
                }

                public void caseThrowStmt(ThrowStmt s) {
                    newStmtBox.setUnit(Grimp.v().newThrowStmt(s));
                }
            });
            Stmt newStmt = (Stmt)newStmtBox.getUnit();
            for (ValueBox b : newStmt.getUseBoxes()) {
                b.setValue(Grimp.v().newExpr(b.getValue()));
            }
            for (ValueBox b : newStmt.getDefBoxes()) {
                b.setValue(Grimp.v().newExpr(b.getValue()));
            }
            this.getUnits().add(newStmt);
            oldToNew.put(stmt, newStmt);
            if (updateStmtBox.getUnit() == null) continue;
            updates.add(updateStmtBox.getUnit());
        }
        for (Stmt stmt : updates) {
            stmt.apply(new AbstractStmtSwitch(){

                public void caseGotoStmt(GotoStmt s) {
                    GotoStmt newStmt = (GotoStmt)oldToNew.get(s);
                    newStmt.setTarget((Unit)oldToNew.get(newStmt.getTarget()));
                }

                public void caseIfStmt(IfStmt s) {
                    IfStmt newStmt = (IfStmt)oldToNew.get(s);
                    newStmt.setTarget((Unit)oldToNew.get(newStmt.getTarget()));
                }

                public void caseLookupSwitchStmt(LookupSwitchStmt s) {
                    LookupSwitchStmt newStmt = (LookupSwitchStmt)oldToNew.get(s);
                    newStmt.setDefaultTarget((Unit)oldToNew.get(newStmt.getDefaultTarget()));
                    Unit[] newTargList = new Unit[newStmt.getTargetCount()];
                    for (int i = 0; i < newStmt.getTargetCount(); ++i) {
                        newTargList[i] = (Unit)oldToNew.get(newStmt.getTarget(i));
                    }
                    newStmt.setTargets(newTargList);
                }

                public void caseTableSwitchStmt(TableSwitchStmt s) {
                    TableSwitchStmt newStmt = (TableSwitchStmt)oldToNew.get(s);
                    newStmt.setDefaultTarget((Unit)oldToNew.get(newStmt.getDefaultTarget()));
                    int tc = newStmt.getHighIndex() - newStmt.getLowIndex() + 1;
                    LinkedList<Unit> newTargList = new LinkedList<Unit>();
                    for (int i = 0; i < tc; ++i) {
                        newTargList.add((Unit)oldToNew.get(newStmt.getTarget(i)));
                    }
                    newStmt.setTargets(newTargList);
                }
            });
        }
        for (Trap oldTrap : jBody.getTraps()) {
            this.getTraps().add(Grimp.v().newTrap(oldTrap.getException(), (Unit)oldToNew.get(oldTrap.getBeginUnit()), (Unit)oldToNew.get(oldTrap.getEndUnit()), (Unit)oldToNew.get(oldTrap.getHandlerUnit())));
        }
        PackManager.v().getPack("gb").apply(this);
    }
}

