/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.NullType;
import soot.PatchingChain;
import soot.Scene;
import soot.SceneTransformer;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jbco.IJbcoTransform;
import soot.jbco.jimpleTransformations.FieldRenamer;
import soot.jbco.util.BodyBuilder;
import soot.jbco.util.Rand;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.LongConstant;
import soot.jimple.NullConstant;
import soot.jimple.StringConstant;
import soot.util.Chain;

public class CollectConstants
extends SceneTransformer
implements IJbcoTransform {
    int updatedConstants = 0;
    int constants = 0;
    public static String[] dependancies = new String[]{"wjtp.jbco_cc"};
    public static String name = "wjtp.jbco_cc";
    public static HashMap<Constant, SootField> constantsToFields = new HashMap();
    public static HashMap<Type, List<Constant>> typesToValues = new HashMap();
    public static SootField field = null;

    public void outputSummary() {
        out.println(this.constants + " constants found");
        out.println(this.updatedConstants + " static fields created");
    }

    public String[] getDependancies() {
        return dependancies;
    }

    public String getName() {
        return name;
    }

    protected void internalTransform(String phaseName, Map options) {
        Scene scene = G.v().soot_Scene();
        if (output) {
            out.println("Collecting Constant Data");
        }
        BodyBuilder.retrieveAllNames();
        Chain<SootClass> appClasses = scene.getApplicationClasses();
        for (SootClass cl : appClasses) {
            Object[] meths;
            for (Object element : meths = cl.getMethods().toArray()) {
                SootMethod m = (SootMethod)element;
                if (!m.hasActiveBody() || m.getName().indexOf("<clinit>") >= 0) continue;
                Body body = m.getActiveBody();
                Iterator<ValueBox> iter = body.getUseBoxes().iterator();
                while (iter.hasNext()) {
                    Value v = iter.next().getValue();
                    if (!(v instanceof Constant)) continue;
                    Constant c = (Constant)v;
                    Type t = c.getType();
                    List<Constant> values = typesToValues.get(t);
                    if (values == null) {
                        values = new ArrayList<Constant>();
                        typesToValues.put(t, values);
                    }
                    boolean found = false;
                    Iterator<Constant> vit = values.iterator();
                    while (vit.hasNext()) {
                        if (!vit.next().equals(c)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ++this.constants;
                    values.add(c);
                }
            }
        }
        int count = 0;
        String name = "newConstantJbcoName";
        Object[] classes = appClasses.toArray();
        for (Type t : typesToValues.keySet()) {
            if (t instanceof NullType) continue;
            for (Constant c : typesToValues.get(t)) {
                name = name + "_";
                SootClass rand = null;
                while ((rand = (SootClass)classes[Rand.getInt(classes.length)]).isInterface()) {
                }
                SootField newf = new SootField(FieldRenamer.getNewName(), t, 9);
                rand.addField(newf);
                FieldRenamer.sootFieldsRenamed.add(newf);
                FieldRenamer.addOldAndNewName(name, newf.getName());
                constantsToFields.put(c, newf);
                this.addInitializingValue(rand, newf, c);
                FieldRenamer.addOldAndNewName("addedConstant" + count++, newf.getName());
            }
        }
        this.updatedConstants += count;
    }

    private void addInitializingValue(SootClass clas, SootField f, Constant con) {
        SootMethod m;
        if (con instanceof NullConstant) {
            return;
        }
        if (con instanceof IntConstant ? ((IntConstant)con).value == 0 : (con instanceof LongConstant ? ((LongConstant)con).value == 0L : (con instanceof StringConstant ? ((StringConstant)con).value == null : (con instanceof DoubleConstant ? ((DoubleConstant)con).value == 0.0 : con instanceof FloatConstant && ((FloatConstant)con).value == 0.0f)))) {
            return;
        }
        Body b = null;
        boolean newInit = false;
        if (!clas.declaresMethodByName("<clinit>")) {
            m = new SootMethod("<clinit>", new ArrayList(), VoidType.v());
            clas.addMethod(m);
            b = Jimple.v().newBody(m);
            m.setActiveBody(b);
            newInit = true;
        } else {
            m = clas.getMethodByName("<clinit>");
            b = m.getActiveBody();
        }
        PatchingChain<Unit> units = b.getUnits();
        units.addFirst(Jimple.v().newAssignStmt(Jimple.v().newStaticFieldRef(f.makeRef()), con));
        if (newInit) {
            units.addLast(Jimple.v().newReturnVoidStmt());
        }
    }
}

