/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import soot.DoubleType;
import soot.Type;
import soot.jimple.ConstantSwitch;
import soot.jimple.IntConstant;
import soot.jimple.NumericConstant;
import soot.jimple.RealConstant;
import soot.util.Switch;

public class DoubleConstant
extends RealConstant {
    public final double value;

    private DoubleConstant(double value) {
        this.value = value;
    }

    public static DoubleConstant v(double value) {
        return new DoubleConstant(value);
    }

    public boolean equals(Object c) {
        return c instanceof DoubleConstant && ((DoubleConstant)c).value == this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public NumericConstant add(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return DoubleConstant.v(this.value + ((DoubleConstant)c).value);
    }

    public NumericConstant subtract(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return DoubleConstant.v(this.value - ((DoubleConstant)c).value);
    }

    public NumericConstant multiply(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return DoubleConstant.v(this.value * ((DoubleConstant)c).value);
    }

    public NumericConstant divide(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return DoubleConstant.v(this.value / ((DoubleConstant)c).value);
    }

    public NumericConstant remainder(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return DoubleConstant.v(this.value % ((DoubleConstant)c).value);
    }

    public NumericConstant equalEqual(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value == ((DoubleConstant)c).value ? 1 : 0);
    }

    public NumericConstant notEqual(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value != ((DoubleConstant)c).value ? 1 : 0);
    }

    public NumericConstant lessThan(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value < ((DoubleConstant)c).value ? 1 : 0);
    }

    public NumericConstant lessThanOrEqual(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value <= ((DoubleConstant)c).value ? 1 : 0);
    }

    public NumericConstant greaterThan(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value > ((DoubleConstant)c).value ? 1 : 0);
    }

    public NumericConstant greaterThanOrEqual(NumericConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        return IntConstant.v(this.value >= ((DoubleConstant)c).value ? 1 : 0);
    }

    public IntConstant cmpg(RealConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        double cValue = ((DoubleConstant)c).value;
        if (this.value < cValue) {
            return IntConstant.v(-1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(1);
    }

    public IntConstant cmpl(RealConstant c) {
        if (!(c instanceof DoubleConstant)) {
            throw new IllegalArgumentException("DoubleConstant expected");
        }
        double cValue = ((DoubleConstant)c).value;
        if (this.value > cValue) {
            return IntConstant.v(1);
        }
        if (this.value == cValue) {
            return IntConstant.v(0);
        }
        return IntConstant.v(-1);
    }

    public NumericConstant negate() {
        return DoubleConstant.v(-this.value);
    }

    public String toString() {
        String doubleString = new Double(this.value).toString();
        if (doubleString.equals("NaN") || doubleString.equals("Infinity") || doubleString.equals("-Infinity")) {
            return "#" + doubleString;
        }
        return doubleString;
    }

    public Type getType() {
        return DoubleType.v();
    }

    public void apply(Switch sw) {
        ((ConstantSwitch)sw).caseDoubleConstant(this);
    }
}

