/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple;

import java.util.Iterator;
import java.util.List;
import soot.AbstractUnit;
import soot.SootField;
import soot.SootFieldRef;
import soot.Type;
import soot.Unit;
import soot.UnitPrinter;
import soot.baf.Baf;
import soot.baf.StaticGetInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.FieldRef;
import soot.jimple.JimpleToBafContext;
import soot.jimple.RefSwitch;
import soot.tagkit.Tag;
import soot.util.Switch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticFieldRef
implements FieldRef,
ConvertToBaf {
    protected SootFieldRef fieldRef;

    protected StaticFieldRef(SootFieldRef fieldRef) {
        if (!fieldRef.isStatic()) {
            throw new RuntimeException("wrong static-ness");
        }
        this.fieldRef = fieldRef;
    }

    @Override
    public Object clone() {
        return new StaticFieldRef(this.fieldRef);
    }

    public String toString() {
        return this.fieldRef.getSignature();
    }

    @Override
    public void toString(UnitPrinter up) {
        up.fieldRef(this.fieldRef);
    }

    @Override
    public SootFieldRef getFieldRef() {
        return this.fieldRef;
    }

    @Override
    public void setFieldRef(SootFieldRef fieldRef) {
        this.fieldRef = fieldRef;
    }

    @Override
    public SootField getField() {
        return this.fieldRef.resolve();
    }

    @Override
    public List getUseBoxes() {
        return AbstractUnit.emptyList;
    }

    @Override
    public Type getType() {
        return this.fieldRef.type();
    }

    @Override
    public void apply(Switch sw) {
        ((RefSwitch)sw).caseStaticFieldRef(this);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof StaticFieldRef) {
            return ((StaticFieldRef)o).getField().equals(this.getField());
        }
        return false;
    }

    @Override
    public int equivHashCode() {
        return this.getField().equivHashCode();
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        StaticGetInst u = Baf.v().newStaticGetInst(this.fieldRef);
        out.add(u);
        Iterator<Tag> it = context.getCurrentUnit().getTags().iterator();
        while (it.hasNext()) {
            u.addTag(it.next());
        }
    }
}

