/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.parser.node;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import soot.jimple.parser.node.Cast;
import soot.jimple.parser.node.NoCast;

public class TypedLinkedList
extends LinkedList {
    Cast cast;

    public TypedLinkedList() {
        this.cast = NoCast.instance;
    }

    public TypedLinkedList(Collection c) {
        this.cast = NoCast.instance;
        this.addAll(c);
    }

    public TypedLinkedList(Cast cast) {
        this.cast = cast;
    }

    public TypedLinkedList(Collection c, Cast cast) {
        this.cast = cast;
        this.addAll(c);
    }

    public Cast getCast() {
        return this.cast;
    }

    public void add(int index, Object element) {
        super.add(index, this.cast.cast(element));
    }

    public boolean add(Object o) {
        return super.add(this.cast.cast(o));
    }

    public boolean addAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            super.add(this.cast.cast(i.next()));
        }
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int pos = index;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            super.add(pos++, this.cast.cast(i.next()));
        }
        return true;
    }

    public void addFirst(Object o) {
        super.addFirst(this.cast.cast(o));
    }

    public void addLast(Object o) {
        super.addLast(this.cast.cast(o));
    }

    public ListIterator listIterator(int index) {
        return new TypedLinkedListIterator(super.listIterator(index));
    }

    private class TypedLinkedListIterator
    implements ListIterator {
        ListIterator iterator;

        TypedLinkedListIterator(ListIterator iterator) {
            this.iterator = iterator;
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            return this.iterator.next();
        }

        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return this.iterator.previous();
        }

        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        public void remove() {
            this.iterator.remove();
        }

        public void set(Object o) {
            this.iterator.set(TypedLinkedList.this.cast.cast(o));
        }

        public void add(Object o) {
            this.iterator.add(TypedLinkedList.this.cast.cast(o));
        }
    }
}

