/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.internal;

import java.util.Iterator;
import soot.AnySubType;
import soot.FastHierarchy;
import soot.G;
import soot.NullType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.Type;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.util.ArrayNumberer;
import soot.util.BitVector;
import soot.util.LargeNumberedMap;
import soot.util.queue.QueueReader;

public final class TypeManager {
    private LargeNumberedMap typeMask = null;
    protected FastHierarchy fh = null;
    protected PAG pag;
    protected QueueReader allocNodeListener = null;

    public TypeManager(PAG pag) {
        this.pag = pag;
    }

    public static boolean isUnresolved(Type type) {
        if (!(type instanceof RefType)) {
            return false;
        }
        RefType rt = (RefType)type;
        if (!rt.hasSootClass()) {
            return true;
        }
        SootClass cl = rt.getSootClass();
        return cl.resolvingLevel() < 1;
    }

    public final BitVector get(Type type) {
        if (type == null) {
            return null;
        }
        while (this.allocNodeListener.hasNext()) {
            AllocNode n = (AllocNode)this.allocNodeListener.next();
            Iterator tIt = Scene.v().getTypeNumberer().iterator();
            while (tIt.hasNext()) {
                Type t = (Type)tIt.next();
                if (!(t instanceof RefLikeType) || t instanceof AnySubType || TypeManager.isUnresolved(t) || !this.castNeverFails(n.getType(), t)) continue;
                BitVector mask = (BitVector)this.typeMask.get(t);
                if (mask == null) {
                    mask = new BitVector();
                    this.typeMask.put(t, mask);
                    Iterator anIt = this.pag.getAllocNodeNumberer().iterator();
                    while (anIt.hasNext()) {
                        AllocNode an = (AllocNode)anIt.next();
                        if (!this.castNeverFails(an.getType(), t)) continue;
                        mask.set(an.getNumber());
                    }
                    continue;
                }
                mask.set(n.getNumber());
            }
        }
        BitVector ret = (BitVector)this.typeMask.get(type);
        if (ret == null && this.fh != null) {
            throw new RuntimeException("oops" + type);
        }
        return ret;
    }

    public final void clearTypeMask() {
        this.typeMask = null;
    }

    public final void makeTypeMask() {
        RefType.v("java.lang.Class");
        this.typeMask = new LargeNumberedMap(Scene.v().getTypeNumberer());
        if (this.fh == null) {
            return;
        }
        int numTypes = Scene.v().getTypeNumberer().size();
        if (this.pag.getOpts().verbose()) {
            G.v().out.println("Total types: " + numTypes);
        }
        ArrayNumberer allocNodes = this.pag.getAllocNodeNumberer();
        Iterator tIt = Scene.v().getTypeNumberer().iterator();
        while (tIt.hasNext()) {
            Type t = (Type)tIt.next();
            if (!(t instanceof RefLikeType) || t instanceof AnySubType || TypeManager.isUnresolved(t)) continue;
            BitVector mask = new BitVector(allocNodes.size());
            Iterator nIt = allocNodes.iterator();
            while (nIt.hasNext()) {
                Node n = (Node)nIt.next();
                if (!this.castNeverFails(n.getType(), t)) continue;
                mask.set(n.getNumber());
            }
            this.typeMask.put(t, mask);
        }
        this.allocNodeListener = this.pag.allocNodeListener();
    }

    public final boolean castNeverFails(Type src, Type dst) {
        if (this.fh == null) {
            return true;
        }
        if (dst == null) {
            return true;
        }
        if (dst == src) {
            return true;
        }
        if (src == null) {
            return false;
        }
        if (dst.equals(src)) {
            return true;
        }
        if (src instanceof NullType) {
            return true;
        }
        if (src instanceof AnySubType) {
            return true;
        }
        if (dst instanceof NullType) {
            return false;
        }
        if (dst instanceof AnySubType) {
            throw new RuntimeException("oops src=" + src + " dst=" + dst);
        }
        return this.fh.canStoreType(src, dst);
    }

    public void setFastHierarchy(FastHierarchy fh) {
        this.fh = fh;
    }

    public FastHierarchy getFastHierarchy() {
        return this.fh;
    }
}

