/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand;

import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.ondemand.EverythingHeuristic;
import soot.jimple.spark.ondemand.FieldCheckHeuristic;
import soot.jimple.spark.ondemand.InnerTypesIncrementalHeuristic;
import soot.jimple.spark.ondemand.ManualAndInnerHeuristic;
import soot.jimple.spark.ondemand.ManualFieldCheckHeuristic;
import soot.jimple.spark.ondemand.NothingHeuristic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum HeuristicType {
    MANUAL,
    INCR,
    EVERY,
    MANUALINCR,
    NOTHING;


    public static FieldCheckHeuristic getHeuristic(HeuristicType type, TypeManager tm, int maxPasses) {
        FieldCheckHeuristic ret = null;
        switch (type) {
            case MANUAL: {
                ret = new ManualFieldCheckHeuristic();
                break;
            }
            case INCR: {
                ret = new InnerTypesIncrementalHeuristic(tm, maxPasses);
                break;
            }
            case EVERY: {
                ret = new EverythingHeuristic();
                break;
            }
            case MANUALINCR: {
                ret = new ManualAndInnerHeuristic(tm, maxPasses);
                break;
            }
            case NOTHING: {
                ret = new NothingHeuristic();
                break;
            }
        }
        return ret;
    }
}

