/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.pag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import soot.Context;
import soot.FastHierarchy;
import soot.G;
import soot.Kind;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ClassConstant;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.spark.builder.GlobalNodeFactory;
import soot.jimple.spark.builder.MethodNodeFactory;
import soot.jimple.spark.internal.TypeManager;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.spark.pag.AllocNode;
import soot.jimple.spark.pag.ArrayElement;
import soot.jimple.spark.pag.ClassConstantNode;
import soot.jimple.spark.pag.ContextVarNode;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.GlobalVarNode;
import soot.jimple.spark.pag.LocalVarNode;
import soot.jimple.spark.pag.MethodPAG;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.StringConstantNode;
import soot.jimple.spark.pag.VarNode;
import soot.jimple.spark.sets.BitPointsToSet;
import soot.jimple.spark.sets.DoublePointsToSet;
import soot.jimple.spark.sets.EmptyPointsToSet;
import soot.jimple.spark.sets.HashPointsToSet;
import soot.jimple.spark.sets.HybridPointsToSet;
import soot.jimple.spark.sets.P2SetFactory;
import soot.jimple.spark.sets.P2SetVisitor;
import soot.jimple.spark.sets.PointsToSetInternal;
import soot.jimple.spark.sets.SharedHybridSet;
import soot.jimple.spark.sets.SharedListSet;
import soot.jimple.spark.sets.SortedArraySet;
import soot.jimple.spark.solver.OnFlyCallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.pointer.util.NativeMethodDriver;
import soot.options.SparkOptions;
import soot.tagkit.LinkTag;
import soot.tagkit.StringTag;
import soot.tagkit.Tag;
import soot.toolkits.scalar.Pair;
import soot.util.ArrayNumberer;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PAG
implements PointsToAnalysis {
    protected static final Node[] EMPTY_NODE_ARRAY = new Node[0];
    protected P2SetFactory setFactory;
    protected boolean somethingMerged = false;
    ChunkedQueue newAllocNodes = new ChunkedQueue();
    protected ChunkedQueue edgeQueue = new ChunkedQueue();
    private final ArrayNumberer allocNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer varNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer fieldRefNodeNumberer = new ArrayNumberer();
    private final ArrayNumberer allocDotFieldNodeNumberer = new ArrayNumberer();
    protected SparkOptions opts;
    protected Map<Object, Object> simple = new HashMap<Object, Object>();
    protected Map<Object, Object> load = new HashMap<Object, Object>();
    protected Map<Object, Object> store = new HashMap<Object, Object>();
    protected Map<Object, Object> alloc = new HashMap<Object, Object>();
    protected Map<Object, Object> simpleInv = new HashMap<Object, Object>();
    protected Map<Object, Object> loadInv = new HashMap<Object, Object>();
    protected Map<Object, Object> storeInv = new HashMap<Object, Object>();
    protected Map<Object, Object> allocInv = new HashMap<Object, Object>();
    private final Map<Object, LocalVarNode> valToLocalVarNode = new HashMap<Object, LocalVarNode>(1000);
    private final Map<Object, GlobalVarNode> valToGlobalVarNode = new HashMap<Object, GlobalVarNode>(1000);
    private final Map<Object, AllocNode> valToAllocNode = new HashMap<Object, AllocNode>(1000);
    private OnFlyCallGraph ofcg;
    private final ArrayList<VarNode> dereferences = new ArrayList();
    protected TypeManager typeManager;
    private final LargeNumberedMap localToNodeMap = new LargeNumberedMap(Scene.v().getLocalNumberer());
    public int maxFinishNumber = 0;
    private Map<Node, Tag> nodeToTag;
    private final GlobalNodeFactory nodeFactory = new GlobalNodeFactory(this);
    public NativeMethodDriver nativeMethodDriver;
    public HashMultiMap callAssigns = new HashMultiMap();
    public Map<InvokeExpr, SootMethod> callToMethod = new HashMap<InvokeExpr, SootMethod>();
    public Map<InvokeExpr, Node> virtualCallsToReceivers = new HashMap<InvokeExpr, Node>();

    public PAG(SparkOptions opts) {
        this.opts = opts;
        if (opts.add_tags()) {
            this.nodeToTag = new HashMap<Node, Tag>();
        }
        this.typeManager = new TypeManager(this);
        if (!opts.ignore_types()) {
            this.typeManager.setFastHierarchy(Scene.v().getOrMakeFastHierarchy());
        }
        switch (opts.set_impl()) {
            case 1: {
                this.setFactory = HashPointsToSet.getFactory();
                break;
            }
            case 3: {
                this.setFactory = HybridPointsToSet.getFactory();
                break;
            }
            case 5: {
                this.setFactory = SharedHybridSet.getFactory();
                break;
            }
            case 6: {
                this.setFactory = SharedListSet.getFactory();
                break;
            }
            case 4: {
                this.setFactory = SortedArraySet.getFactory();
                break;
            }
            case 2: {
                this.setFactory = BitPointsToSet.getFactory();
                break;
            }
            case 7: {
                P2SetFactory newF;
                P2SetFactory oldF;
                switch (opts.double_set_old()) {
                    case 1: {
                        oldF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        oldF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        oldF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        oldF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        oldF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        oldF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                switch (opts.double_set_new()) {
                    case 1: {
                        newF = HashPointsToSet.getFactory();
                        break;
                    }
                    case 3: {
                        newF = HybridPointsToSet.getFactory();
                        break;
                    }
                    case 5: {
                        newF = SharedHybridSet.getFactory();
                        break;
                    }
                    case 6: {
                        newF = SharedListSet.getFactory();
                        break;
                    }
                    case 4: {
                        newF = SortedArraySet.getFactory();
                        break;
                    }
                    case 2: {
                        newF = BitPointsToSet.getFactory();
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                this.setFactory = DoublePointsToSet.getFactory(newF, oldF);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    @Override
    public PointsToSet reachingObjects(Local l) {
        LocalVarNode n = this.findLocalVarNode(l);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l) {
        ContextVarNode n = this.findContextVarNode(l, c);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(SootField f) {
        if (!f.isStatic()) {
            throw new RuntimeException("The parameter f must be a *static* field.");
        }
        GlobalVarNode n = this.findGlobalVarNode(f);
        if (n == null) {
            return EmptyPointsToSet.v();
        }
        return n.getP2Set();
    }

    @Override
    public PointsToSet reachingObjects(PointsToSet s, SootField f) {
        if (f.isStatic()) {
            throw new RuntimeException("The parameter f must be an *instance* field.");
        }
        return this.reachingObjectsInternal(s, f);
    }

    @Override
    public PointsToSet reachingObjectsOfArrayElement(PointsToSet s) {
        return this.reachingObjectsInternal(s, ArrayElement.v());
    }

    private PointsToSet reachingObjectsInternal(PointsToSet s, final SparkField f) {
        if (this.getOpts().field_based() || this.getOpts().vta()) {
            GlobalVarNode n = this.findGlobalVarNode(f);
            if (n == null) {
                return EmptyPointsToSet.v();
            }
            return n.getP2Set();
        }
        if (this.getOpts().propagator() == 5) {
            throw new RuntimeException("The alias edge propagator does not compute points-to information for instance fields! Use a different propagator.");
        }
        PointsToSetInternal bases = (PointsToSetInternal)s;
        final PointsToSetInternal ret = this.setFactory.newSet(f instanceof SootField ? ((SootField)f).getType() : null, this);
        bases.forall(new P2SetVisitor(){

            public final void visit(Node n) {
                AllocDotField nDotF = ((AllocNode)n).dot(f);
                if (nDotF != null) {
                    ret.addAll(nDotF.getP2Set(), null);
                }
            }
        });
        return ret;
    }

    public P2SetFactory getSetFactory() {
        return this.setFactory;
    }

    public void cleanUpMerges() {
        Map[] maps;
        if (this.opts.verbose()) {
            G.v().out.println("Cleaning up graph for merged nodes");
        }
        for (Map m : maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv}) {
            for (Object object : m.keySet()) {
                this.lookup(m, object);
            }
        }
        this.somethingMerged = false;
        if (this.opts.verbose()) {
            G.v().out.println("Done cleaning up graph for merged nodes");
        }
    }

    public boolean doAddSimpleEdge(VarNode from, VarNode to) {
        return this.addToMap(this.simple, from, to) | this.addToMap(this.simpleInv, to, from);
    }

    public boolean doAddStoreEdge(VarNode from, FieldRefNode to) {
        return this.addToMap(this.store, from, to) | this.addToMap(this.storeInv, to, from);
    }

    public boolean doAddLoadEdge(FieldRefNode from, VarNode to) {
        return this.addToMap(this.load, from, to) | this.addToMap(this.loadInv, to, from);
    }

    public boolean doAddAllocEdge(AllocNode from, VarNode to) {
        return this.addToMap(this.alloc, from, to) | this.addToMap(this.allocInv, to, from);
    }

    void mergedWith(Node n1, Node n2) {
        Map[] maps;
        if (n1.equals(n2)) {
            throw new RuntimeException("oops");
        }
        this.somethingMerged = true;
        if (this.ofcg() != null) {
            this.ofcg().mergedWith(n1, n2);
        }
        for (Map m : maps = new Map[]{this.simple, this.alloc, this.store, this.load, this.simpleInv, this.allocInv, this.storeInv, this.loadInv}) {
            if (!m.keySet().contains(n2)) continue;
            Object[] os = new Object[]{m.get(n1), m.get(n2)};
            int size1 = PAG.getSize(os[0]);
            int size2 = PAG.getSize(os[1]);
            if (size1 == 0) {
                if (os[1] != null) {
                    m.put(n1, os[1]);
                }
            } else if (size2 != 0) {
                Node[] ar;
                if (os[0] instanceof HashSet) {
                    if (os[1] instanceof HashSet) {
                        ((HashSet)os[0]).addAll((HashSet)os[1]);
                    } else {
                        ar = (Node[])os[1];
                        for (Node node : ar) {
                            ((HashSet)os[0]).add(node);
                        }
                    }
                } else if (os[1] instanceof HashSet) {
                    ar = (Node[])os[0];
                    for (Node node : ar) {
                        ((HashSet)os[1]).add(node);
                    }
                    m.put(n1, os[1]);
                } else if (size1 * size2 < 1000) {
                    Node[] a1 = (Node[])os[0];
                    Node[] a2 = (Node[])os[1];
                    Node[] ret = new Node[size1 + size2];
                    System.arraycopy(a1, 0, ret, 0, a1.length);
                    int j = a1.length;
                    block3: for (Node rep : a2) {
                        for (int k = 0; k < j; ++k) {
                            if (rep == ret[k]) continue block3;
                        }
                        ret[j++] = rep;
                    }
                    Node[] nodeArray = new Node[j];
                    System.arraycopy(ret, 0, nodeArray, 0, j);
                    ret = nodeArray;
                    m.put(n1, nodeArray);
                } else {
                    HashSet<Node> s = new HashSet<Node>(size1 + size2);
                    for (Object object : os) {
                        Node[] ar2;
                        if (object == null) continue;
                        if (object instanceof Set) {
                            s.addAll((Set)object);
                            continue;
                        }
                        for (Node element1 : ar2 = (Node[])object) {
                            s.add(element1);
                        }
                    }
                    m.put(n1, s);
                }
            }
            m.remove(n2);
        }
    }

    protected Node[] lookup(Map<Object, Object> m, Object key) {
        Node[] valueList = m.get(key);
        if (valueList == null) {
            return EMPTY_NODE_ARRAY;
        }
        if (valueList instanceof Set) {
            try {
                valueList = ((Set)valueList).toArray(EMPTY_NODE_ARRAY);
                m.put(key, valueList);
            }
            catch (Exception e) {
                Iterator it = ((Set)valueList).iterator();
                while (it.hasNext()) {
                    G.v().out.println("" + it.next());
                }
                throw new RuntimeException("" + valueList + e);
            }
        }
        Node[] ret = valueList;
        if (this.somethingMerged) {
            for (int i = 0; i < ret.length; ++i) {
                int j;
                Node reti = ret[i];
                Node rep = reti.getReplacement();
                if (rep == reti && rep != key) continue;
                if (ret.length <= 75) {
                    int j2 = i;
                    while (i < ret.length) {
                        block14: {
                            reti = ret[i];
                            rep = reti.getReplacement();
                            if (rep != key) {
                                for (int k = 0; k < j2; ++k) {
                                    if (rep != ret[k]) {
                                        continue;
                                    }
                                    break block14;
                                }
                                ret[j2++] = rep;
                            }
                        }
                        ++i;
                    }
                    Node[] newArray = new Node[j2];
                    System.arraycopy(ret, 0, newArray, 0, j2);
                    ret = newArray;
                    m.put(key, newArray);
                    break;
                }
                HashSet<Node> s = new HashSet<Node>(ret.length * 2);
                for (j = 0; j < i; ++j) {
                    s.add(ret[j]);
                }
                for (j = i; j < ret.length; ++j) {
                    rep = ret[j].getReplacement();
                    if (rep == key) continue;
                    s.add(rep);
                }
                ret = s.toArray(EMPTY_NODE_ARRAY);
                m.put(key, ret);
                break;
            }
        }
        return ret;
    }

    public Node[] simpleLookup(VarNode key) {
        return this.lookup(this.simple, key);
    }

    public Node[] simpleInvLookup(VarNode key) {
        return this.lookup(this.simpleInv, key);
    }

    public Node[] loadLookup(FieldRefNode key) {
        return this.lookup(this.load, key);
    }

    public Node[] loadInvLookup(VarNode key) {
        return this.lookup(this.loadInv, key);
    }

    public Node[] storeLookup(VarNode key) {
        return this.lookup(this.store, key);
    }

    public Node[] storeInvLookup(FieldRefNode key) {
        return this.lookup(this.storeInv, key);
    }

    public Node[] allocLookup(AllocNode key) {
        return this.lookup(this.alloc, key);
    }

    public Node[] allocInvLookup(VarNode key) {
        return this.lookup(this.allocInv, key);
    }

    public Set<Object> simpleSources() {
        return this.simple.keySet();
    }

    public Set<Object> allocSources() {
        return this.alloc.keySet();
    }

    public Set<Object> storeSources() {
        return this.store.keySet();
    }

    public Set<Object> loadSources() {
        return this.load.keySet();
    }

    public Set<Object> simpleInvSources() {
        return this.simpleInv.keySet();
    }

    public Set<Object> allocInvSources() {
        return this.allocInv.keySet();
    }

    public Set<Object> storeInvSources() {
        return this.storeInv.keySet();
    }

    public Set<Object> loadInvSources() {
        return this.loadInv.keySet();
    }

    public Iterator<Object> simpleSourcesIterator() {
        return this.simple.keySet().iterator();
    }

    public Iterator<Object> allocSourcesIterator() {
        return this.alloc.keySet().iterator();
    }

    public Iterator<Object> storeSourcesIterator() {
        return this.store.keySet().iterator();
    }

    public Iterator<Object> loadSourcesIterator() {
        return this.load.keySet().iterator();
    }

    public Iterator<Object> simpleInvSourcesIterator() {
        return this.simpleInv.keySet().iterator();
    }

    public Iterator<Object> allocInvSourcesIterator() {
        return this.allocInv.keySet().iterator();
    }

    public Iterator<Object> storeInvSourcesIterator() {
        return this.storeInv.keySet().iterator();
    }

    public Iterator<Object> loadInvSourcesIterator() {
        return this.loadInv.keySet().iterator();
    }

    private static int getSize(Object set) {
        if (set instanceof Set) {
            return ((Set)set).size();
        }
        if (set == null) {
            return 0;
        }
        return ((Object[])set).length;
    }

    @Override
    public PointsToSet reachingObjects(Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(l), f);
    }

    @Override
    public PointsToSet reachingObjects(Context c, Local l, SootField f) {
        return this.reachingObjects(this.reachingObjects(c, l), f);
    }

    private void addNodeTag(Node node, SootMethod m) {
        if (this.nodeToTag != null) {
            StringTag tag = m == null ? new StringTag(node.toString()) : new LinkTag(node.toString(), m, m.getDeclaringClass().getName());
            this.nodeToTag.put(node, tag);
        }
    }

    public AllocNode makeAllocNode(Object newExpr, Type type, SootMethod m) {
        AllocNode ret;
        if (this.opts.types_for_sites() || this.opts.vta()) {
            newExpr = type;
        }
        if ((ret = this.valToAllocNode.get(newExpr)) == null) {
            ret = new AllocNode(this, newExpr, type, m);
            this.valToAllocNode.put(newExpr, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, m);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("NewExpr " + newExpr + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public AllocNode makeStringConstantNode(String s) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.String"), RefType.v("java.lang.String"), null);
        }
        StringConstantNode ret = (StringConstantNode)this.valToAllocNode.get(s);
        if (ret == null) {
            ret = new StringConstantNode(this, s);
            this.valToAllocNode.put(s, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public AllocNode makeClassConstantNode(ClassConstant cc) {
        if (this.opts.types_for_sites() || this.opts.vta()) {
            return this.makeAllocNode(RefType.v("java.lang.Class"), RefType.v("java.lang.Class"), null);
        }
        ClassConstantNode ret = (ClassConstantNode)this.valToAllocNode.get(cc);
        if (ret == null) {
            ret = new ClassConstantNode(this, cc);
            this.valToAllocNode.put(cc, ret);
            this.newAllocNodes.add(ret);
            this.addNodeTag(ret, null);
        }
        return ret;
    }

    public QueueReader allocNodeListener() {
        return this.newAllocNodes.reader();
    }

    public GlobalVarNode findGlobalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        }
        return this.valToGlobalVarNode.get(value);
    }

    public LocalVarNode findLocalVarNode(Object value) {
        if (this.opts.rta()) {
            value = null;
        } else if (value instanceof Local) {
            return (LocalVarNode)this.localToNodeMap.get((Local)value);
        }
        return this.valToLocalVarNode.get(value);
    }

    public GlobalVarNode makeGlobalVarNode(Object value, Type type) {
        GlobalVarNode ret;
        if (this.opts.rta()) {
            value = null;
            type = RefType.v("java.lang.Object");
        }
        if ((ret = this.valToGlobalVarNode.get(value)) == null) {
            ret = new GlobalVarNode(this, value, type);
            this.valToGlobalVarNode.put(value, ret);
            this.addNodeTag(ret, null);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public LocalVarNode makeLocalVarNode(Object value, Type type, SootMethod method) {
        if (this.opts.rta()) {
            value = null;
            type = RefType.v("java.lang.Object");
            method = null;
        } else if (value instanceof Local) {
            LocalVarNode ret;
            Local val = (Local)value;
            if (val.getNumber() == 0) {
                Scene.v().getLocalNumberer().add(val);
            }
            if ((ret = (LocalVarNode)this.localToNodeMap.get(val)) == null) {
                ret = new LocalVarNode(this, value, type, method);
                this.localToNodeMap.put((Local)value, ret);
                this.addNodeTag(ret, method);
            } else if (!ret.getType().equals(type)) {
                throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
            }
            return ret;
        }
        LocalVarNode ret = this.valToLocalVarNode.get(value);
        if (ret == null) {
            ret = new LocalVarNode(this, value, type, method);
            this.valToLocalVarNode.put(value, ret);
            this.addNodeTag(ret, method);
        } else if (!ret.getType().equals(type)) {
            throw new RuntimeException("Value " + value + " of type " + type + " previously had type " + ret.getType());
        }
        return ret;
    }

    public ContextVarNode findContextVarNode(Object baseValue, Context context) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.context(context);
    }

    public ContextVarNode makeContextVarNode(Object baseValue, Type baseType, Context context, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeContextVarNode(base, context);
    }

    public ContextVarNode makeContextVarNode(LocalVarNode base, Context context) {
        ContextVarNode ret = base.context(context);
        if (ret == null) {
            ret = new ContextVarNode(this, base, context);
            this.addNodeTag(ret, base.getMethod());
        }
        return ret;
    }

    public FieldRefNode findLocalFieldRefNode(Object baseValue, SparkField field) {
        LocalVarNode base = this.findLocalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode findGlobalFieldRefNode(Object baseValue, SparkField field) {
        GlobalVarNode base = this.findGlobalVarNode(baseValue);
        if (base == null) {
            return null;
        }
        return base.dot(field);
    }

    public FieldRefNode makeLocalFieldRefNode(Object baseValue, Type baseType, SparkField field, SootMethod method) {
        LocalVarNode base = this.makeLocalVarNode(baseValue, baseType, method);
        return this.makeFieldRefNode(base, field);
    }

    public FieldRefNode makeGlobalFieldRefNode(Object baseValue, Type baseType, SparkField field) {
        GlobalVarNode base = this.makeGlobalVarNode(baseValue, baseType);
        return this.makeFieldRefNode(base, field);
    }

    public FieldRefNode makeFieldRefNode(VarNode base, SparkField field) {
        FieldRefNode ret = base.dot(field);
        if (ret == null) {
            ret = new FieldRefNode(this, base, field);
            if (base instanceof LocalVarNode) {
                this.addNodeTag(ret, ((LocalVarNode)base).getMethod());
            } else {
                this.addNodeTag(ret, null);
            }
        }
        return ret;
    }

    public AllocDotField findAllocDotField(AllocNode an, SparkField field) {
        return an.dot(field);
    }

    public AllocDotField makeAllocDotField(AllocNode an, SparkField field) {
        AllocDotField ret = an.dot(field);
        if (ret == null) {
            ret = new AllocDotField(this, an, field);
        }
        return ret;
    }

    public boolean addSimpleEdge(VarNode from, VarNode to) {
        boolean ret = false;
        if (this.doAddSimpleEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            ret = true;
        }
        if (this.opts.simple_edges_bidirectional() && this.doAddSimpleEdge(to, from)) {
            this.edgeQueue.add(to);
            this.edgeQueue.add(from);
            ret = true;
        }
        return ret;
    }

    public boolean addStoreEdge(VarNode from, FieldRefNode to) {
        if (!this.opts.rta() && this.doAddStoreEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addLoadEdge(FieldRefNode from, VarNode to) {
        if (!this.opts.rta() && this.doAddLoadEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public boolean addAllocEdge(AllocNode from, VarNode to) {
        FastHierarchy fh = this.typeManager.getFastHierarchy();
        if ((fh == null || to.getType() == null || fh.canStoreType(from.getType(), to.getType())) && this.doAddAllocEdge(from, to)) {
            this.edgeQueue.add(from);
            this.edgeQueue.add(to);
            return true;
        }
        return false;
    }

    public final boolean addEdge(Node from, Node to) {
        from = from.getReplacement();
        to = to.getReplacement();
        if (from instanceof VarNode) {
            if (to instanceof VarNode) {
                return this.addSimpleEdge((VarNode)from, (VarNode)to);
            }
            return this.addStoreEdge((VarNode)from, (FieldRefNode)to);
        }
        if (from instanceof FieldRefNode) {
            return this.addLoadEdge((FieldRefNode)from, (VarNode)to);
        }
        return this.addAllocEdge((AllocNode)from, (VarNode)to);
    }

    public QueueReader edgeReader() {
        return this.edgeQueue.reader();
    }

    public int getNumAllocNodes() {
        return this.allocNodeNumberer.size();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public void setOnFlyCallGraph(OnFlyCallGraph ofcg) {
        this.ofcg = ofcg;
    }

    public OnFlyCallGraph getOnFlyCallGraph() {
        return this.ofcg;
    }

    public OnFlyCallGraph ofcg() {
        return this.ofcg;
    }

    public void addDereference(VarNode base) {
        this.dereferences.add(base);
    }

    public List<VarNode> getDereferences() {
        return this.dereferences;
    }

    public Map<Node, Tag> getNodeTags() {
        return this.nodeToTag;
    }

    public ArrayNumberer getAllocNodeNumberer() {
        return this.allocNodeNumberer;
    }

    public ArrayNumberer getVarNodeNumberer() {
        return this.varNodeNumberer;
    }

    public ArrayNumberer getFieldRefNodeNumberer() {
        return this.fieldRefNodeNumberer;
    }

    public ArrayNumberer getAllocDotFieldNodeNumberer() {
        return this.allocDotFieldNodeNumberer;
    }

    public SparkOptions getOpts() {
        return this.opts;
    }

    public final void addCallTarget(Edge e) {
        if (!e.passesParameters()) {
            return;
        }
        MethodPAG srcmpag = MethodPAG.v(this, e.src());
        MethodPAG tgtmpag = MethodPAG.v(this, e.tgt());
        if (e.isExplicit() || e.kind() == Kind.THREAD) {
            this.addCallTarget(srcmpag, tgtmpag, (Stmt)e.srcUnit(), e.srcCtxt(), e.tgtCtxt());
        } else if (e.kind() == Kind.PRIVILEGED) {
            InvokeExpr ie = e.srcStmt().getInvokeExpr();
            Node parm = srcmpag.nodeFactory().getNode(ie.getArg(0));
            parm = srcmpag.parameterize(parm, e.srcCtxt());
            parm = parm.getReplacement();
            Node thiz = tgtmpag.nodeFactory().caseThis();
            thiz = tgtmpag.parameterize(thiz, e.tgtCtxt());
            thiz = thiz.getReplacement();
            this.addEdge(parm, thiz);
            this.callAssigns.put(ie, new Pair<Node, Node>(parm, thiz));
            this.callToMethod.put(ie, srcmpag.getMethod());
            if (e.srcUnit() instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)e.srcUnit();
                Node ret = tgtmpag.nodeFactory().caseRet();
                ret = tgtmpag.parameterize(ret, e.tgtCtxt());
                ret = ret.getReplacement();
                Node lhs = srcmpag.nodeFactory().getNode(as.getLeftOp());
                lhs = srcmpag.parameterize(lhs, e.srcCtxt());
                lhs = lhs.getReplacement();
                this.addEdge(ret, lhs);
                this.callAssigns.put(ie, new Pair<Node, Node>(ret, lhs));
                this.callToMethod.put(ie, srcmpag.getMethod());
            }
        } else if (e.kind() == Kind.FINALIZE) {
            Node srcThis = srcmpag.nodeFactory().caseThis();
            srcThis = srcmpag.parameterize(srcThis, e.srcCtxt());
            srcThis = srcThis.getReplacement();
            Node tgtThis = tgtmpag.nodeFactory().caseThis();
            tgtThis = tgtmpag.parameterize(tgtThis, e.tgtCtxt());
            tgtThis = tgtThis.getReplacement();
            this.addEdge(srcThis, tgtThis);
        } else if (e.kind() == Kind.NEWINSTANCE) {
            Stmt s = (Stmt)e.srcUnit();
            InstanceInvokeExpr iie = (InstanceInvokeExpr)s.getInvokeExpr();
            Node cls = srcmpag.nodeFactory().getNode(iie.getBase());
            cls = srcmpag.parameterize(cls, e.srcCtxt());
            cls = cls.getReplacement();
            Node newObject = this.nodeFactory.caseNewInstance((VarNode)cls);
            Node initThis = tgtmpag.nodeFactory().caseThis();
            initThis = tgtmpag.parameterize(initThis, e.tgtCtxt());
            initThis = initThis.getReplacement();
            this.addEdge(newObject, initThis);
            if (s instanceof AssignStmt) {
                AssignStmt as = (AssignStmt)s;
                Node asLHS = srcmpag.nodeFactory().getNode(as.getLeftOp());
                asLHS = srcmpag.parameterize(asLHS, e.srcCtxt());
                asLHS = asLHS.getReplacement();
                this.addEdge(newObject, asLHS);
            }
            this.callAssigns.put(s.getInvokeExpr(), new Pair<Node, Node>(newObject, initThis));
            this.callToMethod.put(s.getInvokeExpr(), srcmpag.getMethod());
        } else {
            throw new RuntimeException("Unhandled edge " + e);
        }
    }

    public final void addCallTarget(MethodPAG srcmpag, MethodPAG tgtmpag, Stmt s, Context srcContext, Context tgtContext) {
        Value dest;
        MethodNodeFactory srcnf = srcmpag.nodeFactory();
        MethodNodeFactory tgtnf = tgtmpag.nodeFactory();
        InvokeExpr ie = s.getInvokeExpr();
        boolean virtualCall = this.callAssigns.containsKey(ie);
        int numArgs = ie.getArgCount();
        for (int i = 0; i < numArgs; ++i) {
            Value arg = ie.getArg(i);
            if (!(arg.getType() instanceof RefLikeType) || arg instanceof NullConstant) continue;
            Node argNode = srcnf.getNode(arg);
            argNode = srcmpag.parameterize(argNode, srcContext);
            argNode = argNode.getReplacement();
            Node parm = tgtnf.caseParm(i);
            parm = tgtmpag.parameterize(parm, tgtContext);
            parm = parm.getReplacement();
            this.addEdge(argNode, parm);
            this.callAssigns.put(ie, new Pair<Node, Node>(argNode, parm));
            this.callToMethod.put(ie, srcmpag.getMethod());
        }
        if (ie instanceof InstanceInvokeExpr) {
            InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
            Node baseNode = srcnf.getNode(iie.getBase());
            baseNode = srcmpag.parameterize(baseNode, srcContext);
            baseNode = baseNode.getReplacement();
            Node thisRef = tgtnf.caseThis();
            thisRef = tgtmpag.parameterize(thisRef, tgtContext);
            thisRef = thisRef.getReplacement();
            this.addEdge(baseNode, thisRef);
            this.callAssigns.put(ie, new Pair<Node, Node>(baseNode, thisRef));
            this.callToMethod.put(ie, srcmpag.getMethod());
            if (virtualCall && !this.virtualCallsToReceivers.containsKey(ie)) {
                this.virtualCallsToReceivers.put(ie, baseNode);
            }
        }
        if (s instanceof AssignStmt && (dest = ((AssignStmt)s).getLeftOp()).getType() instanceof RefLikeType && !(dest instanceof NullConstant)) {
            Node destNode = srcnf.getNode(dest);
            destNode = srcmpag.parameterize(destNode, srcContext);
            destNode = destNode.getReplacement();
            Node retNode = tgtnf.caseRet();
            retNode = tgtmpag.parameterize(retNode, tgtContext);
            retNode = retNode.getReplacement();
            this.addEdge(retNode, destNode);
            this.callAssigns.put(ie, new Pair<Node, Node>(retNode, destNode));
            this.callToMethod.put(ie, srcmpag.getMethod());
        }
    }

    protected boolean addToMap(Map<Object, Object> m, Node key, Node value) {
        HashSet valueList = m.get(key);
        if (valueList == null) {
            valueList = new HashSet(4);
            m.put(key, valueList);
        } else if (!(valueList instanceof Set)) {
            Node[] ar = (Node[])valueList;
            HashSet<Node> vl = new HashSet<Node>(ar.length + 4);
            m.put(key, vl);
            for (Node element : ar) {
                vl.add(element);
            }
            return vl.add(value);
        }
        return ((Set)valueList).add(value);
    }

    public GlobalNodeFactory nodeFactory() {
        return this.nodeFactory;
    }
}

