/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.base;

import java.util.HashMap;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.PatchingChain;
import soot.Trap;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.scalar.LocalNameStandardizer;

public class ThisInliner
extends BodyTransformer {
    public void internalTransform(Body b, String phaseName, Map options) {
        if (!b.getMethod().getName().equals("<init>")) {
            return;
        }
        InvokeStmt invokeStmt = this.getFirstSpecialInvoke(b);
        if (invokeStmt == null) {
            return;
        }
        SpecialInvokeExpr specInvokeExpr = (SpecialInvokeExpr)invokeStmt.getInvokeExpr();
        if (specInvokeExpr.getMethod().getDeclaringClass().equals(b.getMethod().getDeclaringClass())) {
            if (!specInvokeExpr.getMethod().hasActiveBody()) {
                specInvokeExpr.getMethod().retrieveActiveBody();
            }
            HashMap<Local, Local> oldLocalsToNew = new HashMap<Local, Local>();
            for (Local l : specInvokeExpr.getMethod().getActiveBody().getLocals()) {
                Local newLocal = (Local)l.clone();
                b.getLocals().add(newLocal);
                oldLocalsToNew.put(l, newLocal);
            }
            IdentityStmt origIdStmt = this.findIdentityStmt(b);
            HashMap<Stmt, Stmt> oldStmtsToNew = new HashMap<Stmt, Stmt>();
            PatchingChain<Unit> containerUnits = b.getUnits();
            for (Stmt stmt : specInvokeExpr.getMethod().getActiveBody().getUnits()) {
                if (stmt instanceof IdentityStmt) {
                    IdentityStmt identityStmt = (IdentityStmt)stmt;
                    if (identityStmt.getRightOp() instanceof ThisRef) {
                        AssignStmt newThis = Jimple.v().newAssignStmt((Local)oldLocalsToNew.get(identityStmt.getLeftOp()), origIdStmt.getLeftOp());
                        containerUnits.insertBefore(newThis, (Unit)invokeStmt);
                        oldStmtsToNew.put(stmt, newThis);
                        continue;
                    }
                    if (identityStmt.getRightOp() instanceof CaughtExceptionRef) {
                        Stmt newInlinee = (Stmt)stmt.clone();
                        for (ValueBox next : newInlinee.getUseAndDefBoxes()) {
                            if (!(next.getValue() instanceof Local)) continue;
                            next.setValue((Local)oldLocalsToNew.get(next.getValue()));
                        }
                        containerUnits.insertBefore(newInlinee, (Unit)invokeStmt);
                        oldStmtsToNew.put(stmt, newInlinee);
                        continue;
                    }
                    if (!(identityStmt.getRightOp() instanceof ParameterRef)) continue;
                    AssignStmt newParam = Jimple.v().newAssignStmt((Local)oldLocalsToNew.get(identityStmt.getLeftOp()), specInvokeExpr.getArg(((ParameterRef)identityStmt.getRightOp()).getIndex()));
                    containerUnits.insertBefore(newParam, (Unit)invokeStmt);
                    oldStmtsToNew.put(stmt, newParam);
                    continue;
                }
                if (stmt instanceof ReturnVoidStmt) {
                    GotoStmt gotoStmt = Jimple.v().newGotoStmt((Stmt)containerUnits.getSuccOf(invokeStmt));
                    containerUnits.insertBefore(gotoStmt, (Unit)invokeStmt);
                    System.out.println("adding to stmt map: " + stmt + " and " + gotoStmt);
                    oldStmtsToNew.put(stmt, gotoStmt);
                    continue;
                }
                Stmt stmt2 = (Stmt)stmt.clone();
                for (ValueBox next : stmt2.getUseAndDefBoxes()) {
                    if (!(next.getValue() instanceof Local)) continue;
                    next.setValue((Local)oldLocalsToNew.get(next.getValue()));
                }
                containerUnits.insertBefore(stmt2, (Unit)invokeStmt);
                oldStmtsToNew.put(stmt, stmt2);
            }
            for (Trap trap : specInvokeExpr.getMethod().getActiveBody().getTraps()) {
                System.out.println("begin: " + trap.getBeginUnit());
                Stmt newBegin = (Stmt)oldStmtsToNew.get(trap.getBeginUnit());
                System.out.println("end: " + trap.getEndUnit());
                Stmt newEnd = (Stmt)oldStmtsToNew.get(trap.getEndUnit());
                System.out.println("handler: " + trap.getHandlerUnit());
                Stmt newHandler = (Stmt)oldStmtsToNew.get(trap.getHandlerUnit());
                if (newBegin == null || newEnd == null || newHandler == null) {
                    throw new RuntimeException("couldn't map trap!");
                }
                b.getTraps().add(Jimple.v().newTrap(trap.getException(), newBegin, newEnd, newHandler));
            }
            for (Stmt stmt : specInvokeExpr.getMethod().getActiveBody().getUnits()) {
                if (!(stmt instanceof GotoStmt)) continue;
                System.out.println("inlinee goto target: " + ((GotoStmt)stmt).getTarget());
                ((GotoStmt)oldStmtsToNew.get(stmt)).setTarget((Unit)oldStmtsToNew.get(((GotoStmt)stmt).getTarget()));
            }
            containerUnits.remove(invokeStmt);
            LocalNameStandardizer.v().transform(b, "ji.lns");
        }
    }

    private InvokeStmt getFirstSpecialInvoke(Body b) {
        for (Stmt stmt : b.getUnits()) {
            InvokeExpr invokeExpr;
            if (!(stmt instanceof InvokeStmt) || !((invokeExpr = ((InvokeStmt)stmt).getInvokeExpr()) instanceof SpecialInvokeExpr)) continue;
            return (InvokeStmt)stmt;
        }
        return null;
    }

    private IdentityStmt findIdentityStmt(Body b) {
        for (Stmt stmt : b.getUnits()) {
            if (!(stmt instanceof IdentityStmt) || !(((IdentityStmt)stmt).getRightOp() instanceof ThisRef)) continue;
            return (IdentityStmt)stmt;
        }
        return null;
    }
}

