/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootMethod;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Targets;
import soot.util.NumberedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologicalOrderer {
    CallGraph cg;
    List<SootMethod> order = new ArrayList<SootMethod>();
    NumberedSet visited = new NumberedSet(Scene.v().getMethodNumberer());

    public TopologicalOrderer(CallGraph cg) {
        this.cg = cg;
    }

    public void go() {
        Iterator<MethodOrMethodContext> methods = this.cg.sourceMethods();
        while (methods.hasNext()) {
            SootMethod m = (SootMethod)methods.next();
            this.dfsVisit(m);
        }
    }

    private void dfsVisit(SootMethod m) {
        if (this.visited.contains(m)) {
            return;
        }
        this.visited.add(m);
        Targets targets = new Targets(this.cg.edgesOutOf(m));
        while (targets.hasNext()) {
            SootMethod target = (SootMethod)targets.next();
            this.dfsVisit(target);
        }
        this.order.add(m);
    }

    public List<SootMethod> order() {
        return this.order;
    }
}

