/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import soot.Body;
import soot.EquivalentValue;
import soot.Local;
import soot.RefLikeType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.VoidType;
import soot.jimple.FieldRef;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.jimple.toolkits.infoflow.SmartMethodInfoFlowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MemoryEfficientGraph;
import soot.toolkits.graph.MutableDirectedGraph;

public class ClassInfoFlowAnalysis {
    SootClass sootClass;
    InfoFlowAnalysis dfa;
    Map<SootMethod, SmartMethodInfoFlowAnalysis> methodToInfoFlowAnalysis;
    Map<SootMethod, HashMutableDirectedGraph> methodToInfoFlowSummary;
    public static int methodCount = 0;

    public ClassInfoFlowAnalysis(SootClass sootClass, InfoFlowAnalysis dfa) {
        this.sootClass = sootClass;
        this.dfa = dfa;
        this.methodToInfoFlowAnalysis = new HashMap<SootMethod, SmartMethodInfoFlowAnalysis>();
        this.methodToInfoFlowSummary = new HashMap<SootMethod, HashMutableDirectedGraph>();
    }

    public SmartMethodInfoFlowAnalysis getMethodInfoFlowAnalysis(SootMethod method) {
        if (!this.methodToInfoFlowAnalysis.containsKey(method)) {
            ++methodCount;
            if (!this.methodToInfoFlowSummary.containsKey(method)) {
                HashMutableDirectedGraph dataFlowGraph = this.simpleConservativeInfoFlowAnalysis(method);
                this.methodToInfoFlowSummary.put(method, dataFlowGraph);
            }
            if (method.isConcrete()) {
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
                SmartMethodInfoFlowAnalysis smdfa = new SmartMethodInfoFlowAnalysis(g, this.dfa);
                this.methodToInfoFlowAnalysis.put(method, smdfa);
                this.methodToInfoFlowSummary.remove(method);
                this.methodToInfoFlowSummary.put(method, smdfa.getMethodInfoFlowSummary());
                return smdfa;
            }
        }
        return this.methodToInfoFlowAnalysis.get(method);
    }

    public MutableDirectedGraph getMethodInfoFlowSummary(SootMethod method) {
        return this.getMethodInfoFlowSummary(method, true);
    }

    public HashMutableDirectedGraph getMethodInfoFlowSummary(SootMethod method, boolean doFullAnalysis) {
        if (!this.methodToInfoFlowSummary.containsKey(method)) {
            ++methodCount;
            HashMutableDirectedGraph dataFlowGraph = this.simpleConservativeInfoFlowAnalysis(method);
            this.methodToInfoFlowSummary.put(method, dataFlowGraph);
            if (method.isConcrete() && doFullAnalysis) {
                Body b = method.retrieveActiveBody();
                ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
                SmartMethodInfoFlowAnalysis smdfa = new SmartMethodInfoFlowAnalysis(g, this.dfa);
                this.methodToInfoFlowAnalysis.put(method, smdfa);
                this.methodToInfoFlowSummary.remove(method);
                this.methodToInfoFlowSummary.put(method, smdfa.getMethodInfoFlowSummary());
            }
        }
        return this.methodToInfoFlowSummary.get(method);
    }

    /*
     * WARNING - void declaration
     */
    private HashMutableDirectedGraph simpleConservativeInfoFlowAnalysis(SootMethod sm) {
        void var8_19;
        void var8_15;
        if (!sm.isConcrete()) {
            return this.triviallyConservativeInfoFlowAnalysis(sm);
        }
        Body b = sm.retrieveActiveBody();
        ExceptionalUnitGraph g = new ExceptionalUnitGraph(b);
        HashSet<EquivalentValue> fieldsStaticsParamsAccessed = new HashSet<EquivalentValue>();
        for (Stmt s : g) {
            InstanceFieldRef instanceFieldRef;
            Value base;
            IdentityStmt is;
            IdentityRef identityRef;
            if (s instanceof IdentityStmt && (identityRef = (IdentityRef)(is = (IdentityStmt)s).getRightOp()) instanceof ParameterRef) {
                ParameterRef pr = (ParameterRef)identityRef;
                fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForParameterRef(sm, pr.getIndex()));
            }
            if (!s.containsFieldRef()) continue;
            FieldRef ref = s.getFieldRef();
            if (ref instanceof StaticFieldRef) {
                StaticFieldRef staticFieldRef = (StaticFieldRef)ref;
                fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForFieldRef(sm, staticFieldRef.getField()));
                continue;
            }
            if (!(ref instanceof InstanceFieldRef) || !((base = (instanceFieldRef = (InstanceFieldRef)ref).getBase()) instanceof Local) || !this.dfa.includesInnerFields() && (sm.isStatic() || !base.equivTo(b.getThisLocal()))) continue;
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForFieldRef(sm, instanceFieldRef.getField()));
        }
        MemoryEfficientGraph dataFlowGraph = new MemoryEfficientGraph();
        for (Object e : fieldsStaticsParamsAccessed) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(e);
        }
        boolean bl = false;
        while (var8_15 < sm.getParameterCount()) {
            EquivalentValue parameterRefEqVal = InfoFlowAnalysis.getNodeForParameterRef(sm, (int)var8_15);
            if (!dataFlowGraph.containsNode(parameterRefEqVal)) {
                ((HashMutableDirectedGraph)dataFlowGraph).addNode(parameterRefEqVal);
            }
            ++var8_15;
        }
        for (SootField sf : sm.getDeclaringClass().getFields()) {
            EquivalentValue equivalentValue;
            if (!sf.isStatic() && sm.isStatic() || dataFlowGraph.containsNode(equivalentValue = InfoFlowAnalysis.getNodeForFieldRef(sm, sf))) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(equivalentValue);
        }
        SootClass sootClass = sm.getDeclaringClass();
        if (sootClass.hasSuperclass()) {
            SootClass sootClass2 = sm.getDeclaringClass().getSuperclass();
        }
        while (var8_19.hasSuperclass()) {
            for (SootField sootField : var8_19.getFields()) {
                EquivalentValue fieldRefEqVal;
                if (!sootField.isStatic() && sm.isStatic() || dataFlowGraph.containsNode(fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sootField))) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addNode(fieldRefEqVal);
            }
            SootClass sootClass3 = var8_19.getSuperclass();
        }
        ParameterRef returnValueRef = null;
        if (sm.getReturnType() != VoidType.v()) {
            returnValueRef = new ParameterRef(sm.getReturnType(), -1);
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        if (!sm.isStatic()) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForThisRef(sm));
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForThisRef(sm));
        }
        for (Object e : fieldsStaticsParamsAccessed) {
            Ref rRef = (Ref)((EquivalentValue)e).getValue();
            if (!(rRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            for (Object e2 : fieldsStaticsParamsAccessed) {
                Ref sRef = (Ref)((EquivalentValue)e2).getValue();
                if (rRef instanceof ThisRef && sRef instanceof InstanceFieldRef || sRef instanceof ThisRef && rRef instanceof InstanceFieldRef || sRef instanceof ParameterRef && this.dfa.includesInnerFields() || !(sRef.getType() instanceof RefLikeType)) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addEdge(e, e2);
            }
            if (returnValueRef == null || !(returnValueRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addEdge(e, InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        return dataFlowGraph;
    }

    /*
     * WARNING - void declaration
     */
    public HashMutableDirectedGraph triviallyConservativeInfoFlowAnalysis(SootMethod sm) {
        HashSet<EquivalentValue> fieldsStaticsParamsAccessed = new HashSet<EquivalentValue>();
        for (int i = 0; i < sm.getParameterCount(); ++i) {
            EquivalentValue parameterRefEqVal = InfoFlowAnalysis.getNodeForParameterRef(sm, i);
            fieldsStaticsParamsAccessed.add(parameterRefEqVal);
        }
        for (SootField sf : sm.getDeclaringClass().getFields()) {
            if (!sf.isStatic() && sm.isStatic()) continue;
            EquivalentValue fieldRefEqVal = InfoFlowAnalysis.getNodeForFieldRef(sm, sf);
            fieldsStaticsParamsAccessed.add(fieldRefEqVal);
        }
        SootClass superclass = sm.getDeclaringClass();
        if (superclass.hasSuperclass()) {
            superclass = sm.getDeclaringClass().getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            for (SootField scField : superclass.getFields()) {
                if (!scField.isStatic() && sm.isStatic()) continue;
                EquivalentValue equivalentValue = InfoFlowAnalysis.getNodeForFieldRef(sm, scField);
                fieldsStaticsParamsAccessed.add(equivalentValue);
            }
            superclass = superclass.getSuperclass();
        }
        MemoryEfficientGraph dataFlowGraph = new MemoryEfficientGraph();
        for (Object e : fieldsStaticsParamsAccessed) {
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(e);
        }
        Object var6_10 = null;
        if (sm.getReturnType() != VoidType.v()) {
            ParameterRef parameterRef = new ParameterRef(sm.getReturnType(), -1);
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        ThisRef thisRef = null;
        if (!sm.isStatic()) {
            thisRef = new ThisRef(this.sootClass.getType());
            ((HashMutableDirectedGraph)dataFlowGraph).addNode(InfoFlowAnalysis.getNodeForThisRef(sm));
            fieldsStaticsParamsAccessed.add(InfoFlowAnalysis.getNodeForThisRef(sm));
        }
        for (Object e : fieldsStaticsParamsAccessed) {
            void var6_12;
            Ref rRef = (Ref)((EquivalentValue)e).getValue();
            if (!(rRef.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            for (Object e2 : fieldsStaticsParamsAccessed) {
                Ref sRef = (Ref)((EquivalentValue)e2).getValue();
                if (rRef instanceof ThisRef && sRef instanceof InstanceFieldRef || sRef instanceof ThisRef && rRef instanceof InstanceFieldRef || !(sRef.getType() instanceof RefLikeType)) continue;
                ((HashMutableDirectedGraph)dataFlowGraph).addEdge(e, e2);
            }
            if (var6_12 == null || !(var6_12.getType() instanceof RefLikeType) && !this.dfa.includesPrimitiveInfoFlow()) continue;
            ((HashMutableDirectedGraph)dataFlowGraph).addEdge(e, InfoFlowAnalysis.getNodeForReturnRef(sm));
        }
        return dataFlowGraph;
    }
}

