/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.infoflow;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.EquivalentValue;
import soot.G;
import soot.Local;
import soot.RefLikeType;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.IdentityRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.Ref;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;
import soot.jimple.UnopExpr;
import soot.jimple.internal.JCaughtExceptionRef;
import soot.jimple.toolkits.infoflow.AbstractDataSource;
import soot.jimple.toolkits.infoflow.CachedEquivalentValue;
import soot.jimple.toolkits.infoflow.FakeJimpleLocal;
import soot.jimple.toolkits.infoflow.InfoFlowAnalysis;
import soot.toolkits.graph.HashMutableDirectedGraph;
import soot.toolkits.graph.MemoryEfficientGraph;
import soot.toolkits.graph.UnitGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmartMethodInfoFlowAnalysis {
    UnitGraph graph;
    SootMethod sm;
    Value thisLocal;
    InfoFlowAnalysis dfa;
    boolean refOnly;
    boolean includeInnerFields;
    HashMutableDirectedGraph abbreviatedInfoFlowGraph;
    HashMutableDirectedGraph infoFlowSummary;
    Ref returnRef;
    boolean printMessages;
    public static int counter = 0;

    public SmartMethodInfoFlowAnalysis(UnitGraph g, InfoFlowAnalysis dfa) {
        EquivalentValue thisRefEqVal;
        this.graph = g;
        this.sm = g.getBody().getMethod();
        this.thisLocal = this.sm.isStatic() ? null : g.getBody().getThisLocal();
        this.dfa = dfa;
        this.refOnly = !dfa.includesPrimitiveInfoFlow();
        this.includeInnerFields = dfa.includesInnerFields();
        this.abbreviatedInfoFlowGraph = new MemoryEfficientGraph();
        this.infoFlowSummary = new MemoryEfficientGraph();
        this.returnRef = new ParameterRef(g.getBody().getMethod().getReturnType(), -1);
        this.printMessages = false;
        ++counter;
        for (int i = 0; i < this.sm.getParameterCount(); ++i) {
            EquivalentValue parameterRefEqVal = InfoFlowAnalysis.getNodeForParameterRef(this.sm, i);
            if (this.infoFlowSummary.containsNode(parameterRefEqVal)) continue;
            this.infoFlowSummary.addNode(parameterRefEqVal);
        }
        for (SootField sf : this.sm.getDeclaringClass().getFields()) {
            EquivalentValue fieldRefEqVal;
            if (!sf.isStatic() && this.sm.isStatic() || this.infoFlowSummary.containsNode(fieldRefEqVal = !this.sm.isStatic() ? InfoFlowAnalysis.getNodeForFieldRef(this.sm, sf, this.sm.retrieveActiveBody().getThisLocal()) : InfoFlowAnalysis.getNodeForFieldRef(this.sm, sf))) continue;
            this.infoFlowSummary.addNode(fieldRefEqVal);
        }
        SootClass superclass = this.sm.getDeclaringClass();
        if (superclass.hasSuperclass()) {
            superclass = this.sm.getDeclaringClass().getSuperclass();
        }
        while (superclass.hasSuperclass()) {
            for (SootField scField : superclass.getFields()) {
                EquivalentValue fieldRefEqVal;
                if (!scField.isStatic() && this.sm.isStatic() || this.infoFlowSummary.containsNode(fieldRefEqVal = !this.sm.isStatic() ? InfoFlowAnalysis.getNodeForFieldRef(this.sm, scField, this.sm.retrieveActiveBody().getThisLocal()) : InfoFlowAnalysis.getNodeForFieldRef(this.sm, scField))) continue;
                this.infoFlowSummary.addNode(fieldRefEqVal);
            }
            superclass = superclass.getSuperclass();
        }
        if (!this.sm.isStatic() && !this.infoFlowSummary.containsNode(thisRefEqVal = InfoFlowAnalysis.getNodeForThisRef(this.sm))) {
            this.infoFlowSummary.addNode(thisRefEqVal);
        }
        CachedEquivalentValue returnRefEqVal = new CachedEquivalentValue(this.returnRef);
        if (this.returnRef.getType() != VoidType.v() && !this.infoFlowSummary.containsNode(returnRefEqVal)) {
            this.infoFlowSummary.addNode(returnRefEqVal);
        }
        Date start = new Date();
        int counterSoFar = counter;
        if (this.printMessages) {
            G.v().out.println("STARTING SMART ANALYSIS FOR " + g.getBody().getMethod() + " -----");
        }
        this.generateAbbreviatedInfoFlowGraph();
        this.generateInfoFlowSummary();
        if (this.printMessages) {
            long longTime = new Date().getTime() - start.getTime();
            float time = (float)longTime / 1000.0f;
            G.v().out.println("ENDING   SMART ANALYSIS FOR " + g.getBody().getMethod() + " ----- " + (counter - counterSoFar + 1) + " analyses took: " + time + "s");
            G.v().out.println("  AbbreviatedDataFlowGraph:");
            InfoFlowAnalysis.printInfoFlowSummary(this.abbreviatedInfoFlowGraph);
            G.v().out.println("  DataFlowSummary:");
            InfoFlowAnalysis.printInfoFlowSummary(this.infoFlowSummary);
        }
    }

    public void generateAbbreviatedInfoFlowGraph() {
        for (Stmt s : this.graph) {
            this.addFlowToCdfg(s);
        }
    }

    public void generateInfoFlowSummary() {
        for (EquivalentValue node : this.infoFlowSummary) {
            List<EquivalentValue> sources = this.sourcesOf(node);
            for (EquivalentValue source : sources) {
                if (!(source.getValue() instanceof Ref)) continue;
                this.infoFlowSummary.addEdge(source, node);
            }
        }
    }

    public List<EquivalentValue> sourcesOf(EquivalentValue node) {
        return this.sourcesOf(node, new HashSet<EquivalentValue>(), new HashSet<EquivalentValue>());
    }

    private List<EquivalentValue> sourcesOf(EquivalentValue node, Set<EquivalentValue> visitedSources, Set<EquivalentValue> visitedSinks) {
        visitedSources.add(node);
        LinkedList<EquivalentValue> ret = new LinkedList<EquivalentValue>();
        if (!this.abbreviatedInfoFlowGraph.containsNode(node)) {
            return ret;
        }
        Set preds = this.abbreviatedInfoFlowGraph.getPredsOfAsSet(node);
        for (EquivalentValue pred : preds) {
            if (visitedSources.contains(pred)) continue;
            ret.add(pred);
            ret.addAll(this.sourcesOf(pred, visitedSources, visitedSinks));
        }
        List<EquivalentValue> sinks = this.sinksOf(node, visitedSources, visitedSinks);
        for (EquivalentValue sink : sinks) {
            if (visitedSources.contains(sink)) continue;
            CachedEquivalentValue flowsToSourcesOf = new CachedEquivalentValue(new AbstractDataSource(sink.getValue()));
            if (!this.abbreviatedInfoFlowGraph.getPredsOfAsSet(sink).contains(flowsToSourcesOf)) continue;
            ret.addAll(this.sourcesOf(flowsToSourcesOf, visitedSources, visitedSinks));
        }
        return ret;
    }

    public List<EquivalentValue> sinksOf(EquivalentValue node) {
        return this.sinksOf(node, new HashSet<EquivalentValue>(), new HashSet<EquivalentValue>());
    }

    private List<EquivalentValue> sinksOf(EquivalentValue node, Set<EquivalentValue> visitedSources, Set<EquivalentValue> visitedSinks) {
        LinkedList<EquivalentValue> ret = new LinkedList<EquivalentValue>();
        visitedSinks.add(node);
        if (!this.abbreviatedInfoFlowGraph.containsNode(node)) {
            return ret;
        }
        Set succs = this.abbreviatedInfoFlowGraph.getSuccsOfAsSet(node);
        for (EquivalentValue succ : succs) {
            if (visitedSinks.contains(succ)) continue;
            ret.add(succ);
            ret.addAll(this.sinksOf(succ, visitedSources, visitedSinks));
        }
        for (EquivalentValue succ : succs) {
            Set vHolder;
            EquivalentValue v;
            if (!(succ.getValue() instanceof AbstractDataSource) || visitedSinks.contains(v = (EquivalentValue)(vHolder = this.abbreviatedInfoFlowGraph.getSuccsOfAsSet(succ)).iterator().next())) continue;
            ret.addAll(this.sourcesOf(v, visitedSinks, visitedSinks));
        }
        return ret;
    }

    public HashMutableDirectedGraph getMethodInfoFlowSummary() {
        return this.infoFlowSummary;
    }

    public HashMutableDirectedGraph getMethodAbbreviatedInfoFlowGraph() {
        return this.abbreviatedInfoFlowGraph;
    }

    protected boolean isNonRefType(Type type) {
        return !(type instanceof RefLikeType);
    }

    protected boolean ignoreThisDataType(Type type) {
        return this.refOnly && this.isNonRefType(type);
    }

    protected void handleFlowsToValue(Value sink, Value source) {
        EquivalentValue sourceEqVal;
        EquivalentValue sinkEqVal;
        InstanceFieldRef ifr;
        if (sink instanceof InstanceFieldRef) {
            ifr = (InstanceFieldRef)sink;
            sinkEqVal = InfoFlowAnalysis.getNodeForFieldRef(this.sm, ifr.getField(), (Local)ifr.getBase());
        } else {
            sinkEqVal = new CachedEquivalentValue(sink);
        }
        if (source instanceof InstanceFieldRef) {
            ifr = (InstanceFieldRef)source;
            sourceEqVal = InfoFlowAnalysis.getNodeForFieldRef(this.sm, ifr.getField(), (Local)ifr.getBase());
        } else {
            sourceEqVal = new CachedEquivalentValue(source);
        }
        if (source instanceof Ref && !this.infoFlowSummary.containsNode(sourceEqVal)) {
            this.infoFlowSummary.addNode(sourceEqVal);
        }
        if (sink instanceof Ref && !this.infoFlowSummary.containsNode(sinkEqVal)) {
            this.infoFlowSummary.addNode(sinkEqVal);
        }
        if (!this.abbreviatedInfoFlowGraph.containsNode(sinkEqVal)) {
            this.abbreviatedInfoFlowGraph.addNode(sinkEqVal);
        }
        if (!this.abbreviatedInfoFlowGraph.containsNode(sourceEqVal)) {
            this.abbreviatedInfoFlowGraph.addNode(sourceEqVal);
        }
        this.abbreviatedInfoFlowGraph.addEdge(sourceEqVal, sinkEqVal);
    }

    protected void handleFlowsToDataStructure(Value base, Value source) {
        EquivalentValue sourceEqVal;
        CachedEquivalentValue sourcesOfBaseEqVal = new CachedEquivalentValue(new AbstractDataSource(base));
        CachedEquivalentValue baseEqVal = new CachedEquivalentValue(base);
        if (source instanceof InstanceFieldRef) {
            InstanceFieldRef ifr = (InstanceFieldRef)source;
            sourceEqVal = InfoFlowAnalysis.getNodeForFieldRef(this.sm, ifr.getField(), (Local)ifr.getBase());
        } else {
            sourceEqVal = new CachedEquivalentValue(source);
        }
        if (source instanceof Ref && !this.infoFlowSummary.containsNode(sourceEqVal)) {
            this.infoFlowSummary.addNode(sourceEqVal);
        }
        if (!this.abbreviatedInfoFlowGraph.containsNode(baseEqVal)) {
            this.abbreviatedInfoFlowGraph.addNode(baseEqVal);
        }
        if (!this.abbreviatedInfoFlowGraph.containsNode(sourceEqVal)) {
            this.abbreviatedInfoFlowGraph.addNode(sourceEqVal);
        }
        if (!this.abbreviatedInfoFlowGraph.containsNode(sourcesOfBaseEqVal)) {
            this.abbreviatedInfoFlowGraph.addNode(sourcesOfBaseEqVal);
        }
        this.abbreviatedInfoFlowGraph.addEdge(sourceEqVal, sourcesOfBaseEqVal);
        this.abbreviatedInfoFlowGraph.addEdge(sourcesOfBaseEqVal, baseEqVal);
    }

    protected void handleInnerField(Value innerFieldRef) {
    }

    protected List handleInvokeExpr(InvokeExpr ie) {
        HashMutableDirectedGraph dataFlowSummary = this.dfa.getInvokeInfoFlowSummary(ie, this.sm);
        ArrayList returnValueSources = new ArrayList();
        for (EquivalentValue equivalentValue : dataFlowSummary.getNodes()) {
            InstanceInvokeExpr iie;
            if (!(equivalentValue.getValue() instanceof Ref)) {
                throw new RuntimeException("Illegal node type in data flow summary:" + equivalentValue.getValue() + " should be an object of type Ref.");
            }
            Ref node = (Ref)equivalentValue.getValue();
            ArrayList<Value> sources = new ArrayList<Value>();
            if (node instanceof ParameterRef) {
                ParameterRef param = (ParameterRef)node;
                if (param.getIndex() == -1) continue;
                sources.add(ie.getArg(param.getIndex()));
            } else if (node instanceof StaticFieldRef) {
                sources.add(node);
            } else if (node instanceof InstanceFieldRef && ie instanceof InstanceInvokeExpr) {
                iie = (InstanceInvokeExpr)ie;
                if (iie.getBase() == this.thisLocal) {
                    sources.add(node);
                } else if (this.includeInnerFields) {
                    InstanceFieldRef ifr = (InstanceFieldRef)node;
                    if (!(ifr.getBase() instanceof FakeJimpleLocal)) {
                        sources.add(ifr.getBase());
                    }
                    sources.add(node);
                } else {
                    sources.add(iie.getBase());
                }
            } else if (node instanceof InstanceFieldRef && this.includeInnerFields) {
                InstanceFieldRef ifr = (InstanceFieldRef)node;
                if (!(ifr.getBase() instanceof FakeJimpleLocal)) {
                    sources.add(ifr.getBase());
                }
                sources.add(node);
            } else if (node instanceof ThisRef && ie instanceof InstanceInvokeExpr) {
                iie = (InstanceInvokeExpr)ie;
                sources.add(iie.getBase());
            } else {
                throw new RuntimeException("Unknown Node Type in Data Flow Graph: node " + node + " in InvokeExpr " + ie);
            }
            for (EquivalentValue sinkEqVal : dataFlowSummary.getSuccsOfAsSet(equivalentValue)) {
                Ref sink = (Ref)sinkEqVal.getValue();
                if (sink instanceof ParameterRef) {
                    ParameterRef param = (ParameterRef)sink;
                    if (param.getIndex() == -1) {
                        returnValueSources.addAll(sources);
                        continue;
                    }
                    for (Value source : sources) {
                        this.handleFlowsToDataStructure(ie.getArg(param.getIndex()), source);
                    }
                    continue;
                }
                if (sink instanceof StaticFieldRef) {
                    for (Value source : sources) {
                        this.handleFlowsToValue(sink, source);
                    }
                    continue;
                }
                if (sink instanceof InstanceFieldRef && ie instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr iie2 = (InstanceInvokeExpr)ie;
                    if (iie2.getBase() == this.thisLocal) {
                        for (Value source : sources) {
                            this.handleFlowsToValue(sink, source);
                        }
                        continue;
                    }
                    if (this.includeInnerFields) {
                        for (Value source : sources) {
                            this.handleFlowsToValue(sink, source);
                            this.handleInnerField(sink);
                        }
                        continue;
                    }
                    for (Value source : sources) {
                        this.handleFlowsToDataStructure(iie2.getBase(), source);
                    }
                    continue;
                }
                if (!(sink instanceof InstanceFieldRef) || !this.includeInnerFields) continue;
                for (Value source : sources) {
                    this.handleFlowsToValue(sink, source);
                    this.handleInnerField(sink);
                }
            }
        }
        return returnValueSources;
    }

    protected void addFlowToCdfg(Stmt stmt) {
        if (stmt instanceof IdentityStmt) {
            IdentityStmt is = (IdentityStmt)stmt;
            IdentityRef ir = (IdentityRef)is.getRightOp();
            if (!(ir instanceof JCaughtExceptionRef)) {
                if (ir instanceof ParameterRef) {
                    if (!this.ignoreThisDataType(ir.getType())) {
                        this.handleFlowsToValue(is.getLeftOp(), ir);
                    }
                } else if (ir instanceof ThisRef && !this.ignoreThisDataType(ir.getType())) {
                    this.handleFlowsToValue(is.getLeftOp(), ir);
                }
            }
        } else if (stmt instanceof ReturnStmt) {
            ReturnStmt rs = (ReturnStmt)stmt;
            Value rv = rs.getOp();
            if (!(rv instanceof Constant) && rv instanceof Local && !this.ignoreThisDataType(rv.getType())) {
                this.handleFlowsToValue(this.returnRef, rv);
            }
        } else if (stmt instanceof AssignStmt) {
            AssignStmt as = (AssignStmt)stmt;
            Value lv = as.getLeftOp();
            Value rv = as.getRightOp();
            Value sink = null;
            boolean flowsToDataStructure = false;
            if (lv instanceof Local) {
                sink = lv;
            } else if (lv instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)lv;
                sink = ar.getBase();
                flowsToDataStructure = true;
            } else if (lv instanceof StaticFieldRef) {
                sink = lv;
            } else if (lv instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)lv;
                if (ifr.getBase() == this.thisLocal) {
                    sink = lv;
                } else if (this.includeInnerFields) {
                    sink = lv;
                    this.handleInnerField(sink);
                } else {
                    sink = ifr.getBase();
                    flowsToDataStructure = true;
                }
            }
            ArrayList<Value> sources = new ArrayList<Value>();
            boolean interestingFlow = true;
            if (rv instanceof Local) {
                sources.add(rv);
                interestingFlow = !this.ignoreThisDataType(rv.getType());
            } else if (rv instanceof Constant) {
                sources.add(rv);
                interestingFlow = !this.ignoreThisDataType(rv.getType());
            } else if (rv instanceof ArrayRef) {
                ArrayRef ar = (ArrayRef)rv;
                sources.add(ar.getBase());
                interestingFlow = !this.ignoreThisDataType(ar.getType());
            } else if (rv instanceof StaticFieldRef) {
                sources.add(rv);
                interestingFlow = !this.ignoreThisDataType(rv.getType());
            } else if (rv instanceof InstanceFieldRef) {
                InstanceFieldRef ifr = (InstanceFieldRef)rv;
                if (ifr.getBase() == this.thisLocal) {
                    sources.add(rv);
                    interestingFlow = !this.ignoreThisDataType(rv.getType());
                } else if (this.includeInnerFields) {
                    sources.add(ifr.getBase());
                    sources.add(rv);
                    this.handleInnerField(rv);
                    interestingFlow = !this.ignoreThisDataType(rv.getType());
                } else {
                    sources.add(ifr.getBase());
                    interestingFlow = !this.ignoreThisDataType(ifr.getType());
                }
            } else if (rv instanceof AnyNewExpr) {
                sources.add(rv);
                interestingFlow = !this.ignoreThisDataType(rv.getType());
            } else if (rv instanceof BinopExpr) {
                BinopExpr be = (BinopExpr)rv;
                sources.add(be.getOp1());
                sources.add(be.getOp2());
                interestingFlow = !this.ignoreThisDataType(be.getType());
            } else if (rv instanceof CastExpr) {
                CastExpr ce = (CastExpr)rv;
                sources.add(ce.getOp());
                interestingFlow = !this.ignoreThisDataType(ce.getType());
            } else if (rv instanceof InstanceOfExpr) {
                InstanceOfExpr ioe = (InstanceOfExpr)rv;
                sources.add(ioe.getOp());
                interestingFlow = !this.ignoreThisDataType(ioe.getType());
            } else if (rv instanceof UnopExpr) {
                UnopExpr ue = (UnopExpr)rv;
                sources.add(ue.getOp());
                interestingFlow = !this.ignoreThisDataType(ue.getType());
            } else if (rv instanceof InvokeExpr) {
                InvokeExpr ie = (InvokeExpr)rv;
                sources.addAll(this.handleInvokeExpr(ie));
                boolean bl = interestingFlow = !this.ignoreThisDataType(ie.getType());
            }
            if (interestingFlow) {
                if (flowsToDataStructure) {
                    for (Value source : sources) {
                        this.handleFlowsToDataStructure(sink, source);
                    }
                } else {
                    for (Value source : sources) {
                        this.handleFlowsToValue(sink, source);
                    }
                }
            }
        } else if (stmt.containsInvokeExpr()) {
            this.handleInvokeExpr(stmt.getInvokeExpr());
        }
    }

    public Value getThisLocal() {
        return this.thisLocal;
    }
}

