/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.PatchingChain;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Timers;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.DivExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NopStmt;
import soot.jimple.RemExpr;
import soot.jimple.Stmt;
import soot.options.Options;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLiveLocals;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.SmartLocalDefs;
import soot.toolkits.scalar.UnitValueBoxPair;

public class DeadAssignmentEliminator
extends BodyTransformer {
    public DeadAssignmentEliminator(Singletons.Global g) {
    }

    public static DeadAssignmentEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_DeadAssignmentEliminator();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        Stmt s;
        boolean eliminateOnlyStackLocals = PhaseOptions.getBoolean(options, "only-stack-locals");
        if (Options.v().verbose()) {
            G.v().out.println("[" + b.getMethod().getName() + "] Eliminating dead code...");
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.start();
        }
        HashSet<Stmt> essentialStmts = new HashSet<Stmt>();
        LinkedList<Stmt> toVisit = new LinkedList<Stmt>();
        PatchingChain<Unit> units = b.getUnits();
        for (Stmt stmt : units) {
            AssignStmt as;
            boolean isEssential = true;
            if (stmt instanceof NopStmt) {
                isEssential = false;
            }
            if (stmt instanceof AssignStmt && (as = (AssignStmt)stmt).getLeftOp() instanceof Local && (!eliminateOnlyStackLocals || ((Local)as.getLeftOp()).getName().startsWith("$"))) {
                Value rhs = as.getRightOp();
                isEssential = false;
                if (rhs instanceof InvokeExpr || rhs instanceof ArrayRef) {
                    isEssential = true;
                }
                if (rhs instanceof InstanceFieldRef && (b.getMethod().isStatic() || ((InstanceFieldRef)rhs).getBase() != b.getThisLocal())) {
                    isEssential = true;
                } else if (rhs instanceof DivExpr || rhs instanceof RemExpr) {
                    BinopExpr expr = (BinopExpr)rhs;
                    if (expr.getOp1().getType().equals(IntType.v()) || expr.getOp2().getType().equals(IntType.v()) || expr.getOp1().getType().equals(LongType.v()) || expr.getOp2().getType().equals(LongType.v())) {
                        isEssential = true;
                    }
                } else if (rhs instanceof CastExpr) {
                    isEssential = true;
                } else if (rhs instanceof NewArrayExpr || rhs instanceof NewMultiArrayExpr) {
                    isEssential = true;
                } else if (rhs instanceof NewExpr || rhs instanceof FieldRef && !(rhs instanceof InstanceFieldRef)) {
                    isEssential = true;
                }
            }
            if (!isEssential) continue;
            essentialStmts.add(stmt);
            toVisit.addLast(stmt);
        }
        ExceptionalUnitGraph graph = new ExceptionalUnitGraph(b);
        SmartLocalDefs smartLocalDefs = new SmartLocalDefs(graph, new SimpleLiveLocals(graph));
        SimpleLocalUses uses = new SimpleLocalUses(graph, (LocalDefs)smartLocalDefs);
        while (!toVisit.isEmpty()) {
            Stmt s3 = (Stmt)toVisit.removeFirst();
            for (ValueBox box : s3.getUseBoxes()) {
                if (!(box.getValue() instanceof Local)) continue;
                for (Stmt stmt : smartLocalDefs.getDefsOfAt((Local)box.getValue(), s3)) {
                    if (essentialStmts.contains(stmt)) continue;
                    essentialStmts.add(stmt);
                    toVisit.addLast(stmt);
                }
            }
        }
        Iterator stmtIt = units.iterator();
        while (stmtIt.hasNext()) {
            s = (Stmt)stmtIt.next();
            if (!essentialStmts.contains(s)) {
                stmtIt.remove();
                s.clearUnitBoxes();
                continue;
            }
            if (!(s instanceof AssignStmt) || ((AssignStmt)s).getLeftOp() != ((AssignStmt)s).getRightOp() || !(((AssignStmt)s).getLeftOp() instanceof Local)) continue;
            stmtIt.remove();
            s.clearUnitBoxes();
        }
        stmtIt = units.snapshotIterator();
        while (stmtIt.hasNext()) {
            s = (Stmt)stmtIt.next();
            if (!(s instanceof AssignStmt) || !s.containsInvokeExpr()) continue;
            Local l = (Local)((AssignStmt)s).getLeftOp();
            InvokeExpr e = s.getInvokeExpr();
            Iterator iterator = uses.getUsesOf(s).iterator();
            boolean isEssential = false;
            while (iterator.hasNext()) {
                UnitValueBoxPair pair = (UnitValueBoxPair)iterator.next();
                if (!essentialStmts.contains(pair.unit)) continue;
                isEssential = true;
                break;
            }
            if (isEssential) continue;
            InvokeStmt newInvoke = Jimple.v().newInvokeStmt(e);
            newInvoke.addAllTagsOf(s);
            units.swapWith(s, newInvoke);
        }
        if (Options.v().time()) {
            Timers.v().deadCodeTimer.end();
        }
    }
}

