/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.HjToJimple.jimple.RegionStmt;
import soot.PhaseOptions;
import soot.Singletons;
import soot.Trap;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.StmtBody;
import soot.jimple.ThrowStmt;
import soot.options.Options;
import soot.toolkits.exceptions.PedanticThrowAnalysis;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.ArraySet;

public class UnreachableCodeEliminator
extends BodyTransformer {
    public UnreachableCodeEliminator(Singletons.Global g) {
    }

    public static UnreachableCodeEliminator v() {
        return G.v().soot_jimple_toolkits_scalar_UnreachableCodeEliminator();
    }

    protected void internalTransform(Body b, String phaseName, Map options) {
        new Instance().internalTransform(b, phaseName, options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Instance {
        ExceptionalUnitGraph stmtGraph;
        HashSet<Object> visited;
        int numPruned;
        private Stack<Unit> regionExitStack = new Stack();

        Instance() {
        }

        protected void internalTransform(Body b, String phaseName, Map options) {
            StmtBody body = (StmtBody)b;
            if (Options.v().verbose()) {
                G.v().out.println("[" + body.getMethod().getName() + "] Eliminating unreachable code...");
            }
            this.numPruned = 0;
            this.stmtGraph = PhaseOptions.getBoolean(options, "remove-unreachable-traps") ? new ExceptionalUnitGraph(body) : new ExceptionalUnitGraph(body, PedanticThrowAnalysis.v(), false);
            this.visited = new HashSet();
            HashMap<Unit, ArraySet<Trap>> handlerToTraps = new HashMap<Unit, ArraySet<Trap>>();
            for (Trap trap : body.getTraps()) {
                Unit handler = trap.getHandlerUnit();
                ArraySet<Trap> handlersTraps = (ArraySet<Trap>)handlerToTraps.get(handler);
                if (handlersTraps == null) {
                    handlersTraps = new ArraySet<Trap>(3);
                    handlerToTraps.put(handler, handlersTraps);
                }
                handlersTraps.add(trap);
            }
            if (!body.getUnits().isEmpty()) {
                LinkedList<Unit> startPoints = new LinkedList<Unit>();
                startPoints.addLast(body.getUnits().getFirst());
                this.visitStmts(startPoints);
            }
            Iterator<Unit> stmtIt = body.getUnits().snapshotIterator();
            while (stmtIt.hasNext()) {
                Stmt stmt = (Stmt)stmtIt.next();
                if (this.visited.contains(stmt) || stmt instanceof RegionStmt) continue;
                body.getUnits().remove(stmt);
                Set traps = (Set)handlerToTraps.get(stmt);
                if (traps != null) {
                    for (Trap trap : traps) {
                        body.getTraps().remove(trap);
                    }
                }
                ++this.numPruned;
            }
            if (Options.v().verbose()) {
                G.v().out.println("[" + body.getMethod().getName() + "]     Removed " + this.numPruned + " statements...");
            }
            Iterator<Trap> trapIt = b.getTraps().iterator();
            while (trapIt.hasNext()) {
                Trap t = trapIt.next();
                if (t.getBeginUnit() != t.getEndUnit()) continue;
                trapIt.remove();
            }
        }

        private void visitStmts(LinkedList<Unit> st) {
            while (!st.isEmpty()) {
                Unit stmt = st.removeLast();
                if (this.visited.contains(stmt)) continue;
                this.visited.add(stmt);
                this.checkRegionStmt(stmt, st);
                for (Unit o : this.stmtGraph.getSuccsOf(stmt)) {
                    if (this.visited.contains(o)) continue;
                    st.addLast(o);
                }
            }
        }

        private void checkRegionStmt(Unit stmt, LinkedList<Unit> st) {
            Unit exitStmt;
            if (stmt instanceof RegionStmt) {
                RegionStmt regionStmt = (RegionStmt)stmt;
                if (regionStmt.isRegionEntry() && !regionStmt.isForLoopRegion()) {
                    Stmt exitStmt2 = regionStmt.getConnect();
                    if (exitStmt2 != null) {
                        this.regionExitStack.push(exitStmt2);
                    }
                } else if (regionStmt.isRegionExit()) {
                    RegionStmt entryStmt = (RegionStmt)regionStmt.getConnect();
                    if (regionStmt.isRegionEntry() && !regionStmt.isForLoopRegion() && !this.regionExitStack.empty()) {
                        this.regionExitStack.pop();
                    }
                }
            } else if (stmt instanceof ThrowStmt && !this.regionExitStack.empty() && (exitStmt = this.regionExitStack.peek()) != null && !this.visited.contains(exitStmt)) {
                st.addLast(exitStmt);
            }
        }
    }
}

