/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.Map;
import soot.EquivalentValue;
import soot.Unit;
import soot.jimple.toolkits.scalar.pre.EarliestnessComputation;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class DelayabilityAnalysis
extends ForwardFlowAnalysis {
    private EarliestnessComputation earliest;
    private Map unitToKillValue;
    private BoundedFlowSet set;

    public DelayabilityAnalysis(DirectedGraph dg) {
        super(dg);
        throw new RuntimeException("Don't use this Constructor!");
    }

    public DelayabilityAnalysis(DirectedGraph dg, EarliestnessComputation earliest, Map equivRhsMap) {
        this(dg, earliest, equivRhsMap, new ArrayPackedSet(new CollectionFlowUniverse(equivRhsMap.values())));
    }

    public DelayabilityAnalysis(DirectedGraph dg, EarliestnessComputation earliest, Map equivRhsMap, BoundedFlowSet set) {
        super(dg);
        UnitGraph g = (UnitGraph)dg;
        this.set = set;
        this.unitToKillValue = equivRhsMap;
        this.earliest = earliest;
        this.doAnalysis();
        for (Unit currentUnit : g) {
            FlowSet beforeSet = (FlowSet)this.getFlowBefore(currentUnit);
            beforeSet.union((FlowSet)earliest.getFlowBefore(currentUnit));
        }
    }

    protected Object newInitialFlow() {
        return this.set.topSet();
    }

    protected Object entryInitialFlow() {
        return this.set.emptySet();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.copy(out);
        out.union((FlowSet)this.earliest.getFlowBefore(unit));
        Unit u = (Unit)unit;
        EquivalentValue equiVal = (EquivalentValue)this.unitToKillValue.get(u);
        if (equiVal != null) {
            out.remove(equiVal);
        }
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

