/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar.pre;

import java.util.Map;
import soot.EquivalentValue;
import soot.jimple.toolkits.scalar.pre.LatestComputation;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArrayPackedSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.BoundedFlowSet;
import soot.toolkits.scalar.CollectionFlowUniverse;
import soot.toolkits.scalar.FlowSet;

public class NotIsolatedAnalysis
extends BackwardFlowAnalysis {
    private LatestComputation unitToLatest;
    private Map unitToGen;
    private FlowSet set;

    public NotIsolatedAnalysis(DirectedGraph dg) {
        super(dg);
        throw new RuntimeException("Don't use this Constructor!");
    }

    public NotIsolatedAnalysis(DirectedGraph dg, LatestComputation latest, Map equivRhsMap) {
        this(dg, latest, equivRhsMap, new ArrayPackedSet(new CollectionFlowUniverse(equivRhsMap.values())));
    }

    public NotIsolatedAnalysis(DirectedGraph dg, LatestComputation latest, Map equivRhsMap, BoundedFlowSet set) {
        super(dg);
        this.set = set;
        this.unitToGen = equivRhsMap;
        this.unitToLatest = latest;
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        return this.set.emptySet();
    }

    protected Object entryInitialFlow() {
        return this.newInitialFlow();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.copy(out);
        EquivalentValue rhs = (EquivalentValue)this.unitToGen.get(unit);
        if (rhs != null) {
            out.add(rhs);
        }
        FlowSet latest = (FlowSet)this.unitToLatest.getFlowBefore(unit);
        out.difference(latest);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.union(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

