/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import soot.Body;
import soot.SootMethod;
import soot.jimple.InvokeExpr;
import soot.jimple.MonitorStmt;
import soot.jimple.Stmt;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.thread.mhp.TargetMethodsFinder;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.CheckRecursiveCalls;
import soot.jimple.toolkits.thread.mhp.pegcallgraph.PegCallGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodExtentBuilder {
    private final Set<Object> methodsNeedingInlining = new HashSet<Object>();

    public MethodExtentBuilder(Body unitBody, PegCallGraph pcg, CallGraph cg) {
        this.build(pcg, cg);
        CheckRecursiveCalls crc = new CheckRecursiveCalls(pcg, this.methodsNeedingInlining);
        this.propagate(pcg);
    }

    public Set<Object> getMethodsNeedingInlining() {
        return this.methodsNeedingInlining;
    }

    private void build(PegCallGraph pcg, CallGraph cg) {
        for (SootMethod method : pcg) {
            this.computeForMethodInlining(method, cg);
        }
    }

    private void computeForMethodInlining(SootMethod targetMethod, CallGraph cg) {
        if (targetMethod.isSynchronized()) {
            this.methodsNeedingInlining.add(targetMethod);
            return;
        }
        Body mBody = targetMethod.getActiveBody();
        for (Stmt stmt : mBody.getUnits()) {
            if (stmt instanceof MonitorStmt) {
                this.methodsNeedingInlining.add(targetMethod);
                return;
            }
            if (!stmt.containsInvokeExpr()) continue;
            InvokeExpr invokeExpr = stmt.getInvokeExpr();
            SootMethod method = invokeExpr.getMethod();
            String name = method.getName();
            if (name.equals("wait") || name.equals("notify") || name.equals("notifyAll") || (name.equals("start") || name.equals("join") || name.equals("suspend") || name.equals("resume") || name.equals("destroy") || name.equals("stop")) && method.getDeclaringClass().getName().equals("java.lang.Thread")) {
                this.methodsNeedingInlining.add(targetMethod);
                return;
            }
            if (!method.isConcrete() || method.getDeclaringClass().isLibraryClass()) continue;
            Iterator<Edge> it = cg.edgesOutOf(stmt);
            TargetMethodsFinder tmd = new TargetMethodsFinder();
            for (SootMethod target : tmd.find(stmt, cg, true, false)) {
                if (!target.isSynchronized()) continue;
                this.methodsNeedingInlining.add(targetMethod);
                return;
            }
        }
    }

    protected void propagate(PegCallGraph cg) {
        HashSet<Object> gray = new HashSet<Object>();
        for (Object o : cg) {
            if (this.methodsNeedingInlining.contains(o) || gray.contains(o) || !this.visitNode(o, gray, cg)) continue;
            this.methodsNeedingInlining.add(o);
        }
    }

    private boolean visitNode(Object o, Set<Object> gray, PegCallGraph cg) {
        gray.add(o);
        for (Object child : cg.getSuccsOf(o)) {
            if (this.methodsNeedingInlining.contains(child)) {
                gray.add(child);
                return true;
            }
            if (gray.contains(child) || !this.visitNode(child, gray, cg)) continue;
            this.methodsNeedingInlining.add(child);
            return true;
        }
        return false;
    }
}

