/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.synchronization;

import java.util.Collection;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.EdgePredicate;
import soot.jimple.toolkits.thread.synchronization.CriticalSection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriticalSectionVisibleEdgesPred
implements EdgePredicate {
    Collection<CriticalSection> tns;
    CriticalSection exemptTn;

    public CriticalSectionVisibleEdgesPred(Collection<CriticalSection> tns) {
        this.tns = tns;
    }

    public void setExemptTransaction(CriticalSection exemptTn) {
        this.exemptTn = exemptTn;
    }

    @Override
    public boolean want(Edge e) {
        String tgtMethod = e.tgt().toString();
        String tgtClass = e.tgt().getDeclaringClass().toString();
        String srcMethod = e.src().toString();
        String srcClass = e.src().getDeclaringClass().toString();
        if (tgtClass.startsWith("sun.")) {
            return false;
        }
        if (tgtClass.startsWith("com.sun.")) {
            return false;
        }
        if (tgtMethod.endsWith("void <clinit>()>")) {
            return false;
        }
        if ((tgtClass.startsWith("java.") || tgtClass.startsWith("javax.")) && e.tgt().toString().endsWith("boolean equals(java.lang.Object)>")) {
            return false;
        }
        if (tgtClass.startsWith("java.util") || srcClass.startsWith("java.util")) {
            return false;
        }
        if (tgtClass.startsWith("java.lang") || srcClass.startsWith("java.lang")) {
            return false;
        }
        if (tgtClass.startsWith("java")) {
            return false;
        }
        if (e.tgt().isSynchronized()) {
            return false;
        }
        if (this.tns != null) {
            for (CriticalSection tn : this.tns) {
                if (tn == this.exemptTn || !tn.units.contains(e.srcStmt())) continue;
                return false;
            }
        }
        return true;
    }
}

