/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorNode;
import soot.toolkits.graph.DominatorsFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DominatorTree {
    protected DominatorsFinder dominators;
    protected DirectedGraph graph;
    protected DominatorNode head;
    protected ArrayList tails;
    protected HashMap godeToDode;

    public DominatorTree(DominatorsFinder dominators) {
        this.dominators = dominators;
        this.graph = dominators.getGraph();
        this.head = null;
        this.tails = new ArrayList();
        this.godeToDode = new HashMap();
        this.buildTree();
    }

    public DirectedGraph getGraph() {
        return this.dominators.getGraph();
    }

    public DominatorNode getHead() {
        return this.head;
    }

    public List getTails() {
        return (List)this.tails.clone();
    }

    public DominatorNode getParentOf(DominatorNode node) {
        return node.getParent();
    }

    public List getChildrenOf(DominatorNode node) {
        return (List)((ArrayList)node.getChildren()).clone();
    }

    public List<DominatorNode> getPredsOf(DominatorNode node) {
        List<Object> preds = this.graph.getPredsOf(node.getGode());
        ArrayList<DominatorNode> predNodes = new ArrayList<DominatorNode>();
        for (Object pred : preds) {
            predNodes.add(this.getDode(pred));
        }
        return predNodes;
    }

    public List<DominatorNode> getSuccsOf(DominatorNode node) {
        List<Object> succs = this.graph.getSuccsOf(node.getGode());
        ArrayList<DominatorNode> succNodes = new ArrayList<DominatorNode>();
        for (Object succ : succs) {
            succNodes.add(this.getDode(succ));
        }
        return succNodes;
    }

    public boolean isImmediateDominatorOf(DominatorNode idom, DominatorNode node) {
        return node.getParent() == idom;
    }

    public boolean isDominatorOf(DominatorNode dom, DominatorNode node) {
        return this.dominators.isDominatedBy(node.getGode(), dom.getGode());
    }

    public DominatorNode getDode(Object gode) {
        DominatorNode dode = (DominatorNode)this.godeToDode.get(gode);
        if (dode == null) {
            throw new RuntimeException("Assertion failed: Dominator tree does not have a corresponding dode for gode (" + gode + ")");
        }
        return dode;
    }

    public Iterator iterator() {
        return this.godeToDode.values().iterator();
    }

    public int size() {
        return this.godeToDode.size();
    }

    protected void buildTree() {
        for (Object gode : this.graph) {
            DominatorNode dode = this.fetchDode(gode);
            DominatorNode parent = this.fetchParent(gode);
            if (parent == null) {
                if (this.head != null) {
                    throw new RuntimeException("Assertion failed.");
                }
                this.head = dode;
                continue;
            }
            parent.addChild(dode);
            dode.setParent(parent);
        }
        Iterator dodesIt = this.iterator();
        while (dodesIt.hasNext()) {
            DominatorNode dode = (DominatorNode)dodesIt.next();
            if (!dode.isTail()) continue;
            this.tails.add(dode);
        }
    }

    protected DominatorNode fetchDode(Object gode) {
        DominatorNode dode;
        if (this.godeToDode.containsKey(gode)) {
            dode = (DominatorNode)this.godeToDode.get(gode);
        } else {
            dode = new DominatorNode(gode);
            this.godeToDode.put(gode, dode);
        }
        return dode;
    }

    protected DominatorNode fetchParent(Object gode) {
        Object immediateDominator = this.dominators.getImmediateDominator(gode);
        if (immediateDominator == null) {
            return null;
        }
        return this.fetchDode(immediateDominator);
    }
}

