/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.DominatorsFinder;

public class MHGDominatorsFinder
implements DominatorsFinder {
    protected DirectedGraph graph;
    protected BitSet fullSet;
    protected List heads;
    protected Map<Object, BitSet> nodeToFlowSet;
    protected Map<Object, Integer> nodeToIndex;
    protected Map<Integer, Object> indexToNode;
    protected int lastIndex = 0;

    public MHGDominatorsFinder(DirectedGraph graph) {
        this.graph = graph;
        this.doAnalysis();
    }

    protected void doAnalysis() {
        this.heads = this.graph.getHeads();
        this.nodeToFlowSet = new HashMap<Object, BitSet>();
        this.nodeToIndex = new HashMap<Object, Integer>();
        this.indexToNode = new HashMap<Integer, Object>();
        this.fullSet = new BitSet(this.graph.size());
        this.fullSet.flip(0, this.graph.size() - 1);
        for (Object o : this.graph) {
            if (this.heads.contains(o)) {
                BitSet self = new BitSet();
                self.set(this.indexOf(o));
                this.nodeToFlowSet.put(o, self);
                continue;
            }
            this.nodeToFlowSet.put(o, this.fullSet);
        }
        boolean changed = true;
        do {
            changed = false;
            for (Object o : this.graph) {
                BitSet predsIntersect;
                if (this.heads.contains(o)) {
                    predsIntersect = new BitSet();
                    predsIntersect.set(this.indexOf(o));
                } else {
                    predsIntersect = (BitSet)this.fullSet.clone();
                }
                Iterator j = this.graph.getPredsOf(o).iterator();
                while (j.hasNext()) {
                    BitSet predSet = this.nodeToFlowSet.get(j.next());
                    predsIntersect.and(predSet);
                }
                BitSet oldSet = this.nodeToFlowSet.get(o);
                predsIntersect.set(this.indexOf(o));
                if (predsIntersect.equals(oldSet)) continue;
                this.nodeToFlowSet.put(o, predsIntersect);
                changed = true;
            }
        } while (changed);
    }

    protected int indexOf(Object o) {
        Integer index = this.nodeToIndex.get(o);
        if (index == null) {
            index = this.lastIndex;
            this.nodeToIndex.put(o, index);
            this.indexToNode.put(index, o);
            ++this.lastIndex;
        }
        return index;
    }

    public DirectedGraph getGraph() {
        return this.graph;
    }

    public List getDominators(Object node) {
        ArrayList<Object> result = new ArrayList<Object>();
        BitSet bitSet = this.nodeToFlowSet.get(node);
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            result.add(this.indexToNode.get(i));
        }
        return result;
    }

    public List getOldDominators(Object node) {
        ArrayList<Object> result = new ArrayList<Object>();
        BitSet bitSet = this.nodeToFlowSet.get(node);
        if (bitSet == null) {
            return new ArrayList();
        }
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            result.add(this.indexToNode.get(i));
        }
        return result;
    }

    public Object getImmediateDominator(Object node) {
        if (this.getGraph().getHeads().contains(node)) {
            return null;
        }
        List dominatorsList = this.getDominators(node);
        dominatorsList.remove(node);
        Iterator dominatorsIt = dominatorsList.iterator();
        Object immediateDominator = null;
        while (immediateDominator == null && dominatorsIt.hasNext()) {
            Object dominator = dominatorsIt.next();
            if (!this.isDominatedByAll(dominator, dominatorsList)) continue;
            immediateDominator = dominator;
        }
        assert (immediateDominator != null);
        return immediateDominator;
    }

    public boolean isDominatedBy(Object node, Object dominator) {
        return this.getDominators(node).contains(dominator);
    }

    public boolean isDominatedByAll(Object node, Collection dominators) {
        return this.getDominators(node).containsAll(dominators);
    }
}

