/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.graph;

import java.util.Iterator;
import java.util.List;
import soot.Unit;
import soot.jimple.Stmt;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.BackwardFlowAnalysis;
import soot.toolkits.scalar.FlowSet;

public class PostDominatorAnalysis
extends BackwardFlowAnalysis {
    private UnitGraph g;
    private FlowSet allNodes;

    public PostDominatorAnalysis(UnitGraph g) {
        super(g);
        this.g = g;
        this.initAllNodes();
        this.doAnalysis();
    }

    private void initAllNodes() {
        this.allNodes = new ArraySparseSet();
        Iterator<Unit> it = this.g.iterator();
        while (it.hasNext()) {
            this.allNodes.add(it.next());
        }
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceIn = (FlowSet)source;
        FlowSet destOut = (FlowSet)dest;
        sourceIn.copy(destOut);
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        Unit s = (Unit)unit;
        if (this.isUnitEndNode(s)) {
            out.clear();
            out.add(s);
        } else {
            FlowSet domsOfSuccs = this.allNodes.clone();
            for (Unit succ : this.g.getSuccsOf(s)) {
                FlowSet next = (FlowSet)this.unitToBeforeFlow.get(succ);
                in.intersection(next, in);
            }
            out.intersection(in, out);
            out.add(s);
        }
    }

    private boolean isUnitEndNode(Unit s) {
        return this.g.getTails().contains(s);
    }

    protected Object entryInitialFlow() {
        ArraySparseSet fs = new ArraySparseSet();
        List<Unit> tails = this.g.getTails();
        fs.add(tails.get(0));
        return fs;
    }

    protected Object newInitialFlow() {
        return this.allNodes.clone();
    }

    public boolean postDominates(Stmt s, Stmt t) {
        return ((FlowSet)this.getFlowBefore(t)).contains(s);
    }
}

