/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.HashMap;
import java.util.Map;
import soot.Local;
import soot.Unit;
import soot.ValueBox;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.ForwardFlowAnalysis;

class GuaranteedDefsAnalysis
extends ForwardFlowAnalysis {
    FlowSet emptySet = new ArraySparseSet();
    Map<Unit, FlowSet> unitToGenerateSet;

    GuaranteedDefsAnalysis(UnitGraph graph) {
        super(graph);
        MHGDominatorsFinder df = new MHGDominatorsFinder(graph);
        this.unitToGenerateSet = new HashMap<Unit, FlowSet>(graph.size() * 2 + 1, 0.7f);
        for (Unit s : graph) {
            FlowSet genSet = this.emptySet.clone();
            for (Unit dom : df.getDominators(s)) {
                for (ValueBox box : dom.getDefBoxes()) {
                    if (!(box.getValue() instanceof Local)) continue;
                    genSet.add(box.getValue(), genSet);
                }
            }
            this.unitToGenerateSet.put(s, genSet);
        }
        this.doAnalysis();
    }

    protected Object newInitialFlow() {
        return this.emptySet.clone();
    }

    protected Object entryInitialFlow() {
        return this.emptySet.clone();
    }

    protected void flowThrough(Object inValue, Object unit, Object outValue) {
        FlowSet in = (FlowSet)inValue;
        FlowSet out = (FlowSet)outValue;
        in.union(this.unitToGenerateSet.get(unit), out);
    }

    protected void merge(Object in1, Object in2, Object out) {
        FlowSet inSet1 = (FlowSet)in1;
        FlowSet inSet2 = (FlowSet)in2;
        FlowSet outSet = (FlowSet)out;
        inSet1.intersection(inSet2, outSet);
    }

    protected void copy(Object source, Object dest) {
        FlowSet sourceSet = (FlowSet)source;
        FlowSet destSet = (FlowSet)dest;
        sourceSet.copy(destSet);
    }
}

