/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import soot.toolkits.scalar.FlowUniverse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectIntMapper<E> {
    private Vector<E> intToObjects;
    private int counter;
    private Map<E, Integer> objectToInts;

    public ObjectIntMapper() {
        this.intToObjects = new Vector();
        this.objectToInts = new HashMap<E, Integer>();
        this.counter = 0;
    }

    public ObjectIntMapper(FlowUniverse<E> flowUniverse) {
        this(flowUniverse.iterator(), flowUniverse.size());
    }

    public ObjectIntMapper(Collection<E> collection) {
        this(collection.iterator(), collection.size());
    }

    private ObjectIntMapper(Iterator<E> it, int initSize) {
        this.intToObjects = new Vector(initSize);
        this.objectToInts = new HashMap<E, Integer>(initSize);
        this.counter = 0;
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    public int add(E o) {
        this.objectToInts.put(o, this.counter);
        this.intToObjects.add(o);
        return this.counter++;
    }

    public int getInt(E o) {
        Integer i = this.objectToInts.get(o);
        if (i != null) {
            return i;
        }
        return this.add(o);
    }

    public Object getObject(int i) {
        return this.intToObjects.get(i);
    }

    public boolean contains(Object o) {
        return this.objectToInts.containsKey(o);
    }

    public int size() {
        return this.counter;
    }
}

