/*
 * Decompiled with CFR 0.152.
 */
package soot.workstealing;

import soot.Body;
import soot.IntType;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.VoidType;
import soot.jimple.IdentityStmt;
import soot.jimple.IntConstant;
import soot.jimple.Jimple;
import soot.jimple.NullConstant;
import soot.jimple.Stmt;
import soot.jimple.ThisRef;

public class GenJimple {
    private static GenJimple instance = new GenJimple();

    private GenJimple() {
    }

    public static GenJimple v() {
        return instance;
    }

    public Local addLocal(Body body, String name, Type type) {
        Local newLocal = Jimple.v().newLocal(name, type);
        body.getLocals().add(newLocal);
        return newLocal;
    }

    public void addThisRefStmt(Body body, Local leftOp, RefType rType) {
        body.getUnits().addFirst(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newThisRef(rType)));
    }

    public void addParameterRefStmt(Body body, Local leftOp, Type paramType, int paramNum) {
        Stmt thisStmt = null;
        if (body.getUnits().size() > 0) {
            thisStmt = (Stmt)body.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            body.getUnits().insertAfter(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newParameterRef(paramType, paramNum)), (Unit)thisStmt);
        } else {
            body.getUnits().addFirst(Jimple.v().newIdentityStmt(leftOp, Jimple.v().newParameterRef(paramType, paramNum)));
        }
    }

    public Local addLocalAndThisRefStmt(Body body, String name, RefType rType) {
        Local thisLocal = this.addLocal(body, name, rType);
        this.addThisRefStmt(body, thisLocal, rType);
        return thisLocal;
    }

    public Local addLocalAndParameterRefStmt(Body body, String name, Type paramType, int paramNum) {
        Local newLocal = this.addLocal(body, name, paramType);
        this.addParameterRefStmt(body, newLocal, paramType, paramNum);
        return newLocal;
    }

    public Stmt generateReturnStmtForMethod(SootMethod sMethod) {
        Stmt retSt = sMethod.getReturnType() == VoidType.v() ? Jimple.v().newReturnVoidStmt() : (sMethod.getReturnType() == IntType.v() ? Jimple.v().newReturnStmt(IntConstant.v(-1)) : Jimple.v().newReturnStmt(NullConstant.v()));
        return retSt;
    }
}

