/*
 * Decompiled with CFR 0.152.
 */
package soot.workstealing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.IntType;
import soot.IntegerType;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.IntConstant;
import soot.jimple.InterfaceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.JimpleBody;
import soot.jimple.NullConstant;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.ReturnVoidStmt;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.ThisRef;
import soot.jimple.ThrowStmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.internal.JimpleLocal;
import soot.workstealing.FinishAsyncTransformer;
import soot.workstealing.GenJimple;
import soot.workstealing.RuntimeReferences;

public class MethodTransformer {
    private SootMethod theMethod;
    private SootMethod fastClone;
    private SootMethod slowClone;
    private SootClass declaringClass;
    private SootClass frameClass;
    private SootMethod frameConstructor;
    private SootMethod frameExecuteSlow;
    private SootMethod frameSetReturnResult;
    private SootField frameArgsField;
    private SootField frameThisOuter;
    private Stmt fastCloneFrameInitSt;
    private Stmt slowCloneFrameInitSt;
    private Body fastCloneBody;
    private Body slowCloneBody;
    private Local fastCloneWorker;
    private Local slowCloneWorker;
    private Local fastCloneFrame;
    private Local slowCloneFrame;
    private Local slowCloneF;
    private boolean hasFastClone;
    private boolean hasSlowClone;
    private boolean hasFrameClass;
    private boolean hasBfFrameClass;
    private boolean finishAsyncTransformationDone;
    private Map<Local, SootField> locals2Fields;
    private Map<SootField, Local> fields2Locals;
    private Map<Local, SootField> locals2bfFrameFields;
    private Map<SootField, Local> bfFrameFields2Locals;
    private Map<SootClass, SootMethod> innerClassConstructors;
    private List<SootMethod> oldInnerClassConstructors;
    private List<Stmt> continuations;
    private Map<Integer, Local> seqCallReturnLocals;
    private Map<Stmt, Integer> seqCallContinuations;
    public static int count = 0;

    public MethodTransformer(SootMethod sMethod) {
        this.theMethod = sMethod;
        this.declaringClass = this.theMethod.getDeclaringClass();
        this.hasBfFrameClass = false;
        this.hasFrameClass = false;
        this.hasSlowClone = false;
        this.hasFastClone = false;
        this.finishAsyncTransformationDone = false;
        this.locals2Fields = new HashMap<Local, SootField>();
        this.fields2Locals = new HashMap<SootField, Local>();
        this.locals2bfFrameFields = new HashMap<Local, SootField>();
        this.bfFrameFields2Locals = new HashMap<SootField, Local>();
        this.innerClassConstructors = new HashMap<SootClass, SootMethod>();
        this.oldInnerClassConstructors = new ArrayList<SootMethod>();
        this.continuations = new ArrayList<Stmt>();
        this.fastCloneFrameInitSt = null;
        this.slowCloneFrameInitSt = null;
        this.frameThisOuter = null;
        this.seqCallReturnLocals = new HashMap<Integer, Local>();
        this.seqCallContinuations = new HashMap<Stmt, Integer>();
    }

    public SootMethod fastClone() {
        if (!this.hasFastClone) {
            throw new RuntimeException("There is no fast clone for method : " + this.theMethod.getName());
        }
        return this.fastClone;
    }

    public Local fastCloneWorker() {
        if (!this.hasFastClone) {
            throw new RuntimeException("There is no fast clone for method : " + this.theMethod.getName());
        }
        return this.fastCloneWorker;
    }

    public SootMethod slowClone() {
        if (!this.hasSlowClone) {
            throw new RuntimeException("There is no slow clone for method : " + this.theMethod.getName());
        }
        return this.slowClone;
    }

    public Local slowCloneWorker() {
        if (!this.hasSlowClone) {
            throw new RuntimeException("There is no slow clone for method : " + this.theMethod.getName());
        }
        return this.slowCloneWorker;
    }

    public SootClass frameClass() {
        if (!this.hasFrameClass) {
            throw new RuntimeException("There is no frame class for method : " + this.theMethod.getName());
        }
        return this.frameClass;
    }

    public SootMethod frameConstructor() {
        if (!this.hasFrameClass) {
            throw new RuntimeException("There is no frame class for method : " + this.theMethod.getName());
        }
        return this.frameConstructor;
    }

    public boolean hasSlowClone() {
        return this.hasSlowClone;
    }

    public boolean hasFastClone() {
        return this.hasFastClone;
    }

    public boolean hasFrameClass() {
        return this.hasFrameClass;
    }

    public boolean hasBfFrameClass() {
        return this.hasBfFrameClass;
    }

    public boolean finishAsyncTransformationDone() {
        return this.finishAsyncTransformationDone;
    }

    public static int getCount() {
        return count++;
    }

    public void generateClones() {
        this.generateFastClone();
        this.generateSlowClone();
    }

    public void cleanupMethodDeclarations() {
        this.theMethod.releaseActiveBody();
        this.declaringClass.removeMethod(this.theMethod);
    }

    public SootMethod generateFastClone() {
        this.fastClone = new SootMethod(this.theMethod.getName() + "Seq", this.theMethod.getParameterTypes(), this.theMethod.getReturnType(), this.theMethod.getModifiers());
        this.declaringClass.addMethod(this.fastClone);
        this.hasFastClone = true;
        this.fastCloneBody = (Body)this.theMethod.getActiveBody().clone();
        this.fastClone.setActiveBody(this.fastCloneBody);
        this.fastClone.addException(RuntimeReferences.v().WSSpawnFrameStolenException());
        this.incrementParameterRefsInIdentityStmts(this.fastClone);
        List params = this.fastClone.getParameterTypes();
        params.add(0, RuntimeReferences.v().WSWorker().getType());
        this.fastClone.setParameterTypes(params);
        this.fastCloneWorker = new JimpleLocal("pWorker", RuntimeReferences.v().WSWorker().getType());
        this.fastCloneBody.getLocals().add(this.fastCloneWorker);
        Stmt thisStmt = null;
        if (this.fastCloneBody.getUnits().size() > 0) {
            thisStmt = (Stmt)this.fastCloneBody.getUnits().getFirst();
        }
        if (thisStmt != null && thisStmt instanceof IdentityStmt && ((IdentityStmt)thisStmt).getRightOp() instanceof ThisRef) {
            this.fastCloneBody.getUnits().insertAfter(Jimple.v().newIdentityStmt(this.fastCloneWorker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 0)), (Unit)thisStmt);
        } else {
            this.fastCloneBody.getUnits().addFirst(Jimple.v().newIdentityStmt(this.fastCloneWorker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 0)));
        }
        return this.fastClone;
    }

    private void incrementParameterRefsInIdentityStmts(SootMethod sMethod) {
        Body body = sMethod.getActiveBody();
        int paramsCount = sMethod.getParameterCount();
        System.out.println("Modifying Parameter Refs in function : " + sMethod.getSignature());
        System.out.println("Parameter Count = " + paramsCount);
        Iterator<Unit> unitsIt = body.getUnits().iterator();
        while (paramsCount > 0) {
            IdentityStmt idSt;
            Value rightOp;
            assert (unitsIt.hasNext());
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof IdentityStmt) || !((rightOp = (idSt = (IdentityStmt)st).getRightOp()) instanceof ParameterRef)) continue;
            ParameterRef pRef = (ParameterRef)rightOp;
            pRef.setIndex(pRef.getIndex() + 1);
            --paramsCount;
        }
    }

    public SootMethod generateSlowClone() {
        this.slowClone = new SootMethod(this.theMethod.getName() + "Slow", Arrays.asList(RuntimeReferences.v().WSWorker().getType(), RuntimeReferences.v().WSFrame().getType()), VoidType.v(), this.theMethod.getModifiers());
        this.declaringClass.addMethod(this.slowClone);
        this.slowCloneBody = (Body)this.theMethod.getActiveBody().clone();
        this.slowClone.setActiveBody(this.slowCloneBody);
        this.hasSlowClone = true;
        this.slowClone.addException(RuntimeReferences.v().WSSpawnFrameStolenException());
        Iterator<Unit> unitsIt = this.slowCloneBody.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Value rightOp;
            Stmt st = (Stmt)unitsIt.next();
            if (!(st instanceof IdentityStmt) || !((rightOp = ((IdentityStmt)st).getRightOp()) instanceof ParameterRef)) continue;
            this.slowCloneBody.getUnits().remove(st);
        }
        this.slowCloneF = GenJimple.v().addLocalAndParameterRefStmt(this.slowCloneBody, "pFrame", RuntimeReferences.v().WSFrame().getType(), 1);
        this.slowCloneWorker = GenJimple.v().addLocalAndParameterRefStmt(this.slowCloneBody, "pWorker", RuntimeReferences.v().WSWorker().getType(), 0);
        return this.slowClone;
    }

    public void transformFinishAsyncs() {
        if (this.finishAsyncTransformationDone) {
            return;
        }
        this.fastCloneFrameInitSt = this.addNewFrameLocal();
        this.addBeginMethodCall(this.fastCloneFrameInitSt);
        this.addEndMethodCalls(this.fastClone, this.fastCloneWorker, true);
        this.transformFinishAsyncs(this.fastClone, this.fastCloneWorker, this.fastCloneFrame, true);
        this.addWorkerParamToFuncCalls(this.fastClone, this.fastCloneWorker, this.fastCloneFrame, true);
        Stmt lastAddedSt = this.copyFrameParamToLocal();
        this.slowCloneFrameInitSt = lastAddedSt = this.addCopiesFromFrameFieldsToLocals(this.slowCloneBody, lastAddedSt, this.slowCloneFrame);
        this.continuations.add(0, lastAddedSt);
        this.addEndMethodCalls(this.slowClone, this.slowCloneWorker, false);
        this.transformFinishAsyncs(this.slowClone, this.slowCloneWorker, this.slowCloneFrame, false);
        this.addWorkerParamToFuncCalls(this.slowClone, this.slowCloneWorker, this.slowCloneFrame, false);
        this.addCodeForContinuations();
        this.finishAsyncTransformationDone = true;
    }

    public void transformFinishAsyncs(SootMethod sMethod, Local worker, Local frame, boolean fastVersion) {
        Body body = sMethod.getActiveBody();
        int currPC = 1;
        Iterator<Unit> getStmtIt = body.getUnits().snapshotIterator();
        while (getStmtIt.hasNext()) {
            Stmt st = (Stmt)getStmtIt.next();
            if (!st.containsInvokeExpr()) continue;
            ValueBox invExprBox = st.getInvokeExprBox();
            InvokeExpr invExpr = (InvokeExpr)invExprBox.getValue();
            SootMethod callMethod = invExpr.getMethod();
            if (FinishAsyncTransformer.v().isStartFinishMethod(callMethod)) {
                Stmt newSt = this.handleStartFinishCall(st, body, worker);
                continue;
            }
            if (FinishAsyncTransformer.v().isStopFinishMethod(callMethod)) {
                Stmt prevSt = (Stmt)body.getUnits().getPredOf(st);
                this.addCopiesFromLocalsToFrameFields(body, prevSt, frame);
                Stmt lastAddedSt = this.handleStopFinishCall(st, body, worker, frame, currPC);
                if (!fastVersion) {
                    this.continuations.add(lastAddedSt);
                }
                ++currPC;
                continue;
            }
            if (FinishAsyncTransformer.v().isAsyncMethod(callMethod)) {
                this.handleAsyncCall(st, body, worker, fastVersion);
                continue;
            }
            if (!FinishAsyncTransformer.v().isATransformedMethod(callMethod)) continue;
            this.seqCallContinuations.put(st, new Integer(currPC));
            ++currPC;
        }
    }

    private void addWorkerParamToFuncCalls(SootMethod sMethod, Local worker, Local frame, boolean fastVersion) {
        Body body = sMethod.getActiveBody();
        Iterator<Unit> unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (!st.containsInvokeExpr()) continue;
            ValueBox invExprBox = st.getInvokeExprBox();
            InvokeExpr invExpr = (InvokeExpr)invExprBox.getValue();
            SootMethod callMethod = invExpr.getMethod();
            if (!FinishAsyncTransformer.v().isATransformedMethod(callMethod)) continue;
            MethodTransformer mT = FinishAsyncTransformer.v().getMethodTransformer(callMethod);
            SootMethod thisFastClone = mT.fastClone();
            if (!FinishAsyncTransformer.v().isARunHjTaskMethod(sMethod) && this.seqCallContinuations.containsKey(st)) {
                Iterator<ValueBox> defsIt;
                int firstCont = this.seqCallContinuations.get(st);
                int secondCont = firstCont + 1;
                this.addCopiesFromLocalsToFrameFields(body, st, frame);
                this.updatePCInFrame(body, st, frame, firstCont);
                if (!fastVersion) {
                    this.continuations.add(firstCont, st);
                }
                if (fastVersion && (defsIt = st.getDefBoxes().iterator()).hasNext()) {
                    Value def = defsIt.next().getValue();
                    assert (!defsIt.hasNext());
                    assert (def instanceof Local);
                    this.seqCallReturnLocals.put(firstCont, (Local)def);
                }
            }
            List args = invExpr.getArgs();
            args.add(0, worker);
            if (invExpr instanceof InterfaceInvokeExpr) {
                InterfaceInvokeExpr iie = (InterfaceInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newInterfaceInvokeExpr((Local)iie.getBase(), thisFastClone.makeRef(), args));
                continue;
            }
            if (invExpr instanceof SpecialInvokeExpr) {
                SpecialInvokeExpr sie = (SpecialInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newSpecialInvokeExpr((Local)sie.getBase(), thisFastClone.makeRef(), args));
                continue;
            }
            if (invExpr instanceof StaticInvokeExpr) {
                StaticInvokeExpr sie = (StaticInvokeExpr)invExpr;
                invExprBox.setValue(Jimple.v().newStaticInvokeExpr(thisFastClone.makeRef(), args));
                continue;
            }
            if (!(invExpr instanceof VirtualInvokeExpr)) continue;
            VirtualInvokeExpr vie = (VirtualInvokeExpr)invExpr;
            invExprBox.setValue(Jimple.v().newVirtualInvokeExpr((Local)vie.getBase(), thisFastClone.makeRef(), args));
        }
    }

    private void addEndMethodCalls(SootMethod sMethod, Local worker, boolean fastVersion) {
        Body body = sMethod.getActiveBody();
        Iterator<Unit> unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (st instanceof ReturnVoidStmt) {
                if (fastVersion) {
                    body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerEndMethodFast().makeRef())), (Unit)st);
                    continue;
                }
                body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerEndMethodSlow().makeRef())), (Unit)st);
                continue;
            }
            if (!(st instanceof ReturnStmt)) continue;
            if (fastVersion) {
                body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerEndMethodFast().makeRef())), (Unit)st);
                continue;
            }
            Value retValue = ((ReturnStmt)st).getOp();
            if (this.theMethod.getReturnType() instanceof IntegerType) {
                Local integerObject = Jimple.v().newLocal("$p_" + MethodTransformer.getCount(), RuntimeReferences.v().JavaLangInteger().getType());
                body.getLocals().add(integerObject);
                body.getUnits().insertBefore(Jimple.v().newAssignStmt(integerObject, Jimple.v().newStaticInvokeExpr(RuntimeReferences.v().integerValueOf().makeRef(), retValue)), (Unit)st);
                retValue = integerObject;
            }
            body.getUnits().insertBefore(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerEndMethodSlowWObject().makeRef(), retValue)), (Unit)st);
            body.getUnits().swapWith(st, Jimple.v().newReturnVoidStmt());
        }
    }

    private Stmt addNewFrameLocal() {
        this.fastCloneFrame = GenJimple.v().addLocal(this.fastCloneBody, "frame", this.frameClass.getType());
        JimpleBody jBody = (JimpleBody)this.fastCloneBody;
        Stmt beforeSt = jBody.getFirstNonIdentityStmt();
        this.fastCloneBody.getUnits().insertBefore(Jimple.v().newAssignStmt(this.fastCloneFrame, Jimple.v().newNewExpr(this.frameClass.getType())), (Unit)beforeSt);
        ArrayList<Local> paramList = new ArrayList<Local>();
        if (!this.theMethod.isStatic()) {
            paramList.add(this.fastCloneBody.getThisLocal());
        }
        for (int i = 1; i < this.fastClone.getParameterCount(); ++i) {
            paramList.add(this.fastCloneBody.getParameterLocal(i));
        }
        InvokeStmt splInvSt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(this.fastCloneFrame, this.frameConstructor.makeRef(), paramList));
        this.fastCloneBody.getUnits().insertBefore(splInvSt, (Unit)beforeSt);
        return splInvSt;
    }

    private void addBeginMethodCall(Stmt afterSt) {
        JimpleBody jBody = (JimpleBody)this.fastCloneBody;
        Stmt beforeSt = jBody.getFirstNonIdentityStmt();
        InvokeStmt virInvSt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(this.fastCloneWorker, RuntimeReferences.v().workerBeginMethod().makeRef(), this.fastCloneFrame));
        jBody.getUnits().insertAfter(virInvSt, (Unit)afterSt);
    }

    private Stmt copyFrameParamToLocal() {
        this.slowCloneFrame = GenJimple.v().addLocal(this.slowCloneBody, "frame", this.frameClass.getType());
        JimpleBody jBody = (JimpleBody)this.slowCloneBody;
        Stmt beforeSt = jBody.getFirstNonIdentityStmt();
        AssignStmt assignSt = Jimple.v().newAssignStmt(this.slowCloneFrame, Jimple.v().newCastExpr(this.slowCloneF, this.frameClass.getType()));
        this.slowCloneBody.getUnits().insertBefore(assignSt, (Unit)beforeSt);
        return assignSt;
    }

    private Stmt addCopiesFromLocalsToFrameFields(Body body, Stmt beforeSt, Local frame) {
        for (Local local : body.getLocals()) {
            if (!this.frameClass.declaresField(local.getName(), local.getType())) continue;
            SootField sField = this.frameClass.getField(local.getName(), local.getType());
            AssignStmt st = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(frame, sField.makeRef()), local);
            body.getUnits().insertBefore(st, (Unit)beforeSt);
        }
        Stmt lastSt = (Stmt)body.getUnits().getPredOf(beforeSt);
        return lastSt;
    }

    private Stmt addCopiesFromFrameFieldsToLocals(Body body, Stmt afterSt, Local frame) {
        Stmt lastSt = (Stmt)body.getUnits().getSuccOf(afterSt);
        for (Local local : body.getLocals()) {
            if (!this.frameClass.declaresField(local.getName(), local.getType())) continue;
            SootField sField = this.frameClass.getField(local.getName(), local.getType());
            body.getUnits().insertAfter(Jimple.v().newAssignStmt(local, Jimple.v().newInstanceFieldRef(frame, sField.makeRef())), (Unit)afterSt);
        }
        lastSt = (Stmt)body.getUnits().getPredOf(lastSt);
        return lastSt;
    }

    private void updatePCInFrame(Body body, Stmt beforeSt, Local frame, int pc) {
        body.getUnits().insertBefore(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(frame, RuntimeReferences.v().framePC().makeRef()), IntConstant.v(pc)), (Unit)beforeSt);
    }

    private Stmt addCheckActivationFrameStolen(Body body, Stmt afterSt, Local worker, int currPC) {
        Stmt nextSt = (Stmt)body.getUnits().getSuccOf(afterSt);
        Local checkActFrame = Jimple.v().newLocal("$p" + currPC, BooleanType.v());
        body.getLocals().add(checkActFrame);
        AssignStmt assignSt = Jimple.v().newAssignStmt(checkActFrame, Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerCheckActivationFrameStolen().makeRef()));
        body.getUnits().insertAfter(assignSt, (Unit)afterSt);
        Stmt retSt = GenJimple.v().generateReturnStmtForMethod(body.getMethod());
        body.getUnits().insertAfter(retSt, (Unit)assignSt);
        body.getUnits().insertAfter(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(checkActFrame, IntConstant.v(0)), nextSt), (Unit)assignSt);
        return retSt;
    }

    private void replaceLocalsWithFrameFields(Body body, Local frame) {
        int tempCount = 0;
        Iterator<Unit> unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            Stmt st = (Stmt)unitIt.next();
            for (ValueBox useBox : st.getUseBoxes()) {
                Local local;
                if (!(useBox.getValue() instanceof Local) || !this.frameClass.declaresField((local = (Local)useBox.getValue()).getName(), local.getType())) continue;
                SootField sField = this.frameClass.getField(local.getName(), local.getType());
                InstanceFieldRef newValue = Jimple.v().newInstanceFieldRef(frame, sField.makeRef());
                Local newLocal = Jimple.v().newLocal("$t" + tempCount, sField.getType());
                ++tempCount;
                body.getLocals().add(newLocal);
                body.getUnits().insertBefore(Jimple.v().newAssignStmt(newLocal, newValue), (Unit)st);
                useBox.setValue(newLocal);
            }
            for (ValueBox defBox : st.getDefBoxes()) {
                IdentityStmt idSt;
                Local local;
                if (!(defBox.getValue() instanceof Local) || !this.frameClass.declaresField((local = (Local)defBox.getValue()).getName(), local.getType())) continue;
                SootField sField = this.frameClass.getField(local.getName(), local.getType());
                InstanceFieldRef newValue = Jimple.v().newInstanceFieldRef(frame, sField.makeRef());
                Local newLocal = Jimple.v().newLocal("$t" + tempCount, sField.getType());
                ++tempCount;
                body.getLocals().add(newLocal);
                AssignStmt newAssignSt = Jimple.v().newAssignStmt(newValue, newLocal);
                boolean inserted = false;
                if (st instanceof IdentityStmt && ((idSt = (IdentityStmt)st).getRightOp() instanceof ParameterRef || idSt.getRightOp() instanceof ThisRef)) {
                    body.getUnits().insertAfter(newAssignSt, (Unit)this.slowCloneFrameInitSt);
                    inserted = true;
                }
                if (!inserted) {
                    body.getUnits().insertAfter(newAssignSt, (Unit)st);
                }
                defBox.setValue(newLocal);
            }
        }
    }

    private Stmt addStartFinishCallBeforeSt(Stmt st, Body body, Local worker) {
        InvokeStmt virInvSt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerStartFinish().makeRef()));
        body.getUnits().insertBefore(virInvSt, (Unit)st);
        return virInvSt;
    }

    private Stmt addStartFinishCall(Stmt st, Body body, Local worker) {
        InvokeStmt virInvSt = Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerStartFinish().makeRef()));
        body.getUnits().insertAfter(virInvSt, (Unit)st);
        return virInvSt;
    }

    private Stmt handleStartFinishCall(Stmt st, Body body, Local worker) {
        Stmt virInvSt = this.addStartFinishCall(st, body, worker);
        body.getUnits().remove(body.getUnits().getPredOf(st));
        body.getUnits().remove(st);
        return virInvSt;
    }

    private Stmt addStopFinishCall(Stmt st, Body body, Local worker, Local frame, int currPC) {
        Stmt nextSt = (Stmt)body.getUnits().getSuccOf(st);
        AssignStmt pcUpdate = Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(frame, RuntimeReferences.v().framePC().makeRef()), IntConstant.v(currPC));
        body.getUnits().insertAfter(pcUpdate, (Unit)st);
        Local newLocal = Jimple.v().newLocal("$p" + currPC, BooleanType.v());
        body.getLocals().add(newLocal);
        AssignStmt stopFinishSt = Jimple.v().newAssignStmt(newLocal, Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerStopFinishSlow().makeRef()));
        body.getUnits().insertAfter(stopFinishSt, (Unit)pcUpdate);
        Local newExcepLocal = GenJimple.v().addLocal(body, "$p_" + MethodTransformer.getCount(), RuntimeReferences.v().WSSpawnFrameStolenException().getType());
        AssignStmt newExcepSt = Jimple.v().newAssignStmt(newExcepLocal, Jimple.v().newNewExpr(RuntimeReferences.v().WSSpawnFrameStolenException().getType()));
        InvokeStmt newExcepConstructorCall = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(newExcepLocal, RuntimeReferences.v().WSSpawnFrameStolenException().getMethodByName("<init>").makeRef()));
        ThrowStmt throwSt = Jimple.v().newThrowStmt(newExcepLocal);
        body.getUnits().insertAfter(newExcepSt, (Unit)stopFinishSt);
        body.getUnits().insertAfter(newExcepConstructorCall, (Unit)newExcepSt);
        body.getUnits().insertAfter(throwSt, (Unit)newExcepConstructorCall);
        body.getUnits().insertAfter(Jimple.v().newIfStmt((Value)Jimple.v().newEqExpr(newLocal, IntConstant.v(1)), nextSt), (Unit)stopFinishSt);
        ++currPC;
        return throwSt;
    }

    private Stmt handleStopFinishCall(Stmt st, Body body, Local worker, Local frame, int currPC) {
        Stmt lastSt = this.addStopFinishCall(st, body, worker, frame, currPC);
        body.getUnits().remove(body.getUnits().getPredOf(st));
        body.getUnits().remove(st);
        return lastSt;
    }

    private void incrementParameterRefsInIdentityStmts(SootMethod sMethod, int fromParam) {
        Body body = sMethod.getActiveBody();
        System.out.println("Modifying Parameter Refs in function : " + sMethod.getSignature());
        for (Stmt stmt : body.getUnits()) {
            ParameterRef pRef;
            IdentityStmt idSt;
            Value rightOp;
            if (!(stmt instanceof IdentityStmt) || !((rightOp = (idSt = (IdentityStmt)stmt).getRightOp()) instanceof ParameterRef) || (pRef = (ParameterRef)rightOp).getIndex() < fromParam) continue;
            pRef.setIndex(pRef.getIndex() + 1);
        }
    }

    private void handleAsyncCall(Stmt st, Body body, Local worker, boolean fastVersion) {
        assert (st instanceof InvokeStmt);
        Stmt spInvSt = (Stmt)body.getUnits().getPredOf(st);
        Stmt newSt = (Stmt)body.getUnits().getPredOf(spInvSt);
        assert (spInvSt.containsInvokeExpr());
        InvokeExpr invExpr = spInvSt.getInvokeExpr();
        assert (invExpr instanceof SpecialInvokeExpr);
        SpecialInvokeExpr spInvExpr = (SpecialInvokeExpr)invExpr;
        SootClass nClass = spInvExpr.getMethod().getDeclaringClass();
        SootMethod newConstructor = this.transformInnerClass(nClass);
        List spInvArgs = spInvExpr.getArgs();
        if (this.fastClone.isStatic()) {
            spInvArgs.add(0, worker);
        } else {
            spInvArgs.add(1, worker);
        }
        InvokeStmt newSpInvSt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr((Local)spInvExpr.getBase(), newConstructor.makeRef(), spInvArgs));
        body.getUnits().swapWith(spInvSt, newSpInvSt);
        body.getUnits().swapWith(st, Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerPushBfAsync().makeRef(), spInvExpr.getBase())));
    }

    private SootMethod transformInnerClass(SootClass sClass) {
        int workerParamNum;
        sClass.setSuperclass(RuntimeReferences.v().WSBfAsyncFrame());
        if (this.innerClassConstructors.containsKey(sClass)) {
            return this.innerClassConstructors.get(sClass);
        }
        SootMethod oldConstructor = sClass.getMethodByName("<init>");
        JimpleBody oldConstructorBody = (JimpleBody)oldConstructor.getActiveBody();
        ArrayList<RefType> paramTypes = new ArrayList<RefType>(oldConstructor.getParameterTypes());
        if (this.fastClone.isStatic()) {
            paramTypes.add(0, RuntimeReferences.v().WSWorker().getType());
            workerParamNum = 0;
        } else {
            paramTypes.add(1, RuntimeReferences.v().WSWorker().getType());
            workerParamNum = 1;
        }
        SootMethod newConstructor = new SootMethod(oldConstructor.getName(), paramTypes, oldConstructor.getReturnType(), oldConstructor.getModifiers());
        JimpleBody newConstructorBody = (JimpleBody)oldConstructorBody.clone();
        newConstructor.setActiveBody(newConstructorBody);
        sClass.addMethod(newConstructor);
        this.innerClassConstructors.put(sClass, newConstructor);
        this.oldInnerClassConstructors.add(oldConstructor);
        this.incrementParameterRefsInIdentityStmts(newConstructor, workerParamNum);
        Local constructorWorker = GenJimple.v().addLocal(newConstructorBody, "$p_" + MethodTransformer.getCount(), RuntimeReferences.v().WSWorker().getType());
        newConstructorBody.getUnits().insertBefore(Jimple.v().newIdentityStmt(constructorWorker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), workerParamNum)), (Unit)newConstructorBody.getFirstNonIdentityStmt());
        Iterator<Unit> unitsIt = newConstructorBody.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            InvokeExpr invExpr;
            Stmt st = (Stmt)unitsIt.next();
            if (!st.containsInvokeExpr() || !(invExpr = st.getInvokeExpr()).getMethod().getName().equals("<init>")) continue;
            Local finishScope = GenJimple.v().addLocal(newConstructorBody, "$p_" + MethodTransformer.getCount(), RuntimeReferences.v().WSFinishTreeNode().getType());
            AssignStmt setFinishScopeSt = Jimple.v().newAssignStmt(finishScope, Jimple.v().newVirtualInvokeExpr(constructorWorker, RuntimeReferences.v().workerGetCurrentFinishScope().makeRef()));
            InvokeStmt superCallSt = Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(newConstructorBody.getThisLocal(), RuntimeReferences.v().WSBfAsyncFrame().getMethodByName("<init>").makeRef(), finishScope));
            newConstructorBody.getUnits().insertBefore(superCallSt, (Unit)newConstructorBody.getFirstNonIdentityStmt());
            newConstructorBody.getUnits().insertBefore(setFinishScopeSt, (Unit)newConstructorBody.getFirstNonIdentityStmt());
            newConstructorBody.getUnits().remove(st);
            break;
        }
        SootMethod executeMethod = sClass.getMethodByName("runHjTask");
        executeMethod.addException(RuntimeReferences.v().WSSpawnFrameStolenException());
        JimpleBody executeMethodBody = (JimpleBody)executeMethod.getActiveBody();
        List paramList = executeMethod.getParameterTypes();
        paramList.add(0, RuntimeReferences.v().WSWorker().getType());
        executeMethod.setParameterTypes(paramList);
        Local executeMethodWorker = GenJimple.v().addLocal(executeMethodBody, "$p_" + MethodTransformer.getCount(), RuntimeReferences.v().WSWorker().getType());
        executeMethodBody.getUnits().insertBefore(Jimple.v().newIdentityStmt(executeMethodWorker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 0)), (Unit)executeMethodBody.getFirstNonIdentityStmt());
        this.addWorkerParamToFuncCalls(executeMethod, executeMethodWorker, null, true);
        executeMethod.setName("execute");
        return newConstructor;
    }

    private void addCodeForContinuations() {
        if (this.continuations.isEmpty()) {
            return;
        }
        ArrayList<Stmt> targets = new ArrayList<Stmt>();
        Iterator<Stmt> continuationsIt = this.continuations.iterator();
        Body slowCloneBody = this.slowClone.getActiveBody();
        while (continuationsIt.hasNext()) {
            Stmt cont = continuationsIt.next();
            targets.add((Stmt)slowCloneBody.getUnits().getSuccOf(cont));
        }
        Local newLocalPC = Jimple.v().newLocal("$p" + this.continuations.size() + 1, IntType.v());
        slowCloneBody.getLocals().add(newLocalPC);
        AssignStmt assignSt = Jimple.v().newAssignStmt(newLocalPC, Jimple.v().newInstanceFieldRef(this.slowCloneFrame, RuntimeReferences.v().framePC().makeRef()));
        slowCloneBody.getUnits().insertAfter(assignSt, (Unit)this.continuations.get(0));
        TableSwitchStmt switchSt = Jimple.v().newTableSwitchStmt((Value)newLocalPC, 0, targets.size() - 1, targets, slowCloneBody.getUnits().getLast());
        slowCloneBody.getUnits().insertAfter(switchSt, (Unit)assignSt);
    }

    public void identityLocals() {
        HashSet<String> localsSet = new HashSet<String>();
        for (Local local : this.theMethod.getActiveBody().getLocals()) {
            while (localsSet.contains(local.getName())) {
                local.setName(local.getName() + "_");
            }
            localsSet.add(local.getName());
        }
    }

    public void generateFrameClass() {
        assert (this.hasSlowClone);
        this.frameClass = new SootClass(this.declaringClass.getName() + "$" + this.theMethod.getName() + "frame", this.fastClone.getModifiers());
        this.frameClass.setOuterClass(this.declaringClass);
        this.frameClass.setSuperclass(RuntimeReferences.v().WSFrame());
        Scene.v().addClass(this.frameClass);
        this.frameClass.setApplicationClass();
        this.hasFrameClass = true;
        Iterator<Local> localIt = this.fastCloneBody.getLocals().iterator();
        this.frameArgsField = null;
        while (localIt.hasNext()) {
            Local local = localIt.next();
            if (!FinishAsyncTransformer.v().isLocalNeededInFrame(local) || !this.fastClone.isStatic() && this.fastCloneBody.getThisLocal() == local) continue;
            SootField sField = new SootField(local.getName(), local.getType());
            this.frameClass.addField(sField);
            this.locals2Fields.put(local, sField);
            this.fields2Locals.put(sField, local);
            if (!local.getType().equals(ArrayType.v(RefType.v("java.lang.String"), 1))) continue;
            this.frameArgsField = sField;
        }
        this.generateFrameClassConstructorSC();
        this.generateFrameClassExecuteSlow();
    }

    private void generateFrameClassConstructor() {
        if (!this.fastClone.isStatic()) {
            this.frameThisOuter = new SootField("this$0", this.declaringClass.getType());
            this.frameClass.addField(this.frameThisOuter);
            this.frameConstructor = new SootMethod("<init>", Arrays.asList(this.declaringClass.getType(), IntType.v(), RuntimeReferences.v().WSWorker().getType()), VoidType.v());
            this.frameClass.addMethod(this.frameConstructor);
            JimpleBody constructorBody = Jimple.v().newBody(this.frameConstructor);
            this.frameConstructor.setActiveBody(constructorBody);
            Local constructorThis = Jimple.v().newLocal("this", this.frameClass.getType());
            constructorBody.getLocals().add(constructorThis);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(constructorThis, Jimple.v().newThisRef(this.frameClass.getType())));
            Local outerObject = Jimple.v().newLocal("outerObject", this.declaringClass.getType());
            constructorBody.getLocals().add(outerObject);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(outerObject, Jimple.v().newParameterRef(this.declaringClass.getType(), 0)));
            Local pc = Jimple.v().newLocal("pc", IntType.v());
            constructorBody.getLocals().add(pc);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(pc, Jimple.v().newParameterRef(IntType.v(), 1)));
            Local worker = Jimple.v().newLocal("worker", RuntimeReferences.v().WSWorker().getType());
            constructorBody.getLocals().add(worker);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(worker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 2)));
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(constructorThis, this.frameThisOuter.makeRef()), outerObject));
            Local closure = Jimple.v().newLocal("$r0", RuntimeReferences.v().WSClosure().getType());
            constructorBody.getLocals().add(closure);
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(closure, Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerGetClosure().makeRef())));
            Local ftn = Jimple.v().newLocal("$r1", RuntimeReferences.v().WSFinishTreeNode().getType());
            constructorBody.getLocals().add(ftn);
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(ftn, Jimple.v().newVirtualInvokeExpr(closure, RuntimeReferences.v().closureGetCurrentFinishScope().makeRef())));
            constructorBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(constructorThis, this.frameClass.getSuperclass().getMethodByName("<init>").makeRef(), pc, ftn)));
            constructorBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        } else if (this.theMethod.getName().equals("main")) {
            this.frameConstructor = new SootMethod("<init>", Arrays.asList(IntType.v(), ArrayType.v(RefType.v("java.lang.String"), 1)), VoidType.v());
            this.frameClass.addMethod(this.frameConstructor);
            JimpleBody constructorBody = Jimple.v().newBody(this.frameConstructor);
            this.frameConstructor.setActiveBody(constructorBody);
            Local constructorThis = GenJimple.v().addLocalAndThisRefStmt(constructorBody, "this", this.frameClass.getType());
            Local pc = GenJimple.v().addLocalAndParameterRefStmt(constructorBody, "pc", this.frameConstructor.getParameterType(0), 0);
            Local args = GenJimple.v().addLocalAndParameterRefStmt(constructorBody, "args", this.frameConstructor.getParameterType(1), 1);
            constructorBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(constructorThis, this.frameClass.getSuperclass().getMethodByName("<init>").makeRef(), pc, NullConstant.v())));
            if (this.frameArgsField == null) {
                throw new RuntimeException("No args field in main function");
            }
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(constructorThis, this.frameArgsField.makeRef()), args));
            constructorBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        } else {
            this.frameConstructor = new SootMethod("<init>", Arrays.asList(IntType.v(), RuntimeReferences.v().WSWorker().getType()), VoidType.v());
            this.frameClass.addMethod(this.frameConstructor);
            JimpleBody constructorBody = Jimple.v().newBody(this.frameConstructor);
            this.frameConstructor.setActiveBody(constructorBody);
            Local constructorThis = Jimple.v().newLocal("this", this.frameClass.getType());
            constructorBody.getLocals().add(constructorThis);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(constructorThis, Jimple.v().newThisRef(this.frameClass.getType())));
            Local pc = Jimple.v().newLocal("pc", IntType.v());
            constructorBody.getLocals().add(pc);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(pc, Jimple.v().newParameterRef(IntType.v(), 0)));
            Local worker = Jimple.v().newLocal("worker", RuntimeReferences.v().WSWorker().getType());
            constructorBody.getLocals().add(worker);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(worker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 1)));
            Local closure = Jimple.v().newLocal("$r0", RuntimeReferences.v().WSClosure().getType());
            constructorBody.getLocals().add(closure);
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(closure, Jimple.v().newVirtualInvokeExpr(worker, RuntimeReferences.v().workerGetClosure().makeRef())));
            Local ftn = Jimple.v().newLocal("$r1", RuntimeReferences.v().WSFinishTreeNode().getType());
            constructorBody.getLocals().add(ftn);
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(ftn, Jimple.v().newVirtualInvokeExpr(closure, RuntimeReferences.v().closureGetCurrentFinishScope().makeRef())));
            constructorBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(constructorThis, this.frameClass.getSuperclass().getMethodByName("<init>").makeRef(), pc, ftn)));
            constructorBody.getUnits().add(Jimple.v().newReturnVoidStmt());
        }
    }

    private void generateFrameClassConstructorSC() {
        List params = this.theMethod.getParameterTypes();
        if (!this.theMethod.isStatic()) {
            params.add(0, this.declaringClass.getType());
        }
        this.frameConstructor = new SootMethod("<init>", params, VoidType.v(), 1);
        this.frameClass.addMethod(this.frameConstructor);
        JimpleBody constructorBody = Jimple.v().newBody(this.frameConstructor);
        this.frameConstructor.setActiveBody(constructorBody);
        Local constructorThis = Jimple.v().newLocal("this", this.frameClass.getType());
        constructorBody.getLocals().add(constructorThis);
        constructorBody.getUnits().add(Jimple.v().newIdentityStmt(constructorThis, Jimple.v().newThisRef(this.frameClass.getType())));
        HashMap<SootField, Local> paramField2Local = new HashMap<SootField, Local>();
        int paramCount = 0;
        if (!this.theMethod.isStatic()) {
            this.frameThisOuter = new SootField("this$0", this.declaringClass.getType());
            this.frameClass.addField(this.frameThisOuter);
            Local localThisOuter = Jimple.v().newLocal("thisOuter_" + MethodTransformer.getCount(), this.declaringClass.getType());
            constructorBody.getLocals().add(localThisOuter);
            paramField2Local.put(this.frameThisOuter, localThisOuter);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(localThisOuter, Jimple.v().newParameterRef(this.declaringClass.getType(), paramCount)));
            ++paramCount;
        }
        for (int i = 1; i < this.fastClone.getParameterCount(); ++i) {
            Local param = this.fastClone.getActiveBody().getParameterLocal(i);
            SootField fieldForParam = this.locals2Fields.get(param);
            assert (fieldForParam != null);
            Local localForParam = Jimple.v().newLocal("$p_" + MethodTransformer.getCount(), param.getType());
            constructorBody.getLocals().add(localForParam);
            paramField2Local.put(fieldForParam, localForParam);
            constructorBody.getUnits().add(Jimple.v().newIdentityStmt(localForParam, Jimple.v().newParameterRef(localForParam.getType(), paramCount)));
            ++paramCount;
        }
        constructorBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newSpecialInvokeExpr(constructorThis, this.frameClass.getSuperclass().getMethodByName("<init>").makeRef())));
        for (SootField sField : this.frameClass.getFields()) {
            if (!paramField2Local.containsKey(sField)) continue;
            Local paramLocal = (Local)paramField2Local.get(sField);
            constructorBody.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(constructorThis, sField.makeRef()), paramLocal));
        }
        constructorBody.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    private void generateFrameClassExecuteSlow() {
        this.frameExecuteSlow = new SootMethod("execute", Arrays.asList(RuntimeReferences.v().WSWorker().getType()), VoidType.v(), 1);
        this.frameClass.addMethod(this.frameExecuteSlow);
        JimpleBody execBody = Jimple.v().newBody(this.frameExecuteSlow);
        this.frameExecuteSlow.setActiveBody(execBody);
        this.frameExecuteSlow.addException(RuntimeReferences.v().WSSpawnFrameStolenException());
        Local execThis = Jimple.v().newLocal("this", this.frameClass.getType());
        execBody.getLocals().add(execThis);
        execBody.getUnits().add(Jimple.v().newIdentityStmt(execThis, Jimple.v().newThisRef(this.frameClass.getType())));
        Local worker = Jimple.v().newLocal("worker", RuntimeReferences.v().WSWorker().getType());
        execBody.getLocals().add(worker);
        execBody.getUnits().add(Jimple.v().newIdentityStmt(worker, Jimple.v().newParameterRef(RuntimeReferences.v().WSWorker().getType(), 0)));
        if (this.fastClone.isStatic()) {
            execBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newStaticInvokeExpr(this.slowClone.makeRef(), worker, execBody.getThisLocal())));
        } else {
            Local outerObject = Jimple.v().newLocal("outerObject", this.declaringClass.getType());
            execBody.getLocals().add(outerObject);
            execBody.getUnits().add(Jimple.v().newAssignStmt(outerObject, Jimple.v().newInstanceFieldRef(execThis, this.frameThisOuter.makeRef())));
            execBody.getUnits().add(Jimple.v().newInvokeStmt(Jimple.v().newVirtualInvokeExpr(outerObject, this.slowClone.makeRef(), worker, execThis)));
        }
        execBody.getUnits().add(Jimple.v().newReturnVoidStmt());
    }

    public void generateFrameClassMethods() {
        this.generateSetReturnResult();
    }

    private void generateSetReturnResult() {
        this.frameSetReturnResult = new SootMethod("setReturnResult", Arrays.asList(RuntimeReferences.v().JavaLangObject().getType()), VoidType.v(), 1);
        this.frameClass.addMethod(this.frameSetReturnResult);
        JimpleBody frameSetReturnResultBody = Jimple.v().newBody(this.frameSetReturnResult);
        this.frameSetReturnResult.setActiveBody(frameSetReturnResultBody);
        Local frameSetReturnResultThis = Jimple.v().newLocal("this", this.frameClass.getType());
        frameSetReturnResultBody.getLocals().add(frameSetReturnResultThis);
        frameSetReturnResultBody.getUnits().add(Jimple.v().newIdentityStmt(frameSetReturnResultThis, Jimple.v().newThisRef(this.frameClass.getType())));
        Local frameSetReturnResultObject = Jimple.v().newLocal("$p_" + MethodTransformer.getCount(), RuntimeReferences.v().JavaLangObject().getType());
        frameSetReturnResultBody.getLocals().add(frameSetReturnResultObject);
        frameSetReturnResultBody.getUnits().add(Jimple.v().newIdentityStmt(frameSetReturnResultObject, Jimple.v().newParameterRef(RuntimeReferences.v().JavaLangObject().getType(), 0)));
        Stmt lastIdentitySt = (Stmt)frameSetReturnResultBody.getUnits().getLast();
        ArrayList<Stmt> targets = new ArrayList<Stmt>();
        for (int i = 0; i < this.continuations.size(); ++i) {
            if (this.seqCallReturnLocals.containsKey(i)) {
                AssignStmt assignSt;
                AssignStmt firstSt;
                Local def = this.seqCallReturnLocals.get(i);
                assert (this.locals2Fields.containsKey(def));
                SootField defFieldInFrame = this.locals2Fields.get(def);
                if (defFieldInFrame == null) continue;
                Local defTempLocal = Jimple.v().newLocal("$r_" + MethodTransformer.getCount(), def.getType());
                frameSetReturnResultBody.getLocals().add(defTempLocal);
                if (def.getType() instanceof IntegerType) {
                    Local defIntegerLocal = Jimple.v().newLocal("$r_" + MethodTransformer.getCount(), RuntimeReferences.v().JavaLangInteger().getType());
                    frameSetReturnResultBody.getLocals().add(defIntegerLocal);
                    firstSt = Jimple.v().newAssignStmt(defIntegerLocal, Jimple.v().newCastExpr(frameSetReturnResultObject, RuntimeReferences.v().JavaLangInteger().getType()));
                    frameSetReturnResultBody.getUnits().add(firstSt);
                    assignSt = Jimple.v().newAssignStmt(defTempLocal, Jimple.v().newVirtualInvokeExpr(defIntegerLocal, RuntimeReferences.v().integerIntValue().makeRef()));
                } else {
                    firstSt = assignSt = Jimple.v().newAssignStmt(defTempLocal, Jimple.v().newCastExpr(frameSetReturnResultObject, def.getType()));
                }
                frameSetReturnResultBody.getUnits().add(assignSt);
                frameSetReturnResultBody.getUnits().add(Jimple.v().newAssignStmt(Jimple.v().newInstanceFieldRef(frameSetReturnResultThis, defFieldInFrame.makeRef()), defTempLocal));
                frameSetReturnResultBody.getUnits().add(Jimple.v().newReturnVoidStmt());
                targets.add(firstSt);
                continue;
            }
            ReturnVoidStmt retSt = Jimple.v().newReturnVoidStmt();
            frameSetReturnResultBody.getUnits().add(retSt);
            targets.add(retSt);
        }
        ReturnVoidStmt defaultSt = Jimple.v().newReturnVoidStmt();
        frameSetReturnResultBody.getUnits().add(defaultSt);
        Local newLocalPC = Jimple.v().newLocal("$p_" + MethodTransformer.getCount(), IntType.v());
        frameSetReturnResultBody.getLocals().add(newLocalPC);
        AssignStmt pcAssignSt = Jimple.v().newAssignStmt(newLocalPC, Jimple.v().newInstanceFieldRef(frameSetReturnResultThis, RuntimeReferences.v().framePC().makeRef()));
        frameSetReturnResultBody.getUnits().insertAfter(pcAssignSt, (Unit)lastIdentitySt);
        TableSwitchStmt switchSt = Jimple.v().newTableSwitchStmt((Value)newLocalPC, 0, targets.size() - 1, targets, defaultSt);
        frameSetReturnResultBody.getUnits().insertAfter(switchSt, (Unit)pcAssignSt);
    }

    public void removeUnwantedHjMethodCalls() {
        this.removeUnwantedHjMethodCalls(this.fastCloneBody);
        this.removeUnwantedHjMethodCalls(this.slowCloneBody);
        for (SootMethod sMethod : this.oldInnerClassConstructors) {
            sMethod.getDeclaringClass().removeMethod(sMethod);
        }
    }

    private void removeUnwantedHjMethodCalls(Body body) {
        Iterator<Unit> unitsIt = body.getUnits().snapshotIterator();
        while (unitsIt.hasNext()) {
            Stmt st = (Stmt)unitsIt.next();
            if (!st.containsInvokeExpr()) continue;
            InvokeExpr invExpr = st.getInvokeExpr();
            if (invExpr.getMethod() == RuntimeReferences.v().runtimeAsPlace()) {
                body.getUnits().remove(st);
                continue;
            }
            if (invExpr.getMethod() != RuntimeReferences.v().runtimeHere()) continue;
            body.getUnits().remove(st);
        }
    }

    public boolean validateAllMethods() {
        ((JimpleBody)this.fastCloneBody).validate();
        ((JimpleBody)this.slowCloneBody).validate();
        ((JimpleBody)this.frameConstructor.getActiveBody()).validate();
        ((JimpleBody)this.frameExecuteSlow.getActiveBody()).validate();
        return true;
    }
}

