/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.AsciiCP;
import jas.CP;
import jas.CodeAttr;
import jas.DeprecatedAttr;
import jas.DoubleCP;
import jas.EnclMethAttr;
import jas.ExceptAttr;
import jas.GenericAttr;
import jas.InnerClassAttr;
import jas.LongCP;
import jas.Method;
import jas.RuntimeConstants;
import jas.SignatureAttr;
import jas.SourceAttr;
import jas.SyntheticAttr;
import jas.Var;
import jas.VisibilityAnnotationAttr;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ClassEnv
implements RuntimeConstants {
    int magic = -889275714;
    short version_lo = 0;
    short version_hi = (short)46;
    CP this_class;
    CP super_class;
    short class_access;
    Hashtable cpe = new Hashtable();
    Hashtable cpe_index = null;
    Vector interfaces = new Vector();
    Vector vars = new Vector();
    Vector methods = new Vector();
    SourceAttr source;
    Vector generic = new Vector();
    boolean hasSuperClass;
    InnerClassAttr inner_class_attr;
    boolean classSynth;
    SyntheticAttr synthAttr;
    DeprecatedAttr deprAttr = null;
    SignatureAttr sigAttr = null;
    VisibilityAnnotationAttr visAnnotAttr = null;
    VisibilityAnnotationAttr invisAnnotAttr = null;
    EnclMethAttr encl_meth_attr;
    boolean highVersion = false;

    public void setHighVersion(boolean b) {
        this.highVersion = b;
        this.version_lo = 0;
        this.version_hi = (short)49;
    }

    public void setClass(CP name) {
        this.this_class = name;
        this.addCPItem(name);
    }

    public void setNoSuperClass() {
        this.hasSuperClass = false;
    }

    public void setSuperClass(CP name) {
        this.hasSuperClass = true;
        this.super_class = name;
        this.addCPItem(name);
    }

    public void setClassAccess(short access) {
        this.class_access = access;
    }

    public void addInterface(CP ifc) {
        this.addCPItem(ifc);
        this.interfaces.addElement(ifc);
    }

    public void addInterface(CP[] ilist) {
        for (int i = 0; i < ilist.length; ++i) {
            this.interfaces.addElement(ilist[i]);
            this.addCPItem(ilist[i]);
        }
    }

    public void addField(Var v) {
        this.vars.addElement(v);
        v.resolve(this);
    }

    public void write(DataOutputStream out) throws IOException, jasError {
        out.writeInt(this.magic);
        out.writeShort(this.version_lo);
        out.writeShort(this.version_hi);
        int curidx = 1;
        this.cpe_index = new Hashtable();
        Enumeration<Object> e = this.cpe.elements();
        while (e.hasMoreElements()) {
            CP tmp = (CP)e.nextElement();
            this.cpe_index.put(tmp.getUniq(), new Integer(curidx));
            ++curidx;
            if (!(tmp instanceof LongCP) && !(tmp instanceof DoubleCP)) continue;
            ++curidx;
        }
        out.writeShort((short)curidx);
        e = this.cpe.elements();
        while (e.hasMoreElements()) {
            CP now = (CP)e.nextElement();
            now.write(this, out);
        }
        out.writeShort(this.class_access);
        out.writeShort(this.getCPIndex(this.this_class));
        if (this.hasSuperClass) {
            out.writeShort(this.getCPIndex(this.super_class));
        } else {
            out.writeShort(0);
        }
        out.writeShort(this.interfaces.size());
        e = this.interfaces.elements();
        while (e.hasMoreElements()) {
            CP c = (CP)e.nextElement();
            out.writeShort(this.getCPIndex(c));
        }
        out.writeShort(this.vars.size());
        e = this.vars.elements();
        while (e.hasMoreElements()) {
            Var v = (Var)e.nextElement();
            v.write(this, out);
        }
        out.writeShort(this.methods.size());
        e = this.methods.elements();
        while (e.hasMoreElements()) {
            Method m = (Method)e.nextElement();
            m.write(this, out);
        }
        int numExtra = 0;
        if (this.source != null) {
            numExtra = 1;
        }
        numExtra = (short)(numExtra + this.generic.size());
        if (this.inner_class_attr != null) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.isClassSynth()) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.deprAttr != null) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.sigAttr != null) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.visAnnotAttr != null) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.invisAnnotAttr != null) {
            numExtra = (short)(numExtra + 1);
        }
        if (this.encl_meth_attr != null) {
            numExtra = (short)(numExtra + 1);
        }
        out.writeShort(numExtra);
        if (this.source != null) {
            this.source.write(this, out);
        }
        Enumeration gen = this.generic.elements();
        while (gen.hasMoreElements()) {
            GenericAttr gattr = (GenericAttr)gen.nextElement();
            gattr.write(this, out);
        }
        if (this.isClassSynth()) {
            this.synthAttr.write(this, out);
        }
        if (this.deprAttr != null) {
            this.deprAttr.write(this, out);
        }
        if (this.sigAttr != null) {
            this.sigAttr.write(this, out);
        }
        if (this.encl_meth_attr != null) {
            this.encl_meth_attr.write(this, out);
        }
        if (this.visAnnotAttr != null) {
            this.visAnnotAttr.write(this, out);
        }
        if (this.invisAnnotAttr != null) {
            this.invisAnnotAttr.write(this, out);
        }
        if (this.inner_class_attr != null) {
            this.inner_class_attr.write(this, out);
        }
        out.flush();
    }

    public void addCPItem(CP cp) {
        String uniq = cp.getUniq();
        CP intern = (CP)this.cpe.get(uniq);
        if (intern == null) {
            this.cpe.put(uniq, cp);
            cp.resolve(this);
        }
    }

    public void addMethod(short acc, String name, String sig, CodeAttr code, ExceptAttr ex) {
        Method x = new Method(acc, new AsciiCP(name), new AsciiCP(sig), code, ex);
        x.resolve(this);
        this.methods.addElement(x);
    }

    public void setClassSynth(boolean b) {
        this.classSynth = b;
        this.synthAttr = new SyntheticAttr();
        this.synthAttr.resolve(this);
    }

    public boolean isClassSynth() {
        return this.classSynth;
    }

    public void setClassDepr(DeprecatedAttr d) {
        this.deprAttr = d;
        this.deprAttr.resolve(this);
    }

    public void setClassSigAttr(SignatureAttr s) {
        this.sigAttr = s;
        this.sigAttr.resolve(this);
    }

    public void setClassAnnotAttrVis(VisibilityAnnotationAttr s) {
        this.visAnnotAttr = s;
        this.visAnnotAttr.resolve(this);
    }

    public void setClassAnnotAttrInvis(VisibilityAnnotationAttr s) {
        this.invisAnnotAttr = s;
        this.invisAnnotAttr.resolve(this);
    }

    public void finishInnerClassAttr(InnerClassAttr attr) {
        this.inner_class_attr = attr;
        this.inner_class_attr.resolve(this);
    }

    public void addEnclMethAttr(EnclMethAttr attr) {
        this.encl_meth_attr = attr;
        this.encl_meth_attr.resolve(this);
    }

    public void setSource(SourceAttr source) {
        this.source = source;
        source.resolve(this);
    }

    public void setSource(String source) {
        this.source = new SourceAttr(source);
        this.source.resolve(this);
    }

    public void addGenericAttr(GenericAttr g) {
        this.generic.addElement(g);
        g.resolve(this);
    }

    public void addMethod(Method m) {
        m.resolve(this);
        this.methods.addElement(m);
    }

    int getCPIndex(CP cp) throws jasError {
        if (this.cpe_index == null) {
            throw new jasError("Internal error: CPE index has not been generated");
        }
        Integer idx = (Integer)this.cpe_index.get(cp.getUniq());
        if (idx == null) {
            throw new jasError("Item " + cp + " not in the class");
        }
        return idx;
    }
}

