/*
 * Decompiled with CFR 0.152.
 */
package jasmin;

import jas.jasError;
import jasmin.ClassFile;
import jasmin.ScannerUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Main {
    public static final String version = "2.3.0";

    public static void assemble(InputStream in, OutputStream out, boolean number_lines) {
        ClassFile classFile = new ClassFile();
        try {
            BufferedInputStream inp = new BufferedInputStream(in);
            classFile.readJasmin(inp, "Jasmin", number_lines);
            ((InputStream)inp).close();
            if (classFile.errorCount() > 0) {
                System.err.println("Jasmin: Found " + classFile.errorCount() + " errors");
                return;
            }
            classFile.write(out);
            out.flush();
        }
        catch (FileNotFoundException e) {
            System.err.println("Jasmin: file not found");
            System.exit(-1);
        }
        catch (jasError e) {
            classFile.report_error("JAS Error " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            classFile.report_error("Jasmin: exception - <" + e.getClass().getName() + "> " + e.getMessage() + ".");
            e.printStackTrace();
        }
        if (classFile.errorCount() > 0) {
            System.err.println("Jasmin: Found " + classFile.errorCount() + " errors");
        }
    }

    public static void assemble(String dest_dir, String fname, boolean number_lines) {
        File file = new File(fname);
        File out_file = null;
        ClassFile classFile = new ClassFile();
        try {
            BufferedInputStream inp = new BufferedInputStream(new FileInputStream(fname));
            classFile.readJasmin(inp, file.getName(), number_lines);
            ((InputStream)inp).close();
            if (classFile.errorCount() > 0) {
                System.err.println(fname + ": Found " + classFile.errorCount() + " errors");
                return;
            }
            String[] class_path = ScannerUtils.splitClassField(classFile.getClassName());
            String class_name = class_path[1];
            if (class_path[0] != null) {
                String class_dir = ScannerUtils.convertChars(class_path[0], "./", File.separatorChar);
                dest_dir = dest_dir != null ? dest_dir + File.separator + class_dir : class_dir;
            }
            if (dest_dir == null) {
                out_file = new File(class_name + ".class");
            } else {
                out_file = new File(dest_dir, class_name + ".class");
                File dest = new File(dest_dir);
                if (!dest.exists()) {
                    dest.mkdirs();
                }
                if (!dest.isDirectory()) {
                    throw new IOException("Cannot create directory");
                }
            }
            FileOutputStream outp = new FileOutputStream(out_file);
            classFile.write(outp);
            outp.close();
        }
        catch (FileNotFoundException e) {
            System.err.println(fname + ": file not found");
            System.exit(-1);
        }
        catch (jasError e) {
            classFile.report_error("JAS Error " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            classFile.report_error(fname + ": exception - <" + e.getClass().getName() + "> " + e.getMessage() + ".");
            e.printStackTrace();
        }
        if (classFile.errorCount() > 0) {
            System.err.println(fname + ": Found " + classFile.errorCount() + " errors");
        }
    }

    public static void main(String[] args) {
        int i;
        String dest_dir = null;
        boolean debug = false;
        String[] files = new String[args.length];
        int num_files = 0;
        if (args.length == 0) {
            System.err.println("usage: jasmin [-d <directory>] [-version] <file> [<file> ...]");
            System.exit(-1);
        }
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-d")) {
                dest_dir = args[i + 1];
                ++i;
                continue;
            }
            if (args[i].equals("-g")) {
                debug = true;
                continue;
            }
            if (args[i].equals("-version")) {
                System.out.println("Jasmin version: 2.3.0");
                System.exit(0);
                continue;
            }
            files[num_files++] = args[i];
        }
        for (i = 0; i < num_files; ++i) {
            Main.assemble(dest_dir, files[i], debug);
        }
    }
}

