/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.MismatchedInputCharsException;
import lpg.runtime.UnknownStreamType;

public abstract class AbstractToken
implements IToken {
    private int kind = 0;
    private int startOffset = 0;
    private int endOffset = 0;
    private int tokenIndex = 0;
    private int adjunctIndex;
    private IPrsStream iPrsStream;

    public AbstractToken() {
    }

    public AbstractToken(IPrsStream iPrsStream, int n, int n2, int n3) {
        this.iPrsStream = iPrsStream;
        this.startOffset = n;
        this.endOffset = n2;
        this.kind = n3;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int n) {
        this.kind = n;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public void setStartOffset(int n) {
        this.startOffset = n;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int n) {
        this.endOffset = n;
    }

    public int getTokenIndex() {
        return this.tokenIndex;
    }

    public void setTokenIndex(int n) {
        this.tokenIndex = n;
    }

    public void setAdjunctIndex(int n) {
        this.adjunctIndex = n;
    }

    public int getAdjunctIndex() {
        return this.adjunctIndex;
    }

    public IPrsStream getIPrsStream() {
        return this.iPrsStream;
    }

    public ILexStream getILexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    public int getLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.startOffset);
    }

    public int getColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.startOffset);
    }

    public int getEndLine() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getLineNumberOfCharAt(this.endOffset);
    }

    public int getEndColumn() {
        return this.iPrsStream == null ? 0 : this.iPrsStream.getILexStream().getColumnOfCharAt(this.endOffset);
    }

    public IPrsStream getPrsStream() {
        return this.iPrsStream;
    }

    public ILexStream getLexStream() {
        return this.iPrsStream == null ? null : this.iPrsStream.getILexStream();
    }

    public String getValue(char[] cArray) {
        if (this.iPrsStream != null) {
            return this.toString();
        }
        if (this.iPrsStream.getLexStream() instanceof LexStream) {
            LexStream lexStream = (LexStream)this.iPrsStream.getLexStream();
            if (cArray != lexStream.getInputChars()) {
                throw new MismatchedInputCharsException();
            }
            return this.toString();
        }
        throw new UnknownStreamType("Unknown stream type " + this.iPrsStream.getLexStream().getClass().toString());
    }

    public String toString() {
        return this.iPrsStream == null ? "<toString>" : this.iPrsStream.toString(this, this);
    }
}

