/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ConfigurationElement;
import lpg.runtime.ObjectTuple;
import lpg.runtime.ParseTable;
import lpg.runtime.StateElement;

public class ConfigurationStack {
    private static final int TABLE_SIZE = 1021;
    private ConfigurationElement[] table = new ConfigurationElement[1021];
    private ObjectTuple configuration_stack = new ObjectTuple(4096);
    private StateElement state_root;
    private int max_configuration_size;
    private int stacks_size;
    private int state_element_size;
    ParseTable prs;

    public ConfigurationStack(ParseTable parseTable) {
        this.prs = parseTable;
        ++this.state_element_size;
        this.state_root = new StateElement();
        this.state_root.parent = null;
        this.state_root.siblings = null;
        this.state_root.children = null;
        this.state_root.number = parseTable.getStartState();
    }

    StateElement makeStateList(StateElement stateElement, int[] nArray, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            ++this.state_element_size;
            StateElement stateElement2 = new StateElement();
            stateElement2.number = nArray[i];
            stateElement2.parent = stateElement;
            stateElement2.children = null;
            stateElement2.siblings = null;
            stateElement.children = stateElement2;
            stateElement = stateElement2;
        }
        return stateElement;
    }

    StateElement findOrInsertStack(StateElement stateElement, int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        StateElement stateElement2 = stateElement;
        while (stateElement2 != null) {
            if (stateElement2.number == n3) {
                return n == n2 ? stateElement2 : (stateElement2.children == null ? this.makeStateList(stateElement2, nArray, n + 1, n2) : this.findOrInsertStack(stateElement2.children, nArray, n + 1, n2));
            }
            stateElement2 = stateElement2.siblings;
        }
        ++this.state_element_size;
        stateElement2 = new StateElement();
        stateElement2.number = n3;
        stateElement2.parent = stateElement.parent;
        stateElement2.children = null;
        stateElement2.siblings = stateElement.siblings;
        stateElement.siblings = stateElement2;
        return n == n2 ? stateElement2 : this.makeStateList(stateElement2, nArray, n + 1, n2);
    }

    public boolean findConfiguration(int[] nArray, int n, int n2) {
        StateElement stateElement = this.findOrInsertStack(this.state_root, nArray, 0, n);
        int n3 = n2 % 1021;
        ConfigurationElement configurationElement = this.table[n3];
        while (configurationElement != null) {
            if (configurationElement.curtok == n2 && stateElement == configurationElement.last_element) {
                return true;
            }
            configurationElement = configurationElement.next;
        }
        return false;
    }

    public void push(int[] nArray, int n, int n2, int n3, int n4) {
        ConfigurationElement configurationElement = new ConfigurationElement();
        int n5 = n3 % 1021;
        configurationElement.next = this.table[n5];
        this.table[n5] = configurationElement;
        ++this.max_configuration_size;
        configurationElement.stack_top = n;
        this.stacks_size += n + 1;
        configurationElement.last_element = this.findOrInsertStack(this.state_root, nArray, 0, n);
        configurationElement.conflict_index = n2;
        configurationElement.curtok = n3;
        configurationElement.action_length = n4;
        this.configuration_stack.add(configurationElement);
    }

    public ConfigurationElement pop() {
        ConfigurationElement configurationElement = null;
        if (this.configuration_stack.size() > 0) {
            int n = this.configuration_stack.size() - 1;
            configurationElement = (ConfigurationElement)this.configuration_stack.get(n);
            configurationElement.act = this.prs.baseAction(configurationElement.conflict_index++);
            if (this.prs.baseAction(configurationElement.conflict_index) == 0) {
                this.configuration_stack.reset(n);
            }
        }
        return configurationElement;
    }

    public ConfigurationElement top() {
        ConfigurationElement configurationElement = null;
        if (this.configuration_stack.size() > 0) {
            int n = this.configuration_stack.size() - 1;
            configurationElement = (ConfigurationElement)this.configuration_stack.get(n);
            configurationElement.act = this.prs.baseAction(configurationElement.conflict_index);
        }
        return configurationElement;
    }

    public int size() {
        return this.configuration_stack.size();
    }

    public int maxConfigurationSize() {
        return this.max_configuration_size;
    }

    int numStateElements() {
        return this.state_element_size;
    }

    int stacksSize() {
        return this.stacks_size;
    }
}

