/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BadParseException;
import lpg.runtime.BadParseSymFileException;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.NotDeterministicParseTableException;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import lpg.runtime.Stacks;
import lpg.runtime.TokenStream;
import lpg.runtime.UnavailableParserInformationException;

public class DeterministicParser
extends Stacks {
    private boolean taking_actions = false;
    private int markerKind = 0;
    private Monitor monitor;
    private int START_STATE;
    private int NUM_RULES;
    private int NT_OFFSET;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int ERROR_SYMBOL;
    private int lastToken;
    private int currentAction;
    private IntTuple action = null;
    private TokenStream tokStream;
    private ParseTable prs;
    private RuleAction ra;

    private int lookahead(int n, int n2) {
        return (n = this.prs.lookAhead(n - this.LA_STATE_OFFSET, this.tokStream.getKind(n2))) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.getNext(n2)) : n;
    }

    private int tAction(int n, int n2) {
        return (n = this.prs.tAction(n, n2)) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.peek()) : n;
    }

    private int tAction(int n, int[] nArray, int n2) {
        n = this.prs.tAction(n, nArray[n2]);
        while (n > this.LA_STATE_OFFSET) {
            n2 = (n2 + 1) % nArray.length;
            n = this.prs.lookAhead(n - this.LA_STATE_OFFSET, nArray[n2]);
        }
        return n;
    }

    private final void processReductions() {
        do {
            this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
            this.ra.ruleAction(this.currentAction);
            this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
        } while (this.currentAction <= this.NUM_RULES);
    }

    public final int getCurrentRule() {
        if (this.taking_actions) {
            return this.currentAction;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getFirstToken() {
        if (this.taking_actions) {
            return this.getToken(1);
        }
        throw new UnavailableParserInformationException();
    }

    public final int getFirstToken(int n) {
        if (this.taking_actions) {
            return this.getToken(n);
        }
        throw new UnavailableParserInformationException();
    }

    public final int getLastToken() {
        if (this.taking_actions) {
            return this.lastToken;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getLastToken(int n) {
        if (this.taking_actions) {
            return n >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(n + 1));
        }
        throw new UnavailableParserInformationException();
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void reset() {
        this.taking_actions = false;
        this.markerKind = 0;
        if (this.action != null) {
            this.action.reset();
        }
    }

    public void reset(Monitor monitor, TokenStream tokenStream) {
        this.monitor = monitor;
        this.tokStream = tokenStream;
        this.reset();
    }

    public void reset(TokenStream tokenStream) {
        this.reset(null, tokenStream);
    }

    public void reset(Monitor monitor, TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(monitor, tokenStream);
        this.prs = parseTable;
        this.ra = ruleAction;
        this.START_STATE = parseTable.getStartState();
        this.NUM_RULES = parseTable.getNumRules();
        this.NT_OFFSET = parseTable.getNtOffset();
        this.LA_STATE_OFFSET = parseTable.getLaStateOffset();
        this.EOFT_SYMBOL = parseTable.getEoftSymbol();
        this.ERROR_SYMBOL = parseTable.getErrorSymbol();
        this.ACCEPT_ACTION = parseTable.getAcceptAction();
        this.ERROR_ACTION = parseTable.getErrorAction();
        if (!parseTable.isValidForParser()) {
            throw new BadParseSymFileException();
        }
        if (parseTable.getBacktrack()) {
            throw new NotDeterministicParseTableException();
        }
    }

    public void reset(TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(null, tokenStream, parseTable, ruleAction);
    }

    public DeterministicParser() {
    }

    public DeterministicParser(TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(null, tokenStream, parseTable, ruleAction);
    }

    public DeterministicParser(Monitor monitor, TokenStream tokenStream, ParseTable parseTable, RuleAction ruleAction) throws BadParseSymFileException, NotDeterministicParseTableException {
        this.reset(monitor, tokenStream, parseTable, ruleAction);
    }

    public Object parse() throws BadParseException {
        return this.parseEntry(0);
    }

    public Object parseEntry(int n) throws BadParseException {
        int n2;
        int n3;
        this.taking_actions = true;
        this.tokStream.reset();
        this.lastToken = this.tokStream.getPrevious(this.tokStream.peek());
        if (n == 0) {
            n3 = this.tokStream.getToken();
            n2 = this.tokStream.getKind(n3);
        } else {
            n3 = this.lastToken;
            n2 = n;
        }
        this.reallocateStacks();
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                this.taking_actions = false;
                return null;
            }
            try {
                this.stateStack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = this.currentAction;
            }
            this.locationStack[this.stateStackTop] = n3;
            this.currentAction = this.tAction(this.currentAction, n2);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                this.processReductions();
                continue;
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.lastToken = n3;
                n3 = this.tokStream.getToken();
                n2 = this.tokStream.getKind(n3);
                this.currentAction -= this.ERROR_ACTION;
                this.processReductions();
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.lastToken = n3;
            n3 = this.tokStream.getToken();
            n2 = this.tokStream.getKind(n3);
        }
        this.taking_actions = false;
        if (this.currentAction == this.ERROR_ACTION) {
            throw new BadParseException(n3);
        }
        return this.parseStack[n == 0 ? 0 : 1];
    }

    public void resetParser() {
        this.resetParserEntry(0);
    }

    public void resetParserEntry(int n) {
        this.markerKind = n;
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        if (this.action == null) {
            this.action = new IntTuple(0x100000);
        } else {
            this.action.reset();
        }
        this.taking_actions = false;
        if (n != 0) {
            int[] nArray = new int[]{this.markerKind};
            this.parse(nArray, 0);
        }
    }

    private boolean recoverableState(int n) {
        int n2 = this.prs.asi(n);
        while (this.prs.asr(n2) != 0) {
            if (this.prs.asr(n2) == this.ERROR_SYMBOL) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void errorReset() {
        int n;
        int n2 = n = this.markerKind == 0 ? 0 : 1;
        while (this.stateStackTop >= n && !this.recoverableState(this.stateStack[this.stateStackTop])) {
            --this.stateStackTop;
        }
        if (this.stateStackTop < n) {
            this.resetParserEntry(this.markerKind);
        }
    }

    public int parse(int[] nArray, int n) {
        int n2 = this.action.size();
        int n3 = this.stateStackTop;
        int n4 = this.stateStackTop - 1;
        this.currentAction = this.tAction(this.stateStack[this.stateStackTop], nArray, n);
        while (this.currentAction <= this.NUM_RULES) {
            this.action.add(this.currentAction);
            do {
                int n5 = (n4 -= this.prs.rhs(this.currentAction) - 1) > n3 ? this.locationStack[n4] : this.stateStack[n4];
                this.currentAction = this.prs.ntAction(n5, this.prs.lhs(this.currentAction));
            } while (this.currentAction <= this.NUM_RULES);
            n3 = n3 < n4 ? n3 : n4;
            try {
                this.locationStack[n4 + 1] = this.currentAction;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.locationStack[n4 + 1] = this.currentAction;
            }
            this.currentAction = this.tAction(this.currentAction, nArray, n);
        }
        if (this.currentAction > this.ERROR_ACTION || this.currentAction < this.ACCEPT_ACTION) {
            this.action.add(this.currentAction);
            this.stateStackTop = n4 + 1;
            for (int i = n3 + 1; i <= this.stateStackTop; ++i) {
                this.stateStack[i] = this.locationStack[i];
            }
            if (this.currentAction > this.ERROR_ACTION) {
                this.currentAction -= this.ERROR_ACTION;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stateStack[this.stateStackTop], this.prs.lhs(this.currentAction));
                } while (this.currentAction <= this.NUM_RULES);
            }
            try {
                this.stateStack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = this.currentAction;
            }
        } else if (this.currentAction == this.ERROR_ACTION) {
            this.action.reset(n2);
        }
        return this.currentAction;
    }

    public Object parseActions() throws BadParseException {
        this.taking_actions = true;
        this.tokStream.reset();
        this.lastToken = this.tokStream.getPrevious(this.tokStream.peek());
        int n = this.markerKind == 0 ? this.tokStream.getToken() : this.lastToken;
        try {
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            for (int i = 0; i < this.action.size(); ++i) {
                if (this.monitor != null && this.monitor.isCancelled()) {
                    this.taking_actions = false;
                    return null;
                }
                this.stateStack[++this.stateStackTop] = this.currentAction;
                this.locationStack[this.stateStackTop] = n;
                this.currentAction = this.action.get(i);
                if (this.currentAction <= this.NUM_RULES) {
                    --this.stateStackTop;
                    this.processReductions();
                    continue;
                }
                this.lastToken = n;
                n = this.tokStream.getToken();
                if (this.currentAction <= this.ERROR_ACTION) continue;
                this.currentAction -= this.ERROR_ACTION;
                this.processReductions();
            }
        }
        catch (Throwable throwable) {
            this.taking_actions = false;
            throw new BadParseException(n);
        }
        this.taking_actions = false;
        this.action = null;
        return this.parseStack[this.markerKind == 0 ? 0 : 1];
    }
}

