/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.ParseTable;
import lpg.runtime.TokenStream;

public class DiagnoseParser
implements ParseErrorCodes {
    protected Monitor monitor = null;
    protected TokenStream tokStream;
    protected ParseTable prs;
    protected int ERROR_SYMBOL;
    protected int SCOPE_SIZE;
    protected int MAX_NAME_LENGTH;
    protected int NT_OFFSET;
    protected int LA_STATE_OFFSET;
    protected int NUM_RULES;
    protected int NUM_SYMBOLS;
    protected int START_STATE;
    protected int EOFT_SYMBOL;
    protected int EOLT_SYMBOL;
    protected int ACCEPT_ACTION;
    protected int ERROR_ACTION;
    protected int[] list;
    protected int maxErrors;
    protected long maxTime;
    protected static final int STACK_INCREMENT = 256;
    protected static final int BUFF_UBOUND = 31;
    protected static final int BUFF_SIZE = 32;
    protected static final int MAX_DISTANCE = 30;
    protected static final int MIN_DISTANCE = 3;
    protected int stateStackTop;
    protected int[] stateStack;
    protected int[] locationStack;
    protected int tempStackTop;
    protected int[] tempStack;
    protected int prevStackTop;
    protected int[] prevStack;
    protected int nextStackTop;
    protected int[] nextStack;
    protected int scopeStackTop;
    protected int[] scopeIndex;
    protected int[] scopePosition;
    protected int[] buffer = new int[32];
    protected ConfigurationStack main_configuration_stack;
    private static final int NIL = -1;
    private int[] stateSeen;
    private int statePoolTop;
    private StateInfo[] statePool;

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public DiagnoseParser(TokenStream tokenStream, ParseTable parseTable) {
        this(null, tokenStream, parseTable);
    }

    public DiagnoseParser(Monitor monitor, TokenStream tokenStream, ParseTable parseTable) {
        this(monitor, tokenStream, parseTable, 0, 0L);
    }

    public DiagnoseParser(TokenStream tokenStream, ParseTable parseTable, int n, long l) {
        this(null, tokenStream, parseTable, n, l);
    }

    public DiagnoseParser(Monitor monitor, TokenStream tokenStream, ParseTable parseTable, int n, long l) {
        this.monitor = monitor;
        this.maxErrors = n;
        this.maxTime = l;
        this.tokStream = tokenStream;
        this.prs = parseTable;
        this.main_configuration_stack = new ConfigurationStack(parseTable);
        this.ERROR_SYMBOL = parseTable.getErrorSymbol();
        this.SCOPE_SIZE = parseTable.getScopeSize();
        this.MAX_NAME_LENGTH = parseTable.getMaxNameLength();
        this.NT_OFFSET = parseTable.getNtOffset();
        this.LA_STATE_OFFSET = parseTable.getLaStateOffset();
        this.NUM_RULES = parseTable.getNumRules();
        this.NUM_SYMBOLS = parseTable.getNumSymbols();
        this.START_STATE = parseTable.getStartState();
        this.EOFT_SYMBOL = parseTable.getEoftSymbol();
        this.EOLT_SYMBOL = parseTable.getEoltSymbol();
        this.ACCEPT_ACTION = parseTable.getAcceptAction();
        this.ERROR_ACTION = parseTable.getErrorAction();
        this.list = new int[this.NUM_SYMBOLS + 1];
    }

    public int rhs(int n) {
        return this.prs.rhs(n);
    }

    public int baseAction(int n) {
        return this.prs.baseAction(n);
    }

    public int baseCheck(int n) {
        return this.prs.baseCheck(n);
    }

    public int lhs(int n) {
        return this.prs.lhs(n);
    }

    public int termCheck(int n) {
        return this.prs.termCheck(n);
    }

    public int termAction(int n) {
        return this.prs.termAction(n);
    }

    public int asb(int n) {
        return this.prs.asb(n);
    }

    public int asr(int n) {
        return this.prs.asr(n);
    }

    public int nasb(int n) {
        return this.prs.nasb(n);
    }

    public int nasr(int n) {
        return this.prs.nasr(n);
    }

    public int terminalIndex(int n) {
        return this.prs.terminalIndex(n);
    }

    public int nonterminalIndex(int n) {
        return this.prs.nonterminalIndex(n);
    }

    public int symbolIndex(int n) {
        return n > this.NT_OFFSET ? this.nonterminalIndex(n - this.NT_OFFSET) : this.terminalIndex(n);
    }

    public int scopePrefix(int n) {
        return this.prs.scopePrefix(n);
    }

    public int scopeSuffix(int n) {
        return this.prs.scopeSuffix(n);
    }

    public int scopeLhs(int n) {
        return this.prs.scopeLhs(n);
    }

    public int scopeLa(int n) {
        return this.prs.scopeLa(n);
    }

    public int scopeStateSet(int n) {
        return this.prs.scopeStateSet(n);
    }

    public int scopeRhs(int n) {
        return this.prs.scopeRhs(n);
    }

    public int scopeState(int n) {
        return this.prs.scopeState(n);
    }

    public int inSymb(int n) {
        return this.prs.inSymb(n);
    }

    public String name(int n) {
        return this.prs.name(n);
    }

    public int originalState(int n) {
        return this.prs.originalState(n);
    }

    public int asi(int n) {
        return this.prs.asi(n);
    }

    public int nasi(int n) {
        return this.prs.nasi(n);
    }

    public int inSymbol(int n) {
        return this.prs.inSymbol(n);
    }

    public int ntAction(int n, int n2) {
        return this.prs.ntAction(n, n2);
    }

    public boolean isNullable(int n) {
        return this.prs.isNullable(n);
    }

    protected void reallocateStacks() {
        int n = this.stateStack == null ? 0 : this.stateStack.length;
        int n2 = n + 256;
        if (this.stateStack == null) {
            this.stateStack = new int[n2];
            this.locationStack = new int[n2];
            this.tempStack = new int[n2];
            this.prevStack = new int[n2];
            this.nextStack = new int[n2];
            this.scopeIndex = new int[n2];
            this.scopePosition = new int[n2];
        } else {
            this.stateStack = new int[n2];
            System.arraycopy(this.stateStack, 0, this.stateStack, 0, n);
            this.locationStack = new int[n2];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, n);
            this.tempStack = new int[n2];
            System.arraycopy(this.tempStack, 0, this.tempStack, 0, n);
            this.prevStack = new int[n2];
            System.arraycopy(this.prevStack, 0, this.prevStack, 0, n);
            this.nextStack = new int[n2];
            System.arraycopy(this.nextStack, 0, this.nextStack, 0, n);
            this.scopeIndex = new int[n2];
            System.arraycopy(this.scopeIndex, 0, this.scopeIndex, 0, n);
            this.scopePosition = new int[n2];
            System.arraycopy(this.scopePosition, 0, this.scopePosition, 0, n);
        }
    }

    public void diagnose() {
        this.diagnoseEntry(0, 0);
    }

    public void diagnose(int n) {
        this.diagnoseEntry(0, n);
    }

    public void diagnoseEntry(int n) {
        int n2;
        this.reallocateStacks();
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = this.START_STATE;
        this.tokStream.reset();
        if (n == 0) {
            int n3 = this.tokStream.getToken();
            n2 = this.tokStream.getKind(n3);
        } else {
            int n4 = this.tokStream.peek();
            n2 = n;
        }
        int n5 = this.parseForError(n2);
        if (n5 != 0) {
            this.diagnoseEntry(n, n5);
        }
    }

    public void diagnoseEntry(int n, int n2) {
        int n3;
        int n4;
        int n5;
        IntTuple intTuple = new IntTuple(262144);
        long l = System.currentTimeMillis();
        int n6 = 0;
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = this.START_STATE;
        this.tokStream.reset();
        if (n == 0) {
            n5 = this.tokStream.getToken();
            n4 = this.tokStream.getKind(n5);
        } else {
            n5 = this.tokStream.peek();
            n4 = n;
        }
        this.parseUpToError(intTuple, n4, n2);
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        this.tempStackTop = this.stateStackTop;
        System.arraycopy(this.tempStack, 0, this.stateStack, 0, this.tempStackTop + 1);
        this.tokStream.reset();
        if (n == 0) {
            n5 = this.tokStream.getToken();
            n4 = this.tokStream.getKind(n5);
        } else {
            n5 = this.tokStream.peek();
            n4 = n;
        }
        this.locationStack[this.stateStackTop] = n5;
        do {
            int n7;
            int n8 = -1;
            this.prevStackTop = -1;
            int n9 = -1;
            this.nextStackTop = -1;
            int n10 = this.stateStackTop;
            this.tempStackTop = this.stateStackTop - 1;
            System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
            int n11 = 0;
            n3 = intTuple.get(n11++);
            while (n3 <= this.NUM_RULES) {
                do {
                    this.tempStackTop -= this.rhs(n3) - 1;
                } while ((n3 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n3))) <= this.NUM_RULES);
                if (this.tempStackTop + 1 >= this.stateStack.length) {
                    this.reallocateStacks();
                }
                n10 = n10 < this.tempStackTop ? n10 : this.tempStackTop;
                this.tempStack[this.tempStackTop + 1] = n3;
                n3 = intTuple.get(n11++);
            }
            while (n3 > this.ERROR_ACTION || n3 < this.ACCEPT_ACTION) {
                int n12;
                if (this.monitor != null && this.monitor.isCancelled()) {
                    return;
                }
                this.nextStackTop = this.tempStackTop + 1;
                for (n12 = n9 + 1; n12 <= this.nextStackTop; ++n12) {
                    this.nextStack[n12] = this.tempStack[n12];
                }
                for (n12 = n10 + 1; n12 <= this.nextStackTop; ++n12) {
                    this.locationStack[n12] = this.locationStack[this.stateStackTop];
                }
                if (n3 > this.ERROR_ACTION) {
                    n3 -= this.ERROR_ACTION;
                    do {
                        this.nextStackTop -= this.rhs(n3) - 1;
                    } while ((n3 = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(n3))) <= this.NUM_RULES);
                    int n13 = n10 = n10 < this.nextStackTop ? n10 : this.nextStackTop;
                }
                if (this.nextStackTop + 1 >= this.stateStack.length) {
                    this.reallocateStacks();
                }
                this.tempStackTop = this.nextStackTop++;
                this.nextStack[this.nextStackTop] = n3;
                n9 = this.nextStackTop;
                n5 = this.tokStream.getToken();
                n4 = this.tokStream.getKind(n5);
                n3 = intTuple.get(n11++);
                while (n3 <= this.NUM_RULES) {
                    do {
                        n12 = this.lhs(n3);
                        this.tempStackTop -= this.rhs(n3) - 1;
                        int n14 = n3 = this.tempStackTop > n9 ? this.tempStack[this.tempStackTop] : this.nextStack[this.tempStackTop];
                    } while ((n3 = this.ntAction(n3, n12)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        this.reallocateStacks();
                    }
                    n9 = n9 < this.tempStackTop ? n9 : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = n3;
                    n3 = intTuple.get(n11++);
                }
                if (n3 == this.ERROR_ACTION) continue;
                this.prevStackTop = this.stateStackTop;
                for (n12 = n8 + 1; n12 <= this.prevStackTop; ++n12) {
                    this.prevStack[n12] = this.stateStack[n12];
                }
                n8 = n10;
                this.stateStackTop = this.nextStackTop;
                for (n12 = n10 + 1; n12 <= this.stateStackTop; ++n12) {
                    this.stateStack[n12] = this.nextStack[n12];
                }
                this.locationStack[this.stateStackTop] = n5;
                n10 = n9;
            }
            if (n3 != this.ERROR_ACTION) continue;
            if (++n6 > 1 && (this.maxErrors > 0 && n6 > this.maxErrors || this.maxTime > 0L && System.currentTimeMillis() - l > this.maxTime)) break;
            RepairCandidate repairCandidate = this.errorRecovery(n5);
            if (this.monitor != null && this.monitor.isCancelled()) {
                return;
            }
            n3 = this.stateStack[this.stateStackTop];
            if (repairCandidate.symbol == 0) break;
            if (repairCandidate.symbol > this.NT_OFFSET) {
                n7 = repairCandidate.symbol - this.NT_OFFSET;
                n3 = this.ntAction(n3, n7);
                while (n3 <= this.NUM_RULES) {
                    this.stateStackTop -= this.rhs(n3) - 1;
                    n3 = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(n3));
                }
                this.stateStack[++this.stateStackTop] = n3;
                n5 = this.tokStream.getToken();
                n4 = this.tokStream.getKind(n5);
                this.locationStack[this.stateStackTop] = n5;
            } else {
                n4 = repairCandidate.symbol;
                this.locationStack[this.stateStackTop] = repairCandidate.location;
            }
            n7 = this.tokStream.peek();
            this.tempStackTop = this.stateStackTop;
            System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
            n2 = this.parseForError(n4);
            if (n2 != 0) {
                this.tokStream.reset(n7);
                this.tempStackTop = this.stateStackTop;
                System.arraycopy(this.stateStack, 0, this.tempStack, 0, this.stateStackTop + 1);
                this.parseUpToError(intTuple, n4, n2);
                this.tokStream.reset(n7);
                continue;
            }
            n3 = this.ACCEPT_ACTION;
        } while (n3 != this.ACCEPT_ACTION);
    }

    int parseForError(int n) {
        int n2 = 0;
        int n3 = this.tokStream.getPrevious(this.tokStream.peek());
        int n4 = this.tAction(this.tempStack[this.tempStackTop], n);
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        while (true) {
            if (n4 <= this.NUM_RULES) {
                --this.tempStackTop;
                do {
                    this.tempStackTop -= this.rhs(n4) - 1;
                } while ((n4 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n4))) <= this.NUM_RULES);
            } else if (n4 > this.ERROR_ACTION) {
                n3 = this.tokStream.getToken();
                n = this.tokStream.getKind(n3);
                n4 -= this.ERROR_ACTION;
                do {
                    this.tempStackTop -= this.rhs(n4) - 1;
                } while ((n4 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n4))) <= this.NUM_RULES);
            } else if (n4 < this.ACCEPT_ACTION) {
                n3 = this.tokStream.getToken();
                n = this.tokStream.getKind(n3);
            } else {
                if (n4 == this.ERROR_ACTION) {
                    n2 = n2 > n3 ? n2 : n3;
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n4 = this.ERROR_ACTION;
                        break;
                    }
                    this.tempStackTop = configurationElement.stack_top;
                    configurationElement.retrieveStack(this.tempStack);
                    n4 = configurationElement.act;
                    n3 = configurationElement.curtok;
                    n = this.tokStream.getKind(n3);
                    this.tokStream.reset(this.tokStream.getNext(n3));
                    continue;
                }
                if (n4 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(this.tempStack, this.tempStackTop, n3)) {
                    n4 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(this.tempStack, this.tempStackTop, n4 + 1, n3, 0);
                n4 = this.baseAction(n4);
                continue;
            }
            try {
                this.tempStack[++this.tempStackTop] = n4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.tempStack[this.tempStackTop] = n4;
            }
            n4 = this.tAction(n4, n);
        }
        return n4 == this.ERROR_ACTION ? n2 : 0;
    }

    void parseUpToError(IntTuple intTuple, int n, int n2) {
        int n3 = this.tokStream.getPrevious(this.tokStream.peek());
        int n4 = this.tAction(this.tempStack[this.tempStackTop], n);
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        intTuple.reset();
        while (true) {
            if (n4 <= this.NUM_RULES) {
                intTuple.add(n4);
                --this.tempStackTop;
                do {
                    this.tempStackTop -= this.rhs(n4) - 1;
                } while ((n4 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n4))) <= this.NUM_RULES);
            } else if (n4 > this.ERROR_ACTION) {
                intTuple.add(n4);
                n3 = this.tokStream.getToken();
                n = this.tokStream.getKind(n3);
                n4 -= this.ERROR_ACTION;
                do {
                    this.tempStackTop -= this.rhs(n4) - 1;
                } while ((n4 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n4))) <= this.NUM_RULES);
            } else if (n4 < this.ACCEPT_ACTION) {
                intTuple.add(n4);
                n3 = this.tokStream.getToken();
                n = this.tokStream.getKind(n3);
            } else {
                if (n4 == this.ERROR_ACTION) {
                    if (n3 == n2) break;
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n4 = this.ERROR_ACTION;
                        break;
                    }
                    this.tempStackTop = configurationElement.stack_top;
                    configurationElement.retrieveStack(this.tempStack);
                    n4 = configurationElement.act;
                    n3 = configurationElement.curtok;
                    intTuple.reset(configurationElement.action_length);
                    n = this.tokStream.getKind(n3);
                    this.tokStream.reset(this.tokStream.getNext(n3));
                    continue;
                }
                if (n4 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(this.tempStack, this.tempStackTop, n3)) {
                    n4 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(this.tempStack, this.tempStackTop, n4 + 1, n3, intTuple.size());
                n4 = this.baseAction(n4);
                continue;
            }
            try {
                this.tempStack[++this.tempStackTop] = n4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.tempStack[this.tempStackTop] = n4;
            }
            n4 = this.tAction(n4, n);
        }
        intTuple.add(this.ERROR_ACTION);
    }

    protected int parseCheck(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int[] nArray2 = new int[nArray.length];
        int n6 = n;
        for (int i = 0; i <= n; ++i) {
            nArray2[i] = nArray[i];
        }
        ConfigurationStack configurationStack = new ConfigurationStack(this.prs);
        int n7 = nArray2[n6];
        if (n2 > this.NT_OFFSET) {
            int n8 = n2 - this.NT_OFFSET;
            n5 = n3;
            n4 = this.tokStream.getKind(this.buffer[n5]);
            this.tokStream.reset(this.tokStream.getNext(this.buffer[n5]));
            n7 = this.ntAction(n7, n8);
            while (n7 <= this.NUM_RULES) {
                n7 = this.ntAction(nArray2[n6 -= this.rhs(n7) - 1], this.lhs(n7));
            }
        } else {
            --n6;
            n5 = n3 - 1;
            n4 = n2;
            this.tokStream.reset(this.buffer[n3]);
        }
        if (++n6 >= nArray2.length) {
            return n5;
        }
        nArray2[n6] = n7;
        n7 = this.tAction(n7, n4);
        while (true) {
            if (n7 <= this.NUM_RULES) {
                n6 -= this.rhs(n7);
                n7 = this.ntAction(nArray2[n6], this.lhs(n7));
                while (n7 <= this.NUM_RULES) {
                    n7 = this.ntAction(nArray2[n6 -= this.rhs(n7) - 1], this.lhs(n7));
                }
            } else if (n7 > this.ERROR_ACTION) {
                if (n5++ == 30) break;
                n4 = this.tokStream.getKind(this.buffer[n5]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[n5]));
                n7 -= this.ERROR_ACTION;
                while ((n7 = this.ntAction(nArray2[n6 -= this.rhs(n7) - 1], this.lhs(n7))) <= this.NUM_RULES) {
                }
            } else if (n7 < this.ACCEPT_ACTION) {
                if (n5++ == 30) break;
                n4 = this.tokStream.getKind(this.buffer[n5]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[n5]));
            } else {
                if (n7 == this.ERROR_ACTION) {
                    ConfigurationElement configurationElement = configurationStack.pop();
                    if (configurationElement == null) {
                        n7 = this.ERROR_ACTION;
                        break;
                    }
                    n6 = configurationElement.stack_top;
                    configurationElement.retrieveStack(nArray2);
                    n7 = configurationElement.act;
                    n5 = configurationElement.curtok;
                    n4 = this.tokStream.getKind(this.buffer[n5]);
                    this.tokStream.reset(this.tokStream.getNext(this.buffer[n5]));
                    continue;
                }
                if (n7 <= this.ACCEPT_ACTION) break;
                if (configurationStack.findConfiguration(nArray2, n6, n5)) {
                    n7 = this.ERROR_ACTION;
                    continue;
                }
                configurationStack.push(nArray2, n6, n7 + 1, n5, 0);
                n7 = this.baseAction(n7);
                continue;
            }
            if (++n6 >= nArray2.length) break;
            nArray2[n6] = n7;
            n7 = this.tAction(n7, n4);
        }
        return n7 == this.ACCEPT_ACTION ? 30 : n5;
    }

    protected RepairCandidate errorRecovery(int n) {
        int n2;
        int n3 = this.tokStream.getPrevious(n);
        RepairCandidate repairCandidate = this.primaryPhase(n);
        if (repairCandidate.symbol != 0) {
            return repairCandidate;
        }
        repairCandidate = this.secondaryPhase(n);
        if (repairCandidate.symbol != 0) {
            return repairCandidate;
        }
        if (this.tokStream.getKind(n) != this.EOFT_SYMBOL) {
            while (this.tokStream.getKind(this.buffer[31]) != this.EOFT_SYMBOL) {
                repairCandidate = this.secondaryPhase(this.buffer[29]);
                if (repairCandidate.symbol == 0) continue;
                return repairCandidate;
            }
        }
        PrimaryRepairInfo primaryRepairInfo = new PrimaryRepairInfo();
        primaryRepairInfo.bufferPosition = 31;
        for (n2 = this.stateStackTop; n2 >= 0; --n2) {
            this.scopeTrial(primaryRepairInfo, this.stateStack, n2);
            if (primaryRepairInfo.distance > 0) break;
        }
        for (n2 = 0; n2 < this.scopeStackTop; ++n2) {
            this.emitError(9, -this.scopeIndex[n2], this.locationStack[this.scopePosition[n2]], this.buffer[1], this.nonterminalIndex(this.scopeLhs(this.scopeIndex[n2])));
        }
        if (this.tokStream.getKind(n) == this.EOFT_SYMBOL) {
            this.emitError(10, this.terminalIndex(this.EOFT_SYMBOL), n3, n3);
        } else {
            n2 = 31;
            while (this.tokStream.getKind(this.buffer[n2]) == this.EOFT_SYMBOL) {
                --n2;
            }
            this.emitError(6, this.terminalIndex(this.tokStream.getKind(n)), n, this.buffer[n2]);
        }
        repairCandidate.symbol = 0;
        repairCandidate.location = this.buffer[31];
        return repairCandidate;
    }

    protected RepairCandidate primaryPhase(int n) {
        Object object;
        int n2;
        int n3 = this.nextStackTop >= 0 ? 3 : 2;
        this.buffer[n3] = n;
        for (n2 = n3; n2 > 0; --n2) {
            this.buffer[n2 - 1] = this.tokStream.getPrevious(this.buffer[n2]);
        }
        for (n2 = n3 + 1; n2 < 32; ++n2) {
            this.buffer[n2] = this.tokStream.getNext(this.buffer[n2 - 1]);
        }
        Object object2 = new PrimaryRepairInfo();
        if (this.nextStackTop >= 0) {
            ((PrimaryRepairInfo)object2).bufferPosition = 3;
            this.checkPrimaryDistance((PrimaryRepairInfo)object2, this.nextStack, this.nextStackTop);
        }
        PrimaryRepairInfo primaryRepairInfo = new PrimaryRepairInfo((PrimaryRepairInfo)object2);
        primaryRepairInfo.bufferPosition = 2;
        this.checkPrimaryDistance(primaryRepairInfo, this.stateStack, this.stateStackTop);
        if (primaryRepairInfo.distance > ((PrimaryRepairInfo)object2).distance || primaryRepairInfo.misspellIndex > ((PrimaryRepairInfo)object2).misspellIndex) {
            object2 = primaryRepairInfo;
        }
        if (this.prevStackTop >= 0) {
            object = new PrimaryRepairInfo((PrimaryRepairInfo)object2);
            ((PrimaryRepairInfo)object).bufferPosition = 1;
            this.checkPrimaryDistance((PrimaryRepairInfo)object, this.prevStack, this.prevStackTop);
            if (((PrimaryRepairInfo)object).distance > ((PrimaryRepairInfo)object2).distance || ((PrimaryRepairInfo)object).misspellIndex > ((PrimaryRepairInfo)object2).misspellIndex) {
                object2 = object;
            }
        }
        object = new RepairCandidate();
        if (this.nextStackTop >= 0 ? this.secondaryCheck(this.nextStack, this.nextStackTop, 3, ((PrimaryRepairInfo)object2).distance) : this.secondaryCheck(this.stateStack, this.stateStackTop, 2, ((PrimaryRepairInfo)object2).distance)) {
            return object;
        }
        ((PrimaryRepairInfo)object2).distance = ((PrimaryRepairInfo)object2).distance - ((PrimaryRepairInfo)object2).bufferPosition + 1;
        if (((PrimaryRepairInfo)object2).code == 4 || ((PrimaryRepairInfo)object2).code == 6 || ((PrimaryRepairInfo)object2).code == 5 || ((PrimaryRepairInfo)object2).code == 7) {
            --((PrimaryRepairInfo)object2).distance;
        }
        if (((PrimaryRepairInfo)object2).distance < 3) {
            return object;
        }
        if (((PrimaryRepairInfo)object2).code == 3 && this.tokStream.getKind(this.buffer[((PrimaryRepairInfo)object2).bufferPosition - 1]) == 0) {
            ((PrimaryRepairInfo)object2).code = 2;
        }
        if (((PrimaryRepairInfo)object2).bufferPosition == 1) {
            this.stateStackTop = this.prevStackTop;
            System.arraycopy(this.prevStack, 0, this.stateStack, 0, this.stateStackTop + 1);
        } else if (this.nextStackTop >= 0 && ((PrimaryRepairInfo)object2).bufferPosition >= 3) {
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
            this.locationStack[this.stateStackTop] = this.buffer[3];
        }
        return this.primaryDiagnosis((PrimaryRepairInfo)object2);
    }

    protected int mergeCandidate(int n, int n2) {
        String string = this.tokStream.getName(this.buffer[n2]) + this.tokStream.getName(this.buffer[n2 + 1]);
        int n3 = this.asi(n);
        while (this.asr(n3) != 0) {
            int n4 = this.terminalIndex(this.asr(n3));
            if (string.length() == this.name(n4).length() && string.toLowerCase().equals(this.name(n4).toLowerCase())) {
                return this.asr(n3);
            }
            ++n3;
        }
        return 0;
    }

    protected void checkPrimaryDistance(PrimaryRepairInfo primaryRepairInfo, int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        PrimaryRepairInfo primaryRepairInfo2 = new PrimaryRepairInfo(primaryRepairInfo);
        this.scopeTrial(primaryRepairInfo2, nArray, n);
        if (primaryRepairInfo2.distance > primaryRepairInfo.distance) {
            primaryRepairInfo.copy(primaryRepairInfo2);
        }
        if ((n7 = this.mergeCandidate(nArray[n], primaryRepairInfo.bufferPosition)) != 0 && ((n6 = this.parseCheck(nArray, n, n7, primaryRepairInfo.bufferPosition + 2)) > primaryRepairInfo.distance || n6 == primaryRepairInfo.distance && primaryRepairInfo.misspellIndex < 10)) {
            primaryRepairInfo.misspellIndex = 10;
            primaryRepairInfo.symbol = n7;
            primaryRepairInfo.distance = n6;
            primaryRepairInfo.code = 7;
        }
        n6 = this.parseCheck(nArray, n, this.tokStream.getKind(this.buffer[primaryRepairInfo.bufferPosition + 1]), primaryRepairInfo.bufferPosition + 2);
        int n8 = n5 = this.tokStream.getKind(this.buffer[primaryRepairInfo.bufferPosition]) == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[primaryRepairInfo.bufferPosition + 1]) ? 10 : 0;
        if (n6 > primaryRepairInfo.distance || n6 == primaryRepairInfo.distance && n5 > primaryRepairInfo.misspellIndex) {
            primaryRepairInfo.misspellIndex = n5;
            primaryRepairInfo.code = 6;
            primaryRepairInfo.distance = n6;
        }
        int n9 = nArray[n];
        int n10 = n;
        this.tempStackTop = n - 1;
        this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition + 1]);
        int n11 = this.tokStream.getKind(this.buffer[primaryRepairInfo.bufferPosition]);
        int n12 = this.tAction(n9, n11);
        while (n12 <= this.NUM_RULES) {
            do {
                n4 = this.lhs(n12);
                this.tempStackTop -= this.rhs(n12) - 1;
                int n13 = n12 = this.tempStackTop > n10 ? this.tempStack[this.tempStackTop] : nArray[this.tempStackTop];
            } while ((n12 = this.ntAction(n12, n4)) <= this.NUM_RULES);
            n10 = n10 < this.tempStackTop ? n10 : this.tempStackTop;
            this.tempStack[this.tempStackTop + 1] = n12;
            n9 = n12;
            n12 = this.tAction(n9, n11);
        }
        n4 = 0;
        int n14 = this.asi(n9);
        while (this.asr(n14) != 0) {
            n7 = this.asr(n14);
            if (n7 != this.EOFT_SYMBOL && n7 != this.ERROR_SYMBOL) {
                if (n4 == 0) {
                    this.list[n7] = n7;
                } else {
                    this.list[n7] = this.list[n4];
                    this.list[n4] = n7;
                }
                n4 = n7;
            }
            ++n14;
        }
        if (nArray[n] != n9) {
            n14 = this.asi(nArray[n]);
            while (this.asr(n14) != 0) {
                n7 = this.asr(n14);
                if (n7 != this.EOFT_SYMBOL && n7 != this.ERROR_SYMBOL && this.list[n7] == 0) {
                    if (n4 == 0) {
                        this.list[n7] = n7;
                    } else {
                        this.list[n7] = this.list[n4];
                        this.list[n4] = n7;
                    }
                    n4 = n7;
                }
                ++n14;
            }
        }
        n14 = this.list[n4];
        this.list[n4] = 0;
        n7 = n4 = n14;
        while (n7 != 0) {
            n3 = this.parseCheck(nArray, n, n7, primaryRepairInfo.bufferPosition);
            int n15 = n2 = n7 == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[primaryRepairInfo.bufferPosition]) ? 10 : 0;
            if (n3 > primaryRepairInfo.distance || n3 == primaryRepairInfo.distance && n2 > primaryRepairInfo.misspellIndex) {
                primaryRepairInfo.misspellIndex = n2;
                primaryRepairInfo.distance = n3;
                primaryRepairInfo.symbol = n7;
                primaryRepairInfo.code = 3;
            }
            n7 = this.list[n7];
        }
        n7 = n4;
        while (n7 != 0) {
            n3 = this.parseCheck(nArray, n, n7, primaryRepairInfo.bufferPosition + 1);
            int n16 = n2 = n7 == this.EOLT_SYMBOL && this.tokStream.afterEol(this.buffer[primaryRepairInfo.bufferPosition + 1]) ? 10 : this.misspell(n7, this.buffer[primaryRepairInfo.bufferPosition]);
            if (n3 > primaryRepairInfo.distance || n3 == primaryRepairInfo.distance && n2 > primaryRepairInfo.misspellIndex) {
                primaryRepairInfo.misspellIndex = n2;
                primaryRepairInfo.distance = n3;
                primaryRepairInfo.symbol = n7;
                primaryRepairInfo.code = 5;
            }
            int n17 = n7;
            n7 = this.list[n7];
            this.list[n17] = 0;
        }
        n3 = this.nasi(nArray[n]);
        while (this.nasr(n3) != 0) {
            n7 = this.nasr(n3) + this.NT_OFFSET;
            n2 = this.parseCheck(nArray, n, n7, primaryRepairInfo.bufferPosition + 1);
            if (n2 > primaryRepairInfo.distance) {
                primaryRepairInfo.misspellIndex = 0;
                primaryRepairInfo.distance = n2;
                primaryRepairInfo.symbol = n7;
                primaryRepairInfo.code = 4;
            }
            if ((n2 = this.parseCheck(nArray, n, n7, primaryRepairInfo.bufferPosition)) > primaryRepairInfo.distance || n2 == primaryRepairInfo.distance && primaryRepairInfo.code == 4) {
                primaryRepairInfo.misspellIndex = 0;
                primaryRepairInfo.distance = n2;
                primaryRepairInfo.symbol = n7;
                primaryRepairInfo.code = 3;
            }
            ++n3;
        }
    }

    protected RepairCandidate primaryDiagnosis(PrimaryRepairInfo primaryRepairInfo) {
        int n = this.buffer[primaryRepairInfo.bufferPosition - 1];
        int n2 = this.buffer[primaryRepairInfo.bufferPosition];
        switch (primaryRepairInfo.code) {
            case 2: 
            case 3: {
                int n3 = primaryRepairInfo.symbol > this.NT_OFFSET ? this.getNtermIndex(this.stateStack[this.stateStackTop], primaryRepairInfo.symbol, primaryRepairInfo.bufferPosition) : this.getTermIndex(this.stateStack, this.stateStackTop, primaryRepairInfo.symbol, primaryRepairInfo.bufferPosition);
                int n4 = primaryRepairInfo.code == 3 ? n : n2;
                this.emitError(primaryRepairInfo.code, n3, n4, n4);
                break;
            }
            case 4: {
                int n3 = this.getNtermIndex(this.stateStack[this.stateStackTop], primaryRepairInfo.symbol, primaryRepairInfo.bufferPosition + 1);
                this.emitError(primaryRepairInfo.code, n3, n2, n2);
                break;
            }
            case 5: {
                int n3;
                if (primaryRepairInfo.misspellIndex >= 6) {
                    n3 = this.terminalIndex(primaryRepairInfo.symbol);
                } else {
                    n3 = this.getTermIndex(this.stateStack, this.stateStackTop, primaryRepairInfo.symbol, primaryRepairInfo.bufferPosition + 1);
                    if (n3 != this.terminalIndex(primaryRepairInfo.symbol)) {
                        primaryRepairInfo.code = 4;
                    }
                }
                this.emitError(primaryRepairInfo.code, n3, n2, n2);
                break;
            }
            case 7: {
                this.emitError(primaryRepairInfo.code, this.terminalIndex(primaryRepairInfo.symbol), n2, this.tokStream.getNext(n2));
                break;
            }
            case 9: {
                int n3;
                for (n3 = 0; n3 < this.scopeStackTop; ++n3) {
                    this.emitError(primaryRepairInfo.code, -this.scopeIndex[n3], this.locationStack[this.scopePosition[n3]], n, this.nonterminalIndex(this.scopeLhs(this.scopeIndex[n3])));
                }
                primaryRepairInfo.symbol = this.scopeLhs(this.scopeIndex[this.scopeStackTop]) + this.NT_OFFSET;
                this.stateStackTop = this.scopePosition[this.scopeStackTop];
                this.emitError(primaryRepairInfo.code, -this.scopeIndex[this.scopeStackTop], this.locationStack[this.scopePosition[this.scopeStackTop]], n, this.getNtermIndex(this.stateStack[this.stateStackTop], primaryRepairInfo.symbol, primaryRepairInfo.bufferPosition));
                break;
            }
            default: {
                this.emitError(primaryRepairInfo.code, this.terminalIndex(this.ERROR_SYMBOL), n2, n2);
            }
        }
        RepairCandidate repairCandidate = new RepairCandidate();
        switch (primaryRepairInfo.code) {
            case 2: 
            case 3: 
            case 9: {
                repairCandidate.symbol = primaryRepairInfo.symbol;
                repairCandidate.location = this.buffer[primaryRepairInfo.bufferPosition];
                this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition]);
                break;
            }
            case 4: 
            case 5: {
                repairCandidate.symbol = primaryRepairInfo.symbol;
                repairCandidate.location = this.buffer[primaryRepairInfo.bufferPosition];
                this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition + 1]);
                break;
            }
            case 7: {
                repairCandidate.symbol = primaryRepairInfo.symbol;
                repairCandidate.location = this.buffer[primaryRepairInfo.bufferPosition];
                this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition + 2]);
                break;
            }
            default: {
                repairCandidate.location = this.buffer[primaryRepairInfo.bufferPosition + 1];
                repairCandidate.symbol = this.tokStream.getKind(this.buffer[primaryRepairInfo.bufferPosition + 1]);
                this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition + 2]);
            }
        }
        return repairCandidate;
    }

    protected int getTermIndex(int[] nArray, int n, int n2, int n3) {
        int n4;
        int n5 = nArray[n];
        int n6 = n;
        int n7 = n2;
        this.tempStackTop = n - 1;
        this.tokStream.reset(this.buffer[n3]);
        n5 = this.tAction(n5, n2);
        while (n5 <= this.NUM_RULES) {
            do {
                n4 = this.lhs(n5);
                this.tempStackTop -= this.rhs(n5) - 1;
                int n8 = n5 = this.tempStackTop > n6 ? this.tempStack[this.tempStackTop] : nArray[this.tempStackTop];
            } while ((n5 = this.ntAction(n5, n4)) <= this.NUM_RULES);
            n6 = n6 < this.tempStackTop ? n6 : this.tempStackTop;
            this.tempStack[this.tempStackTop + 1] = n5;
            n5 = this.tAction(n5, n2);
        }
        ++this.tempStackTop;
        n4 = this.tempStackTop;
        n2 = this.tokStream.getKind(this.buffer[n3]);
        this.tokStream.reset(this.buffer[n3 + 1]);
        if (n5 > this.ERROR_ACTION) {
            n5 -= this.ERROR_ACTION;
        } else if (n5 < this.ACCEPT_ACTION) {
            this.tempStack[this.tempStackTop + 1] = n5;
            n5 = this.tAction(n5, n2);
        }
        while (n5 <= this.NUM_RULES) {
            int n9;
            do {
                n9 = this.lhs(n5);
                this.tempStackTop -= this.rhs(n5) - 1;
                if (this.tempStackTop < n4) {
                    return n7 > this.NT_OFFSET ? this.nonterminalIndex(n7 - this.NT_OFFSET) : this.terminalIndex(n7);
                }
                if (this.tempStackTop == n4) {
                    n7 = n9 + this.NT_OFFSET;
                }
                int n10 = n5 = this.tempStackTop > n6 ? this.tempStack[this.tempStackTop] : nArray[this.tempStackTop];
            } while ((n5 = this.ntAction(n5, n9)) <= this.NUM_RULES);
            this.tempStack[this.tempStackTop + 1] = n5;
            n5 = this.tAction(n5, n2);
        }
        return n7 > this.NT_OFFSET ? this.nonterminalIndex(n7 - this.NT_OFFSET) : this.terminalIndex(n7);
    }

    protected int getNtermIndex(int n, int n2, int n3) {
        int n4 = n2 - this.NT_OFFSET;
        int n5 = this.tokStream.getKind(this.buffer[n3]);
        this.tokStream.reset(this.buffer[n3 + 1]);
        this.tempStackTop = 0;
        this.tempStack[this.tempStackTop] = n;
        int n6 = this.ntAction(n, n4);
        if (n6 > this.NUM_RULES) {
            this.tempStack[this.tempStackTop + 1] = n6;
            n6 = this.tAction(n6, n5);
        }
        while (n6 <= this.NUM_RULES) {
            do {
                this.tempStackTop -= this.rhs(n6) - 1;
                if (this.tempStackTop < 0) {
                    return this.nonterminalIndex(n4);
                }
                if (this.tempStackTop != 0) continue;
                n4 = this.lhs(n6);
            } while ((n6 = this.ntAction(this.tempStack[this.tempStackTop], this.lhs(n6))) <= this.NUM_RULES);
            this.tempStack[this.tempStackTop + 1] = n6;
            n6 = this.tAction(n6, n5);
        }
        return this.nonterminalIndex(n4);
    }

    protected int misspell(int n, int n2) {
        String string = new String(this.name(this.terminalIndex(n))).toLowerCase();
        int n3 = string.length();
        string = string + '\u0000';
        String string2 = new String(this.tokStream.getName(n2)).toLowerCase();
        int n4 = string2.length() < this.MAX_NAME_LENGTH ? string2.length() : this.MAX_NAME_LENGTH;
        string2 = string2.substring(0, n4) + '\u0000';
        if (n3 == 1 && n4 == 1 && (string.charAt(0) == ';' && string2.charAt(0) == ',' || string.charAt(0) == ',' && string2.charAt(0) == ';' || string.charAt(0) == ';' && string2.charAt(0) == ':' || string.charAt(0) == ':' && string2.charAt(0) == ';' || string.charAt(0) == '.' && string2.charAt(0) == ',' || string.charAt(0) == ',' && string2.charAt(0) == '.' || string.charAt(0) == '\'' && string2.charAt(0) == '\"' || string.charAt(0) == '\"' && string2.charAt(0) == '\'')) {
            return 3;
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        while (n8 < n3 && n9 < n4) {
            if (string.charAt(n8) == string2.charAt(n9)) {
                ++n5;
                ++n8;
                ++n9;
                if (n7 != 0) continue;
                ++n6;
                continue;
            }
            if (string.charAt(n8 + 1) == string2.charAt(n9) && string.charAt(n8) == string2.charAt(n9 + 1)) {
                n5 += 2;
                n8 += 2;
                n9 += 2;
                ++n7;
                continue;
            }
            if (string.charAt(n8 + 1) == string2.charAt(n9 + 1)) {
                n8 += 2;
                n9 += 2;
                ++n7;
                continue;
            }
            if (n3 - n8 > n4 - n9) {
                ++n8;
            } else if (n4 - n9 > n3 - n8) {
                ++n9;
            } else {
                ++n8;
                ++n9;
            }
            ++n7;
        }
        if (n8 < n3 || n9 < n4) {
            ++n7;
        }
        if (n7 > (n3 < n4 ? n3 : n4) / 6 + 1) {
            n5 = n6;
        }
        return n5 * 10 / ((n3 < string.length() ? string.length() : n3) + n7);
    }

    protected void scopeTrial(PrimaryRepairInfo primaryRepairInfo, int[] nArray, int n) {
        if (this.stateSeen == null || this.stateSeen.length < this.stateStack.length) {
            this.stateSeen = new int[this.stateStack.length];
        }
        for (int i = 0; i < this.stateStack.length; ++i) {
            this.stateSeen[i] = -1;
        }
        this.statePoolTop = 0;
        if (this.statePool == null || this.statePool.length < this.stateStack.length) {
            this.statePool = new StateInfo[this.stateStack.length];
        }
        this.scopeTrialCheck(primaryRepairInfo, nArray, n, 0);
        primaryRepairInfo.code = 9;
        primaryRepairInfo.misspellIndex = 10;
    }

    protected void scopeTrialCheck(PrimaryRepairInfo primaryRepairInfo, int[] nArray, int n, int n2) {
        int n3 = this.stateSeen[n];
        while (n3 != -1) {
            if (this.statePool[n3].state == nArray[n]) {
                return;
            }
            n3 = this.statePool[n3].next;
        }
        n3 = this.statePoolTop++;
        if (this.statePoolTop >= this.statePool.length) {
            this.statePool = new StateInfo[this.statePoolTop * 2];
            System.arraycopy(this.statePool, 0, this.statePool, 0, this.statePoolTop);
        }
        this.statePool[n3] = new StateInfo(nArray[n], this.stateSeen[n]);
        this.stateSeen[n] = n3;
        IntTuple intTuple = new IntTuple(8);
        for (int i = 0; i < this.SCOPE_SIZE; ++i) {
            intTuple.reset();
            int n4 = this.tAction(nArray[n], this.scopeLa(i));
            if (n4 > this.ACCEPT_ACTION && n4 < this.ERROR_ACTION) {
                do {
                    intTuple.add(this.baseAction(n4++));
                } while (this.baseAction(n4) != 0);
            } else {
                intTuple.add(n4);
            }
            for (int j = 0; j < intTuple.size(); ++j) {
                int n5;
                int n6;
                this.tokStream.reset(this.buffer[primaryRepairInfo.bufferPosition]);
                this.tempStackTop = n - 1;
                int n7 = n;
                n4 = intTuple.get(j);
                while (n4 <= this.NUM_RULES) {
                    do {
                        n6 = this.lhs(n4);
                        this.tempStackTop -= this.rhs(n4) - 1;
                        int n8 = n4 = this.tempStackTop > n7 ? this.tempStack[this.tempStackTop] : nArray[this.tempStackTop];
                    } while ((n4 = this.ntAction(n4, n6)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        return;
                    }
                    n7 = n7 < this.tempStackTop ? n7 : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = n4;
                    n4 = this.tAction(n4, this.scopeLa(i));
                }
                if (n4 == this.ERROR_ACTION) continue;
                int n9 = this.scopePrefix(i);
                for (n6 = this.tempStackTop + 1; n6 >= n7 + 1 && this.inSymbol(this.tempStack[n6]) == this.scopeRhs(n9); --n6) {
                    ++n9;
                }
                if (n6 == n7) {
                    for (n6 = n7; n6 >= 1 && this.inSymbol(nArray[n6]) == this.scopeRhs(n9); --n6) {
                        ++n9;
                    }
                }
                int n10 = n5 = n7 < n ? n7 + 1 : n;
                if (this.scopeRhs(n9) != 0 || n6 >= n5) continue;
                int n11 = n6;
                n6 = this.scopeStateSet(i);
                while (nArray[n11] != this.scopeState(n6) && this.scopeState(n6) != 0) {
                    ++n6;
                }
                if (this.scopeState(n6) == 0) continue;
                int n12 = primaryRepairInfo.distance;
                int n13 = this.parseCheck(nArray, n11, this.scopeLhs(i) + this.NT_OFFSET, primaryRepairInfo.bufferPosition);
                if (n13 - primaryRepairInfo.bufferPosition + 1 < 3) {
                    int n14 = n11;
                    n4 = this.ntAction(nArray[n14], this.scopeLhs(i));
                    while (n4 <= this.NUM_RULES) {
                        n4 = this.ntAction(nArray[n14 -= this.rhs(n4) - 1], this.lhs(n4));
                    }
                    n6 = n4;
                    n4 = nArray[++n14];
                    nArray[n14] = n6;
                    this.scopeTrialCheck(primaryRepairInfo, nArray, n14, n2 + 1);
                    nArray[n14] = n4;
                } else if (n13 > primaryRepairInfo.distance) {
                    this.scopeStackTop = n2;
                    primaryRepairInfo.distance = n13;
                }
                if (this.tokStream.getKind(this.buffer[primaryRepairInfo.bufferPosition]) == this.EOFT_SYMBOL && primaryRepairInfo.distance == n12) {
                    this.scopeStackTop = n2;
                    primaryRepairInfo.distance = 30;
                }
                if (primaryRepairInfo.distance <= n12) continue;
                this.scopeIndex[n2] = i;
                this.scopePosition[n2] = n11;
                return;
            }
        }
    }

    protected boolean secondaryCheck(int[] nArray, int n, int n2, int n3) {
        for (int i = n - 1; i >= 0; --i) {
            int n4 = this.parseCheck(nArray, i, this.tokStream.getKind(this.buffer[n2]), n2 + 1);
            if (n4 - n2 + 1 <= 3 || n4 <= n3) continue;
            return true;
        }
        PrimaryRepairInfo primaryRepairInfo = new PrimaryRepairInfo();
        primaryRepairInfo.bufferPosition = n2 + 1;
        primaryRepairInfo.distance = n3;
        this.scopeTrial(primaryRepairInfo, nArray, n);
        return primaryRepairInfo.distance - n2 > 3 && primaryRepairInfo.distance > n3;
    }

    protected RepairCandidate secondaryPhase(int n) {
        int n2;
        int n3;
        SecondaryRepairInfo secondaryRepairInfo = new SecondaryRepairInfo();
        SecondaryRepairInfo secondaryRepairInfo2 = new SecondaryRepairInfo();
        int n4 = 0;
        if (this.nextStackTop >= 0) {
            this.buffer[2] = n;
            this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
            this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
            for (n3 = 3; n3 < 31; ++n3) {
                this.buffer[n3] = this.tokStream.getNext(this.buffer[n3 - 1]);
            }
            this.buffer[31] = this.tokStream.badToken();
            for (n4 = 29; n4 >= 1 && this.tokStream.getKind(this.buffer[n4]) == this.EOFT_SYMBOL; --n4) {
            }
            n2 = this.locationStack[this.nextStackTop];
            this.locationStack[this.nextStackTop] = this.buffer[2];
            secondaryRepairInfo2.numDeletions = this.nextStackTop;
            this.misplacementRecovery(secondaryRepairInfo2, this.nextStack, this.nextStackTop, ++n4, true);
            if (secondaryRepairInfo2.recoveryOnNextStack) {
                ++secondaryRepairInfo2.distance;
            }
            secondaryRepairInfo.numDeletions = this.nextStackTop + 31;
            this.secondaryRecovery(secondaryRepairInfo, this.nextStack, this.nextStackTop, n4, true);
            if (secondaryRepairInfo.recoveryOnNextStack) {
                ++secondaryRepairInfo.distance;
            }
            this.locationStack[this.nextStackTop] = n2;
        } else {
            secondaryRepairInfo2.numDeletions = this.stateStackTop;
            secondaryRepairInfo.numDeletions = this.stateStackTop + 31;
        }
        this.buffer[3] = n;
        this.buffer[2] = this.tokStream.getPrevious(this.buffer[3]);
        this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
        this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
        for (n2 = 4; n2 < 32; ++n2) {
            this.buffer[n2] = this.tokStream.getNext(this.buffer[n2 - 1]);
        }
        for (n2 = 29; n2 >= 1 && this.tokStream.getKind(this.buffer[n2]) == this.EOFT_SYMBOL; --n2) {
        }
        this.misplacementRecovery(secondaryRepairInfo2, this.stateStack, this.stateStackTop, ++n2, false);
        this.secondaryRecovery(secondaryRepairInfo, this.stateStack, this.stateStackTop, n2, false);
        if (secondaryRepairInfo2.distance > 3 && (secondaryRepairInfo2.numDeletions <= secondaryRepairInfo.numDeletions || secondaryRepairInfo2.distance - secondaryRepairInfo2.numDeletions >= secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions)) {
            secondaryRepairInfo.code = 8;
            secondaryRepairInfo.stackPosition = secondaryRepairInfo2.stackPosition;
            secondaryRepairInfo.bufferPosition = 2;
            secondaryRepairInfo.numDeletions = secondaryRepairInfo2.numDeletions;
            secondaryRepairInfo.distance = secondaryRepairInfo2.distance;
            secondaryRepairInfo.recoveryOnNextStack = secondaryRepairInfo2.recoveryOnNextStack;
        }
        if (secondaryRepairInfo.recoveryOnNextStack) {
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
            this.buffer[2] = n;
            this.buffer[1] = this.tokStream.getPrevious(this.buffer[2]);
            this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
            for (n3 = 3; n3 < 31; ++n3) {
                this.buffer[n3] = this.tokStream.getNext(this.buffer[n3 - 1]);
            }
            this.buffer[31] = this.tokStream.badToken();
            this.locationStack[this.nextStackTop] = this.buffer[2];
            n2 = n4;
        }
        if (secondaryRepairInfo.code == 5 || secondaryRepairInfo.code == 6) {
            PrimaryRepairInfo primaryRepairInfo = new PrimaryRepairInfo();
            primaryRepairInfo.bufferPosition = 2;
            while (primaryRepairInfo.bufferPosition <= secondaryRepairInfo.bufferPosition && secondaryRepairInfo.code != 9) {
                this.scopeTrial(primaryRepairInfo, this.stateStack, this.stateStackTop);
                int n5 = primaryRepairInfo.distance == 30 ? n2 : primaryRepairInfo.distance;
                int n6 = primaryRepairInfo.bufferPosition - 1;
                if (primaryRepairInfo.distance - n6 > 3 && n5 - n6 > secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions) {
                    int n7 = this.scopeIndex[this.scopeStackTop];
                    secondaryRepairInfo.code = 9;
                    secondaryRepairInfo.symbol = this.scopeLhs(n7) + this.NT_OFFSET;
                    secondaryRepairInfo.stackPosition = this.stateStackTop;
                    secondaryRepairInfo.bufferPosition = primaryRepairInfo.bufferPosition;
                }
                ++primaryRepairInfo.bufferPosition;
            }
        }
        RepairCandidate repairCandidate = new RepairCandidate();
        if (secondaryRepairInfo.code == 0) {
            return repairCandidate;
        }
        this.secondaryDiagnosis(secondaryRepairInfo);
        switch (secondaryRepairInfo.code) {
            case 8: {
                repairCandidate.location = this.buffer[2];
                repairCandidate.symbol = this.tokStream.getKind(this.buffer[2]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[2]));
                break;
            }
            case 6: {
                repairCandidate.location = this.buffer[secondaryRepairInfo.bufferPosition];
                repairCandidate.symbol = this.tokStream.getKind(this.buffer[secondaryRepairInfo.bufferPosition]);
                this.tokStream.reset(this.tokStream.getNext(this.buffer[secondaryRepairInfo.bufferPosition]));
                break;
            }
            default: {
                repairCandidate.symbol = secondaryRepairInfo.symbol;
                repairCandidate.location = this.buffer[secondaryRepairInfo.bufferPosition];
                this.tokStream.reset(this.buffer[secondaryRepairInfo.bufferPosition]);
            }
        }
        return repairCandidate;
    }

    protected void misplacementRecovery(SecondaryRepairInfo secondaryRepairInfo, int[] nArray, int n, int n2, boolean bl) {
        int n3 = this.buffer[2];
        int n4 = 0;
        for (int i = n - 1; i >= 0; --i) {
            int n5;
            if (this.locationStack[i] < n3) {
                ++n4;
            }
            n3 = this.locationStack[i];
            int n6 = this.parseCheck(nArray, i, this.tokStream.getKind(this.buffer[2]), 3);
            int n7 = n5 = n6 == 30 ? n2 : n6;
            if (n6 <= 3 || n5 - n4 <= secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions) continue;
            secondaryRepairInfo.stackPosition = i;
            secondaryRepairInfo.distance = n5;
            secondaryRepairInfo.numDeletions = n4;
            secondaryRepairInfo.recoveryOnNextStack = bl;
        }
    }

    protected void secondaryRecovery(SecondaryRepairInfo secondaryRepairInfo, int[] nArray, int n, int n2, boolean bl) {
        int n3 = this.buffer[2];
        int n4 = 0;
        for (int i = n; i >= 0 && secondaryRepairInfo.numDeletions >= n4; --i) {
            if (this.locationStack[i] < n3) {
                ++n4;
            }
            n3 = this.locationStack[i];
            for (int j = 2; j <= n2 - 3 + 1 && secondaryRepairInfo.numDeletions >= n4 + j - 1; ++j) {
                int n5;
                int n6;
                int n7 = this.parseCheck(nArray, i, this.tokStream.getKind(this.buffer[j]), j + 1);
                int n8 = n6 = n7 == 30 ? n2 : n7;
                if (n7 - j + 1 > 3 && ((n5 = n4 + j - 1) < secondaryRepairInfo.numDeletions || n6 - n5 > secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions || secondaryRepairInfo.code == 5 && n6 - n5 == secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions)) {
                    secondaryRepairInfo.code = 6;
                    secondaryRepairInfo.distance = n6;
                    secondaryRepairInfo.stackPosition = i;
                    secondaryRepairInfo.bufferPosition = j;
                    secondaryRepairInfo.numDeletions = n5;
                    secondaryRepairInfo.recoveryOnNextStack = bl;
                }
                for (n5 = this.nasi(nArray[i]); n5 >= 0 && this.nasr(n5) != 0; ++n5) {
                    int n9;
                    int n10 = this.nasr(n5) + this.NT_OFFSET;
                    n7 = this.parseCheck(nArray, i, n10, j);
                    int n11 = n6 = n7 == 30 ? n2 : n7;
                    if (n7 - j + 1 <= 3 || (n9 = n4 + j - 1) >= secondaryRepairInfo.numDeletions && n6 - n9 <= secondaryRepairInfo.distance - secondaryRepairInfo.numDeletions) continue;
                    secondaryRepairInfo.code = 5;
                    secondaryRepairInfo.symbol = n10;
                    secondaryRepairInfo.distance = n6;
                    secondaryRepairInfo.stackPosition = i;
                    secondaryRepairInfo.bufferPosition = j;
                    secondaryRepairInfo.numDeletions = n9;
                    secondaryRepairInfo.recoveryOnNextStack = bl;
                }
            }
        }
    }

    protected void secondaryDiagnosis(SecondaryRepairInfo secondaryRepairInfo) {
        switch (secondaryRepairInfo.code) {
            case 9: {
                if (secondaryRepairInfo.stackPosition < this.stateStackTop) {
                    this.emitError(6, this.terminalIndex(this.ERROR_SYMBOL), this.locationStack[secondaryRepairInfo.stackPosition], this.buffer[1]);
                }
                for (int i = 0; i < this.scopeStackTop; ++i) {
                    this.emitError(9, -this.scopeIndex[i], this.locationStack[this.scopePosition[i]], this.buffer[1], this.nonterminalIndex(this.scopeLhs(this.scopeIndex[i])));
                }
                secondaryRepairInfo.symbol = this.scopeLhs(this.scopeIndex[this.scopeStackTop]) + this.NT_OFFSET;
                this.stateStackTop = this.scopePosition[this.scopeStackTop];
                this.emitError(9, -this.scopeIndex[this.scopeStackTop], this.locationStack[this.scopePosition[this.scopeStackTop]], this.buffer[1], this.getNtermIndex(this.stateStack[this.stateStackTop], secondaryRepairInfo.symbol, secondaryRepairInfo.bufferPosition));
                break;
            }
            default: {
                this.emitError(secondaryRepairInfo.code, secondaryRepairInfo.code == 5 ? this.getNtermIndex(this.stateStack[secondaryRepairInfo.stackPosition], secondaryRepairInfo.symbol, secondaryRepairInfo.bufferPosition) : this.terminalIndex(this.ERROR_SYMBOL), this.locationStack[secondaryRepairInfo.stackPosition], this.buffer[secondaryRepairInfo.bufferPosition - 1]);
                this.stateStackTop = secondaryRepairInfo.stackPosition;
            }
        }
    }

    protected void emitError(int n, int n2, int n3, int n4, int n5) {
        String string;
        int n6 = n3 > n4 ? n4 : n3;
        int n7 = n4;
        String string2 = string = n2 >= 0 && !this.name(n2).equalsIgnoreCase("ERROR") ? "\"" + this.name(n2) + "\"" : "";
        if (n == 4) {
            int n8 = n = string.length() == 0 ? 4 : 11;
        }
        if (n == 9) {
            string = "\"";
            int n9 = this.scopeSuffix(-n2);
            while (this.scopeRhs(n9) != 0) {
                if (!this.isNullable(this.scopeRhs(n9))) {
                    int n10;
                    int n11 = n10 = this.scopeRhs(n9) > this.NT_OFFSET ? this.nonterminalIndex(this.scopeRhs(n9) - this.NT_OFFSET) : this.terminalIndex(this.scopeRhs(n9));
                    if (this.name(n10).length() > 0) {
                        if (string.length() > 1) {
                            string = string + " ";
                        }
                        string = string + this.name(n10);
                    }
                }
                ++n9;
            }
            string = string + "\"";
        }
        this.tokStream.reportError(n, n3, n4, string);
    }

    protected void emitError(int n, int n2, int n3, int n4) {
        this.emitError(n, n2, n3, n4, 0);
    }

    private int lookahead(int n, int n2) {
        return (n = this.prs.lookAhead(n - this.LA_STATE_OFFSET, this.tokStream.getKind(n2))) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.getNext(n2)) : n;
    }

    protected int tAction(int n, int n2) {
        return (n = this.prs.tAction(n, n2)) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.peek()) : n;
    }

    protected class StateInfo {
        int state;
        int next;

        public StateInfo(int n, int n2) {
            this.state = n;
            this.next = n2;
        }
    }

    protected class SecondaryRepairInfo {
        public int code;
        public int distance;
        public int bufferPosition;
        public int stackPosition;
        public int numDeletions;
        public int symbol;
        boolean recoveryOnNextStack;

        protected SecondaryRepairInfo() {
        }
    }

    protected class PrimaryRepairInfo {
        public int distance;
        public int misspellIndex;
        public int code;
        public int bufferPosition;
        public int symbol;

        public PrimaryRepairInfo() {
        }

        public PrimaryRepairInfo(PrimaryRepairInfo primaryRepairInfo) {
            this.copy(primaryRepairInfo);
        }

        public void copy(PrimaryRepairInfo primaryRepairInfo) {
            this.distance = primaryRepairInfo.distance;
            this.misspellIndex = primaryRepairInfo.misspellIndex;
            this.code = primaryRepairInfo.code;
            this.bufferPosition = primaryRepairInfo.bufferPosition;
            this.symbol = primaryRepairInfo.symbol;
        }
    }

    protected class RepairCandidate {
        public int symbol;
        public int location;

        protected RepairCandidate() {
        }
    }
}

