/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.Differ;
import lpg.runtime.ILexStream;
import lpg.runtime.IPrsStream;
import lpg.runtime.LexStream;
import lpg.runtime.UnknownStreamType;
import lpg.runtime.Utf8LexStream;

public class DifferLines
extends Differ {
    public DifferLines(IPrsStream iPrsStream, IPrsStream iPrsStream2) {
        super(iPrsStream, iPrsStream2);
    }

    protected DifferLines() {
    }

    public Differ.ILine[] getBuffer(IPrsStream iPrsStream) {
        ILexStream iLexStream = iPrsStream.getLexStream();
        Differ.ILine[] iLineArray = new Line[iLexStream.getLineCount() + 1];
        int n = 1;
        iLineArray[0] = new Line(iPrsStream, 0, 0);
        for (int i = 1; i < iLineArray.length; ++i) {
            int n2 = n;
            while (n < iPrsStream.getSize() && iPrsStream.getLine(n) == i) {
                ++n;
            }
            iLineArray[i] = new Line(iPrsStream, n2, n);
        }
        return iLineArray;
    }

    void printLines(IPrsStream iPrsStream, int n, int n2) {
        if (iPrsStream.getLexStream() instanceof LexStream) {
            LexStream lexStream = (LexStream)iPrsStream.getLexStream();
            char[] cArray = lexStream.getInputChars();
            for (int i = n; i <= n2; ++i) {
                int n3 = lexStream.getLineOffset(i - 1) + 1;
                int n4 = lexStream.getLineOffset(i);
                String string = i + " ";
                for (int j = 0; j < 7 - string.length(); ++j) {
                    System.out.print(' ');
                }
                String string2 = string + new String(cArray, n3, n4 - n3);
                System.out.println(string2);
            }
        } else if (iPrsStream.getLexStream() instanceof Utf8LexStream) {
            Utf8LexStream utf8LexStream = (Utf8LexStream)iPrsStream.getLexStream();
            byte[] byArray = utf8LexStream.getInputBytes();
            for (int i = n; i <= n2; ++i) {
                int n5 = utf8LexStream.getLineOffset(i - 1) + 1;
                int n6 = utf8LexStream.getLineOffset(i);
                String string = i + " ";
                for (int j = 0; j < 7 - string.length(); ++j) {
                    System.out.print(' ');
                }
                String string3 = string + new String(byArray, n5, n6 - n5);
                System.out.println(string3);
            }
        } else {
            throw new UnknownStreamType("Unknown stream type " + iPrsStream.getLexStream().getClass().toString());
        }
    }

    void outputInsert(Differ.Change change) {
        this.insertCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Insert after " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlde()].getStartLine() + " " + this.newStream.getFileName() + "," + this.newBuffer[change.getNews()].getStartLine() + (this.newBuffer[change.getNewe()].getEndLine() > this.newBuffer[change.getNews()].getStartLine() ? ".." + this.newBuffer[change.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[change.getNews()].getStartLine(), this.newBuffer[change.getNewe()].getEndLine());
    }

    void outputDelete(Differ.Change change) {
        this.deleteCount += change.getOlde() - change.getOlds() + 1;
        System.out.println("Delete after " + this.newStream.getFileName() + "," + this.newBuffer[change.getNewe()].getStartLine() + " " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlds()].getStartLine() + (this.oldBuffer[change.getOlde()].getEndLine() > this.oldBuffer[change.getOlds()].getStartLine() ? ".." + this.oldBuffer[change.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[change.getOlds()].getStartLine(), this.oldBuffer[change.getOlde()].getEndLine());
    }

    void outputReplace(Differ.Change change) {
        this.replaceDeleteCount += change.getOlde() - change.getOlds() + 1;
        this.replaceInsertCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Replace " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlds()].getStartLine() + (this.oldBuffer[change.getOlde()].getEndLine() > this.oldBuffer[change.getOlds()].getStartLine() ? ".." + this.oldBuffer[change.getOlde()].getEndLine() : "") + ":");
        this.printLines(this.oldStream, this.oldBuffer[change.getOlds()].getStartLine(), this.oldBuffer[change.getOlde()].getEndLine());
        System.out.println("With " + this.newStream.getFileName() + "," + this.newBuffer[change.getNews()].getStartLine() + (this.newBuffer[change.getNewe()].getEndLine() > this.newBuffer[change.getNews()].getStartLine() ? ".." + this.newBuffer[change.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[change.getNews()].getStartLine(), this.newBuffer[change.getNewe()].getEndLine());
    }

    void outputMove(Differ.Change change) {
        this.moveCount += change.getNewe() - change.getNews() + 1;
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlds()].getStartLine() + (this.oldBuffer[change.getOlde()].getEndLine() > this.oldBuffer[change.getOlds()].getStartLine() ? ".." + this.oldBuffer[change.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[change.getNews()].getStartLine() + (this.newBuffer[change.getNewe()].getEndLine() > this.newBuffer[change.getNews()].getStartLine() ? ".." + this.newBuffer[change.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[change.getNews()].getStartLine(), this.newBuffer[change.getNewe()].getEndLine());
    }

    void outputMoveDelete(Differ.Change change) {
        this.moveCount += change.getNewe() - change.getNews() + 1;
        int n = this.newBuffer[change.getNewe()].getEndLine() - this.newBuffer[change.getNews()].getStartLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlds()].getStartLine() + (n > 0 ? ".." + (this.oldBuffer[change.getOlds()].getStartLine() + n) : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[change.getNews()].getStartLine() + (this.newBuffer[change.getNewe()].getEndLine() > this.newBuffer[change.getNews()].getStartLine() ? ".." + this.newBuffer[change.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, this.newBuffer[change.getNews()].getStartLine(), this.newBuffer[change.getNewe()].getEndLine());
        int n2 = this.oldBuffer[change.getOlds()].getStartLine() + n + 1;
        this.deleteCount += change.getOlde() - change.getOlds() - change.getNewe() + change.getNews();
        System.out.println("... And delete " + this.oldStream.getFileName() + "," + n2 + (this.oldBuffer[change.getOlde()].getEndLine() > n2 ? ".." + this.oldBuffer[change.getOlde()].getEndLine() : ""));
        this.printLines(this.oldStream, n2, this.newBuffer[change.getOlde()].getEndLine());
    }

    void outputMoveInsert(Differ.Change change) {
        this.moveCount += change.getOlde() - change.getOlds() + 1;
        int n = this.oldBuffer[change.getOlde()].getStartLine() - this.oldBuffer[change.getOlds()].getEndLine();
        System.out.println("Move " + this.oldStream.getFileName() + "," + this.oldBuffer[change.getOlds()].getStartLine() + (this.oldBuffer[change.getOlde()].getEndLine() > this.oldBuffer[change.getOlds()].getStartLine() ? ".." + this.oldBuffer[change.getOlde()].getEndLine() : "") + " to " + this.newStream.getFileName() + "," + this.newBuffer[change.getNews()].getStartLine() + (n > 0 ? ".." + this.newBuffer[change.getNews()].getStartLine() + n : "") + ":");
        this.printLines(this.newStream, this.newBuffer[change.getNews()].getStartLine(), this.newBuffer[change.getNews()].getStartLine() + n);
        int n2 = this.newBuffer[change.getNews()].getStartLine() + n + 1;
        this.insertCount += change.getNewe() - change.getNews() - change.getOlde() + change.getOlds();
        System.out.println("... And insert " + this.newStream.getFileName() + "," + n2 + (this.newBuffer[change.getNewe()].getEndLine() > n2 ? ".." + this.newBuffer[change.getNewe()].getEndLine() : "") + ":");
        this.printLines(this.newStream, n2, this.newBuffer[change.getNewe()].getEndLine());
    }

    public class Line
    implements Differ.ILine {
        private int[] kind;
        private String[] name;
        private int hash_code;
        private int start_line;
        private int start_column;
        private int end_line;
        private int end_column;
        private int buffer_length;

        public Line(IPrsStream iPrsStream, int n, int n2) {
            int n3 = n2 > n ? n2 - n : 0;
            int n4 = n2 - 1;
            this.start_line = iPrsStream.getLine(n);
            this.start_column = iPrsStream.getColumn(n);
            if (n3 > 0) {
                this.end_line = iPrsStream.getEndLine(n4);
                this.end_column = iPrsStream.getEndColumn(n4);
            } else {
                this.end_line = iPrsStream.getLine(n);
                this.end_column = iPrsStream.getColumn(n);
            }
            this.kind = new int[n3];
            this.name = new String[n3];
            this.hash_code = n3;
            for (int i = 0; i < n3; ++i) {
                this.kind[i] = iPrsStream.getKind(n + i);
                this.name[i] = iPrsStream.getName(n + i);
                this.buffer_length += this.name[i].length() + 1;
                this.hash_code += this.kind[i];
            }
            this.hash_code += this.buffer_length;
        }

        public final int size() {
            return this.kind.length;
        }

        public final int hashCode() {
            return this.hash_code;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Line) {
                Line line = (Line)object;
                if (this.kind.length == line.kind.length) {
                    int n;
                    for (n = 0; n < this.kind.length && this.kind[n] == line.kind[n] && this.name[n].equals(line.name[n]); ++n) {
                    }
                    return n == this.kind.length;
                }
            }
            return false;
        }

        public final int getStartLine() {
            return this.start_line;
        }

        public final int getStartColumn() {
            return this.start_column;
        }

        public final int getEndLine() {
            return this.end_line;
        }

        public final int getEndColumn() {
            return this.end_column;
        }

        public final String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.buffer_length);
            if (this.name.length > 0) {
                stringBuffer.append(this.name[0]);
                for (int i = 1; i < this.name.length; ++i) {
                    stringBuffer.append(" ");
                    stringBuffer.append(this.name[i]);
                }
            }
            return stringBuffer.toString();
        }
    }
}

