/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ILexStream;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseTable;
import lpg.runtime.RuleAction;
import lpg.runtime.UnavailableParserInformationException;

public class LexParser {
    private boolean taking_actions = false;
    private int START_STATE;
    private int LA_STATE_OFFSET;
    private int EOFT_SYMBOL;
    private int ACCEPT_ACTION;
    private int ERROR_ACTION;
    private int START_SYMBOL;
    private int NUM_RULES;
    private ILexStream tokStream;
    private ParseTable prs;
    private RuleAction ra;
    private IntTuple action = null;
    private int STACK_INCREMENT = 1024;
    private int stateStackTop;
    private int stackLength = 0;
    private int[] stack;
    private int[] locationStack;
    private int[] tempStack;
    private int lastToken;
    private int currentAction;
    private int curtok;
    private int starttok;
    private int current_kind;

    public void reset(ILexStream iLexStream) {
        this.tokStream = iLexStream;
    }

    public void reset(ILexStream iLexStream, ParseTable parseTable, RuleAction ruleAction) {
        this.tokStream = iLexStream;
        this.prs = parseTable;
        this.ra = ruleAction;
        this.START_STATE = parseTable.getStartState();
        this.LA_STATE_OFFSET = parseTable.getLaStateOffset();
        this.EOFT_SYMBOL = parseTable.getEoftSymbol();
        this.ACCEPT_ACTION = parseTable.getAcceptAction();
        this.ERROR_ACTION = parseTable.getErrorAction();
        this.START_SYMBOL = parseTable.getStartSymbol();
        this.NUM_RULES = parseTable.getNumRules();
    }

    public LexParser() {
    }

    public LexParser(ILexStream iLexStream, ParseTable parseTable, RuleAction ruleAction) {
        this.reset(iLexStream, parseTable, ruleAction);
    }

    private void reallocateStacks() {
        int n = this.stack == null ? 0 : this.stackLength;
        this.stackLength += this.STACK_INCREMENT;
        if (n == 0) {
            this.stack = new int[this.stackLength];
            this.locationStack = new int[this.stackLength];
            this.tempStack = new int[this.stackLength];
        } else {
            this.stack = new int[this.stackLength];
            System.arraycopy(this.stack, 0, this.stack, 0, n);
            this.locationStack = new int[this.stackLength];
            System.arraycopy(this.locationStack, 0, this.locationStack, 0, n);
            this.tempStack = new int[this.stackLength];
            System.arraycopy(this.tempStack, 0, this.tempStack, 0, n);
        }
    }

    public final int getFirstToken(int n) {
        return this.getToken(n);
    }

    public final int getLastToken(int n) {
        if (this.taking_actions) {
            return n >= this.prs.rhs(this.currentAction) ? this.lastToken : this.tokStream.getPrevious(this.getToken(n + 1));
        }
        throw new UnavailableParserInformationException();
    }

    public final int getCurrentRule() {
        if (this.taking_actions) {
            return this.currentAction;
        }
        throw new UnavailableParserInformationException();
    }

    public final int getToken(int n) {
        if (this.taking_actions) {
            return this.locationStack[this.stateStackTop + (n - 1)];
        }
        throw new UnavailableParserInformationException();
    }

    public final void setSym1(int n) {
    }

    public final int getSym(int n) {
        return this.getLastToken(n);
    }

    public final int getFirstToken() {
        return this.starttok;
    }

    public final int getLastToken() {
        return this.lastToken;
    }

    public void resetTokenStream(int n) {
        this.tokStream.reset(n > this.tokStream.getStreamLength() ? this.tokStream.getStreamLength() : n);
        this.curtok = this.tokStream.getToken();
        this.current_kind = this.tokStream.getKind(this.curtok);
        if (this.stack == null) {
            this.reallocateStacks();
        }
        if (this.action == null) {
            this.action = new IntTuple(1024);
        }
    }

    public void parseCharacters(int n, int n2) {
        this.parseCharacters(null, n, n2);
    }

    public void parseCharacters(Monitor monitor, int n, int n2) {
        this.resetTokenStream(n);
        while (this.curtok <= n2) {
            if (monitor != null && monitor.isCancelled()) {
                return;
            }
            this.lexNextToken(n2);
        }
    }

    public void parseCharacters() {
        this.parseCharacters(null);
    }

    public void parseCharacters(Monitor monitor) {
        this.taking_actions = true;
        this.resetTokenStream(0);
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        block2: while (!(this.current_kind == this.EOFT_SYMBOL || monitor != null && monitor.isCancelled())) {
            this.stateStackTop = -1;
            this.currentAction = this.START_STATE;
            this.starttok = this.curtok;
            while (true) {
                try {
                    this.stack[++this.stateStackTop] = this.currentAction;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.reallocateStacks();
                    this.stack[this.stateStackTop] = this.currentAction;
                }
                this.locationStack[this.stateStackTop] = this.curtok;
                this.parseNextCharacter(this.curtok, this.current_kind);
                if (this.currentAction == this.ERROR_ACTION && this.current_kind != this.EOFT_SYMBOL) {
                    int n = this.tokStream.peek();
                    this.tokStream.reset(this.tokStream.getStreamLength() - 1);
                    this.parseNextCharacter(this.curtok, this.EOFT_SYMBOL);
                    this.tokStream.reset(n);
                }
                if (this.currentAction > this.ERROR_ACTION) {
                    this.lastToken = this.curtok;
                    this.curtok = this.tokStream.getToken();
                    this.current_kind = this.tokStream.getKind(this.curtok);
                    this.currentAction -= this.ERROR_ACTION;
                    do {
                        this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                        this.ra.ruleAction(this.currentAction);
                        int n = this.prs.lhs(this.currentAction);
                        if (n == this.START_SYMBOL) continue block2;
                        this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], n);
                    } while (this.currentAction <= this.NUM_RULES);
                    continue;
                }
                if (this.currentAction >= this.ACCEPT_ACTION) break;
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
            }
            if (this.currentAction == this.ACCEPT_ACTION) continue;
            if (this.starttok == this.curtok) {
                if (this.current_kind == this.EOFT_SYMBOL) break;
                this.tokStream.reportLexicalError(this.starttok, this.curtok);
                this.lastToken = this.curtok;
                this.curtok = this.tokStream.getToken();
                this.current_kind = this.tokStream.getKind(this.curtok);
                continue;
            }
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        this.taking_actions = false;
    }

    private void parseNextCharacter(int n, int n2) {
        int n3;
        int n4 = this.stack[this.stateStackTop];
        int n5 = this.stateStackTop;
        int n6 = this.stateStackTop - 1;
        this.currentAction = this.tAction(n4, n2);
        block0: while (this.currentAction <= this.NUM_RULES) {
            while ((n3 = this.prs.lhs(this.currentAction)) != this.START_SYMBOL) {
                int n7 = (n6 -= this.prs.rhs(this.currentAction) - 1) > n5 ? this.tempStack[n6] : this.stack[n6];
                this.currentAction = this.prs.ntAction(n7, n3);
                if (this.currentAction <= this.NUM_RULES) continue;
                if (n6 + 1 >= this.stack.length) {
                    this.reallocateStacks();
                }
                n5 = n5 < n6 ? n5 : n6;
                this.tempStack[n6 + 1] = this.currentAction;
                this.currentAction = this.tAction(this.currentAction, n2);
                continue block0;
            }
            break block0;
        }
        if (this.currentAction != this.ERROR_ACTION) {
            this.currentAction = this.tAction(n4, n2);
            block2: while (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.ra.ruleAction(this.currentAction);
                    n3 = this.prs.lhs(this.currentAction);
                    if (n3 == this.START_SYMBOL) {
                        this.currentAction = this.starttok == n ? this.ERROR_ACTION : this.ACCEPT_ACTION;
                        break block2;
                    }
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], n3);
                } while (this.currentAction <= this.NUM_RULES);
                this.stack[++this.stateStackTop] = this.currentAction;
                this.locationStack[this.stateStackTop] = n;
                this.currentAction = this.tAction(this.currentAction, n2);
            }
        }
    }

    private int lookahead(int n, int n2) {
        return (n = this.prs.lookAhead(n - this.LA_STATE_OFFSET, this.tokStream.getKind(n2))) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.getNext(n2)) : n;
    }

    private int tAction(int n, int n2) {
        return (n = this.prs.tAction(n, n2)) > this.LA_STATE_OFFSET ? this.lookahead(n, this.tokStream.peek()) : n;
    }

    public boolean scanNextToken() {
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    public boolean scanNextToken(int n) {
        this.resetTokenStream(n);
        return this.lexNextToken(this.tokStream.getStreamLength());
    }

    private boolean lexNextToken(int n) {
        this.taking_actions = false;
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        this.starttok = this.curtok;
        this.action.reset();
        while (true) {
            try {
                this.stack[++this.stateStackTop] = this.currentAction;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.stack[this.stateStackTop] = this.currentAction;
            }
            this.currentAction = this.lexNextCharacter(this.currentAction, this.current_kind);
            if (this.currentAction == this.ERROR_ACTION && this.current_kind != this.EOFT_SYMBOL) {
                int n2 = this.tokStream.peek();
                this.tokStream.reset(this.tokStream.getStreamLength() - 1);
                this.currentAction = this.lexNextCharacter(this.stack[this.stateStackTop], this.EOFT_SYMBOL);
                this.tokStream.reset(n2);
            }
            this.action.add(this.currentAction);
            if (this.currentAction > this.ERROR_ACTION) {
                this.curtok = this.tokStream.getToken();
                if (this.curtok > n) {
                    this.curtok = this.tokStream.getStreamLength();
                }
                this.current_kind = this.tokStream.getKind(this.curtok);
                this.currentAction -= this.ERROR_ACTION;
                do {
                    int n3;
                    if ((n3 = this.prs.lhs(this.currentAction)) == this.START_SYMBOL) {
                        this.parseActions();
                        return true;
                    }
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], n3);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            if (this.currentAction >= this.ACCEPT_ACTION) break;
            this.curtok = this.tokStream.getToken();
            if (this.curtok > n) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        }
        if (this.currentAction == this.ACCEPT_ACTION) {
            return true;
        }
        if (this.starttok == this.curtok) {
            if (this.current_kind == this.EOFT_SYMBOL) {
                this.action = null;
                return false;
            }
            this.lastToken = this.curtok;
            this.tokStream.reportLexicalError(this.starttok, this.curtok);
            this.curtok = this.tokStream.getToken();
            if (this.curtok > n) {
                this.curtok = this.tokStream.getStreamLength();
            }
            this.current_kind = this.tokStream.getKind(this.curtok);
        } else {
            this.lastToken = this.tokStream.getPrevious(this.curtok);
            this.tokStream.reportLexicalError(this.starttok, this.lastToken);
        }
        return true;
    }

    private int lexNextCharacter(int n, int n2) {
        int n3;
        int n4 = this.action.size();
        int n5 = this.stateStackTop;
        int n6 = this.stateStackTop - 1;
        n = this.tAction(n, n2);
        block0: while (n <= this.NUM_RULES) {
            int n7;
            this.action.add(n);
            do {
                if ((n3 = this.prs.lhs(n)) != this.START_SYMBOL) continue;
                if (this.starttok == this.curtok) {
                    n = this.ERROR_ACTION;
                    break block0;
                }
                this.parseActions();
                return this.ACCEPT_ACTION;
            } while ((n = this.prs.ntAction(n7 = (n6 -= this.prs.rhs(n) - 1) > n5 ? this.tempStack[n6] : this.stack[n6], n3)) <= this.NUM_RULES);
            if (n6 + 1 >= this.stack.length) {
                this.reallocateStacks();
            }
            n5 = n5 < n6 ? n5 : n6;
            this.tempStack[n6 + 1] = n;
            n = this.tAction(n, n2);
        }
        if (n == this.ERROR_ACTION) {
            this.action.reset(n4);
        } else {
            this.stateStackTop = n6 + 1;
            for (n3 = n5 + 1; n3 <= this.stateStackTop; ++n3) {
                this.stack[n3] = this.tempStack[n3];
            }
        }
        return n;
    }

    private void parseActions() {
        this.taking_actions = true;
        this.curtok = this.starttok;
        this.lastToken = this.tokStream.getPrevious(this.curtok);
        this.stateStackTop = -1;
        this.currentAction = this.START_STATE;
        block0: for (int i = 0; i < this.action.size(); ++i) {
            int n;
            this.stack[++this.stateStackTop] = this.currentAction;
            this.locationStack[this.stateStackTop] = this.curtok;
            this.currentAction = this.action.get(i);
            if (this.currentAction <= this.NUM_RULES) {
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                    this.ra.ruleAction(this.currentAction);
                    n = this.prs.lhs(this.currentAction);
                    if (n == this.START_SYMBOL) break block0;
                    this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], n);
                } while (this.currentAction <= this.NUM_RULES);
                continue;
            }
            this.lastToken = this.curtok;
            this.curtok = this.tokStream.getNext(this.curtok);
            if (this.currentAction <= this.ERROR_ACTION) continue;
            this.current_kind = this.tokStream.getKind(this.curtok);
            this.currentAction -= this.ERROR_ACTION;
            do {
                this.stateStackTop -= this.prs.rhs(this.currentAction) - 1;
                this.ra.ruleAction(this.currentAction);
                n = this.prs.lhs(this.currentAction);
                if (n == this.START_SYMBOL) break block0;
                this.currentAction = this.prs.ntAction(this.stack[this.stateStackTop], n);
            } while (this.currentAction <= this.NUM_RULES);
        }
        this.taking_actions = false;
    }
}

