/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.util.ArrayList;
import java.util.HashMap;
import lpg.runtime.Adjunct;
import lpg.runtime.ErrorToken;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.LexStream;
import lpg.runtime.NullExportedSymbolsException;
import lpg.runtime.NullTerminalSymbolsException;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.Token;
import lpg.runtime.UndefinedEofSymbolException;
import lpg.runtime.UnimplementedTerminalsException;
import lpg.runtime.Utf8LexStream;

public class PrsStream
implements IPrsStream,
ParseErrorCodes {
    private ILexStream iLexStream;
    private int[] kindMap = null;
    private ArrayList tokens = new ArrayList();
    private ArrayList adjuncts = new ArrayList();
    private int index = 0;
    private int len = 0;

    public PrsStream() {
    }

    public PrsStream(ILexStream iLexStream) {
        this.iLexStream = iLexStream;
        if (iLexStream != null) {
            iLexStream.setPrsStream(this);
        }
        this.resetTokenStream();
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public void remapTerminalSymbols(String[] stringArray, int n) throws UndefinedEofSymbolException, NullExportedSymbolsException, NullTerminalSymbolsException, UnimplementedTerminalsException {
        if (this.iLexStream == null) {
            throw new NullPointerException("lpg.runtime.PrsStream.remapTerminalSymbols(..):  lexStream is null");
        }
        String[] stringArray2 = this.iLexStream.orderedExportedSymbols();
        if (stringArray2 == null) {
            throw new NullExportedSymbolsException();
        }
        if (stringArray == null) {
            throw new NullTerminalSymbolsException();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (stringArray2 != stringArray) {
            int n2;
            this.kindMap = new int[stringArray2.length];
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                hashMap.put(stringArray2[n2], new Integer(n2));
            }
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                Integer n3 = (Integer)hashMap.get(stringArray[n2]);
                if (n3 != null) {
                    this.kindMap[n3.intValue()] = n2;
                    continue;
                }
                if (n2 == n) {
                    throw new UndefinedEofSymbolException();
                }
                arrayList.add(new Integer(n2));
            }
        }
        if (arrayList.size() > 0) {
            throw new UnimplementedTerminalsException(arrayList);
        }
    }

    public final int mapKind(int n) {
        return this.kindMap == null ? n : this.kindMap[n];
    }

    public void resetTokenStream() {
        this.tokens = new ArrayList();
        this.index = 0;
        this.adjuncts = new ArrayList();
    }

    public void setLexStream(ILexStream iLexStream) {
        this.iLexStream = iLexStream;
        this.resetTokenStream();
    }

    public void resetLexStream(LexStream lexStream) {
        this.iLexStream = lexStream;
        if (lexStream != null) {
            lexStream.setPrsStream(this);
        }
    }

    public void makeToken(int n, int n2, int n3) {
        Token token = new Token(this, n, n2, this.mapKind(n3));
        token.setTokenIndex(this.tokens.size());
        this.tokens.add(token);
        token.setAdjunctIndex(this.adjuncts.size());
    }

    public void removeLastToken() {
        int n = this.tokens.size() - 1;
        Token token = (Token)this.tokens.get(n);
        int n2 = this.adjuncts.size();
        while (n2 > token.getAdjunctIndex()) {
            this.adjuncts.remove(--n2);
        }
        this.tokens.remove(n);
    }

    public int makeErrorToken(int n, int n2, int n3, int n4) {
        int n5 = this.tokens.size();
        ErrorToken errorToken = new ErrorToken(this.getIToken(n), this.getIToken(n2), this.getIToken(n3), this.getStartOffset(n), this.getEndOffset(n2), n4);
        errorToken.setTokenIndex(this.tokens.size());
        this.tokens.add(errorToken);
        errorToken.setAdjunctIndex(this.adjuncts.size());
        return n5;
    }

    public void addToken(IToken iToken) {
        iToken.setTokenIndex(this.tokens.size());
        this.tokens.add(iToken);
        iToken.setAdjunctIndex(this.adjuncts.size());
    }

    public void makeAdjunct(int n, int n2, int n3) {
        int n4 = this.tokens.size() - 1;
        Adjunct adjunct = new Adjunct(this, n, n2, this.mapKind(n3));
        adjunct.setAdjunctIndex(this.adjuncts.size());
        adjunct.setTokenIndex(n4);
        this.adjuncts.add(adjunct);
    }

    public void addAdjunct(IToken iToken) {
        int n = this.tokens.size() - 1;
        iToken.setTokenIndex(n);
        iToken.setAdjunctIndex(this.adjuncts.size());
        this.adjuncts.add(iToken);
    }

    public String getTokenText(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return ((Object)iToken).toString();
    }

    public int getStartOffset(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return iToken.getStartOffset();
    }

    public int getEndOffset(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return iToken.getEndOffset();
    }

    public int getTokenLength(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return iToken.getEndOffset() - iToken.getStartOffset() + 1;
    }

    public int getLineNumberOfTokenAt(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return this.iLexStream.getLineNumberOfCharAt(iToken.getStartOffset());
    }

    public int getEndLineNumberOfTokenAt(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return this.iLexStream.getLineNumberOfCharAt(iToken.getEndOffset());
    }

    public int getColumnOfTokenAt(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return this.iLexStream.getColumnOfCharAt(iToken.getStartOffset());
    }

    public int getEndColumnOfTokenAt(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return this.iLexStream.getColumnOfCharAt(iToken.getEndOffset());
    }

    public String[] orderedTerminalSymbols() {
        return null;
    }

    public int getLineOffset(int n) {
        return this.iLexStream.getLineOffset(n);
    }

    public int getLineCount() {
        return this.iLexStream.getLineCount();
    }

    public int getLineNumberOfCharAt(int n) {
        return this.iLexStream.getLineNumberOfCharAt(n);
    }

    public int getColumnOfCharAt(int n) {
        return this.getColumnOfCharAt(n);
    }

    public int getFirstErrorToken(int n) {
        return this.getFirstRealToken(n);
    }

    public int getFirstRealToken(int n) {
        while (n >= this.len) {
            n = ((ErrorToken)this.tokens.get(n)).getFirstRealToken().getTokenIndex();
        }
        return n;
    }

    public int getLastErrorToken(int n) {
        return this.getLastRealToken(n);
    }

    public int getLastRealToken(int n) {
        while (n >= this.len) {
            n = ((ErrorToken)this.tokens.get(n)).getLastRealToken().getTokenIndex();
        }
        return n;
    }

    public char[] getInputChars() {
        return this.iLexStream instanceof LexStream ? ((LexStream)this.iLexStream).getInputChars() : null;
    }

    public byte[] getInputBytes() {
        return this.iLexStream instanceof Utf8LexStream ? ((Utf8LexStream)this.iLexStream).getInputBytes() : null;
    }

    public String toString(int n, int n2) {
        return this.toString((IToken)this.tokens.get(n), (IToken)this.tokens.get(n2));
    }

    public String toString(IToken iToken, IToken iToken2) {
        return this.iLexStream.toString(iToken.getStartOffset(), iToken2.getEndOffset());
    }

    public int getSize() {
        return this.tokens.size();
    }

    public void setSize() {
        this.len = this.tokens.size();
    }

    public int getTokenIndexAtCharacter(int n) {
        int n2 = 0;
        int n3 = this.tokens.size();
        while (n3 > n2) {
            int n4 = (n3 + n2) / 2;
            IToken iToken = (IToken)this.tokens.get(n4);
            if (n >= iToken.getStartOffset() && n <= iToken.getEndOffset()) {
                return n4;
            }
            if (n < iToken.getStartOffset()) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return -(n2 - 1);
    }

    public IToken getTokenAtCharacter(int n) {
        int n2 = this.getTokenIndexAtCharacter(n);
        return n2 < 0 ? null : this.getTokenAt(n2);
    }

    public IToken getTokenAt(int n) {
        return (IToken)this.tokens.get(n);
    }

    public IToken getIToken(int n) {
        return (IToken)this.tokens.get(n);
    }

    public ArrayList getTokens() {
        return this.tokens;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStreamLength() {
        return this.len;
    }

    public void setStreamIndex(int n) {
        this.index = n;
    }

    public void setStreamLength() {
        this.len = this.tokens.size();
    }

    public void setStreamLength(int n) {
        this.len = n;
    }

    public ILexStream getILexStream() {
        return this.iLexStream;
    }

    public ILexStream getLexStream() {
        return this.iLexStream;
    }

    public void dumpTokens() {
        if (this.getSize() <= 2) {
            return;
        }
        System.out.println(" Kind \tOffset \tLen \tLine \tCol \tText\n");
        for (int i = 1; i < this.getSize() - 1; ++i) {
            this.dumpToken(i);
        }
    }

    public void dumpToken(int n) {
        System.out.print(" (" + this.getKind(n) + ")");
        System.out.print(" \t" + this.getStartOffset(n));
        System.out.print(" \t" + this.getTokenLength(n));
        System.out.print(" \t" + this.getLineNumberOfTokenAt(n));
        System.out.print(" \t" + this.getColumnOfTokenAt(n));
        System.out.print(" \t" + this.getTokenText(n));
        System.out.println();
    }

    private IToken[] getAdjuncts(int n) {
        int n2 = ((IToken)this.tokens.get(n)).getAdjunctIndex();
        int n3 = n + 1 == this.tokens.size() ? this.adjuncts.size() : ((IToken)this.tokens.get(this.getNext(n))).getAdjunctIndex();
        int n4 = n3 - n2;
        IToken[] iTokenArray = new IToken[n4];
        int n5 = n2;
        int n6 = 0;
        while (n5 < n3) {
            iTokenArray[n6] = (IToken)this.adjuncts.get(n5);
            ++n5;
            ++n6;
        }
        return iTokenArray;
    }

    public IToken[] getFollowingAdjuncts(int n) {
        return this.getAdjuncts(n);
    }

    public IToken[] getPrecedingAdjuncts(int n) {
        return this.getAdjuncts(this.getPrevious(n));
    }

    public ArrayList getAdjuncts() {
        return this.adjuncts;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int n) {
        this.index = this.index < n ? this.getNext(this.index) : this.len - 1;
        return this.index;
    }

    public int getKind(int n) {
        IToken iToken = (IToken)this.tokens.get(n);
        return iToken.getKind();
    }

    public int getNext(int n) {
        return ++n < this.len ? n : this.len - 1;
    }

    public int getPrevious(int n) {
        return n <= 0 ? 0 : n - 1;
    }

    public String getName(int n) {
        return this.getTokenText(n);
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int n) {
        this.index = this.getPrevious(n);
    }

    public void reset() {
        this.index = 0;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int n) {
        return this.getLineNumberOfTokenAt(n);
    }

    public int getColumn(int n) {
        return this.getColumnOfTokenAt(n);
    }

    public int getEndLine(int n) {
        return this.getEndLineNumberOfTokenAt(n);
    }

    public int getEndColumn(int n) {
        return this.getEndColumnOfTokenAt(n);
    }

    public boolean afterEol(int n) {
        return n < 1 ? true : this.getEndLineNumberOfTokenAt(n - 1) < this.getLineNumberOfTokenAt(n);
    }

    public String getFileName() {
        return this.iLexStream.getFileName();
    }

    public void setMessageHandler(IMessageHandler iMessageHandler) {
        this.iLexStream.setMessageHandler(iMessageHandler);
    }

    public IMessageHandler getMessageHandler() {
        return this.iLexStream.getMessageHandler();
    }

    public void reportError(int n, int n2, int n3, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, String[] stringArray) {
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, n3, n4, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String[] stringArray) {
        this.iLexStream.reportLexicalError(n, this.getStartOffset(n2), this.getEndOffset(n4), this.getStartOffset(n3), this.getEndOffset(n3), stringArray == null ? new String[]{} : stringArray);
    }
}

