/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.BacktrackingParser;
import lpg.runtime.BadParseException;
import lpg.runtime.ConfigurationElement;
import lpg.runtime.ConfigurationStack;
import lpg.runtime.DiagnoseParser;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.IntTuple;
import lpg.runtime.Monitor;
import lpg.runtime.ParseErrorCodes;
import lpg.runtime.ParseTable;

public class RecoveryParser
extends DiagnoseParser
implements ParseErrorCodes {
    private BacktrackingParser parser;
    private IntSegmentedTuple action;
    private IntTuple tokens;
    private int[] actionStack;
    private DiagnoseParser.PrimaryRepairInfo scope_repair = new DiagnoseParser.PrimaryRepairInfo();

    public RecoveryParser(BacktrackingParser backtrackingParser, IntSegmentedTuple intSegmentedTuple, IntTuple intTuple, IPrsStream iPrsStream, ParseTable parseTable) {
        this(backtrackingParser, null, intSegmentedTuple, intTuple, iPrsStream, parseTable);
    }

    public RecoveryParser(BacktrackingParser backtrackingParser, Monitor monitor, IntSegmentedTuple intSegmentedTuple, IntTuple intTuple, IPrsStream iPrsStream, ParseTable parseTable) {
        this(backtrackingParser, monitor, intSegmentedTuple, intTuple, iPrsStream, parseTable, 0, 0L);
    }

    public RecoveryParser(BacktrackingParser backtrackingParser, IntSegmentedTuple intSegmentedTuple, IntTuple intTuple, IPrsStream iPrsStream, ParseTable parseTable, int n, long l) {
        this(backtrackingParser, null, intSegmentedTuple, intTuple, iPrsStream, parseTable, n, l);
    }

    public RecoveryParser(BacktrackingParser backtrackingParser, Monitor monitor, IntSegmentedTuple intSegmentedTuple, IntTuple intTuple, IPrsStream iPrsStream, ParseTable parseTable, int n, long l) {
        super(monitor, iPrsStream, parseTable, n, l);
        this.parser = backtrackingParser;
        this.action = intSegmentedTuple;
        this.tokens = intTuple;
    }

    protected void reallocateStacks() {
        super.reallocateStacks();
        if (this.actionStack == null) {
            this.actionStack = new int[this.stateStack.length];
        } else {
            int n = this.actionStack.length;
            this.actionStack = new int[this.stateStack.length];
            System.arraycopy(this.actionStack, 0, this.actionStack, 0, n);
        }
    }

    public void reportError(int n, int n2) {
        String string = "\"";
        int n3 = this.scopeSuffix(n);
        while (this.scopeRhs(n3) != 0) {
            if (!this.isNullable(this.scopeRhs(n3))) {
                int n4;
                int n5 = n4 = this.scopeRhs(n3) > this.NT_OFFSET ? this.nonterminalIndex(this.scopeRhs(n3) - this.NT_OFFSET) : this.terminalIndex(this.scopeRhs(n3));
                if (this.name(n4).length() > 0) {
                    if (string.length() > 1) {
                        string = string + " ";
                    }
                    string = string + this.name(n4);
                }
            }
            ++n3;
        }
        string = string + "\"";
        this.tokStream.reportError(9, n2, n2, new String[]{string});
    }

    public int recover(int n, int n2) throws BadParseException {
        if (this.stateStack == null) {
            this.reallocateStacks();
        }
        this.tokens.reset();
        this.tokStream.reset();
        this.tokens.add(this.tokStream.getPrevious(this.tokStream.peek()));
        int n3 = n != 0 ? n : this.tokStream.getToken();
        int n4 = 0;
        this.stateStackTop = 0;
        this.stateStack[this.stateStackTop] = this.START_STATE;
        do {
            this.action.reset(n4);
            if (!this.fixError(n3, n2)) {
                throw new BadParseException(n2);
            }
            if (this.monitor != null && this.monitor.isCancelled()) break;
            n3 = n2;
            this.tokStream.reset(n2);
            n4 = this.action.size();
            n2 = this.parser.backtrackParse(this.stateStack, this.stateStackTop, this.action, 0);
            this.tokStream.reset(this.tokStream.getNext(n3));
        } while (n2 != 0);
        return n3;
    }

    private boolean fixError(int n, int n2) {
        int n3;
        int n4 = n;
        int n5 = this.tokStream.getKind(n4);
        int n6 = this.tokStream.peek();
        this.buffer[1] = n2;
        this.buffer[0] = this.tokStream.getPrevious(this.buffer[1]);
        for (n3 = 2; n3 < 32; ++n3) {
            this.buffer[n3] = this.tokStream.getNext(this.buffer[n3 - 1]);
        }
        this.scope_repair.distance = 0;
        this.scope_repair.misspellIndex = 0;
        this.scope_repair.bufferPosition = 1;
        this.main_configuration_stack = new ConfigurationStack(this.prs);
        this.locationStack[this.stateStackTop] = n4;
        this.actionStack[this.stateStackTop] = this.action.size();
        n3 = this.tAction(this.stateStack[this.stateStackTop], n5);
        while (true) {
            if (this.monitor != null && this.monitor.isCancelled()) {
                return true;
            }
            if (n3 <= this.NUM_RULES) {
                this.action.add(n3);
                --this.stateStackTop;
                do {
                    this.stateStackTop -= this.rhs(n3) - 1;
                } while ((n3 = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(n3))) <= this.NUM_RULES);
                try {
                    this.stateStack[++this.stateStackTop] = n3;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.reallocateStacks();
                    this.stateStack[this.stateStackTop] = n3;
                }
                this.locationStack[this.stateStackTop] = n4;
                this.actionStack[this.stateStackTop] = this.action.size();
                n3 = this.tAction(n3, n5);
                continue;
            }
            if (n3 == this.ERROR_ACTION) {
                if (n4 == n2 && this.main_configuration_stack.size() <= 0) break;
                ConfigurationElement configurationElement = this.main_configuration_stack.pop();
                if (configurationElement == null) {
                    n3 = this.ERROR_ACTION;
                    break;
                }
                this.stateStackTop = configurationElement.stack_top;
                configurationElement.retrieveStack(this.stateStack);
                n3 = configurationElement.act;
                n4 = configurationElement.curtok;
                this.action.reset(configurationElement.action_length);
                n5 = this.tokStream.getKind(n4);
                this.tokStream.reset(this.tokStream.getNext(n4));
                continue;
            }
            if (n3 > this.ACCEPT_ACTION && n3 < this.ERROR_ACTION) {
                if (this.main_configuration_stack.findConfiguration(this.stateStack, this.stateStackTop, n4)) {
                    n3 = this.ERROR_ACTION;
                    continue;
                }
                this.main_configuration_stack.push(this.stateStack, this.stateStackTop, n3 + 1, n4, this.action.size());
                n3 = this.baseAction(n3);
                continue;
            }
            if (n3 < this.ACCEPT_ACTION) {
                this.action.add(n3);
                n4 = this.tokStream.getToken();
                n5 = this.tokStream.getKind(n4);
            } else {
                if (n3 <= this.ERROR_ACTION) break;
                this.action.add(n3);
                n4 = this.tokStream.getToken();
                n5 = this.tokStream.getKind(n4);
                n3 -= this.ERROR_ACTION;
                do {
                    this.stateStackTop -= this.rhs(n3) - 1;
                } while ((n3 = this.ntAction(this.stateStack[this.stateStackTop], this.lhs(n3))) <= this.NUM_RULES);
            }
            try {
                this.stateStack[++this.stateStackTop] = n3;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.reallocateStacks();
                this.stateStack[this.stateStackTop] = n3;
            }
            if (n4 == n2) {
                this.scopeTrial(this.scope_repair, this.stateStack, this.stateStackTop);
                if (this.scope_repair.distance >= 3) {
                    this.tokens.add(n);
                    int n7 = n6;
                    while (n7 != n2) {
                        this.tokens.add(n7);
                        n7 = this.tokStream.getNext(n7);
                    }
                    this.acceptRecovery(n2);
                    break;
                }
            }
            this.locationStack[this.stateStackTop] = n4;
            this.actionStack[this.stateStackTop] = this.action.size();
            n3 = this.tAction(n3, n5);
        }
        return n3 != this.ERROR_ACTION;
    }

    private void acceptRecovery(int n) {
        IntTuple intTuple = new IntTuple();
        for (int i = 0; i <= this.scopeStackTop; ++i) {
            int n2 = this.scopeIndex[i];
            int n3 = this.scopeLa(n2);
            intTuple.reset();
            int n4 = this.tAction(this.stateStack[this.stateStackTop], n3);
            if (n4 > this.ACCEPT_ACTION && n4 < this.ERROR_ACTION) {
                do {
                    intTuple.add(this.baseAction(n4++));
                } while (this.baseAction(n4) != 0);
            } else {
                intTuple.add(n4);
            }
            int n5 = this.action.size();
            for (int j = 0; j < intTuple.size(); ++j) {
                int n6;
                this.action.reset(n5);
                this.tokStream.reset(n);
                this.tempStackTop = this.stateStackTop - 1;
                int n7 = this.stateStackTop;
                n4 = intTuple.get(j);
                while (n4 <= this.NUM_RULES) {
                    this.action.add(n4);
                    do {
                        n6 = this.lhs(n4);
                        this.tempStackTop -= this.rhs(n4) - 1;
                        int n8 = n4 = this.tempStackTop > n7 ? this.tempStack[this.tempStackTop] : this.stateStack[this.tempStackTop];
                    } while ((n4 = this.ntAction(n4, n6)) <= this.NUM_RULES);
                    if (this.tempStackTop + 1 >= this.stateStack.length) {
                        this.reallocateStacks();
                    }
                    n7 = n7 < this.tempStackTop ? n7 : this.tempStackTop;
                    this.tempStack[this.tempStackTop + 1] = n4;
                    n4 = this.tAction(n4, n3);
                }
                if (n4 == this.ERROR_ACTION) continue;
                this.nextStackTop = ++this.tempStackTop;
                for (n6 = 0; n6 <= n7; ++n6) {
                    this.nextStack[n6] = this.stateStack[n6];
                }
                for (n6 = n7 + 1; n6 <= this.tempStackTop; ++n6) {
                    this.nextStack[n6] = this.tempStack[n6];
                }
                if (!this.completeScope(this.action, this.scopeSuffix(n2))) continue;
                n6 = this.scopeSuffix(this.scopeIndex[i]);
                while (this.scopeRhs(n6) != 0) {
                    this.tokens.add(((IPrsStream)this.tokStream).makeErrorToken(n, this.tokStream.getPrevious(n), n, this.scopeRhs(n6)));
                    ++n6;
                }
                this.reportError(this.scopeIndex[i], this.tokStream.getPrevious(n));
                break;
            }
            this.stateStackTop = this.nextStackTop;
            System.arraycopy(this.nextStack, 0, this.stateStack, 0, this.stateStackTop + 1);
        }
    }

    private boolean completeScope(IntSegmentedTuple intSegmentedTuple, int n) {
        int n2 = this.scopeRhs(n);
        if (n2 == 0) {
            return true;
        }
        int n3 = this.nextStack[this.nextStackTop];
        if (n2 > this.NT_OFFSET) {
            int n4 = n2 - this.NT_OFFSET;
            if (this.baseCheck(n3 + n4) != n4) {
                return false;
            }
            intSegmentedTuple.add((n3 = this.ntAction(n3, n4)) <= this.NUM_RULES ? n3 + this.ERROR_ACTION : n3);
            while (n3 <= this.NUM_RULES) {
                this.nextStackTop -= this.rhs(n3) - 1;
                n3 = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(n3));
            }
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = n3;
            return this.completeScope(intSegmentedTuple, n + 1);
        }
        n3 = this.tAction(n3, n2);
        intSegmentedTuple.add(n3);
        if (n3 < this.ACCEPT_ACTION) {
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = n3;
            return this.completeScope(intSegmentedTuple, n + 1);
        }
        if (n3 > this.ERROR_ACTION) {
            n3 -= this.ERROR_ACTION;
            do {
                this.nextStackTop -= this.rhs(n3) - 1;
            } while ((n3 = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(n3))) <= this.NUM_RULES);
            ++this.nextStackTop;
            this.nextStack[this.nextStackTop] = n3;
            return true;
        }
        if (n3 > this.ACCEPT_ACTION && n3 < this.ERROR_ACTION) {
            int n5 = intSegmentedTuple.size();
            int n6 = n3;
            while (this.baseAction(n6) != 0) {
                intSegmentedTuple.reset(n5);
                n3 = this.baseAction(n6);
                intSegmentedTuple.add(n3);
                if (n3 > this.NUM_RULES) {
                    if (n3 < this.ACCEPT_ACTION) {
                        ++this.nextStackTop;
                        this.nextStack[this.nextStackTop] = n3;
                        if (this.completeScope(intSegmentedTuple, n + 1)) {
                            return true;
                        }
                    } else if (n3 > this.ERROR_ACTION) {
                        n3 -= this.ERROR_ACTION;
                        do {
                            this.nextStackTop -= this.rhs(n3) - 1;
                        } while ((n3 = this.ntAction(this.nextStack[this.nextStackTop], this.lhs(n3))) <= this.NUM_RULES);
                        ++this.nextStackTop;
                        this.nextStack[this.nextStackTop] = n3;
                        return true;
                    }
                }
                ++n6;
            }
        }
        return false;
    }
}

