/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import lpg.runtime.ILexStream;
import lpg.runtime.IMessageHandler;
import lpg.runtime.IPrsStream;
import lpg.runtime.IntSegmentedTuple;
import lpg.runtime.ParseErrorCodes;

public class Utf8LexStream
implements ILexStream,
ParseErrorCodes {
    private static final int DEFAULT_TAB = 1;
    private static byte[] charSize;
    private int startIndex = -1;
    private int index = -1;
    private int lastIndex = -1;
    private byte[] inputBytes;
    private boolean isUTF8;
    private String fileName;
    private IntSegmentedTuple lineOffsets;
    private int tab = 1;
    private IPrsStream iPrsStream;
    private IMessageHandler errMsg = null;

    public int getCharSize(byte by) {
        return this.isUTF8 ? charSize[by & 0xFF] : 1;
    }

    public static final int getUnicodeValue(byte[] byArray, int n) {
        int n2;
        block8: {
            try {
                n2 = byArray[n] & 0xFF;
                int n3 = charSize[n2];
                block1 : switch (n3) {
                    case 1: {
                        break;
                    }
                    case 0: {
                        n2 = 0;
                        break;
                    }
                    default: {
                        n2 &= 255 >> n3 + 1;
                        for (int i = 1; i < n3; ++i) {
                            byte by = byArray[n + i];
                            if ((by & 0xC0) != 128) {
                                n2 = 0;
                                break block1;
                            }
                            n2 = (n2 << 6) + (by & 0x3F);
                        }
                        break block8;
                    }
                }
                {
                    break block8;
                    break;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                throw new StringIndexOutOfBoundsException(n);
            }
        }
        return n2;
    }

    public String getString(int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        while (n4 < n2) {
            cArray[n3++] = (char)this.getUnicodeValue(n5);
            n4 += this.getCharSize(this.inputBytes[n5]);
            n5 += this.getCharSize(this.inputBytes[n5]);
        }
        return new String(cArray, 0, n3);
    }

    public Utf8LexStream() {
        this.lineOffsets = new IntSegmentedTuple(12);
        this.setLineOffset(-1);
    }

    public Utf8LexStream(int n) {
        this();
        this.tab = n;
    }

    public Utf8LexStream(String string) throws IOException {
        this(string, 1);
    }

    public Utf8LexStream(String string, int n) throws IOException {
        this(n);
        try {
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray, 0, byArray.length);
            this.initialize(byArray, string);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            System.err.println(exception.getMessage());
            exception.printStackTrace();
            throw iOException;
        }
    }

    public Utf8LexStream(byte[] byArray, String string) {
        this();
        this.initialize(byArray, string);
    }

    public Utf8LexStream(IntSegmentedTuple intSegmentedTuple, byte[] byArray, String string) {
        this.initialize(intSegmentedTuple, byArray, string);
    }

    public Utf8LexStream(byte[] byArray, String string, int n) {
        this(n);
        this.initialize(byArray, string);
    }

    public Utf8LexStream(IntSegmentedTuple intSegmentedTuple, byte[] byArray, String string, int n) {
        this.tab = n;
        this.initialize(intSegmentedTuple, byArray, string);
    }

    public boolean isUtf8() {
        return this.isUTF8;
    }

    public boolean isExtendedAscii() {
        return !this.isUTF8;
    }

    public void initialize(byte[] byArray, String string) {
        this.setInputBytes(byArray);
        this.setFileName(string);
        this.computeLineOffsets();
    }

    public void initialize(IntSegmentedTuple intSegmentedTuple, byte[] byArray, String string) {
        this.lineOffsets = intSegmentedTuple;
        this.setInputBytes(byArray);
        this.setFileName(string);
    }

    public void computeLineOffsets() {
        this.lineOffsets.reset();
        this.setLineOffset(-1);
        for (int i = this.startIndex + 1; i < this.inputBytes.length; ++i) {
            if (this.inputBytes[i] != 10) continue;
            this.setLineOffset(i);
        }
    }

    public void setInputBytes(byte[] byArray) {
        this.inputBytes = byArray;
        this.isUTF8 = byArray.length >= 3 && (byArray[0] & 0xFF) == 239 && (byArray[1] & 0xFF) == 187 && (byArray[2] & 0xFF) == 191;
        this.index = this.startIndex = this.isUTF8 ? 2 : -1;
        this.lastIndex = this.getPrevious(byArray.length);
    }

    public byte[] getInputBytes() {
        return this.inputBytes;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setLineOffsets(IntSegmentedTuple intSegmentedTuple) {
        this.lineOffsets = intSegmentedTuple;
    }

    public IntSegmentedTuple getLineOffsets() {
        return this.lineOffsets;
    }

    public void setTab(int n) {
        this.tab = n;
    }

    public int getTab() {
        return this.tab;
    }

    public void setStreamIndex(int n) {
        this.index = n;
    }

    public int getStreamIndex() {
        return this.index;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public int getStreamLength() {
        return this.inputBytes.length;
    }

    public void setLineOffset(int n) {
        this.lineOffsets.add(n);
    }

    public int getLineOffset(int n) {
        return this.lineOffsets.get(n);
    }

    public void setPrsStream(IPrsStream iPrsStream) {
        this.iPrsStream = iPrsStream;
    }

    public IPrsStream getIPrsStream() {
        return this.iPrsStream;
    }

    public IPrsStream getPrsStream() {
        return this.iPrsStream;
    }

    public String[] orderedExportedSymbols() {
        return null;
    }

    public char getCharValue(int n) {
        return (char)this.getUnicodeValue(n);
    }

    public int getIntValue(int n) {
        return this.getUnicodeValue(n);
    }

    public int getUnicodeValue(int n) {
        return this.isUTF8 ? Utf8LexStream.getUnicodeValue(this.inputBytes, n) : this.inputBytes[n] & 0xFF;
    }

    public int getLineCount() {
        return this.lineOffsets.size();
    }

    public int getLineNumberOfCharAt(int n) {
        int n2 = this.lineOffsets.binarySearch(n);
        return n2 < 0 ? -n2 : (n2 == 0 ? 1 : n2);
    }

    public int getColumnOfCharAt(int n) {
        int n2 = this.getLineNumberOfCharAt(n);
        int n3 = this.getLineOffset(n2 - 1);
        int n4 = this.getTab();
        if (n3 + 1 >= this.inputBytes.length) {
            return 1;
        }
        int n5 = n3 + 1;
        while (n5 < n) {
            byte by = this.inputBytes[n5];
            if (by == 9) {
                int n6 = n5 - n3 - 1;
                n3 -= n4 - 1 - n6 % n4;
            }
            n3 += this.getCharSize(by) - 1;
            n5 = this.getNext(n5);
        }
        return n - n3;
    }

    public int getToken() {
        this.index = this.getNext(this.index);
        return this.index;
    }

    public int getToken(int n) {
        this.index = this.index < n ? this.getNext(this.index) : this.lastIndex;
        return this.index;
    }

    public int getKind(int n) {
        return 0;
    }

    public int getNext(int n) {
        return n <= this.startIndex ? this.startIndex + 1 : (n < this.inputBytes.length ? n + this.getCharSize(this.inputBytes[n]) : this.lastIndex);
    }

    public int getPrevious(int n) {
        int n2 = n = n > this.startIndex ? n - 1 : this.startIndex;
        if (this.isUTF8) {
            while (n > this.startIndex && (this.inputBytes[n] & 0xC0) == 128) {
                --n;
            }
        }
        return n;
    }

    public String getName(int n) {
        int n2 = this.getUnicodeValue(n);
        if (n2 <= 65535) {
            return "" + (char)n2;
        }
        return "#x" + Integer.toHexString(n);
    }

    public String getName(int n, int n2) {
        String string = "";
        for (int i = n; i <= n2; ++i) {
            int n3 = this.getUnicodeValue(i);
            string = n3 <= 65535 ? string + (char)n3 : string + "#x" + Integer.toHexString(i);
        }
        return string;
    }

    public int peek() {
        return this.getNext(this.index);
    }

    public void reset(int n) {
        this.index = this.getPrevious(n);
    }

    public void reset() {
        this.index = this.startIndex;
    }

    public int badToken() {
        return 0;
    }

    public int getLine(int n) {
        return this.getLineNumberOfCharAt(n);
    }

    public int getColumn(int n) {
        return this.getColumnOfCharAt(n);
    }

    public int getEndLine(int n) {
        return this.getLine(n);
    }

    public int getEndColumn(int n) {
        return this.getColumnOfCharAt(n);
    }

    public boolean afterEol(int n) {
        return n < 1 ? true : this.getLineNumberOfCharAt(this.getPrevious(n)) < this.getLineNumberOfCharAt(n);
    }

    public int getFirstErrorToken(int n) {
        return this.getFirstRealToken(n);
    }

    public int getFirstRealToken(int n) {
        return n;
    }

    public int getLastErrorToken(int n) {
        return this.getLastRealToken(n);
    }

    public int getLastRealToken(int n) {
        return n;
    }

    public void setMessageHandler(IMessageHandler iMessageHandler) {
        this.errMsg = iMessageHandler;
    }

    public IMessageHandler getMessageHandler() {
        return this.errMsg;
    }

    public void makeToken(int n, int n2, int n3) {
        if (this.iPrsStream != null) {
            this.iPrsStream.makeToken(n, n2, n3);
        } else {
            this.reportLexicalError(n, n2);
        }
    }

    public void reportLexicalError(int n, int n2) {
        int n3;
        int n4 = n2 >= this.inputBytes.length ? 10 : (n == n2 ? 0 : 11);
        int n5 = n3 = n == n2 ? n2 : n2 - 1;
        String string = n4 == 10 ? "End-of-file " : (n4 == 11 ? "\"" + new String(this.inputBytes, n, n2 - n) + "\" " : "\"" + (char)this.getUnicodeValue(n) + "\" ");
        this.reportLexicalError(n4, n, n3, 0, 0, new String[]{string});
    }

    public int[] getLocation(int n, int n2) {
        int n3 = (n2 < this.inputBytes.length ? n2 : this.inputBytes.length - 1) - n + 1;
        return new int[]{n, n3, this.getLineNumberOfCharAt(n), this.getColumnOfCharAt(n), this.getLineNumberOfCharAt(n2), this.getColumnOfCharAt(n2)};
    }

    public void reportLexicalError(int n, int n2, int n3, int n4, int n5, String[] stringArray) {
        if (this.errMsg == null) {
            String string = this.getFileName() + ':' + this.getLineNumberOfCharAt(n2) + ':' + this.getColumnOfCharAt(n2) + ':' + this.getLineNumberOfCharAt(n3) + ':' + this.getColumnOfCharAt(n3) + ':' + n4 + ':' + n5 + ':' + n + ": ";
            System.out.print("****Error: " + string);
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    System.out.print(stringArray[i] + " ");
                }
            }
            System.out.println(errorMsgText[n]);
        } else {
            this.errMsg.handleMessage(n, this.getLocation(n2, n3), this.getLocation(n4, n5), this.getFileName(), stringArray);
        }
    }

    public void reportError(int n, int n2, int n3, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, String[] stringArray) {
        this.reportError(n, n2, 0, n3, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this.reportError(n, n2, n3, n4, stringArray);
    }

    public void reportError(int n, int n2, int n3, int n4, String[] stringArray) {
        this.reportLexicalError(n, n2, n4, n3, n3, stringArray == null ? new String[]{} : stringArray);
    }

    public String toString(int n, int n2) {
        int n3 = n2 - n + 1;
        return n2 >= this.inputBytes.length ? "$EOF" : (n3 <= 0 ? "" : this.getString(n, n3));
    }

    static {
        int n;
        charSize = new byte[256];
        for (n = 0; n < 128; ++n) {
            Utf8LexStream.charSize[n] = 1;
        }
        for (n = 128; n < 206; ++n) {
            Utf8LexStream.charSize[n] = 0;
        }
        for (n = 206; n < 224; ++n) {
            Utf8LexStream.charSize[n] = 2;
        }
        for (n = 224; n < 240; ++n) {
            Utf8LexStream.charSize[n] = 3;
        }
        for (n = 240; n < 248; ++n) {
            Utf8LexStream.charSize[n] = 4;
        }
        for (n = 248; n < 252; ++n) {
            Utf8LexStream.charSize[n] = 5;
        }
        for (n = 252; n < 254; ++n) {
            Utf8LexStream.charSize[n] = 6;
        }
        for (n = 254; n < 255; ++n) {
            Utf8LexStream.charSize[n] = 0;
        }
    }
}

