/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.ArrayInit;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Formal;
import polyglot.ast.MethodDecl;
import polyglot.ast.New;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.ArrayConstructor;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.ast.HjFormal;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.types.ClassType;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ArrayConstructor_c
extends Expr_c
implements ArrayConstructor {
    protected TypeNode base;
    protected boolean isValue = false;
    protected boolean isSafe = true;
    protected Expr distribution;
    protected Expr initializer;

    public ArrayConstructor_c(Position pos) {
        super(pos);
    }

    public ArrayConstructor_c(Position pos, TypeNode base, boolean unsafe, boolean isValue, Expr distribution, Expr initializer) {
        super(pos);
        assert (distribution != null || initializer instanceof ArrayInit);
        this.base = base;
        this.isSafe = !unsafe;
        this.isValue = isValue;
        this.distribution = distribution;
        this.initializer = initializer;
    }

    public TypeNode arrayBaseType() {
        return this.base;
    }

    public Expr distribution() {
        return this.distribution;
    }

    public Expr initializer() {
        return this.initializer;
    }

    public ArrayConstructor arrayBaseType(TypeNode base) {
        ArrayConstructor_c n = (ArrayConstructor_c)this.copy();
        n.base = base;
        return n;
    }

    public ArrayConstructor distribution(Expr distribution) {
        ArrayConstructor_c n = (ArrayConstructor_c)this.copy();
        n.distribution = distribution;
        return n;
    }

    public ArrayConstructor initializer(Expr init) {
        ArrayConstructor_c n = (ArrayConstructor_c)this.copy();
        n.initializer = init;
        return n;
    }

    public boolean isSafe() {
        return this.isSafe;
    }

    public boolean isValue() {
        return this.isValue;
    }

    protected ArrayConstructor reconstruct(TypeNode base, Expr distribution, Expr init) {
        if (this.base == base && this.distribution == distribution && this.initializer == init) {
            return this;
        }
        ArrayConstructor_c n = (ArrayConstructor_c)this.copy();
        n.base = base;
        n.distribution = distribution;
        n.initializer = init;
        return n;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode base = (TypeNode)this.visitChild((Node)this.base, v);
        Expr distribution = this.distribution == null ? null : (Expr)this.visitChild((Node)this.distribution, v);
        Expr init = this.initializer == null ? null : (Expr)this.visitChild((Node)this.initializer, v);
        return this.reconstruct(base, distribution, init);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        Node n = this.base.del().typeCheck(tc);
        if (!(n instanceof TypeNode)) {
            throw new SemanticException("Array constructor base type |" + n + "| is not a type." + this.position());
        }
        TypeNode newBase = (TypeNode)n;
        Type newBaseType = newBase.type();
        Expr newDistribution = this.distribution;
        if (this.distribution != null) {
            Type distType = this.distribution.type();
            boolean distributionIsInt = ts.isImplicitCastValid(distType, (Type)ts.Int());
            if (distributionIsInt) {
                LinkedList<Expr> l = new LinkedList<Expr>();
                l.add(this.distribution);
                Expr newArray = (Expr)nf.NewArray(this.position(), newBase, l, 0, null).typeCheck(tc);
                if (this.initializer != null) {
                    assert (!(this.initializer instanceof ArrayInit));
                    CanonicalTypeNode arr_ops = nf.CanonicalTypeNode(this.position(), (Type)ts.ArrayOperations());
                    TypeNode arr_type = nf.array(newBase, this.position(), 1);
                    Closure init_closure = (Closure)this.initializer;
                    List init_closure_formals = init_closure.formals();
                    HjFormal init_closure_formal = (HjFormal)init_closure_formals.get(0);
                    TypedList pointwise_members = new TypedList(new LinkedList(), ClassMember.class, false);
                    TypedList apply_formals = new TypedList(new LinkedList(), Formal.class, false);
                    Formal formal = nf.Formal(this.position(), Flags.NONE, init_closure_formal.type(), init_closure_formal.id());
                    formal = formal.localInstance(ts.localInstance(this.position(), Flags.NONE, newBaseType, init_closure_formal.name()));
                    apply_formals.add(formal);
                    Formal dummy_formal = nf.Formal(this.position(), Flags.NONE, (TypeNode)nf.CanonicalTypeNode(this.position(), newBaseType), nf.Id(this.position(), "__dummy__"));
                    dummy_formal = dummy_formal.localInstance(ts.localInstance(this.position(), Flags.NONE, newBaseType, "__dummy__"));
                    apply_formals.add(dummy_formal);
                    Block closure_body = init_closure.body();
                    List<Stmt> index_inits = init_closure_formal.explode(nf, ts);
                    Block body_with_index_vars = nf.Block(this.position(), closure_body.statements());
                    for (Stmt index_init : index_inits) {
                        body_with_index_vars = body_with_index_vars.prepend(index_init);
                    }
                    MethodDecl apply_method = nf.MethodDecl(this.position(), Flags.PUBLIC, newBase, nf.Id(this.position(), "apply"), (List)apply_formals, Collections.EMPTY_LIST, body_with_index_vars);
                    TypedList apply_arg_types = new TypedList(new LinkedList(), Type.class, false);
                    apply_arg_types.add(newBaseType);
                    ParsedClassType anon_type = ts.createClassType();
                    apply_method = apply_method.methodInstance(ts.methodInstance(this.position(), (ReferenceType)anon_type, apply_method.flags(), apply_method.returnType().type(), apply_method.name(), (List)apply_arg_types, new ArrayList()));
                    pointwise_members.add(apply_method);
                    ClassBody pointwise_body = nf.ClassBody(this.position(), (List)pointwise_members);
                    CanonicalTypeNode pointwise_type = nf.CanonicalTypeNode(this.position(), (Type)ts.OperatorPointwise());
                    New new_pointwise = (New)nf.New(this.position(), (TypeNode)pointwise_type, Collections.EMPTY_LIST, pointwise_body).type((Type)ts.OperatorPointwise());
                    new_pointwise = new_pointwise.anonType(anon_type);
                    new_pointwise = new_pointwise.constructorInstance(ts.constructorInstance(this.position(), (ClassType)anon_type, Flags.PUBLIC, Collections.EMPTY_LIST, Collections.EMPTY_LIST));
                    newArray = (Expr)nf.Call(this.position(), (Receiver)arr_ops, nf.Id(this.position(), "arrayInit"), newArray, (Expr)new_pointwise).typeCheck(tc);
                    newArray = (Expr)nf.Cast(this.position(), arr_type, newArray).typeCheck(tc);
                }
                return newArray;
            }
            boolean distributionIsRegion = ts.isImplicitCastValid(distType, (Type)ts.region());
            if (distributionIsRegion) {
                newDistribution = (Expr)nf.Call(this.position(), (Receiver)this.distribution, nf.Id(this.position(), "toDistribution")).typeCheck(tc);
            } else {
                boolean distributionIsDist = ts.isImplicitCastValid(distType, (Type)ts.distribution());
                if (!distributionIsDist) {
                    throw new SemanticException("Array distribution specifier must be of type int or distribution" + this.position());
                }
            }
        }
        Expr newInit = null;
        if (this.initializer != null) {
            if (this.initializer instanceof ArrayInit) {
                throw new InternalError("ArrayConstructor_c should really have been NewArray_c" + this);
            }
            newInit = (Expr)this.initializer.typeCheck(tc);
        }
        HjParsedClassType p = ((HjParsedClassType)ts.array(newBaseType, this.isValue)).makeVariant();
        HjParsedClassType t = this.transferAttributes(p, (HjParsedClassType)newDistribution.type());
        ArrayConstructor_c n1 = (ArrayConstructor_c)this.type(t);
        return n1.distribution(newDistribution).arrayBaseType(newBase).initializer(newInit);
    }

    private HjParsedClassType transferAttributes(HjParsedClassType t, HjParsedClassType distType) {
        C_Var rank;
        boolean isRect;
        C_Var onePlace;
        C_Var self = distType.self();
        if (self != null) {
            t.setDistribution(self);
        }
        if ((onePlace = distType.onePlace()) != null) {
            t.setOnePlace(onePlace);
        }
        if (isRect = distType.isRect()) {
            t.setRect();
        }
        boolean zeroBased = distType.isZeroBased();
        C_Var base = distType.base();
        if (base != null) {
            t.setBase(base);
        }
        if ((rank = distType.rank()) != null) {
            t.setRank(rank);
        }
        if (t.hasLocalProperty() && zeroBased && isRect && ((HjTypeSystem)t.typeSystem()).ONE().equals(rank)) {
            t.setRail();
        }
        return t;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.distribution == null && this.initializer == null) {
            throw new InternalCompilerError("Missing both distribution and initializer", this.position());
        }
        w.write("new ");
        this.printBlock((Node)this.base, w, tr);
        if (this.isValue) {
            w.write(" value ");
        }
        if (!this.isSafe) {
            w.write(" unsafe ");
        }
        w.write("[");
        if (this.distribution != null) {
            this.printBlock((Node)this.distribution, w, tr);
        }
        w.write("]");
        if (this.initializer != null) {
            this.initializer.del().prettyPrint(w, tr);
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer("new " + this.base);
        s.append(this.isValue ? " value " : "");
        s.append(!this.isSafe ? " unsafe " : "");
        s.append("[");
        s.append(this.distribution == null ? "" : this.distribution.toString());
        s.append("]");
        s.append(this.initializer == null ? "" : this.initializer.toString());
        return s.toString();
    }

    public Term firstChild() {
        return this.distribution != null ? this.distribution : (this.initializer != null ? this.initializer : null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.distribution != null) {
            if (this.initializer != null) {
                v.visitCFG((Term)this.distribution, (Term)this.initializer, 1);
            } else {
                v.visitCFG((Term)this.distribution, (Term)this, 0);
            }
        }
        if (this.initializer != null) {
            v.visitCFG((Term)this.initializer, (Term)this, 0);
        }
        return succs;
    }
}

