/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.HashMap;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ext.hj.ast.AssignPropertyBody;
import polyglot.ext.hj.ast.StmtSeq_c;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.constr.C_Field_c;
import polyglot.ext.hj.types.constr.C_Special;
import polyglot.ext.hj.types.constr.C_Term;
import polyglot.ext.hj.types.constr.C_Var;
import polyglot.ext.hj.types.constr.Constraint;
import polyglot.ext.hj.types.constr.Constraint_c;
import polyglot.ext.hj.types.constr.TypeTranslator;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.util.Position;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignPropertyBody_c
extends StmtSeq_c
implements AssignPropertyBody {
    final HjConstructorInstance ci;
    final List<FieldInstance> fi;

    public AssignPropertyBody_c(Position pos, List<Stmt> statements, HjConstructorInstance ci, List<FieldInstance> fi) {
        super(pos, statements);
        this.ci = ci;
        this.fi = fi;
    }

    @Override
    public HjConstructorInstance constructorInstance() {
        return this.ci;
    }

    @Override
    public List<FieldInstance> fieldInstances() {
        return this.fi;
    }

    public Node typeCheckOverride(Node parent, TypeChecker tc) throws SemanticException {
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        AssignPropertyBody_c n = (AssignPropertyBody_c)super.typeCheck(tc);
        n.checkReturnType(ts);
        return n;
    }

    protected void checkReturnType(HjTypeSystem ts) throws SemanticException {
        Constraint result = this.ci.constraint();
        Constraint known = this.ci.supClause();
        known = known == null ? new Constraint_c(ts) : known.copy();
        List s = this.statements();
        int len = s.size();
        for (int i = 0; i < len; ++i) {
            Assign a = (Assign)((Eval)s.get(i)).expr();
            Expr initializer = a.right();
            HjType initType = (HjType)initializer.type();
            C_Field_c prop = new C_Field_c(this.fi.get(i), (C_Var)C_Special.Self);
            Constraint c = initType.realClause();
            if (c == null) {
                c = new Constraint_c(ts);
                C_Term t = new TypeTranslator(ts).trans((Receiver)initializer);
                if (t instanceof C_Var) {
                    c.setSelfVar((C_Var)t);
                }
            }
            if (c == null) continue;
            HashMap<C_Var, C_Var> bindings = c.constraints(null, prop);
            C_Var selfVar = c.selfVar();
            if (selfVar != null) {
                known = known.addBinding(prop, selfVar);
            }
            known = known.addBindings(bindings);
        }
        if (!known.entails(result)) {
            throw new SemanticException("Instances created by this constructor satisfy " + known + "; this is not strong enough to entail the return constraint " + result, this.position());
        }
    }
}

