/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Eval;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Receiver;
import polyglot.ast.Return;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.AssignPropertyCall;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.types.HjConstructorInstance;
import polyglot.ext.hj.types.HjParsedClassType;
import polyglot.frontend.Job;
import polyglot.types.Context;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignPropertyCall_c
extends Stmt_c
implements AssignPropertyCall,
Return {
    List<Expr> arguments;
    HjConstructorInstance thisConstructor = null;
    Expr expr;

    public AssignPropertyCall_c(Position pos, List<Expr> arguments) {
        super(pos);
        this.arguments = arguments;
    }

    public Term firstChild() {
        return AssignPropertyCall_c.listChild(this.arguments, null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.arguments, (Term)this, 0);
        return succs;
    }

    public AssignPropertyCall args(List<Expr> args) {
        if (args == this.arguments) {
            return this;
        }
        AssignPropertyCall_c n = (AssignPropertyCall_c)this.copy();
        n.arguments = args;
        return n;
    }

    public List args() {
        return this.arguments;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context ctx = tc.context();
        NodeFactory nf = tc.nodeFactory();
        Position pos = this.position();
        Job job = tc.job();
        if (!ctx.inCode() || !(ctx.currentCode() instanceof HjConstructorInstance)) {
            throw new SemanticException("The statement property(...) must occur only in the body of a constructor.", this.position());
        }
        this.thisConstructor = (HjConstructorInstance)ctx.currentCode();
        List definedProperties = ((HjParsedClassType)this.thisConstructor.container()).definedProperties();
        int pSize = definedProperties.size();
        int aSize = this.arguments.size();
        if (aSize != pSize) {
            throw new SemanticException("The statement property(...) must have the same  numer of arguments as properties for the class.", this.position());
        }
        ArrayList<Eval> s = new ArrayList<Eval>(pSize);
        for (int i = 0; i < aSize; ++i) {
            Field l = nf.Field(pos, (Receiver)nf.This(pos), nf.Id(pos, ((FieldInstance)definedProperties.get(i)).name()));
            AmbiguityRemover ar = new AmbiguityRemover(job, ts, nf);
            ar = (AmbiguityRemover)ar.context(tc.context());
            l = (Expr)l.visit((NodeVisitor)ar);
            l = (Expr)l.visit((NodeVisitor)tc);
            Expr arg = this.arguments.get(i);
            Assign as = nf.Assign(pos, (Expr)l, Assign.ASSIGN, arg);
            as = as.type(arg.type());
            Eval a = nf.Eval(pos, (Expr)as);
            a = (Stmt)a.visit((NodeVisitor)ar);
            s.add(a);
        }
        Node n = ((HjNodeFactory)nf).AssignPropertyBody(pos, s, this.thisConstructor, definedProperties).del().typeCheck(tc);
        return n;
    }

    public Expr expr() {
        return null;
    }

    public Return expr(Expr e) {
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List args = this.visitList(this.arguments, v);
        return this.args(args);
    }
}

