/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CompoundStmt;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.Async;
import polyglot.ext.hj.ast.AsyncBlock_c;
import polyglot.ext.hj.ast.FutureNode;
import polyglot.ext.hj.ast.HjNodeFactory;
import polyglot.ext.hj.ast.Phased;
import polyglot.ext.hj.ast.PhasedChecker;
import polyglot.ext.hj.ast.RemoteActivityInvocation;
import polyglot.ext.hj.types.AsyncInstance;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.main.Report;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Async_c
extends Expr_c
implements Async,
CompoundStmt {
    public Expr place;
    public Stmt body;
    protected List phasers;
    public Expr condExpr;
    public TypeNode returnType;
    public AsyncInstance ai;
    private boolean isAsyncWithReturn;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context");

    public Async_c(Position pos, TypeNode type, Expr place, List phasers, Expr condExpr, Stmt body, boolean isAsyncWithReturn) {
        super(pos);
        this.place = place;
        this.returnType = type;
        this.phasers = phasers;
        this.condExpr = condExpr;
        this.body = body;
        this.isAsyncWithReturn = isAsyncWithReturn;
    }

    private Block asAsyncBlock(Stmt statement) {
        List<Object> l;
        if (statement == null) {
            return (Block)statement;
        }
        if (statement instanceof Block) {
            Block b = (Block)statement;
            l = b.statements();
        } else {
            l = new ArrayList<Stmt>();
            l.add(statement);
        }
        return new AsyncBlock_c(statement.position(), l);
    }

    public Stmt body() {
        return this.body;
    }

    public List phasers() {
        return this.phasers;
    }

    public Phased phasers(List phasers) {
        Async_c n = (Async_c)this.copy();
        n.phasers = phasers;
        return n;
    }

    public Async body(Stmt body) {
        Async_c n = (Async_c)this.copy();
        n.body = body;
        return n;
    }

    public Expr cond() {
        return this.condExpr;
    }

    public Expr place() {
        return this.place;
    }

    public RemoteActivityInvocation place(Expr place) {
        if (place != this.place) {
            Async_c n = (Async_c)this.copy();
            n.place = place;
            return n;
        }
        return this;
    }

    public Async asyncInstance(AsyncInstance asyncInstance) {
        Async_c n = (Async_c)this.copy();
        n.ai = asyncInstance;
        return n;
    }

    protected Async reconstruct(TypeNode returnType, Expr place, List phasers, Stmt body, Expr condExpr) {
        if (returnType != this.returnType || place != this.place || body != this.body || phasers != this.phasers || condExpr != this.condExpr) {
            Async_c n = (Async_c)this.copy();
            n.returnType = returnType;
            n.place = place;
            n.phasers = phasers;
            n.body = body;
            n.condExpr = condExpr;
            n.isAsyncWithReturn = this.isAsyncWithReturn;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr place = (Expr)this.visitChild((Node)this.place, v);
        TypeNode returnType = (TypeNode)this.visitChild((Node)this.returnType, v);
        List phasers = this.visitList(this.phasers, v);
        Expr condExpr = (Expr)this.visitChild((Node)this.condExpr, v);
        Stmt body = (Stmt)this.visitChild((Node)this.body, v);
        return this.reconstruct(returnType, place, phasers, body, condExpr);
    }

    public Context enterScope(Context c) {
        if (Report.should_report((Collection)TOPICS, (int)5)) {
            Report.report((int)5, (String)"enter async scope");
        }
        HjTypeSystem ts = (HjTypeSystem)c.typeSystem();
        if (c.inStaticContext()) {
            this.ai.setFlags(ts.Public().Static());
        }
        c = ((HjContext)c).pushAsync((CodeInstance)this.ai);
        return c;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        HjTypeSystem xts = (HjTypeSystem)tb.typeSystem();
        AsyncInstance ai = this.isAsyncWithReturn ? (AsyncInstance)xts.asyncWithReturnCodeInstance((Type)xts.unknownType(this.position())) : (AsyncInstance)xts.asyncCodeInstance((Type)xts.unknownType(this.position()));
        return this.asyncInstance(ai);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.condExpr) {
            return ((HjContext)c).pushWhenBlock();
        }
        if (child != this.body) {
            c = c.pop();
        }
        return c;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjContext c;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        HjNodeFactory nf = (HjNodeFactory)tc.nodeFactory();
        if (this.condExpr != null && !this.condExpr.type().isBoolean()) {
            throw new SemanticException("Conditional expression must be of Boolean type", this.position());
        }
        Type placeType = this.place.type();
        boolean placeIsPlace = ts.isImplicitCastValid(placeType, (Type)ts.place());
        if (!placeIsPlace) {
            if (ts.isCastValid(placeType, (Type)ts.HjObject()) && !placeType.isPrimitive()) {
                this.place = (Expr)nf.Field(this.position(), (Receiver)this.place, nf.Id(this.position(), "location")).del().typeCheck(tc);
            } else {
                throw new SemanticException("place expression must be of type hj.lang.place or inherit hj.lang.Object", this.position());
            }
        }
        if ((c = (HjContext)tc.context()).inSequentialCode()) {
            throw new SemanticException("async may not be invoked in sequential code.", this.position());
        }
        PhasedChecker.typeCheck(tc, this.phasers);
        if (this.isAsyncWithReturn() && !this.baseType().isVoid()) {
            this.body = this.asAsyncBlock(this.body);
        }
        return this.type(ts.createFutureType(this.position(), (HjNamedType)((FutureNode)this.returnType).base().type()));
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (!this.returnType.isDisambiguated()) {
            return this;
        }
        this.ai.setReturnType(((FutureNode)this.returnType).base().type());
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.place) {
            return ts.Object();
        }
        return child.type();
    }

    public String toString() {
        return "async <" + this.type + "> (" + this.place + ") { ... }";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("async (");
        this.printBlock((Node)this.place, w, tr);
        w.write(") ");
        if (this.phasers != null && !this.phasers.isEmpty()) {
            w.write("phased (");
            w.begin(0);
            Iterator i = this.phasers.iterator();
            while (i.hasNext()) {
                Formal f = (Formal)i.next();
                this.print((Node)f, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
            w.write(")");
        }
        this.printSubStmt(this.body, w, tr);
    }

    public Term firstChild() {
        if (this.place != null) {
            return this.place;
        }
        if (this.phasers() == null || this.phasers().isEmpty()) {
            return this.body;
        }
        return (Term)this.phasers().get(0);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.place != null) {
            v.visitCFG((Term)this.place, FlowGraph.EDGE_KEY_TRUE, (Term)this.body, 1, FlowGraph.EDGE_KEY_FALSE, (Term)this, 0);
        }
        if (this.condExpr != null) {
            v.visitCFG((Term)this.condExpr, (Term)this, 0);
        }
        v.visitCFG((Term)this.returnType, (Term)this, 0);
        if (this.phasers() == null || this.phasers().isEmpty()) {
            v.visitCFG((Term)this.body, (Term)this, 0);
        } else {
            v.visitCFGList(this.phasers, (Term)this.body, 1);
            v.visitCFG((Term)this.body, (Term)this, 0);
        }
        return succs;
    }

    public Type baseType() {
        return ((FutureNode)this.returnType).base().type();
    }

    public Term codeBody() {
        return this.body();
    }

    public CodeInstance codeInstance() {
        return this.ai;
    }

    public boolean isAsyncWithReturn() {
        return this.isAsyncWithReturn;
    }
}

