/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.Expr_c;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Stmt;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.Closure;
import polyglot.ext.hj.types.ClosureInstance;
import polyglot.ext.hj.types.ClosureType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.HjTypeSystem_c;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.SubtypeSet;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Closure_c
extends Expr_c
implements Closure {
    List formals;
    TypeNode returnType;
    List throwTypes;
    Block body;
    MethodInstance container;
    ClosureInstance codeInstance;
    ClassType typeContainer;
    private static final Collection TOPICS = CollectionUtil.list((Object)"types", (Object)"context");

    public Closure_c(Position pos) {
        super(pos);
    }

    public Closure_c(Position pos, List formals, TypeNode returnType, List throwTypes, Block body) {
        super(pos);
        this.formals = formals;
        this.returnType = returnType;
        this.throwTypes = throwTypes;
        this.body = body;
    }

    public List formals() {
        return this.formals;
    }

    public Closure formals(List formals) {
        Closure_c c = (Closure_c)this.copy();
        c.formals = formals;
        return c;
    }

    public TypeNode returnType() {
        return this.returnType;
    }

    public Closure returnType(TypeNode returnType) {
        Closure_c c = (Closure_c)this.copy();
        c.returnType = returnType;
        return c;
    }

    public List throwTypes() {
        return this.throwTypes;
    }

    public Closure throwTypes(List throwTypes) {
        Closure_c c = (Closure_c)this.copy();
        c.throwTypes = throwTypes;
        return c;
    }

    public Block body() {
        return this.body;
    }

    public CodeBlock body(Block body) {
        Closure_c c = (Closure_c)this.copy();
        c.body = body;
        return c;
    }

    public Term codeBody() {
        return this.body;
    }

    public MethodInstance methodContainer() {
        return this.container;
    }

    public Closure methodContainer(MethodInstance methodInstance) {
        Closure_c c = (Closure_c)this.copy();
        c.container = methodInstance;
        return c;
    }

    public ClassType typeContainer() {
        return this.typeContainer;
    }

    public Closure typeContainer(ClassType classType) {
        Closure_c c = (Closure_c)this.copy();
        c.typeContainer = classType;
        return c;
    }

    public CodeInstance codeInstance() {
        return this.codeInstance;
    }

    public ClosureInstance closureInstance() {
        return this.codeInstance;
    }

    public Closure closureInstance(ClosureInstance ci) {
        if (ci == this.codeInstance) {
            return this;
        }
        Closure_c n = (Closure_c)this.copy();
        n.codeInstance = ci;
        return n;
    }

    protected Closure_c reconstruct(List formals, TypeNode returnType, List throwTypes, Block body) {
        if (!CollectionUtil.equals((Collection)formals, (Collection)this.formals) || returnType != this.returnType || !CollectionUtil.equals((Collection)throwTypes, (Collection)this.throwTypes) || body != this.body) {
            Closure_c n = (Closure_c)this.copy();
            n.formals = TypedList.copyAndCheck((List)formals, Formal.class, (boolean)true);
            n.returnType = returnType;
            n.throwTypes = TypedList.copyAndCheck((List)throwTypes, Type.class, (boolean)true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List formals = this.visitList(this.formals, v);
        TypeNode returnType = (TypeNode)this.visitChild((Node)this.returnType, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        Block body = (Block)this.visitChild((Node)this.body, v);
        return this.reconstruct(formals, returnType, throwTypes, body);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Closure_c n = this;
        TypeSystem ts = tb.typeSystem();
        HjTypeSystem hjts = (HjTypeSystem)ts;
        ArrayList<Type> formalTypes = new ArrayList<Type>(n.formals.size());
        for (int i = 0; i < n.formals.size(); ++i) {
            formalTypes.add((Type)ts.unknownType(this.position()));
        }
        ArrayList<Type> throwTypes = new ArrayList<Type>(n.throwTypes.size());
        for (int i = 0; i < n.throwTypes.size(); ++i) {
            throwTypes.add((Type)ts.unknownType(this.position()));
        }
        n = (Closure_c)n.typeContainer((ClassType)tb.currentClass());
        ClosureInstance ci = hjts.closureInstance(this.position(), n.typeContainer, n.container, n.returnType.type(), formalTypes, throwTypes);
        n = (Closure_c)n.closureInstance(ci);
        ClosureType ct = hjts.closure(this.position(), this.returnType.type(), formalTypes, throwTypes);
        return n.type(ct);
    }

    public Context enterScope(Context c) {
        if (Report.should_report((Collection)TOPICS, (int)5)) {
            Report.report((int)5, (String)("enter scope of closure at " + this.position()));
        }
        c = c.pushCode((CodeInstance)this.codeInstance);
        return c;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.codeInstance.isCanonical()) {
            return this;
        }
        if (!this.returnType.isDisambiguated()) {
            return this;
        }
        this.codeInstance.setReturnType(this.returnType.type());
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Formal f : this.formals) {
            if (!f.isDisambiguated()) {
                return this;
            }
            formalTypes.add(f.declType());
        }
        this.codeInstance.setFormalTypes(formalTypes);
        for (TypeNode tn : this.throwTypes()) {
            if (!tn.isDisambiguated()) {
                return this;
            }
            throwTypes.add(tn.type());
        }
        this.codeInstance.setThrowTypes(throwTypes);
        return this;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjTypeSystem hjts = (HjTypeSystem)tc.typeSystem();
        Context c = tc.context();
        Closure_c closure = this;
        for (TypeNode tn : this.throwTypes()) {
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + hjts.Throwable() + "\".", tn.position());
        }
        ClosureType closureType = (ClosureType)this.type;
        closureType.argumentTypes(this.codeInstance.formalTypes());
        closureType.returnType(this.codeInstance.returnType());
        return closure;
    }

    public Term firstChild() {
        return Closure_c.listChild((List)this.formals(), (Term)this.returnType);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFGList(this.formals(), (Term)this.returnType, 1);
        if (!succs.isEmpty()) {
            v.visitCFG((Term)this.returnType, (Term)this, 0);
        } else {
            v.visitCFG((Term)this.returnType, (Term)this.body, 1);
            v.visitCFG((Term)this.body, (Term)this, 0);
        }
        return succs;
    }

    public SubtypeSet exceptions() {
        return this.body.exceptions();
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public boolean constantValueSet() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public Object constantValue() {
        return null;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.returnType.toString()).append(" (");
        Iterator iter = this.formals.iterator();
        while (iter.hasNext()) {
            Formal formal = (Formal)iter.next();
            buff.append(formal.toString());
            if (!iter.hasNext()) continue;
            buff.append(',');
        }
        buff.append(") ");
        if (this.throwTypes.size() > 0) {
            buff.append("throws ");
            buff.append(HjTypeSystem_c.listToString(this.throwTypes));
            buff.append(' ');
        }
        buff.append(this.body);
        return buff.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write("(");
        w.allowBreak(2, 2, "", 0);
        w.begin(0);
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print((Node)f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(") ");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
        this.printSubStmt((Stmt)this.body, w, tr);
    }
}

