/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.hj.ast.DepCast;
import polyglot.ext.hj.ast.DepParameterExpr;
import polyglot.ext.hj.ast.HjCast_c;
import polyglot.ext.hj.ast.HjDepCastInfo;
import polyglot.ext.hj.ast.HjTypeNode;
import polyglot.ext.hj.ast.NullableNode;
import polyglot.ext.hj.types.HjContext;
import polyglot.ext.hj.types.HjNamedType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.main.Report;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class DepCast_c
extends HjCast_c
implements DepCast,
HjDepCastInfo {
    protected boolean depTypeCheckingNeeded = false;
    protected boolean notVisited = true;
    protected DepParameterExpr dep;
    Type lookaheadType = null;

    public DepCast_c(Position pos, TypeNode castType, DepParameterExpr d, Expr expr) {
        super(pos, castType, expr);
        this.dep = d;
    }

    public DepParameterExpr dep() {
        return this.dep;
    }

    public boolean isDepTypeCheckingNeeded() {
        return this.depTypeCheckingNeeded;
    }

    public NodeVisitor disambiguateEnter(AmbiguityRemover sc) throws SemanticException {
        HjTypeNode tn = (HjTypeNode)((HjTypeNode)this.castType).disambiguateBase(sc);
        this.lookaheadType = tn instanceof NullableNode ? ((NullableNode)tn).base().type() : tn.type();
        return sc;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        HjTypeNode tn = (HjTypeNode)((HjTypeNode)this.castType).typeCheckBase(tc);
        this.lookaheadType = tn instanceof NullableNode ? ((NullableNode)tn).base().type() : tn.type();
        return tc;
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.dep) {
            TypeSystem ts = c.typeSystem();
            if (this.lookaheadType instanceof HjNamedType) {
                c = ((HjContext)c).pushDepType((HjNamedType)this.lookaheadType);
            }
        }
        Context cc = super.enterChildScope(child, c);
        return cc;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        this.depTypeCheckingNeeded = false;
        super.typeCheck(tc);
        Type toType = this.castType.type();
        Type fromType = this.expr.type();
        HjType hjToType = (HjType)toType;
        HjType hjFromType = (HjType)fromType;
        HjTypeSystem xts = (HjTypeSystem)tc.typeSystem();
        if (xts.isTypeConstrained(hjToType) && !xts.isTypeConstrained(hjFromType)) {
            if (fromType.isPrimitive()) {
                if (!this.expr.isConstant()) {
                    if (this.notVisited) {
                        Report.report((int)1, (String)("Warning! Primitive Cast from " + fromType + " to " + toType + " is unsafe at line " + this.position + "."));
                        this.notVisited = false;
                    }
                    this.depTypeCheckingNeeded = true;
                }
                if (toType.isClass()) {
                    // empty if block
                }
            } else {
                if (this.notVisited) {
                    Report.report((int)1, (String)("Warning! Cast from " + fromType + " to " + toType + " is unsafe at line " + this.position + "."));
                    this.notVisited = false;
                }
                this.depTypeCheckingNeeded = true;
                if (fromType.isClass() && toType.isPrimitive()) {
                    this.primitiveType = true;
                }
            }
        }
        return this.type(toType);
    }

    public DepParameterExpr depParameterExpr() {
        return (DepParameterExpr)this.dep.copy();
    }

    protected DepCast_c reconstruct(TypeNode castType, Expr expr, DepParameterExpr dep) {
        DepCast_c superCopy = (DepCast_c)super.reconstruct(castType, expr);
        if (dep != superCopy.dep) {
            DepCast_c copy = (DepCast_c)superCopy.copy();
            copy.dep = dep;
            return copy;
        }
        return superCopy == this ? this : superCopy;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode castType = (TypeNode)this.visitChild((Node)this.castType, v);
        DepParameterExpr depExpr = (DepParameterExpr)this.visitChild((Node)this.dep, v);
        Expr expr = (Expr)this.visitChild((Node)this.expr, v);
        return this.reconstruct(castType, expr, depExpr);
    }

    public String toString() {
        return "/*depCast*/" + super.toString();
    }
}

