/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjArrayAccessAssign;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.types.HjType;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjArrayAccessAssign_c
extends Assign_c
implements HjArrayAccessAssign {
    public HjArrayAccessAssign_c(Position pos, HjArrayAccess left, Assign.Operator op, Expr right) {
        super(pos, (Expr)left, op, right);
    }

    public Assign left(Expr left) {
        HjArrayAccessAssign_c n = (HjArrayAccessAssign_c)super.left(left);
        n.assertLeftType();
        return n;
    }

    private void assertLeftType() {
        if (!(this.left() instanceof HjArrayAccess)) {
            throw new InternalCompilerError("left expression of an HjArrayAccessAssign must be an array access");
        }
    }

    public String opString(Assign.Operator op) {
        if (op == ASSIGN) {
            return "set";
        }
        if (op == ADD_ASSIGN) {
            return "addSet";
        }
        if (op == SUB_ASSIGN) {
            return "subSet";
        }
        if (op == MUL_ASSIGN) {
            return "mulSet";
        }
        if (op == DIV_ASSIGN) {
            return "divSet";
        }
        if (op == MOD_ASSIGN) {
            return "modSet";
        }
        if (op == BIT_AND_ASSIGN) {
            return "bitAndSet";
        }
        if (op == BIT_OR_ASSIGN) {
            return "bitOrSet";
        }
        if (op == BIT_XOR_ASSIGN) {
            return "bitXorSet";
        }
        if (op == SHL_ASSIGN) {
            return "shlSet";
        }
        if (op == SHR_ASSIGN) {
            return "shrSet";
        }
        if (op == USHR_ASSIGN) {
            return "ushrSet";
        }
        throw new InternalCompilerError("Unknown assignment operator");
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Type t = this.left.type();
        Type s = this.right.type();
        if (this.op == ASSIGN) {
            if (!(ts.isImplicitCastValid(s, t) || ts.equals((TypeObject)s, (TypeObject)t) || ts.numericConversionValid(t, this.right.constantValue()))) {
                throw new SemanticException("Cannot assign " + s + " to " + t + ".", this.position());
            }
            return this.type(s);
        }
        if (this.op == ADD_ASSIGN) {
            if (ts.equals((TypeObject)t, (TypeObject)ts.String()) && ts.canCoerceToString(s, tc.context())) {
                throw new SemanticException(" Arrays of strings are not supported yet.");
            }
            if (t.isNumeric() && s.isNumeric()) {
                return this.type(s);
            }
            throw new SemanticException("The " + this.op + " operator must have " + "numeric or String operands.", this.position());
        }
        if (this.op == SUB_ASSIGN || this.op == MUL_ASSIGN || this.op == DIV_ASSIGN || this.op == MOD_ASSIGN) {
            if (t.isNumeric() && s.isNumeric()) {
                return this.type(s);
            }
            throw new SemanticException("The " + this.op + " operator must have " + "numeric operands.", this.position());
        }
        if (this.op == BIT_AND_ASSIGN || this.op == BIT_OR_ASSIGN || this.op == BIT_XOR_ASSIGN) {
            if (t.isBoolean() && s.isBoolean()) {
                return this.type(s);
            }
            if (ts.isImplicitCastValid(t, (Type)ts.Long()) && ts.isImplicitCastValid(s, (Type)ts.Long())) {
                return this.type(s);
            }
            throw new SemanticException("The " + this.op + " operator must have " + "integral or boolean operands.", this.position());
        }
        if (this.op == SHL_ASSIGN || this.op == SHR_ASSIGN || this.op == USHR_ASSIGN) {
            if (ts.isImplicitCastValid(t, (Type)ts.Long()) && ts.isImplicitCastValid(s, (Type)ts.Long())) {
                return this.type(s);
            }
            throw new SemanticException("The " + this.op + " operator must have " + "integral operands.", this.position());
        }
        throw new InternalCompilerError("Unrecognized assignment operator " + this.op + ".");
    }

    public Term firstChild() {
        return this.left();
    }

    protected void acceptCFGAssign(CFGBuilder v) {
        HjArrayAccess a = (HjArrayAccess)this.left();
        v.visitCFG((Term)a, (Term)this.right(), 1);
        v.visitCFG((Term)this.right(), (Term)this, 0);
    }

    protected void acceptCFGOpAssign(CFGBuilder v) {
        HjArrayAccess a = (HjArrayAccess)this.left();
        v.visitCFG((Term)a, (Term)this.right(), 1);
        v.visitCFG((Term)this.right(), (Term)this, 0);
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList<ClassType> l = new ArrayList<ClassType>(super.throwTypes(ts));
        if (this.throwsArrayStoreException()) {
            l.add(ts.ArrayStoreException());
        }
        l.add(ts.NullPointerException());
        l.add(ts.OutOfBoundsException());
        return l;
    }

    public boolean throwsArrayStoreException() {
        return this.op == ASSIGN && this.left.type().isReference();
    }

    public String toString() {
        return this.left + "." + this.opString(this.op) + "(" + this.right + ")";
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        assert (false);
        Expr array = ((HjArrayAccess)this.left).array();
        List<Expr> indices = ((HjArrayAccess)this.left).index();
        HjType pt = (HjType)this.type;
        if (pt.isParametric()) {
            Type result = pt.typeParameters().get(0);
            w.write("(");
            this.print((Node)new HjCanonicalTypeNode_c(Position.COMPILER_GENERATED, result), w, tr);
            w.write(")");
        }
        this.printSubExpr(array, w, tr);
        w.write("." + this.opString(this.op) + "(");
        this.printSubExpr(this.right, w, tr);
        w.write(",");
        Iterator<Expr> i = indices.iterator();
        while (i.hasNext()) {
            Expr e = i.next();
            this.print((Node)e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.write(")");
    }
}

