/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ext.hj.ast;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.ext.hj.ast.HjArrayAccess;
import polyglot.ext.hj.ast.HjCanonicalTypeNode_c;
import polyglot.ext.hj.types.HjClassType;
import polyglot.ext.hj.types.HjType;
import polyglot.ext.hj.types.HjTypeSystem;
import polyglot.ext.hj.types.NullableType;
import polyglot.main.Report;
import polyglot.types.Flags;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class HjArrayAccess_c
extends Expr_c
implements HjArrayAccess {
    protected Expr array;
    protected List index;

    public HjArrayAccess_c(Position pos, Expr array, List index) {
        super(pos);
        assert (index.size() > 1);
        this.array = array;
        this.index = index;
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Expr array() {
        return this.array;
    }

    public HjArrayAccess array(Expr array) {
        HjArrayAccess_c n = (HjArrayAccess_c)this.copy();
        n.array = array;
        return n;
    }

    public List index() {
        return TypedList.copy((List)this.index, Expr.class, (boolean)false);
    }

    public HjArrayAccess index(List index) {
        HjArrayAccess_c n = (HjArrayAccess_c)this.copy();
        n.index = index;
        return n;
    }

    protected HjArrayAccess_c reconstruct(Expr array, List index) {
        if (array != this.array || index != this.index) {
            HjArrayAccess_c n = (HjArrayAccess_c)this.copy();
            n.array = array;
            n.index = index;
            return n;
        }
        return this;
    }

    public Flags flags() {
        return Flags.NONE;
    }

    public Node visitChildren(NodeVisitor v) {
        Expr array = (Expr)this.visitChild((Node)this.array, v);
        List index = this.visitList(this.index, v);
        return this.reconstruct(array, index);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        HjType target;
        HjTypeSystem ts = (HjTypeSystem)tc.typeSystem();
        Type type = this.array.type();
        if (type.isArray()) {
            throw new SemanticException("Multiple subscript cannot follow an array of rank 1.", this.position());
        }
        if (Report.should_report((String)"debug", (int)3)) {
            Report.report((int)3, (String)("HjArrayAccess_c: typeCheck type=" + type + " |" + type.getClass() + "|" + ts.isIndexable(type)));
        }
        if (!ts.isIndexable(target = (HjType)type)) {
            throw new SemanticException("Multiple subscripts can only follow an array of rank > 1.", this.position());
        }
        for (Expr item : this.index) {
            if (ts.isImplicitCastValid(item.type(), (Type)ts.Int())) continue;
            throw new SemanticException("Array subscript " + item + " must be an integer.", this.position());
        }
        LinkedList<List> args = new LinkedList<List>();
        args.add(this.index);
        if (target.isParametric()) {
            List<Type> params = target.typeParameters();
            Type param = params.get(0);
            return this.type(param);
        }
        HjClassType refType = (HjClassType)((Object)(type instanceof NullableType ? ((NullableType)type).base() : type));
        Type retType = ts.baseType(refType);
        return this.type(retType);
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.index) {
            return ts.Int();
        }
        if (child == this.array) {
            return ts.arrayOf(this.type);
        }
        return child.type();
    }

    public String toString() {
        return this.array.toString() + this.index;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        assert (false);
        HjType at = (HjType)this.array.type();
        if (at.isParametric()) {
            Type result = at.typeParameters().get(0);
            w.write("((");
            this.print((Node)new HjCanonicalTypeNode_c(Position.COMPILER_GENERATED, result), w, tr);
            w.write(")");
        }
        this.printSubExpr(this.array, w, tr);
        w.write(".get(");
        w.begin(0);
        Iterator i = this.index.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            this.print((Node)e, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (at.isParametric()) {
            w.write(")");
        }
    }

    public Term firstChild() {
        return this.array;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.index.isEmpty()) {
            v.visitCFG((Term)this.array, (Term)this, 0);
        } else {
            v.visitCFG((Term)this.array, HjArrayAccess_c.listChild((List)this.index, null), 1);
            v.visitCFGList(this.index, (Term)this, 0);
        }
        return succs;
    }

    public List throwTypes(TypeSystem ts) {
        return CollectionUtil.list((Object)ts.OutOfBoundsException(), (Object)ts.NullPointerException());
    }
}

